/*
 * Decompiled with CFR 0.152.
 */
package bightcode.bightsprite;

import bightcode.bightsprite.BSClip;
import bightcode.bightsprite.BSFrame;
import bightcode.bightsprite.BSLayer;
import java.io.DataInputStream;
import java.io.IOException;

public class BSAnimationData {
    static final int _SIZE_INT_ = 32;
    static final int _SIZE_SHORT_ = 16;
    static final int _SIZE_BYTE_ = 8;
    int[] miaRanges;
    int miRangeLength;
    BSClip[] clips;
    BSFrame[] frames;
    short miLargestClipWidth;
    short miLargestClipHeight;
    short miClipLength;
    static final int _ANIMATION_FORMAT_A_ = 0;
    static final int _ANIMATION_FORMAT_B_ = 1;
    int miAnimationFormat;
    int miFrameLength;
    static final int _TARGET_ID_ = 1112760686;
    byte myMajorVersion;
    byte myMinorVersion;
    int offset;

    public BSAnimationData(String filename) {
        int length;
        byte[] raw = null;
        try {
            DataInputStream dis = new DataInputStream(filename.getClass().getResourceAsStream(filename));
            length = dis.readInt() - 4;
            raw = new byte[length];
            dis.read(raw);
            dis.close();
        }
        catch (IOException dis) {
            // empty catch block
        }
        this.offset = 0;
        this.miAnimationFormat = 0;
        int idNum = this.read(raw, 32);
        this.myMajorVersion = (byte)this.read(raw, 8);
        this.myMinorVersion = (byte)this.read(raw, 8);
        this.miAnimationFormat = this.read(raw, 8);
        int _SIZE_CLIP_COUNT_ = this.read(raw, 8);
        int _SIZE_KERNING_POSITION_ = this.read(raw, 8);
        int _SIZE_KERNING_DIMENSION_ = this.read(raw, 8);
        int _SIZE_ANIMATION_FRAMES_ = this.read(raw, 8);
        int _SIZE_ANIMATION_LAYERS_ = this.read(raw, 8);
        int _SIZE_ANIMATION_CLIP_REFERENCES_ = this.read(raw, 8);
        int _SIZE_ANIMATION_POSITION_ = this.read(raw, 8);
        int _SIZE_ANIMATION_TRANSFORM_ = this.read(raw, 8);
        int _SIZE_ANIMATION_RANGE_COUNT_ = this.read(raw, 8);
        int _SIZE_ANIMATION_RANGE_ = 32;
        this.miClipLength = (short)this.read(raw, _SIZE_CLIP_COUNT_);
        this.clips = new BSClip[this.miClipLength];
        int i = 0;
        while (i < this.miClipLength) {
            this.clips[i] = new BSClip();
            this.clips[i].x = (short)this.read(raw, _SIZE_KERNING_POSITION_);
            this.clips[i].y = (short)this.read(raw, _SIZE_KERNING_POSITION_);
            this.clips[i].width = (char)this.read(raw, _SIZE_KERNING_DIMENSION_);
            this.clips[i].height = (char)this.read(raw, _SIZE_KERNING_DIMENSION_);
            ++i;
        }
        this.miFrameLength = (char)this.read(raw, _SIZE_ANIMATION_FRAMES_);
        this.frames = new BSFrame[this.miFrameLength];
        int totalLength = 0;
        int maxArea = 0;
        this.miLargestClipHeight = 0;
        this.miLargestClipWidth = 0;
        BSClip clipReference = null;
        i = 0;
        while (i < this.miFrameLength) {
            this.frames[i] = new BSFrame();
            length = this.read(raw, _SIZE_ANIMATION_LAYERS_);
            this.frames[i].layerCount = (char)length;
            this.frames[i].layers = new BSLayer[length];
            int j = 0;
            while (j < length) {
                ++totalLength;
                this.frames[i].layers[j] = new BSLayer();
                this.frames[i].layers[j].setClipNum((short)this.read(raw, _SIZE_ANIMATION_CLIP_REFERENCES_));
                this.frames[i].layers[j].setX((short)this.signedRead(raw, _SIZE_ANIMATION_POSITION_));
                this.frames[i].layers[j].setY((short)this.signedRead(raw, _SIZE_ANIMATION_POSITION_));
                short a = (short)(this.signedRead(raw, _SIZE_ANIMATION_TRANSFORM_) / 65535);
                short b = (short)(this.signedRead(raw, _SIZE_ANIMATION_TRANSFORM_) / 65535);
                short c = (short)(this.signedRead(raw, _SIZE_ANIMATION_TRANSFORM_) / 65535);
                short d = (short)(this.signedRead(raw, _SIZE_ANIMATION_TRANSFORM_) / 65535);
                this.frames[i].layers[j].setTrans((short)((a & 0xF) << 12 | (b & 0xF) << 8 | (c & 0xF) << 4 | d & 0xF));
                short clipNum = this.frames[i].layers[j].getClipNum();
                clipReference = this.clips[clipNum];
                if (clipReference.width * clipReference.height > maxArea) {
                    maxArea = clipReference.width * clipReference.height;
                    this.miLargestClipWidth = (short)clipReference.width;
                    this.miLargestClipHeight = (short)clipReference.height;
                }
                ++j;
            }
            ++i;
        }
        length = (char)this.read(raw, _SIZE_ANIMATION_RANGE_COUNT_);
        this.miaRanges = new int[length];
        this.miRangeLength = length;
        i = 0;
        while (i < length) {
            this.miaRanges[i] = this.read(raw, _SIZE_ANIMATION_RANGE_);
            ++i;
        }
    }

    int signedRead(byte[] raw, int size) {
        int signMask;
        int val = this.read(raw, size);
        if ((val & (signMask = 1 << size - 1)) > 0) {
            val = -(val & ~signMask);
        }
        return val;
    }

    int read(byte[] raw, int size) {
        int result = this.read2(raw, size);
        return result;
    }

    int read2(byte[] raw, int size) {
        int fullBitOffset = this.offset;
        int indexOffset = fullBitOffset / 8;
        int bitOffset = fullBitOffset - indexOffset * 8;
        int returnValue = 0;
        int valSize = size;
        int overflow = 0;
        if (size + bitOffset > 8) {
            overflow = size + bitOffset - 8;
            valSize = size - overflow;
        }
        returnValue = (raw[indexOffset] << bitOffset & 0xFF) >>> 8 - valSize << overflow;
        this.offset += valSize;
        if (overflow > 0) {
            returnValue |= this.read2(raw, overflow);
        }
        return returnValue;
    }
}

