/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.BCC;
import app.CUtils;
import javax.microedition.lcdui.Graphics;

public class Menu {
    static final int _INT_MIN_ = Integer.MIN_VALUE;
    static final int _INT_MAX_ = Integer.MAX_VALUE;
    static final byte _FALSE_ = 0;
    static final byte _TRUE_ = 1;
    static final byte MODULE_TYPE_ABSOLUTE = 1;
    static final byte MODULE_TYPE_VERTICAL = 2;
    static final byte MODULE_TYPE_HORIZONTAL = 3;
    static final byte TYPE_ELEMENT_TEXT = 1;
    static final byte TYPE_ELEMENT_TEXT_BOX = 2;
    static final byte TYPE_ELEMENT_IMAGE = 3;
    static final byte TYPE_ELEMENT_RECT_DRAW = 4;
    static final byte TYPE_ELEMENT_RECT_FILL = 5;
    static final byte TYPE_ELEMENT_ROUND_RECT_DRAW = 6;
    static final byte TYPE_ELEMENT_ROUND_RECT_FILL = 7;
    static final byte TYPE_ELEMENT_ARC_DRAW = 8;
    static final byte TYPE_ELEMENT_ARC_FILL = 9;
    static final byte ELEMENT_INDEX_TYPE = 0;
    static final byte ELEMENT_INDEX_PARENT = 1;
    static final byte ELEMENT_INDEX_PREVIOUS = 2;
    static final byte ELEMENT_INDEX_NEXT = 3;
    static final byte ELEMENT_INDEX_X = 4;
    static final byte ELEMENT_INDEX_Y = 5;
    static final byte ELEMENT_INDEX_W = 6;
    static final byte ELEMENT_INDEX_H = 7;
    static final byte ELEMENT_INDEX_OFFSET_X = 8;
    static final byte ELEMENT_INDEX_OFFSET_Y = 9;
    static final byte ELEMENT_INDEX_ANCHOR = 10;
    static final byte ELEMENT_INDEX_SPECIAL_PROPERTY = 11;
    static final byte ELEMENT_INDEX_NOT_CLICKABLE = 12;
    static final byte ELEMENT_INDEX_IMAGE_INDEX = 13;
    static final byte ELEMENT_INDEX_PROPERTIES_SIZE = 14;
    static final short ELEMENT_LSK = -36;
    static final short ELEMENT_RSK = -37;
    static final byte TEXT_BOX_SCROLL = 16;
    short _MENU_STATE_;
    short _MENU_SUBSTATE_;
    short _MENU_TEXT_POOL_ID_;
    short _MENU_LEFT_SOFT_KEY_MENU_OFFSET_;
    short _MENU_LEFT_SOFT_KEY_IMAGE_ID_;
    short _MENU_LEFT_SOFT_KEY_TEXT_POOL_ID_;
    short _MENU_RIGHT_SOFT_KEY_MENU_OFFSET_;
    short _MENU_RIGHT_SOFT_KEY_IMAGE_ID_;
    short _MENU_RIGHT_SOFT_KEY_TEXT_POOL_ID_;
    short _MENU_OFFSET_OPTIONS_START_;
    short _MENU_OFFSET_OPTIONS_END_;
    short _MENU_OFFSET_OPTIONS_CUR_;
    short _MENU_CLEAR_KEY_MENU_OFFSET_;
    static final byte _MENU_SIZE_ = 13;
    static final byte _MENU_OPTIONS_TEXT_POOL_ID_ = 0;
    static final byte _MENU_OPTIONS_SELECT_MENU_OFFSET_ = 1;
    static final byte _MENU_OPTIONS_TUTORIAL_OFFSET_ = 2;
    static final byte _MENU_OPTIONS_TUTORIAL_IS_VIEWED_ = 3;
    static final byte _MENU_OPTIONS_SIZE_ = 4;
    short[] miaMenuOptions;
    short miCurSizeMenuOptions;
    short miMaxSizeMenuOptions;
    short miIDCounter;
    short miVerticalCounter;
    short miHorizontalCounter;
    short miOffset;
    short miType;
    short miSpacingX;
    short miSpacingY;
    short miParent;
    short miSelection;
    short miTextBoxOffset;
    short miTextBoxHeight;
    short miScrollOffsetX;
    short miScrollOffsetY;
    short miScrollTextOffsetY;
    short miSize;
    short miAnchor;
    short miX;
    short miY;
    short miWidth;
    short miHeight;
    short miLSKImageIndex;
    short miLSKWidth;
    short miLSKHeight;
    short miLSKX;
    short miLSKY;
    short miLSKAnchor;
    short miRSKImageIndex;
    short miRSKWidth;
    short miRSKHeight;
    short miRSKX;
    short miRSKY;
    short miRSKAnchor;
    short[] objects;
    BCC mbccCore;
    byte[] textForTextBlock;
    int[] miTextEnd;
    byte[] mTextForOptions;
    private int miTitleTextID;
    private int miTitleImageIndex;
    private int miTitleX;
    private int miTitleY;
    private int miTitleWidth;
    private int miTitleAnchor;

    Menu(BCC core) {
        this.mbccCore = core;
        this.miIDCounter = 0;
        this.miVerticalCounter = 1;
        this.miHorizontalCounter = 1;
        this.miOffset = 0;
        this.miParent = (short)-1;
        this.miSelection = 0;
        this.miTextBoxOffset = (short)-1;
        this.miTextBoxHeight = 0;
        this.miScrollOffsetX = 0;
        this.miScrollOffsetY = 0;
        this.miScrollTextOffsetY = 0;
        this.miTitleTextID = -1;
        this.miLSKImageIndex = (short)-1;
        this.miRSKImageIndex = (short)-1;
        this.textForTextBlock = null;
        this.miSize = (short)84;
        this.objects = new short[this.miSize];
        CUtils.MEMSET(this.objects, (short)-1, (int)this.miSize);
        this.miCurSizeMenuOptions = 0;
        this.miMaxSizeMenuOptions = (short)20;
        this.miaMenuOptions = new short[this.miMaxSizeMenuOptions];
        CUtils.MEMSET(this.miaMenuOptions, (short)-1, (int)this.miMaxSizeMenuOptions);
        this._MENU_STATE_ = (short)-1;
        this._MENU_SUBSTATE_ = (short)-1;
        this._MENU_TEXT_POOL_ID_ = (short)-1;
        this._MENU_LEFT_SOFT_KEY_MENU_OFFSET_ = (short)-1;
        this._MENU_LEFT_SOFT_KEY_IMAGE_ID_ = (short)-1;
        this._MENU_LEFT_SOFT_KEY_TEXT_POOL_ID_ = (short)-1;
        this._MENU_RIGHT_SOFT_KEY_MENU_OFFSET_ = (short)-1;
        this._MENU_RIGHT_SOFT_KEY_IMAGE_ID_ = (short)-1;
        this._MENU_RIGHT_SOFT_KEY_TEXT_POOL_ID_ = (short)-1;
        this._MENU_OFFSET_OPTIONS_START_ = (short)-1;
        this._MENU_OFFSET_OPTIONS_END_ = (short)-1;
        this._MENU_OFFSET_OPTIONS_CUR_ = (short)-1;
        this._MENU_CLEAR_KEY_MENU_OFFSET_ = (short)-1;
    }

    void initModuleAbsolute() {
        this.miType = 1;
        this.miAnchor = (short)20;
        this.miX = 0;
        this.miY = 0;
        this.miWidth = (short)this.mbccCore.miCanvasWidth;
        this.miHeight = (short)this.mbccCore.miCanvasHeight;
    }

    void initModuleVertical(int iXOffset, int iYOffset, int iWidth, int iHeight, int iAnchor, int iSpacingY) {
        this.miType = (short)2;
        this.miAnchor = (short)iAnchor;
        this.miX = (short)iXOffset;
        this.miY = (short)iYOffset;
        this.miWidth = (short)iWidth;
        this.miHeight = (short)iHeight;
        this.miSpacingY = (short)iSpacingY;
    }

    void initModuleHorizontal(int iXOffset, int iYOffset, int iWidth, int iHeight, int iAnchor, int iSpacingX) {
        this.miType = (short)3;
        this.miAnchor = (short)iAnchor;
        this.miX = (short)iXOffset;
        this.miY = (short)iYOffset;
        this.miWidth = (short)iWidth;
        this.miHeight = (short)iHeight;
        this.miSpacingX = (short)iSpacingX;
    }

    int menu_AddOption(int iTextPoolID, int iMenuOffset, int iTutorialIndex, int iFontID) {
        if (this.miCurSizeMenuOptions + 4 >= this.miMaxSizeMenuOptions) {
            short iMaxSizeMenuOptionsNew = (short)(this.miMaxSizeMenuOptions * 2);
            short[] temp = new short[this.miMaxSizeMenuOptions];
            CUtils.MEMCPY(temp, this.miaMenuOptions, (int)this.miMaxSizeMenuOptions);
            this.miaMenuOptions = new short[iMaxSizeMenuOptionsNew];
            CUtils.MEMSET(this.miaMenuOptions, (short)-1, (int)iMaxSizeMenuOptionsNew);
            CUtils.MEMCPY(this.miaMenuOptions, temp, (int)this.miMaxSizeMenuOptions);
            this.miMaxSizeMenuOptions = iMaxSizeMenuOptionsNew;
        }
        this.miaMenuOptions[this.miCurSizeMenuOptions + 0] = (short)iTextPoolID;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 1] = (short)iMenuOffset;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 2] = (short)iTutorialIndex;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 3] = 0;
        if (this._MENU_OFFSET_OPTIONS_START_ == -1) {
            this._MENU_OFFSET_OPTIONS_START_ = this.miCurSizeMenuOptions;
            this._MENU_OFFSET_OPTIONS_CUR_ = this.miCurSizeMenuOptions;
        }
        this._MENU_OFFSET_OPTIONS_END_ = this.miCurSizeMenuOptions;
        this.addText(iTextPoolID, iFontID);
        this.miCurSizeMenuOptions = (short)(this.miCurSizeMenuOptions + 4);
        return this.miCurSizeMenuOptions - 4;
    }

    int menu_AddOption(byte[] iText, int iMenuOffset, int iTutorialIndex, int iFontID) {
        if (this.miCurSizeMenuOptions + 4 >= this.miMaxSizeMenuOptions) {
            short iMaxSizeMenuOptionsNew = (short)(this.miMaxSizeMenuOptions * 2);
            short[] temp = new short[this.miMaxSizeMenuOptions];
            CUtils.MEMCPY(temp, this.miaMenuOptions, (int)this.miMaxSizeMenuOptions);
            this.miaMenuOptions = new short[iMaxSizeMenuOptionsNew];
            CUtils.MEMSET(this.miaMenuOptions, (short)-1, (int)iMaxSizeMenuOptionsNew);
            CUtils.MEMCPY(this.miaMenuOptions, temp, (int)this.miMaxSizeMenuOptions);
            this.miMaxSizeMenuOptions = iMaxSizeMenuOptionsNew;
        }
        this.miaMenuOptions[this.miCurSizeMenuOptions + 0] = -1;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 1] = (short)iMenuOffset;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 2] = (short)iTutorialIndex;
        this.miaMenuOptions[this.miCurSizeMenuOptions + 3] = 0;
        if (this._MENU_OFFSET_OPTIONS_START_ == -1) {
            this._MENU_OFFSET_OPTIONS_START_ = this.miCurSizeMenuOptions;
            this._MENU_OFFSET_OPTIONS_CUR_ = this.miCurSizeMenuOptions;
        }
        this._MENU_OFFSET_OPTIONS_END_ = this.miCurSizeMenuOptions;
        int i = 0;
        while (i < CUtils.STRLEN(iText)) {
            this.mTextForOptions[this.miTextEnd[this.miCurSizeMenuOptions / 4] + i] = iText[i];
            ++i;
        }
        if (this.miCurSizeMenuOptions == 0) {
            this.miTextEnd[1] = CUtils.STRLEN(iText);
        } else if (this.miCurSizeMenuOptions / 4 < 6) {
            this.miTextEnd[this.miCurSizeMenuOptions / 4 + 1] = this.miTextEnd[this.miCurSizeMenuOptions / 4] + CUtils.STRLEN(iText);
        }
        this.addText(-1, iFontID);
        this.miCurSizeMenuOptions = (short)(this.miCurSizeMenuOptions + 4);
        return this.miCurSizeMenuOptions - 4;
    }

    void setOptionTextSize(int iSize) {
        this.miTextEnd = new int[iSize];
        int i = 0;
        while (i < iSize) {
            this.miTextEnd[i] = 0;
            ++i;
        }
        this.mTextForOptions = new byte[iSize * 10];
        i = 0;
        while (i < iSize * 10) {
            this.mTextForOptions[i] = 0;
            ++i;
        }
    }

    int getX() {
        return this.miX;
    }

    int getY() {
        return this.miY;
    }

    int setY(int iY) {
        int diff = iY - this.getY();
        this.miY = (short)(this.miY + diff);
        int i = 0;
        while (i < this.miOffset) {
            int n = i + 5;
            this.objects[n] = (short)(this.objects[n] + diff);
            i += 14;
        }
        return diff;
    }

    int setX(int iX) {
        int diff = iX - this.getX();
        this.miX = (short)(this.miX + diff);
        int i = 0;
        while (i < this.miOffset) {
            int n = i + 4;
            this.objects[n] = (short)(this.objects[n] + diff);
            i += 14;
        }
        return this.miX;
    }

    int getWidth() {
        return this.miWidth;
    }

    int getHeight() {
        return this.miHeight;
    }

    int getSize() {
        return this.miIDCounter;
    }

    int getX(int iID, int iAlign) {
        int x = this.objects[iID * 14 + 4];
        short objAlign = this.objects[iID * 14 + 10];
        if (this.objects[iID * 14 + 0] < 4) {
            if ((objAlign & 8) == 8) {
                x -= this.objects[iID * 14 + 6];
            } else if ((objAlign & 1) == 1) {
                x -= this.objects[iID * 14 + 6] >> 1;
            }
        }
        if ((iAlign & 8) == 8) {
            x += this.objects[iID * 14 + 6];
        } else if ((iAlign & 1) == 1) {
            x += this.objects[iID * 14 + 6] >> 1;
        }
        return x - this.miScrollOffsetX;
    }

    int getY(int iID, int iAlign) {
        int y = this.objects[iID * 14 + 5];
        short objAlign = this.objects[iID * 14 + 10];
        if (this.objects[iID * 14 + 0] < 4) {
            if ((objAlign & 0x20) == 32) {
                y -= this.objects[iID * 14 + 7];
            } else if ((objAlign & 2) == 2) {
                y -= this.objects[iID * 14 + 7] >> 1;
            }
        }
        if ((iAlign & 0x20) == 32) {
            y += this.objects[iID * 14 + 7];
        } else if ((iAlign & 2) == 2) {
            y += this.objects[iID * 14 + 7] >> 1;
        }
        return y - this.miScrollOffsetY;
    }

    int getWidth(int iID) {
        return this.objects[iID * 14 + 6];
    }

    int getHeight(int iID) {
        return this.objects[iID * 14 + 7];
    }

    int getWidthFromPercent(int iWidthPercent) {
        int iWidth;
        if (iWidthPercent == 0) {
            iWidth = 0;
        } else {
            iWidth = this.mbccCore.miCanvasWidth * iWidthPercent / 100;
            iWidth += this.mbccCore.miCanvasWidth * iWidthPercent % 100 > 49 ? 1 : 0;
        }
        return iWidth;
    }

    int getHeightFromPercent(int iHeightPercent) {
        int iHeight;
        if (iHeightPercent == 0) {
            iHeight = 0;
        } else {
            iHeight = this.mbccCore.miCanvasHeight * iHeightPercent / 100;
            iHeight += this.mbccCore.miCanvasHeight * iHeightPercent % 100 > 49 ? 1 : 0;
        }
        return iHeight;
    }

    void setSelectedFont(int iOption, int iFontImageID) {
        int iSelection = iOption * 14;
        this.objects[iSelection + 13] = (short)iFontImageID;
    }

    void setSelectedFont(int iFontImageID) {
        if (this.miSelection > -1) {
            this.objects[this.miSelection + 13] = (short)iFontImageID;
        }
    }

    int getSelectedFont() {
        if (this.miSelection > -1) {
            return this.objects[this.miSelection + 13];
        }
        return -1;
    }

    void setTextForTextBlock(byte[] text) {
        this.textForTextBlock = text;
    }

    int getSelectOffset() {
        return this.miaMenuOptions[this._MENU_OFFSET_OPTIONS_CUR_ + 1];
    }

    int getTutorialOffset() {
        return this.miaMenuOptions[this._MENU_OFFSET_OPTIONS_CUR_ + 2];
    }

    boolean isTutorialViewed() {
        return this.miaMenuOptions[this._MENU_OFFSET_OPTIONS_CUR_ + 3] == 1;
    }

    void setTutorialViewed(boolean bViewed) {
        this.miaMenuOptions[this._MENU_OFFSET_OPTIONS_CUR_ + 3] = (short)(bViewed ? 1 : 0);
    }

    void setAllTutorialsViewed(boolean bViewed) {
        int i = 0;
        while (i < this.miCurSizeMenuOptions) {
            this.miaMenuOptions[i + 3] = (short)(bViewed ? 1 : 0);
            i += 4;
        }
    }

    int getElement() {
        return this.miSelection / 14;
    }

    int getNextElement() {
        short child = this.objects[this.miSelection + 2] == -1 ? (short)0 : this.objects[this.miSelection + 2];
        while (this.objects[child + 12] == 1) {
            short s = child = this.objects[child + 2] == -1 ? (short)0 : this.objects[child + 2];
        }
        if (child > 0) {
            this.miSelection = child;
            this._MENU_OFFSET_OPTIONS_CUR_ = (short)(this.miSelection / 14 * 4);
            if (this.miType == 2) {
                if (this.getVerticalScrollOffset() > 0) {
                    this.miScrollOffsetY = (short)this.getVerticalScrollOffset();
                }
            } else if (this.miType == 3 && this.getHorizontalScrollOffset() > 0) {
                this.miScrollOffsetX = (short)this.getHorizontalScrollOffset();
            }
            return child / 14;
        }
        this.miSelection = 0;
        if (this.miType == 2) {
            this.miScrollOffsetY = 0;
        } else if (this.miType == 3) {
            this.miScrollOffsetX = 0;
        }
        this._MENU_OFFSET_OPTIONS_CUR_ = this._MENU_OFFSET_OPTIONS_START_;
        return this.miSelection / 14;
    }

    int getPreviousElement() {
        int parent = this.objects[this.miSelection + 3] == -1 ? (this.miIDCounter - 1) * 14 : this.objects[this.miSelection + 3];
        while (this.objects[parent + 12] == 1) {
            int n = parent = this.objects[parent + 3] == -1 ? (this.miIDCounter - 1) * 14 : this.objects[parent + 3];
        }
        if (parent > -1) {
            this.miSelection = (short)parent;
            this._MENU_OFFSET_OPTIONS_CUR_ = (short)(this.miSelection / 14 * 4);
            if (this.miType == 2) {
                this.miScrollOffsetY = this.getVerticalScrollOffset() > 0 ? (short)this.getVerticalScrollOffset() : (short)0;
            } else if (this.miType == 3) {
                this.miScrollOffsetX = this.getHorizontalScrollOffset() > 0 ? (short)this.getHorizontalScrollOffset() : (short)0;
            }
            return parent / 14;
        }
        this.miSelection = (short)((this.miIDCounter - 1) * 14);
        if (this.miType == 2) {
            if (this.getVerticalScrollOffset() > 0) {
                this.miScrollOffsetY = (short)this.getVerticalScrollOffset();
            }
        } else if (this.miType == 3 && this.getHorizontalScrollOffset() > 0) {
            this.miScrollOffsetX = (short)this.getHorizontalScrollOffset();
        }
        this._MENU_OFFSET_OPTIONS_CUR_ = this._MENU_OFFSET_OPTIONS_START_;
        return this.miSelection / 14;
    }

    void setElement(int iIndex) {
        this.miSelection = (short)(iIndex * 14);
    }

    void setElementClickable(int iIndex) {
        this.objects[iIndex * 14 + 12] = 0;
    }

    void setElementNotClickable(int iIndex) {
        this.objects[iIndex * 14 + 12] = 1;
    }

    boolean isElementClickable(int iIndex) {
        int iOffset = iIndex * 14;
        return this.objects[iOffset + 12] == 0;
    }

    int isElementAtXY(int iTouchX, int iTouchY, int iPaddingX, int iPaddingY) {
        int iOffset = 14;
        short iSizeMultiplier = 1;
        if (this.miLSKImageIndex > -1 && iTouchX >= this.miLSKX - iPaddingX * 2 && iTouchX <= this.miLSKX + this.miLSKWidth * iSizeMultiplier + iPaddingX * 2 && iTouchY >= this.miLSKY - this.miLSKHeight * iSizeMultiplier - iPaddingY * 2 && iTouchY <= this.miLSKY + iPaddingY * 2) {
            return -36;
        }
        if (this.miRSKImageIndex > -1 && iTouchX >= this.miRSKX - this.miRSKWidth * iSizeMultiplier - iPaddingX * 2 && iTouchX <= this.miRSKX + iPaddingX * 2 && iTouchY >= this.miRSKY - this.miRSKHeight * iSizeMultiplier - iPaddingY * 2 && iTouchY <= this.miRSKY + iPaddingY * 2) {
            return -37;
        }
        int i = 0;
        while (i < this.miIDCounter) {
            if (iTouchX >= this.getX(i, 4) - iPaddingX && iTouchX <= this.getX(i, 4) + this.getWidth(i) + iPaddingX && iTouchY >= this.getY(i, 16) - iPaddingY && iTouchY <= this.getY(i, 16) + this.getHeight(i) + iPaddingY) {
                if (this.objects[iOffset + 12] == 1) {
                    return -1;
                }
                return i;
            }
            iOffset += 14;
            ++i;
        }
        return -1;
    }

    void addTitle(int iTextID, int iImageIndex, int iX, int iY, int iW, int iAnchor) {
        this.miTitleTextID = iTextID;
        this.miTitleImageIndex = iImageIndex;
        this.miTitleX = iX;
        this.miTitleY = iY;
        this.miTitleWidth = iW;
        this.miTitleAnchor = iAnchor;
    }

    void addLSK(int iImageIndex, int iX, int iY) {
        this.miLSKImageIndex = (short)iImageIndex;
        this.miLSKWidth = (short)this.mbccCore.image_getWidth(iImageIndex);
        this.miLSKHeight = (short)this.mbccCore.image_getHeight(iImageIndex);
        this.miLSKX = (short)iX;
        this.miLSKY = this.mbccCore.miCanvasWidth > this.mbccCore.miCanvasHeight ? (short)(this.mbccCore.miCanvasWidth - iY - 17) : (short)(this.mbccCore.miCanvasHeight - iY);
        this.miLSKAnchor = (short)36;
    }

    void addRSK(int iImageIndex, int iX, int iY) {
        this.miRSKImageIndex = (short)iImageIndex;
        this.miRSKWidth = (short)this.mbccCore.image_getWidth(iImageIndex);
        this.miRSKHeight = (short)this.mbccCore.image_getHeight(iImageIndex);
        if (this.mbccCore.miCanvasWidth > this.mbccCore.miCanvasHeight) {
            this.miRSKX = (short)(this.mbccCore.miCanvasHeight - iX + 8 + 3);
            this.miRSKY = (short)(this.mbccCore.miCanvasWidth - iY - 17);
        } else {
            this.miRSKX = (short)(this.mbccCore.miCanvasWidth - iX);
            this.miRSKY = (short)(this.mbccCore.miCanvasHeight - iY);
        }
        this.miRSKAnchor = (short)40;
    }

    int addDrawArcOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 8, -1);
    }

    int addDrawArc(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 8, -1);
    }

    int addFillArcOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 9, -1);
    }

    int addFillArc(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 9, -1);
    }

    int addDrawArc(int iOffsetX, int iOffsetY, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetX, iOffsetY, iWidth - 1, iHeight - 1, iColor, 8, iAnchor);
    }

    int addFillArc(int iOffsetX, int iOffsetY, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetX, iOffsetY, iWidth, iHeight, iColor, 9, iAnchor);
    }

    int addDrawRoundRectOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 6, -1);
    }

    int addDrawRoundRect(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 6, -1);
    }

    int addFillRoundRectOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 7, -1);
    }

    int addFillRoundRect(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 7, -1);
    }

    int addDrawRoundRect(int iOffsetX, int iOffsetY, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetX, iOffsetY, iWidth - 1, iHeight - 1, iColor, 6, iAnchor);
    }

    int addFillRoundRect(int iOffsetX, int iOffsetY, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetX, iOffsetY, iWidth, iHeight, iColor, 7, iAnchor);
    }

    int addDrawRectOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 4, -1);
    }

    int addDrawRect(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 4, -1);
    }

    int addFillRectOverlay(int iD, int iWidth, int iHeight, int iColor) {
        return this.addShape(iD, 0, 0, iWidth, iHeight, iColor, 5, -1);
    }

    int addFillRect(int iWidth, int iHeight, int iColor) {
        return this.addShape(-1, 0, 0, iWidth, iHeight, iColor, 5, -1);
    }

    int addDrawRect(int iOffsetXPercent, int iOffsetYPercent, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetXPercent, iOffsetYPercent, iWidth - 1, iHeight - 1, iColor, 4, iAnchor);
    }

    int addFillRect(int iOffsetXPercent, int iOffsetYPercent, int iWidth, int iHeight, int iColor, int iAnchor) {
        return this.addShape(-1, iOffsetXPercent, iOffsetYPercent, iWidth, iHeight, iColor, 5, iAnchor);
    }

    int addText(int iTextID, int iImageIndex) {
        return this.addText(-1, iTextID, iImageIndex, 0, 0, -1, -1, false, 1, -1);
    }

    int addTextOverlay(int parentID, int iTextID, int iImageIndex) {
        return this.addText(parentID, iTextID, iImageIndex, 0, 0, -1, -1, false, 1, -1);
    }

    int addText(int iTextID, int iImageIndex, int iOffsetXPercent, int iOffsetYPercent, int iAnchor) {
        return this.addText(-1, iTextID, iImageIndex, iOffsetXPercent, iOffsetYPercent, -1, -1, false, 1, iAnchor);
    }

    int addTextBox(int iTextID, int iImageIndex, int iWidthPercent, int iHeightPercent) {
        return this.addText(-1, iTextID, iImageIndex, 0, 0, iWidthPercent, iHeightPercent, false, 2, -1);
    }

    int addTextBoxOverlay(int parentID, int iTextID, int iImageIndex, int iWidthPercent, int iHeightPercent) {
        return this.addText(parentID, iTextID, iImageIndex, 0, 0, iWidthPercent, iHeightPercent, true, 2, -1);
    }

    int addTextBox(int iTextID, int iImageIndex, int iOffsetXPercent, int iOffsetYPercent, int iWidthPercent, int iHeightPercent, int iAnchor) {
        return this.addText(-1, iTextID, iImageIndex, iOffsetXPercent, iOffsetYPercent, iWidthPercent, iHeightPercent, false, 2, iAnchor);
    }

    int addImage(int iImageIndex, int iOffsetXPercent, int iOffsetYPercent, int iAnchor) {
        return this.addImage(-1, iImageIndex, iOffsetXPercent, iOffsetYPercent, -1, -1, false, iAnchor);
    }

    int addImage(int iImageIndex, int iOffsetXPercent, int iOffsetYPercent, int iWidthPercent, int iHeightPercent, int iAnchor) {
        return this.addImage(-1, iImageIndex, iOffsetXPercent, iOffsetYPercent, iWidthPercent, iHeightPercent, false, iAnchor);
    }

    int addImage(int iImageIndex) {
        return this.addImage(-1, iImageIndex, -1, -1, -1, -1, false, -1);
    }

    int addImageOverlay(int iD, int iImageIndex) {
        return this.addImage(iD, iImageIndex, -1, -1, -1, -1, false, -1);
    }

    void replaceImage(int iID, int iImageIndex) {
        int offset = iID * 14;
        this.addImage(iID, iImageIndex, -1, -1, this.objects[offset + 8], this.objects[offset + 9], true, this.objects[offset + 10]);
    }

    void replaceText(int iID, int iTextID, int iImageIndex) {
        int offset = iID * 14;
        this.addText(iID, iTextID, iImageIndex, -1, -1, this.objects[offset + 8], this.objects[offset + 9], true, 1, this.objects[offset + 10]);
    }

    void replaceTextBox(int iID, int iTextID, int iImageIndex) {
        int offset = iID * 14;
        this.addText(iID, iTextID, iImageIndex, this.objects[offset + 6], this.objects[offset + 7], this.objects[offset + 8], this.objects[offset + 9], true, 2, this.objects[offset + 10]);
    }

    void scroll(int scrollY) {
        if (this.miTextBoxOffset > -1) {
            if (this.miTextBoxHeight < this.objects[this.miTextBoxOffset + 7]) {
                return;
            }
            if (scrollY < 0) {
                this.miScrollTextOffsetY = (short)(this.miScrollTextOffsetY > 0 ? this.miScrollTextOffsetY + scrollY : 0);
            } else if (scrollY > 0) {
                this.miScrollTextOffsetY = (short)(this.miScrollTextOffsetY < this.miTextBoxHeight - this.objects[this.miTextBoxOffset + 7] ? this.miScrollTextOffsetY + scrollY : this.miTextBoxHeight - this.objects[this.miTextBoxOffset + 7]);
            }
        } else if (this.miIDCounter > BCC._MAX_MENU_OPTIONS_ && this.miType == 2) {
            if (scrollY < 0) {
                this.getPreviousElement();
            } else if (scrollY > 0) {
                this.getNextElement();
            }
        }
    }

    boolean isScrollableUp() {
        if (this.miType == 1) {
            return this.miScrollTextOffsetY > 0;
        }
        if (this.miType == 2) {
            return this.miScrollOffsetY > 0;
        }
        return false;
    }

    boolean isScrollableDown() {
        if (this.miType == 1) {
            return this.miScrollTextOffsetY < this.miTextBoxHeight - this.objects[this.miTextBoxOffset + 7];
        }
        if (this.miType == 2) {
            return this.getElement() != this.miIDCounter - 1;
        }
        return false;
    }

    void paint(Graphics g) {
        int iPrevX = g.getClipX();
        int iPrevY = g.getClipY();
        int iPrevW = g.getClipWidth();
        int iPrevH = g.getClipHeight();
        int objX = this.getX();
        int objY = this.getY();
        int offset = 0;
        int sumX = this.miType == 3 ? this.getX() - this.miScrollOffsetX : 0;
        int sumY = this.miType == 2 ? this.getY() - this.miScrollOffsetY : 0;
        g.setClip(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int iD = 0;
        while (iD < this.miIDCounter) {
            short objType = this.objects[offset + 0];
            short objColor = this.objects[offset + 11];
            short objID = this.objects[offset + 13];
            short objW = this.objects[offset + 6];
            short objH = this.objects[offset + 7];
            short objAlign = this.objects[offset + 10];
            short objTextID = this.objects[offset + 11];
            objX = this.miType == 3 ? (sumX += iD > 0 ? this.miSpacingX : (short)0) : this.objects[offset + 4] - this.miScrollOffsetX;
            objY = this.miType == 2 ? (sumY += iD > 0 ? this.miSpacingY : (short)0) : this.objects[offset + 5] - this.miScrollOffsetY;
            if (objColor > -1) {
                g.setColor((int)objColor);
            }
            if (objY + objH >= this.getY() && objY <= this.getY() + this.getHeight()) {
                if (objType == 1) {
                    int iClipTop;
                    if (objY < this.getY()) {
                        iClipTop = this.getY() - objY;
                        objY = this.getY();
                    } else {
                        iClipTop = 0;
                    }
                    if (objTextID > -1) {
                        this.mbccCore.text_paintBlock(g, this.mbccCore.image_getImage(objID), objTextID, objX, objY, this.getWidth(), this.getY() + this.getHeight() - objY, iClipTop, (int)objAlign);
                    } else {
                        int length = this.miTextEnd[iD + 1] - this.miTextEnd[iD];
                        byte[] text = new byte[length + 1];
                        int i = 0;
                        while (i < length) {
                            text[i] = this.mTextForOptions[this.miTextEnd[iD] + i];
                            ++i;
                        }
                        text[length] = 0;
                        this.mbccCore.text_paintBlock(g, this.mbccCore.image_getImage(objID), text, objX, objY, this.getWidth(), this.getY() + this.getHeight() - objY, iClipTop, (int)objAlign);
                    }
                } else if (objType == 2) {
                    if (objTextID == -1) {
                        this.mbccCore.text_paintBlock(g, this.mbccCore.image_getImage(objID), this.textForTextBlock, objX, objY, (int)objW, (int)objH, (int)this.miScrollTextOffsetY, (int)objAlign);
                    } else {
                        this.mbccCore.text_paintBlock(g, this.mbccCore.image_getImage(objID), objTextID, objX, objY, (int)objW, (int)objH, (int)this.miScrollTextOffsetY, (int)objAlign);
                    }
                } else if (objType == 3) {
                    this.mbccCore.image_Paint(g, objID, objX, objY, objAlign);
                } else if (objType == 5) {
                    g.fillRect(objX, objY, (int)objW, (int)objH);
                } else if (objType == 4) {
                    g.drawRect(objX, objY, (int)objW, (int)objH);
                } else if (objType == 7) {
                    g.fillRoundRect(objX, objY, (int)objW, (int)objH, 20, 20);
                } else if (objType == 6) {
                    g.drawRoundRect(objX, objY, (int)objW, (int)objH, 20, 20);
                } else if (objType == 9) {
                    g.fillArc(objX, objY, (int)objW, (int)objH, 0, 360);
                } else if (objType == 8) {
                    g.drawArc(objX, objY, (int)objW, (int)objH, 0, 360);
                }
            }
            sumY += this.miType == 2 ? objH : (short)0;
            sumX += this.miType == 3 ? objW : (short)0;
            offset += 14;
            ++iD;
        }
        g.setClip(0, 0, this.mbccCore.miCanvasWidth, this.mbccCore.miCanvasHeight);
        if (this.miTitleTextID > -1) {
            this.mbccCore.text_paintBlock(g, this.mbccCore.image_getImage(this.miTitleImageIndex), this.miTitleTextID, this.miTitleX, this.miTitleY, this.miTitleWidth, this.mbccCore.miCanvasHeight, 0, this.miTitleAnchor);
        }
        if (this.mbccCore.m_canvas.m_game != null && (this.mbccCore.m_canvas.m_game.miState != 1 || !this.mbccCore.m_canvas.m_game.mbTutorialDisplaying && this.mbccCore.m_canvas.m_game.miChallengeCompleteTime <= 0 && this.mbccCore.m_canvas.m_game.miPowerDisplayTime <= 0 && this.mbccCore.m_canvas.m_game.miTitleDisplaying <= -1 && this.mbccCore.m_canvas.m_game.miAchievementTime <= 0 || this.mbccCore.m_canvas.m_game.miPygmyFlickID != -1) && this.miLSKImageIndex > -1) {
            this.mbccCore.image_Paint(g, this.miLSKImageIndex, this.miLSKX, this.miLSKY, this.miLSKAnchor);
        }
        if (this.miRSKImageIndex > -1 && (this._MENU_RIGHT_SOFT_KEY_MENU_OFFSET_ > -1 || !this.mbccCore.mbTouchScreen || this.mbccCore.mbClamShellOpen || this.mbccCore.mbOKTouch)) {
            this.mbccCore.image_Paint(g, this.miRSKImageIndex, this.miRSKX, this.miRSKY, this.miRSKAnchor);
        }
        g.setClip(iPrevX, iPrevY, iPrevW, iPrevH);
    }

    private int getAlignedX(int x, int iAnchor) {
        if (this.miType == 3 || this.miType == 2) {
            if ((iAnchor & 1) == 1) {
                x += this.getWidth() >> 1;
            } else if ((iAnchor & 8) == 8) {
                x += this.getWidth();
            }
        }
        return x;
    }

    private int getAlignedY(int y, int iAnchor) {
        if (this.miType == 3 || this.miType == 2) {
            if ((iAnchor & 2) == 2) {
                y += this.getHeight() - 1 >> 1;
            } else if ((iAnchor & 0x20) == 32) {
                y += this.getHeight();
            }
        }
        return y;
    }

    private int getVerticalScrollOffset() {
        return this.objects[this.miSelection + 5] + this.objects[this.miSelection + 7] - (this.getY() + this.getHeight());
    }

    private int getHorizontalScrollOffset() {
        return this.objects[this.miSelection + 4] + this.objects[this.miSelection + 6] - (this.getX() + this.getWidth());
    }

    private void setVertical(int iHeight, boolean bReplace) {
        if (!bReplace) {
            this.miVerticalCounter = (short)(this.miVerticalCounter + 1);
        }
    }

    private void setHorizontal(int iWidth, boolean bReplace) {
        if (!bReplace) {
            this.miHorizontalCounter = (short)(this.miHorizontalCounter + 1);
        }
    }

    private int setOffset(int parentID, int objOffset, boolean bReplace) {
        if (objOffset + 14 >= this.miSize) {
            short iSizeNew = (short)(this.miSize * 2);
            short[] temp = new short[this.miSize];
            CUtils.MEMCPY(temp, this.objects, (int)this.miSize);
            this.objects = new short[iSizeNew];
            CUtils.MEMSET(this.objects, (short)-1, (int)iSizeNew);
            CUtils.MEMCPY(this.objects, temp, (int)this.miSize);
            this.miSize = iSizeNew;
        }
        if (parentID < 0) {
            int objSelection;
            if (!bReplace) {
                if (this.miParent > -1) {
                    this.objects[objOffset + 3] = this.miParent;
                    this.objects[this.miParent + 2] = this.miOffset;
                } else {
                    this.objects[objOffset + 3] = -1;
                    this.miSelection = this.miOffset;
                }
                this.objects[objOffset + 2] = -1;
                this.miParent = this.miOffset;
                objSelection = this.miOffset;
            } else {
                objSelection = objOffset;
            }
            while (this.objects[objSelection + 3] > -1) {
                objSelection = this.objects[objSelection + 3];
            }
            if (this.miType == 3) {
                int iX = this.getX();
                while (objSelection > -1) {
                    this.objects[objSelection + 4] = (short)iX;
                    iX += this.objects[objSelection + 6] + this.miSpacingX;
                    objSelection = this.objects[objSelection + 2];
                }
            } else if (this.miType == 2) {
                int iY = this.getY();
                while (objSelection > -1) {
                    this.objects[objSelection + 5] = (short)iY;
                    iY += this.objects[objSelection + 7] + this.miSpacingY;
                    objSelection = this.objects[objSelection + 2];
                }
            }
        }
        if (!bReplace) {
            this.miOffset = (short)(this.miOffset + 14);
            short s = this.miIDCounter;
            this.miIDCounter = (short)(s + 1);
            return s;
        }
        return parentID;
    }

    private int addImage(int parentID, int iImageIndex, int iOffsetX, int iOffsetY, int iWidth, int iHeight, boolean bReplace, int iAnchor) {
        int imgOffset;
        int x = 0;
        int y = 0;
        int n = iAnchor = iAnchor < 0 ? (int)this.miAnchor : iAnchor;
        if (iWidth < 0) {
            iWidth = this.mbccCore.image_getWidth(iImageIndex);
        }
        if (iHeight < 0) {
            iHeight = this.mbccCore.image_getHeight(iImageIndex);
        }
        if (bReplace) {
            imgOffset = parentID * 14;
            parentID = this.objects[imgOffset + 1] / 14;
        } else {
            imgOffset = this.miOffset;
        }
        int parentOffset = parentID * 14;
        if (this.miType == 1) {
            x = iOffsetX;
            y = iOffsetY;
        } else if (this.miType == 2) {
            x = this.getX();
            if (parentID < 0 || bReplace) {
                this.setVertical(iHeight, bReplace);
            } else {
                y = this.objects[parentOffset + 7] - iHeight >> 1;
            }
        } else if (this.miType == 3) {
            y = this.getY();
            if (parentID < 0 || bReplace) {
                this.setHorizontal(iWidth, bReplace);
            } else {
                x = this.objects[parentOffset + 6] - iWidth >> 1;
            }
        }
        x = this.getAlignedX(x, iAnchor);
        y = this.getAlignedY(y, iAnchor);
        this.objects[imgOffset + 1] = (short)parentOffset;
        this.objects[imgOffset + 0] = 3;
        this.objects[imgOffset + 4] = (short)x;
        this.objects[imgOffset + 5] = (short)y;
        this.objects[imgOffset + 6] = (short)iWidth;
        this.objects[imgOffset + 7] = (short)iHeight;
        this.objects[imgOffset + 8] = (short)iOffsetX;
        this.objects[imgOffset + 9] = (short)iOffsetY;
        this.objects[imgOffset + 10] = (short)iAnchor;
        this.objects[imgOffset + 12] = 0;
        this.objects[imgOffset + 13] = (short)iImageIndex;
        return this.setOffset(parentID, imgOffset, bReplace);
    }

    private int addText(int parentID, int iTextID, int iImageIndex, int iOffsetX, int iOffsetY, int iWidth, int iHeight, boolean bReplace, int iTextType, int iAnchor) {
        int textOffset;
        byte[] text;
        int x = 0;
        int y = 0;
        if (iTextID == -1 && this.textForTextBlock != null) {
            text = this.textForTextBlock;
        } else if (iTextID == -1) {
            text = new byte[this.miTextEnd[this.miCurSizeMenuOptions / 4 + 1]];
            int i = 0;
            while (i < this.miTextEnd[this.miCurSizeMenuOptions / 4 + 1]) {
                text[i] = this.mTextForOptions[this.miTextEnd[this.miCurSizeMenuOptions / 4] + i];
                ++i;
            }
        } else {
            text = this.mbccCore.text_getByteFromTextPool(iTextID);
        }
        int n = iAnchor = iAnchor < 0 ? (int)this.miAnchor : iAnchor;
        if (iWidth < 0) {
            iWidth = this.mbccCore.text_getBlockWidth(this.mbccCore.image_getImage(iImageIndex), text, this.getWidth());
        }
        if (iHeight < 0) {
            iHeight = this.mbccCore.text_getHeightBox(this.mbccCore.image_getImage(iImageIndex), text, this.getWidth(), this.getHeight());
        }
        if (bReplace) {
            textOffset = parentID * 14;
            parentID = this.objects[textOffset + 1] / 14;
        } else {
            textOffset = this.miOffset;
        }
        int parentOffset = parentID * 14;
        if (iTextType == 2) {
            this.miTextBoxOffset = (short)textOffset;
            this.miTextBoxHeight = (short)this.mbccCore.text_getHeightBox(this.mbccCore.image_getImage(iImageIndex), text, iWidth, iHeight, false);
        }
        if (this.miType == 1) {
            x = iOffsetX;
            y = iOffsetY;
        } else if (this.miType == 2) {
            x = this.getX();
            if (parentID < 0 || bReplace) {
                this.setVertical(iHeight, bReplace);
            } else {
                y = this.objects[parentOffset + 7] - iHeight >> 1;
            }
        } else if (this.miType == 3) {
            y = this.getY();
            if (parentID < 0 || bReplace) {
                this.setHorizontal(iWidth, bReplace);
            } else {
                x = this.objects[parentOffset + 6] - iWidth >> 1;
            }
        }
        x = this.getAlignedX(x, iAnchor);
        y = this.getAlignedY(y, iAnchor);
        if ((iAnchor & 2) == 2) {
            y -= this.mbccCore.text_getHeightBox(this.mbccCore.image_getImage(iImageIndex), text, this.getWidth(), this.getHeight()) >> 1;
        } else if ((iAnchor & 0x20) == 32) {
            y -= this.mbccCore.text_getHeightBox(this.mbccCore.image_getImage(iImageIndex), text, this.getWidth(), this.getHeight());
        }
        this.objects[textOffset + 1] = (short)parentOffset;
        this.objects[textOffset + 0] = (short)iTextType;
        this.objects[textOffset + 4] = (short)x;
        this.objects[textOffset + 5] = (short)y;
        this.objects[textOffset + 6] = (short)iWidth;
        this.objects[textOffset + 7] = (short)iHeight;
        this.objects[textOffset + 8] = (short)iOffsetX;
        this.objects[textOffset + 9] = (short)iOffsetY;
        this.objects[textOffset + 11] = (short)iTextID;
        this.objects[textOffset + 10] = (short)iAnchor;
        this.objects[textOffset + 12] = 0;
        this.objects[textOffset + 13] = (short)iImageIndex;
        return this.setOffset(parentID, textOffset, bReplace);
    }

    private int addShape(int parentID, int iOffsetX, int iOffsetY, int iWidth, int iHeight, int iColor, int iShapeType, int iAnchor) {
        int parentOffset = parentID * 14;
        int x = 0;
        int y = 0;
        int n = iAnchor = iAnchor < 0 ? (int)this.miAnchor : iAnchor;
        if (this.miType == 1) {
            x = iOffsetX;
            y = iOffsetY;
        } else if (this.miType == 2) {
            x = this.getX();
            if (parentID < 0) {
                this.setVertical(iHeight, true);
            } else {
                y = this.objects[parentOffset + 7] - iHeight >> 1;
            }
        } else if (this.miType == 3) {
            y = this.getY();
            if (parentID < 0) {
                this.setHorizontal(iWidth, true);
            } else {
                x = this.objects[parentOffset + 6] - iWidth >> 1;
            }
        }
        x = this.getAlignedX(x, iAnchor);
        y = this.getAlignedY(y, iAnchor);
        if ((iAnchor & 1) == 1) {
            x -= iWidth >> 1;
        } else if ((iAnchor & 8) == 8) {
            x -= iWidth;
        }
        if ((iAnchor & 2) == 2) {
            y -= iHeight >> 1;
        } else if ((iAnchor & 0x20) == 32) {
            y -= iHeight;
        }
        this.objects[this.miOffset + 1] = (short)parentOffset;
        this.objects[this.miOffset + 0] = (short)iShapeType;
        this.objects[this.miOffset + 4] = (short)x;
        this.objects[this.miOffset + 5] = (short)y;
        this.objects[this.miOffset + 11] = (short)iColor;
        this.objects[this.miOffset + 6] = (short)iWidth;
        this.objects[this.miOffset + 7] = (short)iHeight;
        this.objects[this.miOffset + 8] = (short)iOffsetX;
        this.objects[this.miOffset + 9] = (short)iOffsetY;
        this.objects[this.miOffset + 10] = (short)iAnchor;
        this.objects[this.miOffset + 12] = 0;
        return this.setOffset(parentID, this.miOffset, false);
    }
}

