/*
 * Decompiled with CFR 0.152.
 */
package bightcode.bightsprite;

import bightcode.bightsprite.BSAnimationData;
import bightcode.bightsprite.BSClip;
import bightcode.bightsprite.BSLayer;
import bightcode.util.Animation;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BSCharacter
extends Animation {
    Image sheet;
    BSAnimationData data;
    int animationClass;
    int miFlipAnimation;
    int frame;
    int startFrame;
    int endFrame;
    int xAnchor;
    int yAnchor;
    int[] frameSizeCache;
    int[] frameEdgeCache;
    int miFrameSizeCacheLength;
    int miFrameEdgeCacheLength;
    boolean mbAnimFinished;
    boolean mbPlayForward;
    boolean isCopy;
    private int maxLayers;

    public BSCharacter(Image image, BSAnimationData animationData) {
        this.data = animationData;
        this.sheet = image;
        this.isCopy = false;
        this.resetToDefaults();
        this.cacheFrameSizes();
        this.cacheFrameEdges();
    }

    public void paint(Graphics g) {
        char length = this.data.frames[this.frame].layerCount;
        int i = length - '\u0001';
        while (i >= 0) {
            BSLayer layerRef = this.data.frames[this.frame].layers[i];
            BSClip clipRef = this.data.clips[layerRef.getClipNum()];
            short relXPos = layerRef.getX();
            short relYPos = layerRef.getY();
            short xPos = clipRef.x;
            short yPos = clipRef.y;
            char width = clipRef.width;
            char height = clipRef.height;
            if (width != '\u0000' && height != '\u0000') {
                int a = layerRef.getTrans() >> 12 & 0xF;
                int b = layerRef.getTrans() >> 8 & 0xF;
                int c = layerRef.getTrans() >> 4 & 0xF;
                int d = layerRef.getTrans() & 0xF;
                if (a == 15) {
                    a = -1;
                }
                if (b == 15) {
                    b = -1;
                }
                if (c == 15) {
                    c = -1;
                }
                if (d == 15) {
                    d = -1;
                }
                int transform = this.getJ2METransformBasedOnMatrix(a, b, c, d);
                g.drawRegion(this.sheet, (int)xPos, (int)yPos, (int)width, (int)height, transform, this.xAnchor + relXPos, this.yAnchor + relYPos, 20);
            }
            --i;
        }
        if (this.mbAutoplay) {
            this.advanceAnimationFrame();
        }
    }

    public void setAnchor(int x, int y) {
        this.xAnchor = x;
        this.yAnchor = y;
    }

    int getAnchorX() {
        return this.xAnchor;
    }

    int getAnchorY() {
        return this.yAnchor;
    }

    int getMaxLayers() {
        return this.maxLayers;
    }

    /*
     * WARNING - void declaration
     */
    public int getFrameHeight(int frame) {
        void var2_5;
        if (frame < this.startFrame) {
            frame += this.startFrame;
        }
        if (frame >= this.data.miFrameLength) {
            return 0;
        }
        int n = 65535;
        int maxY = 0;
        if (this.frameSizeCache == null) {
            int length = this.data.frames[frame].layerCount;
            int layer = 0;
            while (layer < length) {
                short s;
                if (this.data.frames[frame].layers[layer].getY() < s) {
                    s = this.data.frames[frame].layers[layer].getY();
                }
                BSClip clipReference = this.data.clips[this.data.frames[frame].layers[layer].getClipNum()];
                if (this.data.frames[frame].layers[layer].getY() + clipReference.height > maxY) {
                    maxY = this.data.frames[frame].layers[layer].getY() + clipReference.height;
                }
                ++layer;
            }
        } else {
            maxY = this.frameSizeCache[frame] & 0xFFFF;
            boolean bl = false;
        }
        return maxY - var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public int getFrameWidth(int frame) {
        void var2_5;
        if (frame < this.startFrame) {
            frame += this.startFrame;
        }
        if (frame >= this.data.miFrameLength) {
            return 0;
        }
        int n = 65535;
        int maxX = 0;
        if (this.frameSizeCache == null) {
            int length = this.data.frames[frame].layerCount;
            int layer = 0;
            while (layer < length) {
                short s;
                if (this.data.frames[frame].layers[layer].getX() < s) {
                    s = this.data.frames[frame].layers[layer].getX();
                }
                BSClip clipReference = this.data.clips[this.data.frames[frame].layers[layer].getClipNum()];
                if (this.data.frames[frame].layers[layer].getX() + clipReference.width > maxX) {
                    maxX = this.data.frames[frame].layers[layer].getX() + clipReference.width;
                }
                ++layer;
            }
        } else {
            maxX = (this.frameSizeCache[frame] & 0xFFFF0000) >> 16;
            boolean bl = false;
        }
        return maxX - var2_5;
    }

    public void setAnimationClass(int iAnimationClass) {
        this.miAnimationClass = iAnimationClass;
        int start = (this.data.miaRanges[iAnimationClass] & 0xFFFF0000) >> 16;
        int end = this.data.miaRanges[iAnimationClass] & 0xFFFF;
        this.setRunRange(start, end);
    }

    public int getAnimationClass() {
        return this.miAnimationClass;
    }

    public void setRunRange(int start, int end) {
        this.startFrame = start;
        this.endFrame = end;
        this.frame = start;
        this.miNumFrames = this.endFrame - this.startFrame + 1;
        this.mbAnimFinished = false;
    }

    public void advanceAnimationFrame() {
        if (this.mbAnimFinished) {
            return;
        }
        ++this.frame;
        if (this.frame >= this.data.miFrameLength) {
            this.frame = 0;
        }
        if (this.startFrame != -1 && this.frame > this.endFrame) {
            if (this.mbLoopAnimation) {
                this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
            } else {
                int n = this.frame = this.mbPlayForward ? this.endFrame : this.startFrame;
            }
        }
        if (this.endFrame != -1 && this.frame < this.startFrame) {
            if (this.mbLoopAnimation) {
                this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
            } else {
                int n = this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
            }
        }
        if (this.frame == this.endFrame && !this.mbLoopAnimation) {
            this.mbAnimFinished = true;
        }
    }

    public void autoplay(boolean autoplay) {
        this.mbAutoplay = autoplay;
    }

    public void forward(boolean forward) {
        this.mbPlayForward = forward;
    }

    public void loopAnimation(boolean loop) {
        this.mbLoopAnimation = loop;
        this.mbAnimFinished = false;
    }

    public int getLeftMostPiecePosition(int frame) {
        short minX = 0;
        if (this.frameEdgeCache == null) {
            int length = this.data.frames[frame].layerCount;
            int layer = 0;
            while (layer < length) {
                if (this.data.frames[frame].layers[layer].getX() < minX) {
                    minX = this.data.frames[frame].layers[layer].getX();
                }
                ++layer;
            }
        } else {
            minX = (short)((this.frameEdgeCache[0] & 0xFFFF0000) >> 16);
            minX = (short)((this.frameEdgeCache[frame] & 0xFFFF0000) >> 16);
        }
        return minX;
    }

    public int getRightMostPiecePosition(int frame) {
        int maxX = 0;
        if (this.frameEdgeCache == null) {
            int length = this.data.frames[frame].layerCount;
            int layer = 0;
            while (layer < length) {
                BSClip clipReference = this.data.clips[this.data.frames[frame].layers[layer].getClipNum()];
                if (this.data.frames[frame].layers[layer].getX() + clipReference.width > maxX) {
                    maxX = this.data.frames[frame].layers[layer].getX() + clipReference.width;
                }
                ++layer;
            }
        } else {
            maxX = this.frameEdgeCache[frame] & 0xFFFF;
        }
        return maxX;
    }

    public int getCurrentFrame() {
        return this.frame - this.startFrame;
    }

    public int getEndFrame() {
        return this.endFrame - this.startFrame;
    }

    public boolean isAnimationFinished() {
        return this.mbAnimFinished;
    }

    public void setFrame(int f) {
        if (f < this.startFrame) {
            f += this.startFrame;
        }
        this.frame = f;
        if (this.frame < this.endFrame) {
            this.mbAnimFinished = false;
        }
    }

    void setRelativeFrame(int f) {
        this.frame = this.startFrame + f;
        if (this.frame > this.endFrame) {
            this.frame = this.endFrame;
        }
    }

    public void translate(int x, int y) {
        this.xAnchor += x;
        this.yAnchor += y;
    }

    public void setImage(Image img) {
        this.sheet = img;
        if (img == null) {
            this.frameEdgeCache = null;
            this.frameSizeCache = null;
        }
    }

    public Image getImage() {
        return this.sheet;
    }

    public void applyTransform(int extraTransform) {
        this.characterTransform = extraTransform;
    }

    public void paint(Graphics g, int xAnchor, int yAnchor) {
        this.setAnchor(xAnchor, yAnchor);
        this.paint(g);
    }

    public void paint(Graphics g, int xAnchor, int yAnchor, int iAnchor) {
        this.setAnchor(xAnchor, yAnchor);
        this.paint(g);
    }

    public int getFrameCount() {
        return this.endFrame - this.startFrame + 1;
    }

    public void nextFrame() {
        ++this.frame;
        if (this.startFrame != -1 && this.frame > this.endFrame) {
            this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.endFrame : this.startFrame);
        }
    }

    public void previousFrame() {
        --this.frame;
        if (this.endFrame != -1 && this.frame < this.startFrame) {
            this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.startFrame : this.endFrame);
        }
    }

    public void previousAnimationFrame() {
        if (this.fpsLimit == -1) {
            this.mbUpdate = true;
        } else {
            this.time = System.currentTimeMillis() - this.lastFrameTime;
            boolean bl = this.mbUpdate = this.time >= (long)this.fpsTimeLimit;
        }
        if (this.mbUpdate) {
            --this.frame;
            if (this.frame < 0) {
                this.frame = this.miNumFrames - 1;
            }
            if (this.startFrame != -1 && this.frame > this.endFrame) {
                if (this.mbLoopAnimation) {
                    this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
                } else {
                    int n = this.frame = this.mbPlayForward ? this.endFrame : this.startFrame;
                }
            }
            if (this.endFrame != -1 && this.frame < this.startFrame) {
                this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.startFrame : this.endFrame);
            }
        }
    }

    private void cacheFrameEdges() {
        int length = this.data.miFrameLength;
        int[] newCache = new int[length];
        int i = 0;
        while (i < length) {
            int frameLeft = this.getLeftMostPiecePosition(i);
            int frameRight = this.getRightMostPiecePosition(i);
            newCache[i] = (char)frameLeft << 16 | (char)frameRight;
            ++i;
        }
        this.miFrameEdgeCacheLength = length;
        this.frameEdgeCache = newCache;
    }

    private void cacheFrameSizes() {
        int length = this.data.miFrameLength;
        int[] newCache = new int[length];
        int i = 0;
        while (i < length) {
            int frameWidth = this.getFrameWidth(i);
            int frameHeight = this.getFrameHeight(i);
            newCache[i] = (char)frameWidth << 16 | (char)frameHeight;
            ++i;
        }
        this.miFrameSizeCacheLength = length;
        this.frameSizeCache = newCache;
    }

    private void resetToDefaults() {
        this.xAnchor = 0;
        this.yAnchor = 0;
        this.frame = 0;
        this.endFrame = 0;
        this.startFrame = 0;
        this.mbAnimFinished = false;
        this.maxLayers = 0;
        int i = 0;
        while (i < this.data.miFrameLength) {
            if (this.data.frames[i].layerCount > this.maxLayers) {
                this.maxLayers = this.data.frames[i].layerCount;
            }
            ++i;
        }
        this.mbAutoplay = true;
        this.mbLoopAnimation = true;
        this.mbPlayForward = true;
    }

    private int getJ2METransformBasedOnMatrix(int a, int b, int c, int d) {
        int transform = 0;
        if (b == 0 && c == 0) {
            if (a == 1 && d == 1) {
                transform = 0;
            } else if (a == -1 && d == -1) {
                transform = 3;
            } else if (a == -1 && d == 1) {
                transform = 2;
            } else if (a == 1 && d == -1) {
                transform = 1;
            }
        } else if (a == 0 && d == 0) {
            if (b == -1 && c == 1) {
                transform = 6;
            } else if (b == 1 && c == -1) {
                transform = 5;
            } else if (b == 1 && c == 1) {
                transform = 4;
            } else if (b == -1 && c == -1) {
                transform = 7;
            }
        }
        return transform;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = (BSAnimationData)data;
        if (data == null) {
            this.frameEdgeCache = null;
            this.frameSizeCache = null;
        }
    }

    public void setFrameSizeCacheNull() {
        this.frameEdgeCache = null;
        this.frameSizeCache = null;
    }
}

