/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.BCC;
import app.Game;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class PGCanvas
extends Canvas
implements Runnable {
    private static final int FPS = 30;
    private BCC m_midlet;
    Game m_game;
    public static PGCanvas pgCanvas;
    private boolean active = false;
    int gcInPaint;
    public static boolean wasKeyPressed;

    static {
        wasKeyPressed = false;
    }

    public PGCanvas(BCC midlet) {
        this.m_midlet = midlet;
        this.setFullScreenMode(true);
        this.m_game = new Game(this.m_midlet);
        pgCanvas = this;
    }

    protected void paint(Graphics g) {
        if (!this.active) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (!this.active) {
            if (this.m_midlet.m_splash != null) {
                int iColor = 0;
                if (this.m_midlet.m_splash == this.m_midlet.getImageResource(5)) {
                    g.setColor(0xFFFFFF);
                } else {
                    g.setColor(iColor);
                }
                g.fillRect(0, 0, pgCanvas.getWidth(), pgCanvas.getHeight());
                g.drawImage(this.m_midlet.m_splash, pgCanvas.getWidth() >> 1, pgCanvas.getHeight() >> 1, 3);
            }
            return;
        }
        if (this.m_midlet.m_splash != null) {
            this.m_midlet.free(5);
            this.m_midlet.free(6);
            this.m_midlet.free(7);
            this.m_midlet.m_splash = null;
            System.gc();
        }
        ++this.gcInPaint;
        this.m_game.paint(g);
        g = null;
    }

    public void run() {
        try {
            this.m_game.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long FPS_DELAY = 33L;
        long lastTime = System.currentTimeMillis();
        this.active = true;
        while (this.active) {
            long currentTime = System.currentTimeMillis();
            long dt = FPS_DELAY - (currentTime - lastTime);
            if (currentTime - lastTime > FPS_DELAY) {
                lastTime = currentTime;
                try {
                    this.update();
                    this.repaint();
                    this.serviceRepaints();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (dt <= 0L) continue;
                Thread.sleep(dt);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void update() {
        this.m_game.run();
    }

    protected void hideNotify() {
        this.m_game.appPause();
    }

    protected void showNotify() {
        this.m_game.appUnPause();
    }

    private int translateKeyCode(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 1: {
                return 1;
            }
            case -2: 
            case 6: {
                return 2;
            }
            case -3: 
            case 2: {
                return 4;
            }
            case -4: 
            case 5: {
                return 8;
            }
            case -5: 
            case 8: {
                return 16;
            }
            case -6: 
            case 9: {
                return 32;
            }
            case -7: 
            case 10: {
                return 64;
            }
            case -8: 
            case 11: {
                return 128;
            }
            case -9: 
            case 12: {
                return 256;
            }
            case 42: {
                return 524288;
            }
            case 35: {
                return 0x100000;
            }
            case 48: {
                return 512;
            }
            case 49: {
                return 1024;
            }
            case 50: {
                return 2048;
            }
            case 51: {
                return 4096;
            }
            case 52: {
                return 8192;
            }
            case 53: {
                return 16384;
            }
            case 54: {
                return 32768;
            }
            case 55: {
                return 65536;
            }
            case 56: {
                return 131072;
            }
            case 57: {
                return 262144;
            }
        }
        return 0;
    }

    protected synchronized void keyPressed(int keyCode) {
        wasKeyPressed = true;
        this.m_game.keyPressed(this.translateKeyCode(keyCode));
    }

    protected synchronized void keyReleased(int keyCode) {
        this.m_game.keyReleased(this.translateKeyCode(keyCode));
    }
}

