/*
 * Decompiled with CFR 0.152.
 */
package bightcode.util;

import app.BCC;
import bightcode.util.Animation;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CSprite
extends Animation {
    BCC mbccCore;
    Object[] mSpritePack;

    public CSprite() {
    }

    public CSprite(BCC core, Object[] spritePackGameButtons) {
        this.mbccCore = core;
        this.mSpritePack = spritePackGameButtons;
        this.mbLoopAnimation = true;
        this.miAnchor = 20;
        this.fpsLimit = -1;
        this.fpsTimeLimit = -1;
        this.lastFrameTime = -1L;
        this.startFrame = -1;
        this.endFrame = -1;
        this.mbPlayForward = true;
        this.mbAutoplay = true;
        this.mbUpdate = false;
        this.lastFrameTime = System.currentTimeMillis();
    }

    public void setRunRange(int start, int end) {
        if (start != this.startFrame || end != this.endFrame) {
            this.startFrame = start;
            this.endFrame = end;
            this.frame = start;
        }
    }

    public void setRunRange(int iAnim) {
        this.miAnimationClass = iAnim;
        this.miNumFrames = this.mbccCore.sprite_getFrameCount(this.mSpritePack, this.miAnimationClass);
        this.startFrame = 0;
        this.endFrame = this.miNumFrames - 1;
        this.frame = this.startFrame;
    }

    public void forward(boolean playForward) {
        this.mbPlayForward = playForward;
    }

    public void autoplay(boolean autoPlay) {
        this.mbAutoplay = autoPlay;
    }

    public void setFrame(int frame) {
        if (frame < 0) {
            frame = 0;
        }
        if (frame >= this.miNumFrames) {
            frame = this.miNumFrames - 1;
        }
        this.frame = frame;
    }

    public int getCurrentFrame() {
        return this.frame;
    }

    public int getEndFrame() {
        return this.endFrame;
    }

    public void nextFrame() {
        ++this.frame;
        if (this.frame == this.miNumFrames) {
            this.frame = 0;
        }
    }

    public void previousFrame() {
        --this.frame;
        if (this.frame == -1) {
            this.frame = this.miNumFrames - 1;
        }
    }

    public void advanceAnimationFrame() {
        if (this.fpsLimit == -1) {
            this.mbUpdate = true;
        } else {
            this.time = System.currentTimeMillis() - this.lastFrameTime;
            boolean bl = this.mbUpdate = this.time >= (long)this.fpsTimeLimit;
        }
        if (this.mbUpdate) {
            ++this.frame;
            if (this.frame >= this.miNumFrames) {
                this.frame = 0;
            }
            if (this.startFrame != -1 && this.frame > this.endFrame) {
                if (this.mbLoopAnimation) {
                    this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
                } else {
                    int n = this.frame = this.mbPlayForward ? this.endFrame : this.startFrame;
                }
            }
            if (this.endFrame != -1 && this.frame < this.startFrame) {
                this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.startFrame : this.endFrame);
            }
        }
    }

    public void previousAnimationFrame() {
        if (this.fpsLimit == -1) {
            this.mbUpdate = true;
        } else {
            this.time = System.currentTimeMillis() - this.lastFrameTime;
            boolean bl = this.mbUpdate = this.time >= (long)this.fpsTimeLimit;
        }
        if (this.mbUpdate) {
            --this.frame;
            if (this.frame < 0) {
                this.frame = this.miNumFrames - 1;
            }
            if (this.startFrame != -1 && this.frame > this.endFrame) {
                if (this.mbLoopAnimation) {
                    this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
                } else {
                    int n = this.frame = this.mbPlayForward ? this.endFrame : this.startFrame;
                }
            }
            if (this.endFrame != -1 && this.frame < this.startFrame) {
                this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.startFrame : this.endFrame);
            }
        }
    }

    public int getFrameCount() {
        return this.miNumFrames;
    }

    public void setAnchor(int x, int y) {
        this.xAnchor = x;
        this.yAnchor = y;
    }

    public void translate(int x, int y) {
        this.xAnchor += x;
        this.yAnchor += y;
    }

    public void applyTransform(int extraTransform) {
        this.characterTransform = extraTransform;
    }

    public void paint(Graphics g) {
        this.paint(g, this.xAnchor, this.yAnchor);
    }

    public void paint(Graphics g, int xAnchor, int yAnchor) {
        this.paint(g, xAnchor, yAnchor, this.miAnchor);
    }

    public void paint(Graphics g, int xAnchor, int yAnchor, int iAnchor) {
        if (this.mbAutoplay) {
            if (this.fpsLimit == -1) {
                this.mbUpdate = true;
            } else {
                this.time = System.currentTimeMillis() - this.lastFrameTime;
                boolean bl = this.mbUpdate = this.time >= (long)this.fpsTimeLimit;
            }
            if (this.mbUpdate) {
                this.lastFrameTime = System.currentTimeMillis();
                this.frame = this.mbPlayForward ? ++this.frame : --this.frame;
                if (this.startFrame != -1 && this.frame > this.endFrame) {
                    if (this.mbLoopAnimation) {
                        this.frame = this.mbPlayForward ? this.startFrame : this.endFrame;
                    } else {
                        int n = this.frame = this.mbPlayForward ? this.endFrame : this.startFrame;
                    }
                }
                if (this.endFrame != -1 && this.frame < this.startFrame) {
                    this.frame = this.mbLoopAnimation ? (this.mbPlayForward ? this.startFrame : this.endFrame) : (this.mbPlayForward ? this.startFrame : this.endFrame);
                }
            }
        }
        this.mbccCore.sprite_Paint(g, this.mSpritePack, this.miAnimationClass, this.frame, xAnchor, yAnchor, iAnchor, this.characterTransform);
    }

    public int getFrameWidth(int frame) {
        return this.mbccCore.sprite_getFrameWidth(this.mSpritePack, this.miAnimationClass, frame);
    }

    public int getFrameHeight(int frame) {
        return this.mbccCore.sprite_getFrameHeight(this.mSpritePack, this.miAnimationClass, frame);
    }

    public void setAnimationClass(int iAnimationClass) {
        this.miAnimationClass = iAnimationClass;
        this.setRunRange(iAnimationClass);
    }

    public boolean isAnimationFinished() {
        return this.frame == this.endFrame;
    }

    public void loopAnimation(boolean bLoop) {
        this.mbLoopAnimation = bLoop;
    }

    public int getLeftMostPiecePosition(int frame) {
        return this.xAnchor;
    }

    public int getRightMostPiecePosition(int frame) {
        return this.xAnchor + this.mbccCore.sprite_getFrameWidth(this.mSpritePack, this.miAnimationClass, frame);
    }

    public int getCurrentRelativeFrame() {
        return this.frame - this.startFrame;
    }

    public Object getData() {
        return this.mSpritePack;
    }

    public Image getImage() {
        return null;
    }

    public void setData(Object data) {
        this.mSpritePack = (Object[])data;
    }

    public void setImage(Image img) {
    }

    public void setFrameSizeCacheNull() {
    }
}

