/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public abstract class NODLib
extends Canvas
implements Runnable,
PlayerListener {
    public static final int LANGUAGE_ENGLISH = 0;
    public static final int LANGUAGE_SPANISH = 1;
    public static final int KEY_ERROR = 9999;
    private static boolean mIsGameDone;
    private static boolean mIsGamePaused;
    private static int mPreviousWasKeyBitsPressed;
    private static int mPreviousWasKeyBitsReleased;
    private static int mKeyBitsState;
    private static int mWasKeyBitsPressed;
    private static int mWasKeyBitsReleased;
    private static InputStream mPackageInputStream;
    private static DataInputStream mPackageDataInputStream;
    private static StringBuffer mAuxiliarStringBuffer;
    private static boolean mIsSoundLooped;
    private static int mCurrentIdSoundPlaying;
    private static int[] mIdSounds;
    private static Player[] mPlayers;
    private static final int MAX_STRING_PAGES = 5;
    private static String[][] mPageStrings;
    private static short mTileWidth;
    private static short mTileHeight;
    private static short mTilemapRows;
    private static short mTilemapCols;
    private static Image mTilemapImage;
    private static byte[][] mTilemapImxels;
    private static byte[][] mTilemapFlags;
    public static String mDebugStr;
    private static long mLastFrameTime;
    static /* synthetic */ Class class$NODLib;

    NODLib() {
        mIsGameDone = false;
        mPageStrings = new String[5][];
    }

    protected void paint(Graphics g) {
        this.GamePaint(g);
    }

    public void run() {
        mLastFrameTime = System.currentTimeMillis();
        while (!mIsGameDone) {
            if (!mIsGamePaused) {
                long currentTime;
                mPreviousWasKeyBitsPressed = mWasKeyBitsPressed;
                mPreviousWasKeyBitsReleased = mWasKeyBitsReleased;
                mWasKeyBitsPressed = 0;
                mWasKeyBitsReleased = 0;
                try {
                    this.GameUpdate();
                    this.repaint();
                    this.serviceRepaints();
                }
                catch (Exception ex) {
                    mDebugStr = ex.getMessage();
                    System.out.println("GameUpdate " + ex.getMessage());
                    ex.printStackTrace();
                }
                if ((currentTime = System.currentTimeMillis()) - mLastFrameTime <= 100L) continue;
                try {
                    Thread.sleep(15L);
                    mLastFrameTime = System.currentTimeMillis();
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        ThePlague.mMidlet.destroyApp(true);
        ThePlague.mMidlet.notifyDestroyed();
    }

    public void exitGame() {
        mIsGameDone = true;
    }

    protected void setPauseGame(boolean value) {
        mIsGamePaused = value;
    }

    public abstract void GameUpdate();

    public abstract void GamePaint(Graphics var1);

    protected void keyPressed(int keyCode) {
        int code = this.translateKeyCode(keyCode, true);
        if (code == 9999) {
            return;
        }
        mKeyBitsState |= code;
        mWasKeyBitsPressed |= code;
    }

    protected void keyReleased(int keyCode) {
        int code = this.translateKeyCode(keyCode, false);
        if (code == 9999) {
            return;
        }
        mKeyBitsState &= ~code;
        mWasKeyBitsReleased |= code;
    }

    public static boolean isAnyKeyPressed() {
        return mKeyBitsState != 0;
    }

    public static boolean isKeyPressed(int keyCode) {
        return (mKeyBitsState & keyCode) != 0;
    }

    public static boolean wasKeyPressed(int keyCode) {
        return (mPreviousWasKeyBitsPressed & keyCode) != 0;
    }

    public static boolean wasKeyReleased(int keyCode) {
        return (mPreviousWasKeyBitsReleased & keyCode) != 0;
    }

    public static boolean wasAnyKeyReleased() {
        return mPreviousWasKeyBitsReleased != 0;
    }

    private int translateKeyCode(int keyCode, boolean isKeyPressed) {
        if ((keyCode = this.translateQwerty(keyCode, isKeyPressed)) == 48) {
            return 1;
        }
        if (keyCode == 49) {
            return 2;
        }
        if (keyCode == 50) {
            return 4;
        }
        if (keyCode == 51) {
            return 8;
        }
        if (keyCode == 52) {
            return 16;
        }
        if (keyCode == 53) {
            return 32;
        }
        if (keyCode == 54) {
            return 64;
        }
        if (keyCode == 55) {
            return 128;
        }
        if (keyCode == 56) {
            return 256;
        }
        if (keyCode == 57) {
            return 512;
        }
        if (keyCode == 42) {
            return 1024;
        }
        if (keyCode == 35) {
            return 2048;
        }
        if (keyCode == -1) {
            return 16384;
        }
        if (keyCode == -2) {
            return 32768;
        }
        if (keyCode == -3) {
            return 65536;
        }
        if (keyCode == -4) {
            return 131072;
        }
        if (keyCode == -7) {
            return 8192;
        }
        if (keyCode == -6) {
            return 4096;
        }
        if (keyCode == -5) {
            return 262144;
        }
        return 9999;
    }

    protected int translateQwerty(int keyCode, boolean isKeyPressed) {
        switch (keyCode) {
            case 82: 
            case 114: {
                keyCode = 49;
                break;
            }
            case 84: 
            case 116: {
                keyCode = 50;
                break;
            }
            case 89: 
            case 121: {
                keyCode = 51;
                break;
            }
            case 70: 
            case 102: {
                keyCode = 52;
                break;
            }
            case 71: 
            case 103: {
                keyCode = 53;
                break;
            }
            case 72: 
            case 104: {
                keyCode = 54;
                break;
            }
            case 86: 
            case 118: {
                keyCode = 55;
                break;
            }
            case 66: 
            case 98: {
                keyCode = 56;
                break;
            }
            case 78: 
            case 110: {
                keyCode = 57;
                break;
            }
            case 77: 
            case 109: {
                keyCode = 48;
                break;
            }
            case 85: 
            case 117: {
                keyCode = 42;
                break;
            }
            case 74: 
            case 106: {
                keyCode = 35;
                break;
            }
            case 8: {
                keyCode = -7;
                break;
            }
            case 10: {
                keyCode = -6;
            }
        }
        return keyCode;
    }

    public static void loadPackage(String fileName) {
        try {
            if (mPackageInputStream != null) {
                mPackageDataInputStream.close();
                mPackageInputStream.close();
            }
            mPackageInputStream = (class$NODLib == null ? (class$NODLib = NODLib.class$("NODLib")) : class$NODLib).getResourceAsStream(fileName);
            mPackageDataInputStream = new DataInputStream(mPackageInputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static byte[] readNextPackageEntry() {
        try {
            int size = mPackageDataInputStream.readInt();
            byte[] buffer = new byte[size];
            mPackageDataInputStream.read(buffer);
            return buffer;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int createPageString(byte[] bufferData) {
        try {
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(bufferData);
            DataInputStream dis = new DataInputStream(bais);
            int totalStrings = dis.readInt();
            int pageId = -1;
            for (i = 0; i < mPageStrings.length; ++i) {
                if (mPageStrings[i] != null) continue;
                pageId = i;
                break;
            }
            if (pageId == -1) {
                return -1;
            }
            NODLib.mPageStrings[pageId] = new String[totalStrings];
            for (i = 0; i < totalStrings; ++i) {
                NODLib.mPageStrings[pageId][i] = dis.readUTF();
            }
            dis.close();
            bais.close();
            return pageId;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public String getString(int pageId, int textId) {
        return mPageStrings[pageId][textId];
    }

    public void loadTilemap(byte[] tilemapData, byte[] tilesetImage) {
        try {
            int j;
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(tilemapData);
            DataInputStream dis = new DataInputStream(bais);
            mTilemapImage = Image.createImage((byte[])tilesetImage, (int)0, (int)tilesetImage.length);
            int rows = mTilemapRows = dis.readShort();
            int cols = mTilemapCols = dis.readShort();
            mTileWidth = dis.readByte();
            mTileHeight = dis.readByte();
            mTilemapImxels = new byte[rows][cols];
            mTilemapFlags = new byte[rows][cols];
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    NODLib.mTilemapImxels[i][j] = dis.readByte();
                }
            }
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    NODLib.mTilemapFlags[i][j] = dis.readByte();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void unloadTilemap() {
        mTilemapFlags = null;
        mTilemapImage = null;
        mTilemapImxels = null;
    }

    public void paintTilemap(Graphics g, int x, int y, int width, int height) {
        int rowstart = y / mTileHeight;
        int rowend = (y + height) / mTileHeight;
        int colstart = x / mTileWidth;
        int colend = (x + width) / mTileWidth;
        int rx = 0;
        int ry = 0;
        for (int i = rowstart; i < rowend; ++i) {
            for (int j = colstart; j < colend; ++j) {
                rx = mTilemapImxels[i][j] & 0xF;
                ry = (mTilemapImxels[i][j] & 0xF0) >> 4;
                g.drawRegion(mTilemapImage, rx * mTileWidth, ry * mTileHeight, (int)mTileWidth, (int)mTileHeight, 0, j * mTileWidth, i * mTileHeight, 0);
            }
        }
    }

    public int getTileX(int row, int col) {
        return mTilemapImxels[row][col] & 0xF;
    }

    public int getTileY(int row, int col) {
        return (mTilemapImxels[row][col] & 0xF0) >> 4;
    }

    protected String[] loadLanguageTexts(int language) {
        String textFile = null;
        if (language == 0) {
            textFile = "/text_en_QWERTY.txt";
        } else if (language == 1) {
            textFile = "/text_es_QWERTY.txt";
        }
        InputStream is = (class$NODLib == null ? (class$NODLib = NODLib.class$("NODLib")) : class$NODLib).getResourceAsStream(textFile);
        if (mAuxiliarStringBuffer == null) {
            mAuxiliarStringBuffer = new StringBuffer(100);
        }
        String[] texts = new String[80];
        for (int i = 0; i < 80; ++i) {
            mAuxiliarStringBuffer.setLength(0);
            texts[i] = this.readLine(is);
        }
        mAuxiliarStringBuffer = null;
        return texts;
    }

    private String readLine(InputStream inputStream) {
        try {
            char c;
            while ((c = (char)inputStream.read()) != '\n') {
                if (c == '\\') {
                    char c1 = (char)inputStream.read();
                    if (c1 == 'n') {
                        mAuxiliarStringBuffer.append('\n');
                        continue;
                    }
                    mAuxiliarStringBuffer.append('\\');
                    mAuxiliarStringBuffer.append(c1);
                    continue;
                }
                if (c == '\n' || c == '\r') continue;
                mAuxiliarStringBuffer.append(c);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return mAuxiliarStringBuffer.toString();
    }

    protected void loadSounds(int[] idSounds, String[] fileNames) {
        mIdSounds = new int[idSounds.length];
        mPlayers = new Player[idSounds.length];
        for (int i = 0; i < idSounds.length; ++i) {
            try {
                NODLib.mIdSounds[i] = idSounds[i];
                if (fileNames[i] == null) continue;
                NODLib.mPlayers[i] = Manager.createPlayer((InputStream)(class$NODLib == null ? NODLib.class$("NODLib") : class$NODLib).getResourceAsStream(fileNames[i]), (String)"audio/midi");
                mPlayers[i].realize();
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (MediaException ex) {
                // empty catch block
            }
        }
        mCurrentIdSoundPlaying = -1;
    }

    public void playSound(int id) {
        this.playSound(id, false);
    }

    public void playSound(int id, boolean looped) {
        if (mCurrentIdSoundPlaying == id) {
            return;
        }
        try {
            if (mCurrentIdSoundPlaying >= 0) {
                try {
                    mPlayers[mCurrentIdSoundPlaying].stop();
                    mPlayers[mCurrentIdSoundPlaying].deallocate();
                    mPlayers[mCurrentIdSoundPlaying].removePlayerListener((PlayerListener)this);
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            mIsSoundLooped = looped;
            mCurrentIdSoundPlaying = id;
            for (int i = 0; i < mIdSounds.length; ++i) {
                if (mIdSounds[i] != id) continue;
                try {
                    mPlayers[mCurrentIdSoundPlaying].addPlayerListener((PlayerListener)this);
                    mPlayers[mCurrentIdSoundPlaying].prefetch();
                    mPlayers[mCurrentIdSoundPlaying].start();
                    mDebugStr = " tocando bien ";
                    continue;
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                    mDebugStr = ex.getMessage();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            mCurrentIdSoundPlaying = -1;
        }
    }

    public void stopSound() {
        try {
            if (mCurrentIdSoundPlaying >= 0) {
                try {
                    mPlayers[mCurrentIdSoundPlaying].stop();
                    mPlayers[mCurrentIdSoundPlaying].deallocate();
                    mCurrentIdSoundPlaying = -1;
                    mDebugStr = " stoped ";
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            mCurrentIdSoundPlaying = -1;
        }
    }

    public int getCurrentSoundId() {
        return mCurrentIdSoundPlaying;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        try {
            if (event.equals("endOfMedia")) {
                if (mIsSoundLooped) {
                    try {
                        mPlayers[mCurrentIdSoundPlaying].prefetch();
                        mPlayers[mCurrentIdSoundPlaying].start();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    mCurrentIdSoundPlaying = -1;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            mCurrentIdSoundPlaying = -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mPreviousWasKeyBitsPressed = 0;
        mPreviousWasKeyBitsReleased = 0;
        mKeyBitsState = 0;
        mWasKeyBitsPressed = 0;
        mWasKeyBitsReleased = 0;
        mCurrentIdSoundPlaying = -1;
        mDebugStr = "debug";
    }
}

