/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MSprite {
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_ROT90 = 1;
    public static final byte TRANS_ROT180 = 2;
    public static final byte TRANS_ROT270 = 3;
    public static final byte TRANS_MIRROR = 4;
    public static final byte TRANS_MIRROR_ROT90 = 5;
    public static final byte TRANS_MIRROR_ROT180 = 6;
    public static final byte TRANS_MIRROR_ROT270 = 7;
    public static final byte ANCHOR_LEFT = 1;
    public static final byte ANCHOR_RIGHT = 2;
    public static final byte ANCHOR_TOP = 4;
    public static final byte ANCHOR_BOTTOM = 8;
    public static final byte ANCHOR_HCENTER = 16;
    public static final byte ANCHOR_VCENTER = 32;
    public static final int MODULE_LENGTH = 6;
    public static final int MODULE_TYPE_IMAGE = 0;
    public static final int MODULE_TYPE_RECT = 1;
    public static final int MODULE_TYPE_FILLRECT = 2;
    public static final int MODULE_TYPE_ARC = 3;
    public static final int MODULE_TYPE_FILLARC = 4;
    public static final int MODULE_TYPE_MARKER = 5;
    public static final byte PARAM_MODULE_TYPE = 0;
    public static final byte PARAM_MODULE_IMAGE_INDEX = 1;
    public static final byte PARAM_MODULE_IMAGE_XPOS = 2;
    public static final byte PARAM_MODULE_IMAGE_YPOS = 3;
    public static final byte PARAM_MODULE_IMAGE_WIDTH = 4;
    public static final byte PARAM_MODULE_IMAGE_HEIGHT = 5;
    public static final byte PARAM_FMODULE_MODULE_ID = 0;
    public static final byte PARAM_FMODULE_XPOS = 1;
    public static final byte PARAM_FMODULE_YPOS = 2;
    public static final byte PARAM_FMODULE_TRANS = 3;
    public static final byte PARAM_FRAME_BBOX_X0 = 0;
    public static final byte PARAM_FRAME_BBOX_Y0 = 1;
    public static final byte PARAM_FRAME_BBOX_X1 = 2;
    public static final byte PARAM_FRAME_BBOX_Y1 = 3;
    public static final byte PARAM_FRAME_SIZE = 4;
    public static final byte PARAM_AFRAME_FRAME_ID = 0;
    public static final byte PARAM_AFRAME_XPOS = 1;
    public static final byte PARAM_AFRAME_YPOS = 2;
    public static final byte PARAM_AFRAME_TRANS = 3;
    public static final byte PARAM_AFRAME_TIME = 4;
    public Image[] m_images;
    public short[] m_fontMap;
    public short[][] m_moduleArray;
    public short[][] m_frameArray;
    public short[][][] m_fmoduleArray;
    public short[][][] m_aframeArray;
    public int m_maxFrameHeight;
    public int m_currentPaletteIndex;
    public static final byte FONT_MAXARRAY_COORDS = 100;
    public int m_fontWidthSpace = 1;
    public int m_fontHeightSpace = 1;
    public int mFontSpace;
    public short[] m_fontTextX = new short[100];
    public short[] m_fontTextY = new short[100];
    public Vector mAnimations;
    private int[][] mTransform;
    private int[][] mAuxiliarMatrix;
    private int[][] mFrameAuxiliarMatrix;
    private int[] mAuxiliarVector3_1;
    private int[] mAuxiliarVector3_2;
    private int[] mAuxiliarVector3_3;

    private void initializeVars() {
        this.mTransform = new int[3][3];
        this.mAuxiliarMatrix = new int[3][3];
        this.mFrameAuxiliarMatrix = new int[3][3];
        this.mAuxiliarVector3_1 = new int[3];
        this.mAuxiliarVector3_2 = new int[3];
        this.mAuxiliarVector3_3 = new int[3];
        this.mAnimations = new Vector();
    }

    public MSprite(byte[] spriteData, byte[] imageData) {
        this.create(spriteData, imageData, null);
    }

    public MSprite(byte[] spriteData, byte[] imageData, byte[][] palettes) {
        this.create(spriteData, imageData, palettes);
    }

    private void create(byte[] spriteData, byte[] imageData, byte[][] palettes) {
        this.initializeVars();
        try {
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(spriteData);
            DataInputStream dis = new DataInputStream(bais);
            int paletteCount = dis.readByte();
            int[] paletteIndices = new int[paletteCount];
            for (i = 0; i < paletteCount; ++i) {
                paletteIndices[i] = dis.readInt();
            }
            this.m_moduleArray = new short[dis.readShort()][6];
            for (i = 0; i < this.m_moduleArray.length; ++i) {
                this.m_moduleArray[i][0] = dis.readByte();
                this.m_moduleArray[i][1] = dis.readShort();
                this.m_moduleArray[i][2] = dis.readShort();
                this.m_moduleArray[i][3] = dis.readShort();
                this.m_moduleArray[i][4] = dis.readShort();
                this.m_moduleArray[i][5] = dis.readShort();
            }
            this.m_frameArray = new short[dis.readShort()][4];
            this.m_fmoduleArray = new short[this.m_frameArray.length][][];
            this.m_maxFrameHeight = 0;
            for (i = 0; i < this.m_fmoduleArray.length; ++i) {
                short bboxx0 = 0;
                short bboxy0 = 0;
                short bboxx1 = 0;
                short bboxy1 = 0;
                this.m_fmoduleArray[i] = new short[dis.readShort()][4];
                for (int j = 0; j < this.m_fmoduleArray[i].length; ++j) {
                    short moduleHeight;
                    short moduleId;
                    this.m_fmoduleArray[i][j][0] = moduleId = dis.readShort();
                    this.m_fmoduleArray[i][j][1] = dis.readShort();
                    this.m_fmoduleArray[i][j][2] = dis.readShort();
                    this.m_fmoduleArray[i][j][3] = dis.readShort();
                    short moduleWidth = this.m_moduleArray[moduleId][0] == 0 ? this.m_moduleArray[moduleId][4] : this.m_moduleArray[moduleId][3];
                    short s = moduleHeight = this.m_moduleArray[moduleId][0] == 0 ? this.m_moduleArray[moduleId][5] : this.m_moduleArray[moduleId][3];
                    if (this.m_fmoduleArray[i][j][1] < bboxx0) {
                        bboxx0 = this.m_fmoduleArray[i][j][1];
                    }
                    if (this.m_fmoduleArray[i][j][1] + moduleWidth > bboxx1) {
                        bboxx1 = (short)(this.m_fmoduleArray[i][j][1] + moduleWidth);
                    }
                    if (this.m_fmoduleArray[i][j][2] < bboxy0) {
                        bboxy0 = this.m_fmoduleArray[i][j][2];
                    }
                    if (this.m_fmoduleArray[i][j][2] + moduleHeight <= bboxy1) continue;
                    bboxy1 = (short)(this.m_fmoduleArray[i][j][2] + moduleHeight);
                }
                this.m_frameArray[i][0] = bboxx0;
                this.m_frameArray[i][1] = bboxy0;
                this.m_frameArray[i][2] = bboxx1;
                this.m_frameArray[i][3] = bboxy1;
                int frameHeight = Math.abs(this.m_frameArray[i][3] - this.m_frameArray[i][1]);
                this.m_maxFrameHeight = frameHeight > this.m_maxFrameHeight ? frameHeight : this.m_maxFrameHeight;
            }
            this.m_aframeArray = new short[dis.readShort()][][];
            for (i = 0; i < this.m_aframeArray.length; ++i) {
                this.m_aframeArray[i] = new short[dis.readShort()][5];
                for (int j = 0; j < this.m_aframeArray[i].length; ++j) {
                    this.m_aframeArray[i][j][0] = dis.readShort();
                    this.m_aframeArray[i][j][4] = dis.readShort();
                    this.m_aframeArray[i][j][1] = dis.readShort();
                    this.m_aframeArray[i][j][2] = dis.readShort();
                    this.m_aframeArray[i][j][3] = dis.readShort();
                }
            }
            dis.close();
            paletteCount = palettes != null ? palettes.length + 1 : 1;
            this.m_images = new Image[paletteCount];
            this.m_images[0] = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
            for (i = 0; i < paletteCount - 1; ++i) {
                int chunkLength = imageData[33] << 24 | imageData[34] << 16 | imageData[35] << 8 | imageData[36];
                char[] chunkType = new char[]{(char)imageData[37], (char)imageData[38], (char)imageData[39], (char)imageData[40]};
                System.arraycopy(palettes[i], 0, imageData, 41, 768);
                this.m_images[i + 1] = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
            }
            this.setPalette(0);
        }
        catch (IOException ex) {
            throw new RuntimeException("error al cargar sprite");
        }
        catch (NegativeArraySizeException ex) {
            System.out.println("error: " + ex.getMessage());
        }
    }

    public void setFontParameters(int spaceWords, int spaceLetters, int spaceLines) {
        this.mFontSpace = spaceWords;
        this.m_fontWidthSpace = spaceLetters;
        this.m_fontHeightSpace = spaceLines;
    }

    public void setFontMap(short[] fontMap) {
        this.m_fontMap = new short[fontMap.length];
        System.arraycopy(fontMap, 0, this.m_fontMap, 0, fontMap.length);
    }

    int getStringWidth(String text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int result = 0;
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            char c = text.charAt(i);
            if (c == '\u00c2' || c == '*') continue;
            if (c == ' ') {
                result += this.mFontSpace;
                continue;
            }
            if (c > ' ') {
                short frameIndex = this.m_fontMap[c];
                result += this.m_frameArray[frameIndex][2] - this.m_frameArray[frameIndex][0] + 1 + this.m_fontWidthSpace;
                continue;
            }
            if (c != '\n') continue;
            return result;
        }
        return result;
    }

    public int getStringHeight(String text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int result = 0;
        boolean isFontHeightCalculated = false;
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            char c = text.charAt(i);
            if (c == '\u00c2' || c == '*') continue;
            if (c == '\n') {
                result += this.m_fontHeightSpace;
                isFontHeightCalculated = false;
                continue;
            }
            if (isFontHeightCalculated) continue;
            result += this.m_maxFrameHeight;
            isFontHeightCalculated = true;
        }
        return result;
    }

    public void drawString(Graphics g, String text, int x, int y, int anchor) {
        int xpos = x;
        int ypos = y;
        int currentLine = 0;
        this.calculateTextPositions(text, x, y, anchor);
        xpos = this.m_fontTextX[currentLine];
        ypos = this.m_fontTextY[currentLine];
        for (int i = 0; i < text.length(); ++i) {
            int frameIndex;
            char c = text.charAt(i);
            if (c == '\u00c2') continue;
            if (c == ' ') {
                xpos += this.mFontSpace;
                continue;
            }
            if (c == '*') {
                c = text.charAt(++i);
                frameIndex = 0;
                if (c == 'A' || c == 'a') {
                    frameIndex = 1;
                } else if (c == 'E' || c == 'e') {
                    frameIndex = 2;
                } else if (c == 'I' || c == 'i') {
                    frameIndex = 3;
                } else if (c == 'O' || c == 'o') {
                    frameIndex = 4;
                } else if (c == 'U' || c == 'u') {
                    frameIndex = 5;
                } else if (c == 'N' || c == 'n') {
                    frameIndex = 0;
                } else if (c == '*') {
                    frameIndex = 42;
                }
                frameIndex = this.m_fontMap[frameIndex];
                this.drawFrame(g, frameIndex, xpos, ypos, 0);
                xpos += this.m_frameArray[frameIndex][2] - this.m_frameArray[frameIndex][0] + 1 + this.m_fontWidthSpace;
                continue;
            }
            if (c > ' ') {
                frameIndex = this.m_fontMap[c];
                this.drawFrame(g, frameIndex, xpos, ypos, 0);
                xpos += this.m_frameArray[frameIndex][2] - this.m_frameArray[frameIndex][0] + 1 + this.m_fontWidthSpace;
                continue;
            }
            if (c != '\n') continue;
            xpos = this.m_fontTextX[++currentLine];
            ypos = this.m_fontTextY[currentLine];
        }
    }

    private void calculateTextPositions(String text, int x, int y, int anchor) {
        int i;
        if (anchor == 0) {
            anchor = 9;
        }
        int _x = x;
        int _y = y;
        int currentLine = 0;
        int currentLineWidth = 0;
        int totalTextHeight = 0;
        int textWidth = text.length();
        for (i = 0; i < textWidth; ++i) {
            char c = text.charAt(i);
            if (c == '\u00c2' || c == '*' && text.charAt(i + 1) != '*') continue;
            if (c == ' ') {
                currentLineWidth += this.mFontSpace + this.m_fontWidthSpace;
                continue;
            }
            if (c > ' ') {
                short frameIndex = this.m_fontMap[c];
                currentLineWidth += this.m_frameArray[frameIndex][2] - this.m_frameArray[frameIndex][0] + 1 + this.m_fontWidthSpace;
                continue;
            }
            if (c != '\n') continue;
            if ((anchor & 0x10) != 0) {
                _x = x - (currentLineWidth >> 1);
            } else if ((anchor & 2) != 0) {
                _x = x - currentLineWidth;
            }
            this.m_fontTextX[currentLine] = (short)_x;
            ++currentLine;
            _x = x;
            totalTextHeight += this.m_maxFrameHeight + this.m_fontHeightSpace;
            currentLineWidth = 0;
        }
        if ((anchor & 0x10) != 0) {
            _x = x - currentLineWidth / 2;
        } else if ((anchor & 2) != 0) {
            _x = x - currentLineWidth;
        }
        this.m_fontTextX[currentLine] = (short)_x;
        if ((anchor & 8) != 0) {
            _y -= totalTextHeight;
        } else if ((anchor & 0x20) != 0) {
            _y -= totalTextHeight >> 1;
        }
        for (i = 0; i <= currentLine; ++i) {
            this.m_fontTextY[i] = (short)(_y + i * (this.m_maxFrameHeight + this.m_fontHeightSpace));
        }
    }

    public void setPalette(int palette) {
        this.m_currentPaletteIndex = palette;
    }

    public void drawModule(Graphics g, int moduleId, int x, int y, int transformation) {
        short imageIndex = this.m_moduleArray[moduleId][1];
        short moduleX = this.m_moduleArray[moduleId][2];
        short moduleY = this.m_moduleArray[moduleId][3];
        short moduleWidth = this.m_moduleArray[moduleId][4];
        short moduleHeight = this.m_moduleArray[moduleId][5];
        Image image = this.m_images[this.m_currentPaletteIndex];
        int flag = 0;
        if (transformation == 1) {
            flag = 5;
        } else if (transformation == 2) {
            flag = 3;
        } else if (transformation == 3) {
            flag = 6;
        } else if (transformation == 4) {
            flag = 2;
        } else if (transformation == 5) {
            flag = 7;
        } else if (transformation == 6) {
            flag = 1;
        } else if (transformation == 7) {
            flag = 4;
        }
        g.drawRegion(image, (int)moduleX, (int)moduleY, (int)moduleWidth, (int)moduleHeight, flag, x, y, 0);
    }

    private void drawModule(Graphics g, int moduleId, int transformation) {
        short moduleX = this.m_moduleArray[moduleId][2];
        short moduleY = this.m_moduleArray[moduleId][3];
        int moduleWidth = this.m_moduleArray[moduleId][4];
        int moduleHeight = this.m_moduleArray[moduleId][5];
        Image image = this.m_images[this.m_currentPaletteIndex];
        switch (transformation) {
            case 1: {
                this.rotate(1);
                break;
            }
            case 2: {
                this.rotate(2);
                break;
            }
            case 3: {
                this.rotate(3);
                break;
            }
            case 4: {
                this.scale(-1, 1);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.scale(-1, 1);
                this.rotate(2);
                break;
            }
        }
        int[] mp0 = this.mAuxiliarVector3_1;
        int[] mp1 = this.mAuxiliarVector3_2;
        int[] mp2 = this.mAuxiliarVector3_3;
        this.mAuxiliarVector3_1[0] = 0;
        this.mAuxiliarVector3_1[1] = 0;
        this.mAuxiliarVector3_1[2] = 1;
        this.transformVector(this.mAuxiliarVector3_1, mp1);
        int _moduleWidth = moduleWidth;
        int _moduleHeight = moduleHeight;
        if (moduleWidth == moduleHeight) {
            // empty if block
        }
        this.mAuxiliarVector3_1[0] = ++_moduleWidth;
        this.mAuxiliarVector3_1[1] = _moduleHeight;
        this.mAuxiliarVector3_1[2] = 1;
        this.transformVector(this.mAuxiliarVector3_1, mp2);
        int flag = 0;
        int _x = mp1[0];
        int _y = mp1[1];
        mp0[0] = mp2[0] - mp1[0];
        mp0[1] = mp2[1] - mp1[1];
        if (mp0[0] == _moduleWidth && mp0[1] == _moduleHeight) {
            flag = 0;
        } else if (mp0[0] == -_moduleWidth && mp0[1] == _moduleHeight) {
            if (transformation == 0) {
                _x -= moduleWidth;
            }
            flag = 2;
        } else if (mp0[0] == _moduleWidth && mp0[1] == -_moduleHeight) {
            if (transformation == 0) {
                _y -= moduleHeight;
            }
            flag = 1;
        } else if (mp0[0] == -_moduleHeight && mp0[1] == -_moduleWidth) {
            if (transformation == 0) {
                _x -= moduleWidth;
                _y -= moduleHeight;
            }
            flag = 7;
        } else if (mp0[0] == -_moduleHeight && mp0[1] == _moduleWidth) {
            if (transformation == 0) {
                _x -= moduleHeight;
            }
            flag = 5;
        } else if (mp0[0] == -_moduleWidth && mp0[1] == -_moduleHeight) {
            if (transformation == 0) {
                _x -= moduleWidth;
                _y -= moduleHeight;
            }
            flag = 3;
        } else if (mp0[0] == _moduleHeight && mp0[1] == -_moduleWidth) {
            if (transformation == 0) {
                _y -= moduleWidth;
            }
            flag = 6;
        }
        g.drawRegion(image, (int)moduleX, (int)moduleY, moduleWidth, moduleHeight, flag, _x, _y, 0);
    }

    public int getFrameWidth(int frameId) {
        return this.m_frameArray[frameId][2] - this.m_frameArray[frameId][0];
    }

    public int getFrameHeight(int frameId) {
        return this.m_frameArray[frameId][3] - this.m_frameArray[frameId][1];
    }

    public int getModuleWidth(int moduleId) {
        return this.m_moduleArray[moduleId][4];
    }

    public int getModuleHeight(int moduleId) {
        return this.m_moduleArray[moduleId][5];
    }

    public void getFrameBounds(int frameId, int[] bounds) {
        bounds[0] = this.m_frameArray[frameId][0];
        bounds[1] = this.m_frameArray[frameId][1];
        bounds[2] = this.m_frameArray[frameId][2];
        bounds[3] = this.m_frameArray[frameId][3];
    }

    public void drawFrame(Graphics g, int frameId, int x, int y, int transformation) {
        this.setTransformToIdentity();
        this.translate(x, y);
        switch (transformation) {
            case 1: {
                this.rotate(1);
                break;
            }
            case 2: {
                this.rotate(2);
                break;
            }
            case 3: {
                this.rotate(3);
                break;
            }
            case 4: {
                this.scale(-1, 1);
                break;
            }
            case 5: {
                this.scale(-1, 1);
                this.rotate(1);
                break;
            }
            case 6: {
                this.scale(-1, 1);
                this.rotate(-2);
                break;
            }
            case 7: {
                this.scale(-1, 1);
                this.rotate(3);
            }
        }
        for (int i = 0; i < this.m_fmoduleArray[frameId].length; ++i) {
            this.copyTransform(this.mFrameAuxiliarMatrix);
            this.translate(this.m_fmoduleArray[frameId][i][1], this.m_fmoduleArray[frameId][i][2]);
            this.drawModule(g, this.m_fmoduleArray[frameId][i][0], this.m_fmoduleArray[frameId][i][3]);
            this.setTransform(this.mFrameAuxiliarMatrix);
        }
    }

    public void drawAFrame(Graphics g, int frameId, int x, int y, int transformation, boolean isParentAnimation) {
        if (isParentAnimation) {
            this.setTransformToIdentity();
            this.translate(x, y);
        }
        switch (transformation) {
            case 1: {
                this.rotate(1);
                break;
            }
            case 2: {
                this.rotate(2);
                break;
            }
            case 3: {
                this.rotate(3);
                break;
            }
            case 4: {
                this.scale(-1, 1);
                break;
            }
            case 5: {
                this.scale(-1, 1);
                this.rotate(-1);
                break;
            }
            case 6: {
                this.scale(-1, 1);
                this.rotate(2);
                break;
            }
            case 7: {
                this.rotate(3);
            }
        }
        for (int i = 0; i < this.m_fmoduleArray[frameId].length; ++i) {
            this.copyTransform(this.mFrameAuxiliarMatrix);
            this.translate(this.m_fmoduleArray[frameId][i][1], this.m_fmoduleArray[frameId][i][2]);
            this.drawModule(g, this.m_fmoduleArray[frameId][i][0], this.m_fmoduleArray[frameId][i][3]);
            this.setTransform(this.mFrameAuxiliarMatrix);
        }
    }

    public AnimationProfile createAnimationProfile() {
        AnimationProfile animation = new AnimationProfile();
        animation.mSprite = this;
        animation.mCurrentAFrame = 0;
        animation.mDelay = 0;
        animation.mDelayCounter = 0;
        animation.mIsLooped = false;
        animation.mIsAnimationOver = false;
        this.mAnimations.addElement(animation);
        return animation;
    }

    public void setAnimationDelay(AnimationProfile animationProfile, int delay) {
        animationProfile.mDelay = delay;
    }

    public void setCurrentAnimation(AnimationProfile animationProfile, int animationId, boolean loop, boolean reverse) {
        animationProfile.mCurrentAnimation = animationId;
        animationProfile.mIsLooped = loop;
        animationProfile.mIsReverse = reverse;
        animationProfile.mIsAnimationOver = false;
        animationProfile.mDelayCounter = 0;
        animationProfile.mCurrentAFrame = 0;
    }

    public void setCurrentAnimation(AnimationProfile animationProfile, int animationId, boolean loop) {
        this.setCurrentAnimation(animationProfile, animationId, loop, false);
    }

    public void restartCurrentAnimation(AnimationProfile animationProfile) {
        animationProfile.mCurrentAFrame = 0;
    }

    public int getAnimationCurrentFrame(AnimationProfile animationProfile) {
        return animationProfile.mCurrentAFrame;
    }

    public void updateAnimation(AnimationProfile animationProfile) {
        if (animationProfile.mIsAnimationOver) {
            return;
        }
        if (animationProfile.mDelayCounter < animationProfile.mDelay) {
            animationProfile.mDelayCounter = !animationProfile.mIsReverse ? ++animationProfile.mDelayCounter : --animationProfile.mDelayCounter;
            return;
        }
        animationProfile.mDelayCounter = 0;
        int animId = animationProfile.mCurrentAnimation;
        ++animationProfile.mCurrentAFrame;
        if (!animationProfile.mIsReverse && animationProfile.mCurrentAFrame >= this.m_aframeArray[animId].length) {
            if (animationProfile.mIsLooped) {
                animationProfile.mCurrentAFrame = 0;
            } else {
                --animationProfile.mCurrentAFrame;
                animationProfile.mIsAnimationOver = true;
            }
        } else if (animationProfile.mCurrentAFrame <= 0) {
            if (animationProfile.mIsLooped) {
                animationProfile.mCurrentAFrame = this.m_aframeArray[animId].length - 1;
            } else {
                animationProfile.mCurrentAFrame = 0;
                animationProfile.mIsAnimationOver = true;
            }
        }
    }

    public boolean isAnimationOver(AnimationProfile animationProfile) {
        return animationProfile.mIsAnimationOver;
    }

    public void drawAnimation(Graphics g, AnimationProfile animationProfile, int x, int y, int transformation) {
        this.setTransformToIdentity();
        this.translate(x, y);
        switch (transformation) {
            case 1: {
                this.rotate(1);
                break;
            }
            case 2: {
                this.rotate(2);
                break;
            }
            case 3: {
                this.rotate(3);
                break;
            }
            case 4: {
                this.scale(-1, 1);
                break;
            }
            case 5: {
                this.scale(-1, 1);
                this.rotate(1);
                break;
            }
            case 6: {
                this.rotate(2);
                this.scale(-1, 1);
                break;
            }
            case 7: {
                this.scale(-1, 1);
                this.rotate(3);
            }
        }
        this.translate(this.m_aframeArray[animationProfile.mCurrentAnimation][animationProfile.mCurrentAFrame][1], this.m_aframeArray[animationProfile.mCurrentAnimation][animationProfile.mCurrentAFrame][2]);
        this.drawAFrame(g, this.m_aframeArray[animationProfile.mCurrentAnimation][animationProfile.mCurrentAFrame][0], 0, 0, this.m_aframeArray[animationProfile.mCurrentAnimation][animationProfile.mCurrentAFrame][3], false);
    }

    public void destroyAnimation(AnimationProfile animationObject) {
        this.mAnimations.removeElement(animationObject);
    }

    private void setTransformToIdentity() {
        this.mTransform[0][0] = 1;
        this.mTransform[0][1] = 0;
        this.mTransform[0][2] = 0;
        this.mTransform[1][0] = 0;
        this.mTransform[1][1] = 1;
        this.mTransform[1][2] = 0;
        this.mTransform[2][0] = 0;
        this.mTransform[2][1] = 0;
        this.mTransform[2][2] = 1;
    }

    private void scale(int sx, int sy) {
        this.mAuxiliarMatrix[0][0] = sx;
        this.mAuxiliarMatrix[0][1] = 0;
        this.mAuxiliarMatrix[0][2] = 0;
        this.mAuxiliarMatrix[1][0] = 0;
        this.mAuxiliarMatrix[1][1] = sy;
        this.mAuxiliarMatrix[1][2] = 0;
        this.mAuxiliarMatrix[2][0] = 0;
        this.mAuxiliarMatrix[2][1] = 0;
        this.mAuxiliarMatrix[2][2] = 1;
        this.multiply(this.mAuxiliarMatrix);
    }

    private void translate(int tx, int ty) {
        this.mAuxiliarMatrix[0][0] = 1;
        this.mAuxiliarMatrix[0][1] = 0;
        this.mAuxiliarMatrix[0][2] = tx;
        this.mAuxiliarMatrix[1][0] = 0;
        this.mAuxiliarMatrix[1][1] = 1;
        this.mAuxiliarMatrix[1][2] = ty;
        this.mAuxiliarMatrix[2][0] = 0;
        this.mAuxiliarMatrix[2][1] = 0;
        this.mAuxiliarMatrix[2][2] = 1;
        this.multiply(this.mAuxiliarMatrix);
    }

    private void rotate(int rotateFlag) {
        int r00 = 0;
        int r01 = 0;
        int r10 = 0;
        int r11 = 0;
        if (rotateFlag == 1) {
            r00 = 0;
            r01 = -1;
            r10 = 1;
            r11 = 0;
        } else if (rotateFlag == -1) {
            r00 = 0;
            r01 = 1;
            r10 = -1;
            r11 = 0;
        } else if (rotateFlag == 2) {
            r00 = -1;
            r01 = 0;
            r10 = 0;
            r11 = -1;
        } else if (rotateFlag == 3) {
            r00 = 0;
            r01 = 1;
            r10 = -1;
            r11 = 0;
        }
        this.mAuxiliarMatrix[0][0] = r00;
        this.mAuxiliarMatrix[0][1] = r01;
        this.mAuxiliarMatrix[0][2] = 0;
        this.mAuxiliarMatrix[1][0] = r10;
        this.mAuxiliarMatrix[1][1] = r11;
        this.mAuxiliarMatrix[1][2] = 0;
        this.mAuxiliarMatrix[2][0] = 0;
        this.mAuxiliarMatrix[2][1] = 0;
        this.mAuxiliarMatrix[2][2] = 1;
        this.multiply(this.mAuxiliarMatrix);
    }

    private void multiply(int[][] m) {
        int[][] tm = this.mTransform;
        int a00 = tm[0][0] * m[0][0] + tm[0][1] * m[1][0] + tm[0][2] * m[2][0];
        int a01 = tm[0][0] * m[0][1] + tm[0][1] * m[1][1] + tm[0][2] * m[2][1];
        int a02 = tm[0][0] * m[0][2] + tm[0][1] * m[1][2] + tm[0][2] * m[2][2];
        int a10 = tm[1][0] * m[0][0] + tm[1][1] * m[1][0] + tm[1][2] * m[2][0];
        int a11 = tm[1][0] * m[0][1] + tm[1][1] * m[1][1] + tm[1][2] * m[2][1];
        int a12 = tm[1][0] * m[0][2] + tm[1][1] * m[1][2] + tm[1][2] * m[2][2];
        int a20 = tm[2][0] * m[0][0] + tm[2][1] * m[1][0] + tm[2][2] * m[2][0];
        int a21 = tm[2][0] * m[0][1] + tm[2][1] * m[1][1] + tm[2][2] * m[2][1];
        int a22 = tm[2][0] * m[0][2] + tm[2][1] * m[1][2] + tm[2][2] * m[2][2];
        this.mTransform[0][0] = a00;
        this.mTransform[0][1] = a01;
        this.mTransform[0][2] = a02;
        this.mTransform[1][0] = a10;
        this.mTransform[1][1] = a11;
        this.mTransform[1][2] = a12;
        this.mTransform[2][0] = a20;
        this.mTransform[2][1] = a21;
        this.mTransform[2][2] = a22;
    }

    private void dumpTransform() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                System.out.println("(" + i + ", " + j + ") = " + this.mTransform[i][j]);
            }
        }
    }

    private void transformVector(int[] vector3, int[] result) {
        int[][] tm = this.mTransform;
        int a0 = tm[0][0] * vector3[0] + tm[0][1] * vector3[1] + tm[0][2] * vector3[2];
        int a1 = tm[1][0] * vector3[0] + tm[1][1] * vector3[1] + tm[1][2] * vector3[2];
        int a2 = tm[2][0] * vector3[0] + tm[2][1] * vector3[1] + tm[2][2] * vector3[2];
        result[0] = a0;
        result[1] = a1;
        result[2] = a2;
    }

    private void copyTransform(int[][] m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                m[i][j] = this.mTransform[i][j];
            }
        }
    }

    private void setTransform(int[][] m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mTransform[i][j] = m[i][j];
            }
        }
    }

    public static class AnimationProfile {
        public MSprite mSprite;
        public int mCurrentAnimation;
        public int mCurrentAFrame;
        public int mDelay;
        public int mDelayCounter;
        public boolean mIsLooped;
        public boolean mIsReverse;
        public boolean mIsAnimationOver;
    }
}

