/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Actor {
    public static final byte TYPE_GREMLIN = 0;
    public static final byte TYPE_MOCO = 1;
    public static final byte COLOR_BLUE = 0;
    public static final byte COLOR_YELLOW = 1;
    public static final byte COLOR_RED = 2;
    public static final byte COLOR_PURPURE = 3;
    public static final byte COLOR_GREEN = 4;
    public static final int GREMLIN_STATE_NORMAL = 0;
    public static final int GREMLIN_STATE_EXPLOSION = 1;
    public static final int GREMLIN_STATE_FALLING = 2;
    public static final int GREMLIN_ESCUPIR_MIN_LIMITE = 80;
    public static final int GREMLIN_MOCO_TIME_DELAY = 3000;
    private static final int FREEFALL_DELAY = 4;
    public static final byte BEHAVIOR_LINEAL = 0;
    public static final byte BEHAVIOR_SENOIDAL = 1;
    private static final int[] GLOBOFRAME_COLORMAP = new int[]{1, 3, 4, 2, 0};
    private static MSprite mGremlinSprite;
    private static MSprite mMocoSprite;
    private static MSprite mExplosionSprite;
    private MSprite.AnimationProfile mGremlinAnimation;
    private MSprite.AnimationProfile mMocoAnimation;
    private MSprite.AnimationProfile mExplosionAnimation;
    public int offsetX = 0;
    public int offsetY = -10;
    public String mText = "0";
    public String mCacheText = "0";
    public int mActorType;
    public int mPositionX;
    public int mPositionY;
    public int mMocoPositionX;
    public int mMocoPositionY;
    public int mColor;
    public int mFreeFallDelayCounter;
    public int mBehavior;
    public int mActorState;
    public char mLetter;
    public boolean mIsCharacter;
    public boolean mIsEnabled;
    public boolean mIsMocoShowed;
    public boolean mIsMocoEnabled;
    public int mCharacterVisibilityPorcentage;
    public boolean mCharacterVisibilityAzar;
    public boolean mIsTextShowed;
    public boolean mIsBlinkingText;
    public int mBlinkingCount;
    public long mBlinkingTime;
    public int mPalette;
    public boolean isFlipX = false;
    public long mMocoTime;
    private int mVelocity;

    private Actor() {
        if (mGremlinSprite == null) {
            byte[] image = ThePlagueCanvas.readFile("/gremlin.png");
            byte[] sprite = ThePlagueCanvas.readFile("/gremlin.bsprite");
            mGremlinSprite = new MSprite(sprite, image);
            image = ThePlagueCanvas.readFile("/moco.png");
            sprite = ThePlagueCanvas.readFile("/moco.bsprite");
            mMocoSprite = new MSprite(sprite, image);
            image = ThePlagueCanvas.readFile("/explosion.png");
            sprite = ThePlagueCanvas.readFile("/explosion.bsprite");
            mExplosionSprite = new MSprite(sprite, image);
        }
    }

    public static Actor createGremlin() {
        Actor actor = new Actor();
        actor.mActorType = 0;
        actor.mPositionX = 0;
        actor.mPositionY = 0;
        actor.mColor = 0;
        actor.mIsCharacter = false;
        actor.mBehavior = 0;
        actor.mIsEnabled = false;
        actor.mFreeFallDelayCounter = 0;
        actor.mActorState = 0;
        actor.mVelocity = 1;
        actor.mGremlinAnimation = mGremlinSprite.createAnimationProfile();
        actor.mExplosionAnimation = mExplosionSprite.createAnimationProfile();
        actor.mMocoAnimation = mMocoSprite.createAnimationProfile();
        actor.mCharacterVisibilityPorcentage = 100;
        actor.mCharacterVisibilityAzar = false;
        actor.mIsTextShowed = true;
        actor.mPalette = 0;
        actor.mPalette = 0;
        mGremlinSprite.setCurrentAnimation(actor.mGremlinAnimation, 0, true);
        mGremlinSprite.setAnimationDelay(actor.mGremlinAnimation, 5);
        mExplosionSprite.setAnimationDelay(actor.mExplosionAnimation, 4);
        mMocoSprite.setAnimationDelay(actor.mMocoAnimation, 4);
        int flip = ThePlagueCanvas.mRandom.nextInt(2);
        System.out.println("Actor random : " + flip);
        if (flip == 0) {
            actor.isFlipX = false;
            actor.offsetX = -11;
        } else {
            actor.isFlipX = true;
            actor.offsetX = 7;
        }
        return actor;
    }

    public static Actor createMoco() {
        Actor actor = new Actor();
        actor.mActorType = 1;
        actor.mPositionX = 0;
        actor.mPositionY = 0;
        actor.mIsEnabled = false;
        actor.mIsMocoShowed = false;
        actor.mMocoAnimation = mMocoSprite.createAnimationProfile();
        return actor;
    }

    public int getType() {
        return this.mActorType;
    }

    public void setTextShowed(boolean value) {
        this.mIsTextShowed = value;
        this.mIsBlinkingText = false;
    }

    public void update() {
        if (this.mActorType == 0) {
            if (this.mActorState == 0) {
                int altura;
                if (this.mIsTextShowed && this.mCharacterVisibilityPorcentage < 100 && !this.mCharacterVisibilityAzar && this.mPositionY >= (altura = this.mCharacterVisibilityPorcentage * 240 / 100)) {
                    this.setTextShowed(false);
                    this.mBlinkingTime = System.currentTimeMillis();
                    this.mIsBlinkingText = true;
                    this.mBlinkingCount = 0;
                }
                if (!this.mIsMocoEnabled && this.mPositionY >= 80) {
                    ThePlagueCanvas.mRandom.setSeed(System.currentTimeMillis());
                    if (ThePlagueCanvas.mRandom.nextInt(this.mPositionY) == 0 && !ThePlagueCanvas.mIsLimpiadorEnabled) {
                        this.mMocoPositionX = this.mPositionX;
                        this.mMocoPositionY = this.mPositionY;
                        this.mMocoTime = System.currentTimeMillis();
                        mMocoSprite.setCurrentAnimation(this.mMocoAnimation, 0, false);
                        this.mIsMocoEnabled = true;
                    }
                } else {
                    mMocoSprite.updateAnimation(this.mMocoAnimation);
                    if (System.currentTimeMillis() - this.mMocoTime > 3000L) {
                        this.mIsMocoEnabled = false;
                    }
                }
                if (this.mFreeFallDelayCounter >= 4) {
                    this.mPositionY += this.mVelocity;
                    this.mFreeFallDelayCounter = 0;
                } else {
                    ++this.mFreeFallDelayCounter;
                }
                mGremlinSprite.updateAnimation(this.mGremlinAnimation);
            } else if (this.mActorState == 1) {
                mExplosionSprite.updateAnimation(this.mExplosionAnimation);
                if (mExplosionSprite.isAnimationOver(this.mExplosionAnimation)) {
                    this.setActorState(2);
                }
            } else if (this.mActorState == 2) {
                this.mPositionY += 3;
                mGremlinSprite.updateAnimation(this.mGremlinAnimation);
            }
        } else if (this.mActorType == 1 && this.mIsMocoShowed) {
            mMocoSprite.updateAnimation(this.mMocoAnimation);
            if (System.currentTimeMillis() - this.mMocoTime > 3000L) {
                this.mIsMocoShowed = false;
            }
        }
    }

    public boolean isMocoEnabled() {
        if (this.mActorType == 0) {
            return this.mIsMocoEnabled;
        }
        return false;
    }

    public void setMocoEnabled(boolean enabled) {
        if (this.mActorType == 0) {
            this.mIsMocoEnabled = enabled;
        }
    }

    public int getMocoPositionX() {
        return this.mMocoPositionX;
    }

    public int getMocoPositionY() {
        return this.mMocoPositionY;
    }

    public void paintMoco(Graphics g) {
        if (this.mActorType == 0 && this.mIsMocoEnabled) {
            mMocoSprite.drawAnimation(g, this.mMocoAnimation, this.mMocoPositionX, this.mMocoPositionY, 0);
        }
    }

    public void setVisibilityCharacters(int porcentaje, boolean alturaAzar) {
        this.mCharacterVisibilityPorcentage = porcentaje;
        this.mCharacterVisibilityAzar = alturaAzar;
    }

    public void paint(Graphics g) {
        if (this.mActorType == 0) {
            mGremlinSprite.setPalette(this.mPalette);
            if (this.mActorState == 0) {
                if (this.isFlipX) {
                    mGremlinSprite.drawAnimation(g, this.mGremlinAnimation, this.mPositionX, this.mPositionY, 4);
                } else {
                    mGremlinSprite.drawAnimation(g, this.mGremlinAnimation, this.mPositionX, this.mPositionY, 0);
                }
                if (this.mIsTextShowed) {
                    ThePlagueCanvas.mNumerosFont.drawString(g, this.mText, this.mPositionX + this.offsetX, this.mPositionY + this.offsetY, 16);
                } else if (this.mIsBlinkingText) {
                    if (System.currentTimeMillis() - this.mBlinkingTime > 2000L) {
                        this.mIsBlinkingText = false;
                    } else if (this.mBlinkingCount < 5) {
                        ThePlagueCanvas.mNumerosFont.drawString(g, this.mText, this.mPositionX, this.mPositionY - 0, 16);
                    }
                    if (++this.mBlinkingCount == 10) {
                        this.mBlinkingCount = 0;
                    }
                }
            } else if (this.mActorState == 1) {
                mExplosionSprite.drawAnimation(g, this.mExplosionAnimation, this.mPositionX, this.mPositionY, 0);
            } else if (this.mActorState == 2) {
                mGremlinSprite.drawAnimation(g, this.mGremlinAnimation, this.mPositionX, this.mPositionY, 0);
            }
        } else if (this.mActorType == 1 && this.mIsMocoShowed) {
            mMocoSprite.drawAnimation(g, this.mMocoAnimation, this.mPositionX, this.mPositionY, 0);
        }
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setPosition(int x, int y) {
        this.mPositionX = x;
        this.mPositionY = y;
    }

    public int getPositionX() {
        return this.mPositionX;
    }

    public int getPositionY() {
        return this.mPositionY;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
    }

    private int getSpriteFrame() {
        for (int i = 0; i < GLOBOFRAME_COLORMAP.length; ++i) {
            if (this.mColor != GLOBOFRAME_COLORMAP[i]) continue;
            return i;
        }
        return -1;
    }

    public void setVelocity(int velocity) {
        this.mVelocity = velocity;
    }

    public int getActorState() {
        return this.mActorState;
    }

    public void setActorState(int state) {
        this.mActorState = state;
        if (this.mActorState == 2) {
            mGremlinSprite.setCurrentAnimation(this.mGremlinAnimation, 1, true);
        } else if (this.mActorState == 0) {
            mGremlinSprite.setCurrentAnimation(this.mGremlinAnimation, 0, true);
        } else if (this.mActorState == 1) {
            mExplosionSprite.setCurrentAnimation(this.mExplosionAnimation, 0, false);
        }
    }

    public String getCacheText() {
        return this.mCacheText;
    }

    public void setCacheText(String text) {
        this.mCacheText = text;
    }

    public void setText(String text) {
        this.mText = text;
    }

    public String getText() {
        return this.mText;
    }

    public void chooseRandomColor() {
    }

    public void choseLetter(int level) {
        boolean isLetterEspecified;
        char direction = '\u0001';
        while (isLetterEspecified = false) {
            this.mLetter = (char)(this.mLetter + direction);
            if (this.mLetter < '9') continue;
            direction = -direction;
        }
    }

    public char getLetter() {
        return this.mLetter;
    }
}

