/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ThePlagueCanvas
extends NODLib {
    public static final int GAMESTATE_NONE = -1;
    public static final int GAMESTATE_LOGO = 0;
    public static final int GAMESTATE_LOADING = 1;
    public static final int GAMESTATE_SOUNDQUESTION = 2;
    public static final int GAMESTATE_SPLASH = 3;
    public static final int GAMESTATE_MAINMENU = 4;
    public static final int GAMESTATE_MAINMENU_OPTIONS = 5;
    public static final int GAMESTATE_MAINMENU_HELP = 6;
    public static final int GAMESTATE_MAINMENU_HELPPAGE = 7;
    public static final int GAMESTATE_MAINMENU_HIGHSCORES = 8;
    public static final int GAMESTATE_MAINMENU_ABOUT = 9;
    public static final int GAMESTATE_MAINMENU_PLAYMENU = 10;
    public static final int GAMESTATE_MAINMENU_PLAY_LEVELINTRO = 11;
    public static final int GAMESTATE_MAINMENU_PLAYING = 12;
    public static final int GAMESTATE_MAINMENU_PLAY_LEVELEND = 13;
    public static final int GAMESTATE_MAINMENU_PLAY_ENTERSCORENAME = 14;
    public static final int GAMESTATE_MAINMENU_PLAY_SCOREBOARD = 15;
    public static final int GAMESTATE_MAINMENU_PLAY_TUTORIAL = 16;
    public static final int GAMESTATE_MAINMENU_PLAY_INGAMEMENU = 17;
    public static final int GAMESTATE_LANGUAGE_QUESTION = 18;
    public static final int GAMESTATE_MAINMENU_OPTIONS_LANGUAGE = 19;
    public static final int GAMESTATE_MAINMENU_EXIT_DIALOG = 20;
    public static final int GAMESTATE_MAINMENU_RESET_DATA_DIALOG = 21;
    public static final int GAMESTATE_MAINMENU_PLAYING_LEVEL = 22;
    public static final int GAMESTATE_MAINMENU_PLAYING_CONTINUE = 23;
    public static final int GAMESTATE_MAINMENU_PLAY_CONGRATULATIONS_0 = 24;
    public static final int GAMESTATE_MAINMENU_PLAY_CONGRATULATIONS_1 = 25;
    public static final int GAMESTATE_MAINMENU_PLAYMENU_GAMETYPE = 26;
    public static final int GAMESTATE_MAINMENU_PLAY_SELECT_LEVEL = 27;
    public static final int GAMESTATE_MAINMENU_PLAY_SCOREBOARD_2 = 28;
    public static final int GAMESTATE_NO_LANDSCAPE = 29;
    public static final int INGAMEMENU_SUBSTATE_NONE = 0;
    public static final int INGAMEMENU_SUBSTATE_CONFIRM_MM = 1;
    public static final int INGAMEMENU_SUBSTATE_CONFIRM_EXIT = 2;
    public static final int[] MAINMENU_LIST = new int[]{11, 12, 13, 14, 15, 16};
    public static final int[] OPTIONS_LIST = new int[]{17, 6, 18};
    public static final int[] HELP_LIST = new int[]{19, 24, 25};
    public static final int[] PLAY_LIST = new int[]{51, 26};
    public static final int[] GAMEMODE_LIST = new int[]{55, 56};
    public static final int[] INGAMEMENU_LIST = new int[]{10, 17, 13, 23, 16};
    public static final int[] INGAMEMENU_LIST_2 = new int[]{10, 74, 17, 13, 23, 16};
    public static final int[] LANGUAGE_LIST = new int[]{7, 8};
    public static final int[] ENDURANCE_MENU_LIST = new int[]{51, 23};
    public static final int[] ENDURANCE_MENU_LIST_2 = new int[]{74, 23};
    public static final int[] TIME_TRIAL_MENU_LIST = new int[]{60, 61, 62, 23};
    public static final int[] TIME_TRIAL_MENU_LIST_2 = new int[]{61, 62, 23};
    public static final int[] TIME_TRIAL_MENU_LIST_3 = new int[]{73, 61, 62, 23};
    public static final char[][] KEYCHARS = new char[][]{{'A', 'B', 'C'}, {'D', 'E', 'F'}, {'G', 'H', 'I'}, {'J', 'K', 'L'}, {'M', 'N', 'O'}, {'P', 'Q', 'R', 'S'}, {'T', 'U', 'V'}, {'W', 'X', 'Y', 'Z'}};
    public static final int[] KEYCHARSCODES = new int[]{4, 8, 16, 32, 64, 128, 256, 512};
    public static final int MAX_SCORES = 5;
    public static final int[][] HELP_PAGES = new int[][]{{28, 65, 66}, {75, 76}, {77}};
    public static int mAboutPageY;
    public static int mScrollCounter;
    public static final String ABOUT_PAGE = " NVASION CHUPACABRAS \n VERSION 1.0.0 \n\n DEVELOPED AND PUBLISHED BY \n INODE ENTERTAINMENT \n\n SUPPORT \n WWW.INODESOFT.COM \n SUPPORT@INODESOFT.COM \n\n STUDIO MANAGER \n JAIME ENRIQUEZ \n\n LEAD PROGRAMMER \n ISRAEL CABRERA \n\n PROGRAMMERS \n PEDRO OSUNA \n GERMAN MARTINEZ \n\n GRAPHIC DESIGN \n JOSUE AGUILAR \n\n QA \n RUBY ENRIQUEZ \n\n 2011 INODE ENTERTAINMENT. \n ALL RIGHTS RESERVED. \n\n";
    public static final String ABOUT_PAGE_SPANISH = " INVASION CHUPACABRAS \n VERSION: 1.0.0 \n\nDESARROLLADO Y PUBLICADO POR\n INODE ENTERTAINMENT \n\n SOPORTE \n WWW.INODESOFT.COM \n SUPPORT@INODESOFT.COM \n\n GERENTE GENERAL \n JAIME ENRIQUEZ \n\n PROGRAMADOR LIDER \n ISRAEL CABRERA \n\n PROGRAMADORES \n PEDRO OSUNA \n GERMAN MARTINEZ \n\n DISE\u00d1ADOR GRAFICO \n JOSUE AGUILAR \n\n ASEGURAMIENTO DE LA CALIDAD \n RUBY ENRIQUEZ \n\n 2011 INODE ENTERTAINMENT. \n TODOS LOS DERECHOS RESERVADOS. \n\n";
    public static final int SCROLL_DELAY = 2;
    public static int[] TUTORIAL;
    public static String[] SOUND_FILE_LIST;
    public static int[] SOUND_ID_LIST;
    public static final int PUNTAJE_ALTURA_PUNTOS_100 = 50;
    public static final int PUNTAJE_ALTURA_PUNTOS_LINEAL = 200;
    public static final int TIME_TRIAL_LEVEL_TIME = 180;
    public static final int GAMEMODE_ENDURANCE = 0;
    public static final int GAMEMODE_TIME_TRIAL = 1;
    public static final int PENALIZACION_50 = 50;
    public static final int PENALIZACION_20 = 20;
    public static final String[] USO_CARACTERES;
    public static final String[] TIME_TRIAL_USO_CARACTERES;
    public static final String[] USO_DE_LETRAS;
    public static final String[] TIME_TRIAL_USO_DE_LETRAS;
    public static final String[] VISIBILIDAD_DE_CARACTERES;
    public static final String[] TIME_TRIAL_VISIBILIDAD_DE_CARACTERES;
    public static final int[] ENEMIGOS_EN_PANTALLA;
    public static final int[] TIME_TRIAL_ENEMIGOS_EN_PANTALLA;
    public static final int[] VELOCIDAD_DE_CAIDA;
    public static final int[] TIME_TRIAL_VELOCIDAD_DE_CAIDA;
    public static final int[] ATAQUE_DE_ENEMIGOS;
    public static final int[] TIME_TRIAL_ATAQUE_DE_ENEMIGOS;
    public static final int[] ERRORES_PERMITIDOS;
    public static final String[] ORDEN_NIVELES_ENDURANCE;
    public static final String[] TIME_TRIAL_ORDEN_NIVELES;
    public static final int MAX_SCENES = 30;
    public static final int MAX_GREMLINS = 6;
    public static final int MAX_MOCOS = 6;
    public static final int ENEMIGOS_A_DERROTAR = 20;
    public static char[] mCaracteresEntrados;
    public static byte mNextCaracterIndex;
    public static int[] mEnemigosEliminados;
    public static int[] mScoreNivel;
    public static Actor[] mActorList;
    public static Random mRandom;
    public static int mGameLevelStartIndex;
    public static int mPlayerEnergy;
    public static int mGameMode;
    public static int mTotalGremlinsMuertos;
    public static int mCurrentBackground;
    public static int mHighscorePageIndex;
    public static int mBriefingIndex;
    public static int mBriefingCounter;
    public static int mHelpPageIndex;
    public static int mEndingScrollY;
    public static boolean mIsContinueSelected;
    public static boolean mIsBackgroundChanged;
    public static StringBuffer mStringBuffer;
    public static long mAuxiliarTime;
    public static Image mBackgroundImage;
    public static Image mSplashImage;
    public static Image mLogoImage;
    public static Image mSplashLogoImage;
    public static Image mFinalImage;
    public static Image mIconoGrenmlinImage;
    public static Image monoIdiomaImg;
    public static Image monoSoundImg;
    public static Image flechaImg;
    public static Image backgroundImg;
    public static Image monoMenuImg;
    public static Image menuBackImg;
    public static Image fondoGreenImg;
    public static Image dialogoImg;
    public static Image finalImg;
    public static MSprite mSmallFont;
    public static MSprite mMediumFont;
    public static MSprite mNumerosFont;
    public static MSprite mMenusSprite;
    public static MSprite mPiezasSprite;
    public static MSprite mMingTatamiSprite;
    public static MSprite mFlechitaSprite;
    public static MSprite mFrameWindowSprite;
    public static MSprite mFrameWindow2Sprite;
    public static MSprite mItemsSprite;
    public static MSprite mPlagueLimpiadorSprite;
    public static MSprite mPlagueMarquitoSprite;
    public static MSprite mPlagueEnergySprite;
    public static MSprite mPlagueFinal1Sprite;
    public static MSprite mPlagueFinal2Sprite;
    public static MSprite.AnimationProfile mPlagueEnergyAnimation;
    public static MSprite.AnimationProfile mPlagueLimpiadorAnimation;
    public static MSprite.AnimationProfile mFlechitaAnimationLeft;
    public static MSprite.AnimationProfile mFlechitaAnimationRight;
    public static long mPlagueEnergyCounter;
    public static Particles mPetalos;
    public static boolean mIsLimpiadorEnabled;
    public static boolean mIsEnglish;
    public static int mCurrentState;
    public static int mSelectedMenuItemIndex;
    public static int mCurrentSoundId;
    public static boolean mIsSoundEnabled;
    public static boolean mIsChangingState;
    public static boolean mIsWinLevel;
    public static int mRMSCurrentLevel;
    public static int mRMSLastLiberadoLevel;
    public static int mRMSScore;
    public static int mRMSLives;
    public static int mRMSEnemigosDerrotados;
    public static int mRMSTimeTrialCurrentLevel;
    public static boolean mRMSTimeTrailFinished;
    public static int mCurrentLevel;
    public static int mScore;
    public static int mLives;
    public static int mLevelTime;
    public static int mPivoteX;
    public static int mPivoteY;
    public static int mLevelWidth;
    public static int mLevelHeight;
    public static int mPivoteColorDepth;
    public static int mCurrentTutorialIndex;
    public static int mLevelValue;
    public static byte[][] mCurrentLevelData;
    public static String[] mLanguageTexts;
    public static String[] mScoreNames;
    public static int[] mScoreValues;
    public static final int TIME_TRIAL_MAX_SCORES = 3;
    public static String[][] mTimeTrialScoreNames;
    public static int[][] mTimeTrialScoreValues;
    private int mChangeScoreIndex;
    private String mScoreNewName;
    private long mCursorTime;
    private int mScoreLetterIndex;
    private int mPreviousScoreKeyCode;
    private int mInGameMenuSubstate;
    private boolean mInterruptionInIntro;
    private boolean mIsHelpInGameMenu;
    private int mPreviousState;
    public int mKeyCode = 0;
    String hide = "no";
    long lastTime = 0L;
    boolean onetime = true;
    public static int offsetMenuX;
    private static boolean mIsViewEnding;
    private static boolean mIsBackgroundChoose;
    int pressKey = -1;
    int penal = 0;
    static /* synthetic */ Class class$ThePlagueCanvas;

    public ThePlagueCanvas() {
        this.changeState(0);
    }

    private void paintNoLandscapeState(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (mSmallFont != null) {
            mSmallFont.drawString(g, mLanguageTexts[78], this.getWidth() >> 1, this.getHeight() >> 1, 48);
        }
    }

    protected void sizeChanged(int w, int h) {
        mCurrentState = this.mPreviousState;
        if (mCurrentState > 0) {
            this.showNotify();
        }
    }

    protected void showNotify() {
        if (mCurrentState == 29) {
            return;
        }
        switch (mCurrentState) {
            case 11: {
                mSelectedMenuItemIndex = 0;
                this.mInGameMenuSubstate = 0;
                mCurrentState = 17;
                break;
            }
            case 12: 
            case 16: {
                mSelectedMenuItemIndex = 0;
                this.mInGameMenuSubstate = 0;
                mCurrentState = 17;
            }
        }
        this.setPauseGame(false);
        if (mCurrentState != 17 && mCurrentState != 13) {
            this.playSound(mCurrentSoundId, true);
        }
    }

    protected void hideNotify() {
        if (mCurrentState == 29) {
            return;
        }
        mCurrentSoundId = this.getCurrentSoundId();
        this.setPauseGame(true);
        this.stopSound();
    }

    public void GameUpdate() {
        if (mIsChangingState) {
            return;
        }
        switch (mCurrentState) {
            case 0: {
                this.updateLogoState();
                break;
            }
            case 18: {
                this.updateLanguageQuestionState();
                break;
            }
            case 1: {
                this.updateLoadingState();
                break;
            }
            case 2: {
                this.updateSoundQuestionState();
                break;
            }
            case 3: {
                this.updateSplashState();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                this.updateMainMenuState();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.updatePlayingState();
            }
        }
    }

    public void GamePaint(Graphics g) {
        if (this.onetime) {
            this.lastTime = System.currentTimeMillis();
            this.onetime = false;
        }
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 320, 240);
        if (mIsChangingState) {
            return;
        }
        switch (mCurrentState) {
            case 29: {
                this.paintNoLandscapeState(g);
                break;
            }
            case 0: {
                this.paintLogoState(g);
                break;
            }
            case 18: {
                this.paintLanguageQuestionState(g);
                break;
            }
            case 1: {
                this.paintLoadingState(g);
                break;
            }
            case 2: {
                this.paintSoundQuestionState(g);
                break;
            }
            case 3: {
                this.paintSplashState(g);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                this.paintMainMenuState(g);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.paintPlayingState(g);
            }
        }
        this.lastTime = System.currentTimeMillis();
    }

    public void changeState(int newState) {
        mIsChangingState = true;
        switch (mCurrentState) {
            case 0: {
                this.quitLogoState();
                break;
            }
            case 18: {
                this.quitLanguageQuestionState();
                break;
            }
            case 1: {
                this.quitLoadingState();
                break;
            }
            case 2: {
                this.quitSoundQuestionState();
                break;
            }
            case 3: {
                this.quitSplashState();
                break;
            }
            case 4: {
                this.quitMainMenuState();
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 23: {
                this.quitPlayingState();
            }
        }
        mCurrentState = newState;
        switch (newState) {
            case 0: {
                this.initLogoState();
                break;
            }
            case 18: {
                this.initLanguageQuestionState();
                break;
            }
            case 1: {
                this.initLoadingState();
                break;
            }
            case 2: {
                this.initSoundQuestionState();
                break;
            }
            case 3: {
                this.initSplashState();
                break;
            }
            case 4: {
                this.initMainMenuState();
                break;
            }
            case 12: 
            case 16: 
            case 22: 
            case 23: {
                this.initPlayingState();
            }
        }
        mIsChangingState = false;
    }

    public static byte[] readFile(String name) {
        try {
            InputStream is = (class$ThePlagueCanvas == null ? (class$ThePlagueCanvas = ThePlagueCanvas.class$("ThePlagueCanvas")) : class$ThePlagueCanvas).getResourceAsStream(name);
            byte[] result = new byte[is.available()];
            is.read(result);
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void chooseBackgroundImage() {
        int bkValue = 0;
        try {
            if (mIsContinueSelected) {
                if (mGameMode == 0) {
                    bkValue = Integer.valueOf(ORDEN_NIVELES_ENDURANCE[(mCurrentLevel - 1) / 3]);
                    mBackgroundImage = Image.createImage((String)("/bk" + (bkValue + (mCurrentLevel - 1) % 3) + ".png"));
                } else {
                    mBackgroundImage = Image.createImage((String)("/bk" + TIME_TRIAL_ORDEN_NIVELES[mCurrentLevel - 1] + ".png"));
                }
            } else if (mGameMode == 0) {
                int level = 0;
                level = mTotalGremlinsMuertos < (mCurrentLevel - 1) * 20 ? mCurrentLevel - 3 * (mCurrentLevel / 3) + 3 * (mTotalGremlinsMuertos / 60) : mCurrentLevel;
                bkValue = Integer.valueOf(ORDEN_NIVELES_ENDURANCE[(level - 1) / 3]);
                mBackgroundImage = Image.createImage((String)("/bk" + (bkValue + (level - 1) % 3) + ".png"));
            } else {
                mBackgroundImage = Image.createImage((String)("/bk" + TIME_TRIAL_ORDEN_NIVELES[mCurrentLevel - 1] + ".png"));
            }
            mIsBackgroundChanged = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private char getAsNumberChar(char c) {
        int result = 0;
        if (c == '0') {
            result = 48;
        } else if (c == '1') {
            result = 49;
        } else if (c == '2' || c == 'A' || c == 'B' || c == 'C') {
            result = 50;
        } else if (c == '3' || c == 'D' || c == 'E' || c == 'F') {
            result = 51;
        } else if (c == '4' || c == 'G' || c == 'H' || c == 'I') {
            result = 52;
        } else if (c == '5' || c == 'J' || c == 'K' || c == 'L') {
            result = 53;
        } else if (c == '6' || c == 'M' || c == 'N' || c == 'O') {
            result = 54;
        } else if (c == '7' || c == 'P' || c == 'Q' || c == 'R' || c == 'S') {
            result = 55;
        } else if (c == '8' || c == 'T' || c == 'U' || c == 'V') {
            result = 56;
        } else if (c == '9' || c == 'W' || c == 'X' || c == 'Y' || c == 'Z') {
            result = 57;
        }
        return (char)result;
    }

    private int charToInt(char c) {
        int result = 0;
        if (c == '0') {
            result = 0;
        } else if (c == '1') {
            result = 1;
        } else if (c == '2') {
            result = 2;
        } else if (c == '3') {
            result = 3;
        } else if (c == '4') {
            result = 4;
        } else if (c == '5') {
            result = 5;
        } else if (c == '6') {
            result = 6;
        } else if (c == '7') {
            result = 7;
        } else if (c == '8') {
            result = 8;
        } else if (c == '9') {
            result = 9;
        }
        return result;
    }

    private void createCharacterSequence(Actor actor) {
        int i;
        String[] usoCaracteres;
        mStringBuffer.setLength(0);
        int procentajeLength = 0;
        String[] usoLetras = mGameMode == 0 ? USO_DE_LETRAS : TIME_TRIAL_USO_DE_LETRAS;
        String[] stringArray = usoCaracteres = mGameMode == 0 ? USO_CARACTERES : TIME_TRIAL_USO_CARACTERES;
        if (!usoLetras[mCurrentLevel - 1].equals("0")) {
            procentajeLength = Integer.valueOf(usoLetras[mCurrentLevel - 1].substring(2));
        }
        for (i = 0; i < usoCaracteres[mCurrentLevel - 1].length(); ++i) {
            char nc = (char)(48 + mRandom.nextInt(10));
            mStringBuffer.append(nc);
        }
        block1: for (i = 0; i < usoCaracteres[mCurrentLevel - 1].length(); ++i) {
            int number = 0;
            while (true) {
                boolean characterUsed = false;
                for (int j = 0; j < 6; ++j) {
                    if (mActorList[j] == null || mActorList[j] == actor || mActorList[j].getText() == null || mActorList[j].getText().length() != mStringBuffer.length()) continue;
                    String text = mActorList[j].getText();
                    if (mStringBuffer.charAt(i) != this.getAsNumberChar(text.charAt(i))) continue;
                    characterUsed = true;
                    break;
                }
                if (!characterUsed || number >= 9) continue block1;
                mStringBuffer.insert(i, number);
                mStringBuffer.deleteCharAt(i + 1);
                ++number;
            }
        }
        for (i = 0; i < usoCaracteres[mCurrentLevel - 1].length(); ++i) {
            char c = usoCaracteres[mCurrentLevel - 1].charAt(i);
            if (c == '1' || c == 'A' || c != 'A') continue;
            int r = mRandom.nextInt(26 + 10 * procentajeLength);
            boolean nc = false;
            int n0 = this.charToInt(mStringBuffer.charAt(i));
            if (r >= 26 || n0 < 2) continue;
            mStringBuffer.insert(i, KEYCHARS[n0 - 2][mRandom.nextInt(KEYCHARS[n0 - 2].length)]);
            mStringBuffer.deleteCharAt(i + 1);
        }
        actor.setText(mStringBuffer.toString());
        actor.setCacheText(mStringBuffer.toString());
    }

    private void drawHighscorePage(Graphics g, int x, int y, int width, int height, String header) {
        int textH = mSmallFont.getStringHeight(header);
        int textW = mSmallFont.getStringWidth(header);
        g.setColor(0, 58, 64);
        g.fillRect(x, y - textH - 2, textW + 4, textH + 4);
        mSmallFont.drawString(g, header, x + 2, y - textH + 10, 0);
        g.setColor(0, 58, 64);
        g.fillRect(x, y, width, height);
        g.setColor(0xAEBBAE);
        g.fillRect(x + 2, y + 2, width - 4, height - 4);
    }

    private void drawSoftKeys(Graphics g, int leftSoft, int rightSoft) {
        if (leftSoft != -1) {
            this.paintWindowFrame2(g, 1, this.getHeight() - 12, mSmallFont.getStringWidth(mLanguageTexts[SOFTKEYS.LABELS[leftSoft]]) + 8, 17);
            mSmallFont.drawString(g, mLanguageTexts[SOFTKEYS.LABELS[leftSoft]], 4, this.getHeight() - 1, 9);
        }
        if (rightSoft != -1) {
            this.paintWindowFrame2(g, this.getWidth() - 1 - mSmallFont.getStringWidth(mLanguageTexts[SOFTKEYS.LABELS[rightSoft]]) - 8, this.getHeight() - 12, mSmallFont.getStringWidth(mLanguageTexts[SOFTKEYS.LABELS[rightSoft]]) + 8, 17);
            mSmallFont.drawString(g, mLanguageTexts[SOFTKEYS.LABELS[rightSoft]], this.getWidth() - 5, this.getHeight() - 1, 10);
        }
    }

    private String getBriefingMessage() {
        String[] usoCaracteres = mGameMode == 0 ? USO_CARACTERES : TIME_TRIAL_USO_CARACTERES;
        String textUsoCaracteres = usoCaracteres[mCurrentLevel - 1];
        String result = null;
        result = textUsoCaracteres.equals("1") ? mLanguageTexts[67] : (textUsoCaracteres.equals("A") ? mLanguageTexts[68] : (textUsoCaracteres.equals("11") || textUsoCaracteres.equals("111") ? mLanguageTexts[69] : mLanguageTexts[70]));
        return result;
    }

    private int getSceneSoundId() {
        if (mCurrentLevel <= 6) {
            return 5;
        }
        if (mCurrentLevel <= 15) {
            return 0;
        }
        if (mCurrentLevel <= 24) {
            return 6;
        }
        return 7;
    }

    private void initLanguageQuestionState() {
        mSelectedMenuItemIndex = mIsEnglish ? 0 : 1;
    }

    private void initPlayingState() {
        try {
            int i;
            mRandom = new Random(System.currentTimeMillis());
            mIsContinueSelected = true;
            if (mCurrentState == 22) {
                mScore = 0;
                this.setLives(5);
                mCurrentLevel = mLevelValue;
                mGameLevelStartIndex = mLevelValue;
                mTotalGremlinsMuertos = 0;
                mIsContinueSelected = false;
                mCurrentState = 11;
            } else if (mCurrentState == 23) {
                mScore = mRMSScore;
                this.setLives(mRMSLives);
                mCurrentLevel = mRMSCurrentLevel;
                mTotalGremlinsMuertos = mRMSEnemigosDerrotados;
                mGameLevelStartIndex = mRMSCurrentLevel;
                mCurrentState = 11;
            } else {
                mScore = 0;
                this.setLives(5);
                mCurrentLevel = 1;
                mGameLevelStartIndex = 1;
                mTotalGremlinsMuertos = 0;
                mCurrentState = 11;
            }
            for (i = 0; i < mActorList.length; ++i) {
                if (mActorList[i] == null) {
                    if (i < 6) {
                        ThePlagueCanvas.mActorList[i] = Actor.createGremlin();
                        mActorList[i].setEnabled(false);
                        mActorList[i].setPosition(mRandom.nextInt(260) + 20, -5);
                        if (i >= ENEMIGOS_EN_PANTALLA[0]) continue;
                        mActorList[i].setEnabled(true);
                        this.createCharacterSequence(mActorList[i]);
                        continue;
                    }
                    ThePlagueCanvas.mActorList[i] = Actor.createMoco();
                    mActorList[i].setEnabled(false);
                    continue;
                }
                if (i >= 6) continue;
                mActorList[i].setEnabled(false);
                mActorList[i].setPosition(mRandom.nextInt(260) + 20, -10);
                if (i >= ENEMIGOS_EN_PANTALLA[mCurrentLevel - 1]) continue;
                mActorList[i].setEnabled(true);
                this.createCharacterSequence(mActorList[i]);
            }
            for (i = 0; i < 30; ++i) {
                ThePlagueCanvas.mEnemigosEliminados[i] = 0;
                ThePlagueCanvas.mScoreNivel[i] = 0;
            }
            mBriefingIndex = 0;
            this.chooseBackgroundImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeFonts() {
        short[] fontMap = new short[256];
        int ascii = 48;
        int frameIndex = 33;
        while (ascii < 58) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        ascii = 65;
        frameIndex = 0;
        while (ascii <= 90) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        ascii = 97;
        frameIndex = 0;
        while (ascii <= 122) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        fontMap[33] = 26;
        fontMap[63] = 27;
        fontMap[46] = 28;
        fontMap[44] = 29;
        fontMap[58] = 30;
        fontMap[59] = 31;
        fontMap[45] = 32;
        fontMap[161] = 49;
        fontMap[191] = 50;
        fontMap[0] = 48;
        fontMap[1] = 43;
        fontMap[2] = 44;
        fontMap[3] = 45;
        fontMap[4] = 46;
        fontMap[5] = 47;
        mMediumFont.setFontMap(fontMap);
        mMediumFont.setFontParameters(5, -2, 0);
        ascii = 48;
        frameIndex = 32;
        while (ascii < 58) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        fontMap[33] = 26;
        fontMap[63] = 27;
        fontMap[46] = 28;
        fontMap[44] = 29;
        fontMap[58] = 30;
        fontMap[59] = 31;
        fontMap[45] = 50;
        fontMap[161] = 47;
        fontMap[191] = 48;
        fontMap[35] = 51;
        fontMap[42] = 52;
        fontMap[64] = 53;
        fontMap[209] = 49;
        fontMap[1] = 42;
        fontMap[2] = 43;
        fontMap[3] = 44;
        fontMap[4] = 45;
        fontMap[5] = 46;
        mSmallFont.setFontMap(fontMap);
        mSmallFont.setFontParameters(5, -1, 0);
        ascii = 48;
        frameIndex = 0;
        while (ascii < 58) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        ascii = 65;
        frameIndex = 10;
        while (ascii <= 90) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        ascii = 97;
        frameIndex = 10;
        while (ascii <= 122) {
            fontMap[ascii] = (short)frameIndex;
            ++ascii;
            ++frameIndex;
        }
        mNumerosFont.setFontMap(fontMap);
        mNumerosFont.setFontParameters(5, 1, 0);
    }

    private void initLoadingState() {
        try {
            byte[] imageData = ThePlagueCanvas.readFile("/mediumfont.png");
            byte[] spriteData = ThePlagueCanvas.readFile("/mediumfont.bsprite");
            mMediumFont = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/smallfont.png");
            spriteData = ThePlagueCanvas.readFile("/smallfont.bsprite");
            mSmallFont = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/Plague_Numeros.png");
            spriteData = ThePlagueCanvas.readFile("/Plague_Numeros.bsprite");
            mNumerosFont = new MSprite(spriteData, imageData);
            this.initializeFonts();
            imageData = ThePlagueCanvas.readFile("/menus.png");
            spriteData = ThePlagueCanvas.readFile("/menus.bsprite");
            mMenusSprite = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/flechita.png");
            spriteData = ThePlagueCanvas.readFile("/flechita.bsprite");
            mFlechitaSprite = new MSprite(spriteData, imageData);
            mFlechitaAnimationLeft = mFlechitaSprite.createAnimationProfile();
            mFlechitaSprite.setCurrentAnimation(mFlechitaAnimationLeft, 0, true);
            mFlechitaSprite.setAnimationDelay(mFlechitaAnimationLeft, 1);
            mFlechitaAnimationRight = mFlechitaSprite.createAnimationProfile();
            mFlechitaSprite.setCurrentAnimation(mFlechitaAnimationRight, 1, true);
            mFlechitaSprite.setAnimationDelay(mFlechitaAnimationRight, 1);
            imageData = ThePlagueCanvas.readFile("/items.png");
            spriteData = ThePlagueCanvas.readFile("/items.bsprite");
            mItemsSprite = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/framewindow.png");
            spriteData = ThePlagueCanvas.readFile("/framewindow.bsprite");
            mFrameWindowSprite = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/framewindow2.png");
            spriteData = ThePlagueCanvas.readFile("/framewindow2.bsprite");
            mFrameWindow2Sprite = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/plagueMarquito.png");
            spriteData = ThePlagueCanvas.readFile("/plagueMarquito.bsprite");
            mPlagueMarquitoSprite = new MSprite(spriteData, imageData);
            imageData = ThePlagueCanvas.readFile("/Plague_Limpiador.png");
            spriteData = ThePlagueCanvas.readFile("/Plague_Limpiador.bsprite");
            mPlagueLimpiadorSprite = new MSprite(spriteData, imageData);
            mPlagueLimpiadorAnimation = mPlagueLimpiadorSprite.createAnimationProfile();
            mPlagueLimpiadorSprite.setAnimationDelay(mPlagueLimpiadorAnimation, 4);
            imageData = ThePlagueCanvas.readFile("/Plague_Energia.png");
            spriteData = ThePlagueCanvas.readFile("/Plague_Energia.bsprite");
            mPlagueEnergySprite = new MSprite(spriteData, imageData);
            mPlagueFinal1Sprite = new MSprite(ThePlagueCanvas.readFile("/Plague_Final2.bsprite"), ThePlagueCanvas.readFile("/plagueMarquito.png"));
            mPlagueFinal2Sprite = new MSprite(ThePlagueCanvas.readFile("/Plague_Final1.bsprite"), ThePlagueCanvas.readFile("/Plague_Final1.png"));
            finalImg = Image.createImage((String)"/final_new.png");
            mPlagueEnergyAnimation = mPlagueEnergySprite.createAnimationProfile();
            mPlagueEnergySprite.setAnimationDelay(mPlagueEnergyAnimation, 4);
            mSplashImage = Image.createImage((String)"/splash.png");
            mSplashLogoImage = Image.createImage((String)"/logo.png");
            mIconoGrenmlinImage = Image.createImage((String)"/Plague_Icono_Gremlin.png");
            monoIdiomaImg = Image.createImage((String)"/mono_idioma.png");
            monoSoundImg = Image.createImage((String)"/mono_sound.png");
            flechaImg = Image.createImage((String)"/flecha.png");
            backgroundImg = Image.createImage((String)"/background.png");
            mLanguageTexts = this.loadLanguageTexts(0);
            dialogoImg = Image.createImage((String)"/dialogo.png");
            this.loadSounds(SOUND_ID_LIST, SOUND_FILE_LIST);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initLogoState() {
        try {
            mLogoImage = Image.createImage((String)"/inode.png");
            mAuxiliarTime = System.currentTimeMillis();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.getGameData();
        mPetalos = Particles.createChorro(this.getWidth() >> 1, this.getHeight() >> 1, 50, 10);
    }

    private void initMainMenuState() {
        try {
            monoMenuImg = Image.createImage((String)"/mono_menu.png");
            menuBackImg = Image.createImage((String)"/menu_back.png");
            fondoGreenImg = Image.createImage((String)"/fondoGreen.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.playSound(0, true);
        mSelectedMenuItemIndex = 0;
    }

    private void initSoundQuestionState() {
    }

    private void initSplashState() {
        mAuxiliarTime = System.currentTimeMillis();
        this.playSound(0, true);
    }

    public void playSound(int id) {
        this.playSound(id, false);
    }

    public void playSound(int id, boolean loop) {
        if (mIsSoundEnabled) {
            super.playSound(id, loop);
        }
    }

    private void resetGremlin(Actor gremlin) {
        String[] visibilidadChars = null;
        int[] velocidadCaida = null;
        if (mGameMode == 0) {
            visibilidadChars = VISIBILIDAD_DE_CARACTERES;
            velocidadCaida = VELOCIDAD_DE_CAIDA;
        } else {
            visibilidadChars = TIME_TRIAL_VISIBILIDAD_DE_CARACTERES;
            velocidadCaida = TIME_TRIAL_VELOCIDAD_DE_CAIDA;
        }
        int maxGremlinsActivos = ENEMIGOS_EN_PANTALLA[mCurrentLevel - 1];
        if (mGameMode == 1) {
            maxGremlinsActivos = TIME_TRIAL_ENEMIGOS_EN_PANTALLA[mCurrentLevel - 1];
        }
        int yPos = 480;
        for (int i = 0; i < maxGremlinsActivos; ++i) {
            if (mActorList[i] == null || mActorList[i] == gremlin || mActorList[i].getPositionY() >= yPos) continue;
            yPos = mActorList[i].getPositionY();
        }
        gremlin.setActorState(0);
        gremlin.setEnabled(false);
        gremlin.setPosition(mRandom.nextInt(260) + 20, Math.min(yPos - 60, -20));
        gremlin.setMocoEnabled(false);
        gremlin.setTextShowed(true);
        gremlin.setVelocity(mRandom.nextInt(velocidadCaida[mCurrentLevel - 1]) + 1);
        int visibility = 0;
        boolean azar = false;
        visibility = visibilidadChars[mCurrentLevel - 1].charAt(0) != 'i' ? Integer.valueOf(visibilidadChars[mCurrentLevel - 1]).intValue() : Integer.valueOf(visibilidadChars[mCurrentLevel - 1].substring(1)).intValue();
        gremlin.setVisibilityCharacters(visibility, azar);
        gremlin.setEnabled(true);
        this.createCharacterSequence(gremlin);
    }

    private void initializeLevel() {
        mAuxiliarTime = System.currentTimeMillis();
        mIsLimpiadorEnabled = false;
        mIsWinLevel = false;
        this.setLives(5);
        mIsLimpiadorEnabled = false;
        mPlagueLimpiadorSprite.setCurrentAnimation(mPlagueLimpiadorAnimation, 0, false);
        if (mGameMode != 0) {
            mTotalGremlinsMuertos = 0;
            mScore = 0;
            mLevelTime = 180;
            mPetalos.reset();
            this.chooseBackgroundImage();
            for (int i = 0; i < 30; ++i) {
                ThePlagueCanvas.mEnemigosEliminados[i] = 0;
                ThePlagueCanvas.mScoreNivel[i] = 0;
            }
        }
        int[] enemigosEnPantalla = ENEMIGOS_EN_PANTALLA;
        if (mGameMode == 1) {
            enemigosEnPantalla = TIME_TRIAL_ENEMIGOS_EN_PANTALLA;
        }
        for (int i = 0; i < mActorList.length; ++i) {
            if (i >= 6 || mActorList[i] == null) continue;
            this.resetGremlin(mActorList[i]);
            mActorList[i].setEnabled(false);
            if (i >= enemigosEnPantalla[mCurrentLevel - 1]) continue;
            mActorList[i].setEnabled(true);
            this.createCharacterSequence(mActorList[i]);
        }
    }

    private void paintAboutPage(Graphics g) {
        g.setClip(0, 50, 240, 160);
        if (mIsEnglish) {
            mSmallFont.drawString(g, ABOUT_PAGE, this.getWidth() >> 1, mAboutPageY, 16);
        } else {
            mSmallFont.drawString(g, ABOUT_PAGE_SPANISH, this.getWidth() >> 1, mAboutPageY, 16);
        }
        g.setClip(0, 0, 320, 240);
        this.drawSoftKeys(g, -1, 1);
    }

    private void paintHUD(Graphics g) {
        g.setColor(0, 58, 64);
        g.fillRect(0, 0, 320, 16);
        g.setColor(40899);
        g.drawLine(0, 16, 320, 16);
        if (mCurrentState == 12) {
            g.setColor(0, 58, 64);
            g.fillRect(0, this.getHeight() - 16, 320, 16);
            g.setColor(40899);
            g.drawLine(0, this.getHeight() - 16, 320, this.getHeight() - 16);
        }
        if (mGameMode == 0) {
            mSmallFont.drawString(g, mLanguageTexts[55], 1, 11, 0);
            mSmallFont.drawString(g, mLanguageTexts[20] + ": " + mCurrentLevel, 160, 11, 16);
            mSmallFont.drawString(g, "X " + mTotalGremlinsMuertos, 280, 11, 0);
            g.drawImage(mIconoGrenmlinImage, 250, 0, 0);
            if (mCurrentState == 12) {
                mSmallFont.drawString(g, "" + mScore, 160, this.getHeight() - 4, 16);
                mPlagueEnergySprite.drawAnimation(g, mPlagueEnergyAnimation, 280, this.getHeight() - 14, 0);
                mPlagueEnergySprite.updateAnimation(mPlagueEnergyAnimation);
                if (System.currentTimeMillis() - mPlagueEnergyCounter > 10000L) {
                    mPlagueEnergySprite.restartCurrentAnimation(mPlagueEnergyAnimation);
                    mPlagueEnergyCounter = System.currentTimeMillis();
                }
            }
        } else {
            mSmallFont.drawString(g, mLanguageTexts[56], 2, 11, 0);
            mSmallFont.drawString(g, mLanguageTexts[59] + ": " + mCurrentLevel, 110, 11, 16);
            mSmallFont.drawString(g, "" + mLevelTime, 180, 11, 16);
            mItemsSprite.drawFrame(g, 3, 150, 0, 0);
            mSmallFont.drawString(g, "X " + mTotalGremlinsMuertos, 280, 11, 0);
            g.drawImage(mIconoGrenmlinImage, 250, 0, 0);
            if (mCurrentState == 12) {
                mSmallFont.drawString(g, "" + mScore, 160, this.getHeight() - 4, 16);
                mPlagueEnergySprite.drawAnimation(g, mPlagueEnergyAnimation, 280, this.getHeight() - 14, 0);
                mPlagueEnergySprite.updateAnimation(mPlagueEnergyAnimation);
                if (System.currentTimeMillis() - mPlagueEnergyCounter > 10000L) {
                    mPlagueEnergySprite.restartCurrentAnimation(mPlagueEnergyAnimation);
                    mPlagueEnergyCounter = System.currentTimeMillis();
                }
            }
        }
        if (mCurrentState == 12) {
            mFlechitaSprite.drawModule(g, 0, 2, this.getHeight() - mFlechitaSprite.getModuleHeight(0), 0);
        }
    }

    private void paintHelpPage(Graphics g) {
        int textPadding = 10;
        int helpIndex = 0;
        if (this.mIsHelpInGameMenu) {
            helpIndex = mGameMode == 0 ? 1 : 2;
        }
        int textHeight = mSmallFont.getStringHeight(mLanguageTexts[HELP_PAGES[helpIndex][mHelpPageIndex]]);
        int headerTextHeight = mMediumFont.getStringHeight(mLanguageTexts[13]);
        int _x = 25;
        int _y = 80;
        mMediumFont.drawString(g, mLanguageTexts[13], this.getWidth() >> 1, _y, 20);
        mSmallFont.drawString(g, mLanguageTexts[HELP_PAGES[helpIndex][mHelpPageIndex]], this.getWidth() >> 1, _y + 2 * textPadding, 20);
        if (HELP_PAGES[helpIndex].length > 1) {
            if (mHelpPageIndex > 0) {
                mFlechitaSprite.drawAnimation(g, mFlechitaAnimationLeft, 40, 70, 0);
            }
            if (mHelpPageIndex < HELP_PAGES[helpIndex].length - 1) {
                mFlechitaSprite.drawAnimation(g, mFlechitaAnimationRight, 280, 70, 0);
            }
            mFlechitaSprite.updateAnimation(mFlechitaAnimationLeft);
            mFlechitaSprite.updateAnimation(mFlechitaAnimationRight);
        }
        this.drawSoftKeys(g, -1, 1);
    }

    private void paintWindowFrame(Graphics g, int x, int y, int width, int height) {
        int i;
        int _x = x + mFrameWindowSprite.getModuleWidth(1);
        int _y = 0;
        int bordeUpWidth = 6;
        int bordeLeftWidth = 12;
        int bordeLeftHeight = 6;
        mFrameWindowSprite.drawModule(g, 1, x, y, 0);
        for (i = 0; i < (width - mFrameWindowSprite.getModuleWidth(1)) / bordeUpWidth; ++i) {
            mFrameWindowSprite.drawModule(g, 0, _x, y, 1);
            _x += bordeUpWidth;
        }
        mFrameWindowSprite.drawModule(g, 1, x + (width - mFrameWindowSprite.getModuleWidth(1)), y, 4);
        _y = y + mFrameWindowSprite.getModuleHeight(1);
        for (i = 0; i < (height - mFrameWindowSprite.getModuleHeight(1)) / bordeLeftHeight; ++i) {
            _x = x;
            mFrameWindowSprite.drawModule(g, 0, _x, _y, 0);
            _x += 12;
            for (int j = 0; j < (width - 18) / 6; ++j) {
                mFrameWindowSprite.drawModule(g, 2, _x, _y, 0);
                _x += 6;
            }
            mFrameWindowSprite.drawModule(g, 0, x + width - 12, _y, 4);
            _y += bordeLeftHeight;
        }
        _x = x + mFrameWindowSprite.getModuleWidth(1);
        mFrameWindowSprite.drawModule(g, 1, x, y + height - mFrameWindowSprite.getModuleHeight(1), 6);
        for (i = 0; i < (width - mFrameWindowSprite.getModuleWidth(1)) / bordeUpWidth; ++i) {
            mFrameWindowSprite.drawModule(g, 0, _x, y + height - mFrameWindowSprite.getModuleHeight(1), 3);
            _x += bordeUpWidth;
        }
        mFrameWindowSprite.drawModule(g, 1, x + (width - mFrameWindowSprite.getModuleWidth(1)), y + height - mFrameWindowSprite.getModuleHeight(1), 2);
    }

    private void paintWindowFrame2(Graphics g, int x, int y, int width, int height) {
        int i;
        int _x = x + mFrameWindow2Sprite.getModuleWidth(1);
        int _y = 0;
        int bordeUpWidth = 3;
        int bordeLeftHeight = 3;
        mFrameWindow2Sprite.drawModule(g, 1, x, y, 0);
        for (i = 0; i < (width - mFrameWindow2Sprite.getModuleWidth(1)) / bordeUpWidth; ++i) {
            mFrameWindow2Sprite.drawModule(g, 0, _x, y, 1);
            _x += bordeUpWidth;
        }
        mFrameWindow2Sprite.drawModule(g, 1, x + (width - mFrameWindow2Sprite.getModuleWidth(1)), y, 4);
        _y = y + mFrameWindow2Sprite.getModuleHeight(1);
        for (i = 0; i < (height - mFrameWindow2Sprite.getModuleHeight(1)) / bordeLeftHeight; ++i) {
            _x = x;
            mFrameWindow2Sprite.drawModule(g, 0, _x, _y, 0);
            _x += 5;
            for (int j = 0; j < (width - 6) / 6; ++j) {
                mFrameWindow2Sprite.drawModule(g, 2, _x, _y, 0);
                _x += 6;
            }
            mFrameWindow2Sprite.drawModule(g, 0, x + width - 5, _y, 4);
            _y += bordeLeftHeight;
        }
        _x = x + mFrameWindow2Sprite.getModuleWidth(1);
        mFrameWindow2Sprite.drawModule(g, 1, x, y + height - mFrameWindow2Sprite.getModuleHeight(1), 6);
        for (i = 0; i < (width - mFrameWindow2Sprite.getModuleWidth(1)) / bordeUpWidth; ++i) {
            mFrameWindow2Sprite.drawModule(g, 0, _x, y + height - mFrameWindow2Sprite.getModuleHeight(1), 3);
            _x += bordeUpWidth;
        }
        mFrameWindow2Sprite.drawModule(g, 1, x + (width - mFrameWindow2Sprite.getModuleWidth(1)), y + height - mFrameWindow2Sprite.getModuleHeight(1), 2);
    }

    private void paintLanguageQuestionState(Graphics g) {
        g.setColor(0);
        g.drawImage(backgroundImg, 0, 0, 0);
        int monoX = 320 - monoIdiomaImg.getWidth() + 1;
        int monoY = 240 - monoIdiomaImg.getHeight() + 1;
        g.drawImage(monoIdiomaImg, monoX, monoY, 0);
        g.drawImage(dialogoImg, 160 - (dialogoImg.getWidth() >> 1), 0, 0);
        int offsetXTitle = 0;
        mMediumFont.drawString(g, "SELECT LANGUAGE", (this.getWidth() >> 1) - offsetXTitle, 42, 48);
        mMediumFont.drawString(g, "ELIGE IDIOMA", (this.getWidth() >> 1) - offsetXTitle, 67, 48);
        int[] menuItems = LANGUAGE_LIST;
        int _y = 120;
        int _x = 5;
        int offsetX = 0;
        int menuItemY = 100;
        boolean currentFrame = false;
        int frameWidth = mMenusSprite.getFrameWidth(0);
        int frameHeight = mMenusSprite.getFrameHeight(0);
        for (int i = 0; i < menuItems.length; ++i) {
            currentFrame = mSelectedMenuItemIndex != i;
            if (!currentFrame) {
                int flechaX = (this.getWidth() >> 1) - (mMediumFont.getStringWidth(mLanguageTexts[menuItems[i]]) >> 1) - flechaImg.getWidth() - 8;
                g.drawImage(flechaImg, flechaX, _y - mMediumFont.getStringHeight("L") / 2, 0);
            }
            String text = mLanguageTexts[menuItems[i]];
            mMediumFont.drawString(g, text, (this.getWidth() >> 1) - offsetX, _y, 48);
            _y += frameHeight + 1;
        }
        this.drawSoftKeys(g, 0, -1);
    }

    private void paintLoadingState(Graphics g) {
    }

    private void paintLogoState(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(mLogoImage, this.getWidth() - mLogoImage.getWidth() >> 1, this.getHeight() - mLogoImage.getHeight() >> 1, 0);
    }

    private void paintMainMenuState(Graphics g) {
        g.drawImage(backgroundImg, 0, 0, 0);
        int monoX = 320 - monoMenuImg.getWidth() + 1;
        int monoY = 240 - monoMenuImg.getHeight() + 1;
        g.drawImage(monoMenuImg, monoX, monoY, 0);
        if (mCurrentState == 4 || mCurrentState == 5 || mCurrentState == 19 || mCurrentState == 6 || mCurrentState == 10 || mCurrentState == 20 || mCurrentState == 21 || mCurrentState == 26 || mCurrentState == 28) {
            if (mCurrentState == 4 || mCurrentState == 20) {
                g.drawImage(menuBackImg, flechaImg.getWidth() + 5 + offsetMenuX, 0, 0);
            } else {
                g.drawImage(fondoGreenImg, 0, 0, 0);
            }
            int[] menuItems = null;
            if (mCurrentState == 4 || mCurrentState == 20) {
                menuItems = MAINMENU_LIST;
            } else if (mCurrentState == 5 || mCurrentState == 21) {
                menuItems = OPTIONS_LIST;
            } else if (mCurrentState == 6) {
                menuItems = HELP_LIST;
            } else if (mCurrentState == 10) {
                menuItems = PLAY_LIST;
            } else if (mCurrentState == 26) {
                menuItems = GAMEMODE_LIST;
            } else if (mCurrentState == 19) {
                menuItems = LANGUAGE_LIST;
            } else if (mCurrentState == 28) {
                menuItems = mGameMode == 0 ? (mIsWinLevel ? ENDURANCE_MENU_LIST : ENDURANCE_MENU_LIST_2) : (mIsWinLevel ? (mCurrentLevel == 10 && mRMSTimeTrailFinished ? TIME_TRIAL_MENU_LIST_3 : TIME_TRIAL_MENU_LIST) : TIME_TRIAL_MENU_LIST_2);
            }
            int _y = 0;
            int _x = this.getWidth() >> 1;
            if (mCurrentState == 4 || mCurrentState == 20) {
                _y = 30;
            } else if (mCurrentState == 5 || mCurrentState == 21) {
                _y = 80;
            } else if (mCurrentState == 6) {
                _y = 80;
            } else if (mCurrentState == 10) {
                _y = 90;
            } else if (mCurrentState == 26) {
                _y = 90;
            } else if (mCurrentState == 19) {
                _y = 90;
            } else if (mCurrentState == 28) {
                _y = mGameMode == 0 ? 90 : (mIsWinLevel ? 65 : 80);
            }
            boolean currentFrame = false;
            int frameWidth = mMenusSprite.getFrameWidth(0);
            int frameHeight = mMenusSprite.getFrameHeight(0);
            for (int i = 0; i < menuItems.length; ++i) {
                currentFrame = mSelectedMenuItemIndex != i;
                if (!currentFrame) {
                    g.drawImage(flechaImg, 3 + offsetMenuX, _y - flechaImg.getHeight() / 2, 0);
                }
                String text = mLanguageTexts[menuItems[i]];
                _x = 80 + offsetMenuX;
                if (mCurrentState == 5) {
                    _x += 15;
                    if (i == 0) {
                        text = mIsSoundEnabled ? text + ": ON" : text + ": OFF";
                    }
                } else if (mCurrentState != 10 || i != 1) {
                    if (mCurrentState == 26) {
                        int offsetY = 40;
                        if (mSelectedMenuItemIndex == 0) {
                            mSmallFont.drawString(g, mLanguageTexts[57], this.getWidth() >> 1, 200 - offsetY, 16);
                        } else {
                            mSmallFont.drawString(g, mLanguageTexts[58], this.getWidth() >> 1, 200 - offsetY, 16);
                        }
                    } else if (mCurrentState == 28 && mGameMode == 0) {
                        mSmallFont.drawString(g, mLanguageTexts[72], this.getWidth() >> 1, 75, 16);
                    }
                }
                if (mCurrentState == 4 || mCurrentState == 20) {
                    mMediumFont.drawString(g, text, _x, _y + 9, 48);
                } else {
                    mMediumFont.drawString(g, text, _x - 50, _y + 9, 32);
                }
                _y += frameHeight + 1;
            }
        }
        if (mCurrentState == 27) {
            int i;
            int offsetY = 50;
            if (mGameMode == 0) {
                mMediumFont.drawString(g, mLanguageTexts[20], 160, 80 - offsetY, 48);
            } else {
                mMediumFont.drawString(g, mLanguageTexts[59], 160, 80 - offsetY, 48);
            }
            int boxDim = 30;
            int horzCells = 6;
            int vertCells = 5;
            int rmsLevel = mRMSLastLiberadoLevel;
            if (mGameMode == 1) {
                horzCells = 5;
                vertCells = 2;
                rmsLevel = mRMSTimeTrialCurrentLevel;
            }
            int _x = 320 - horzCells * boxDim >> 1;
            int _y = 100 - offsetY;
            for (i = 0; i < vertCells; ++i) {
                _x = 320 - horzCells * boxDim >> 1;
                for (int j = 0; j < horzCells; ++j) {
                    int color2;
                    int color1;
                    if (horzCells * i + j == mSelectedMenuItemIndex) {
                        color1 = 0xAEBBAE;
                        color2 = 40899;
                    } else if (horzCells * i + 1 <= rmsLevel) {
                        g.setColor(0, 58, 64);
                        color1 = g.getColor();
                        color2 = 40899;
                    } else {
                        g.setColor(0, 58, 64);
                        color1 = g.getColor();
                        color2 = 40899;
                    }
                    g.setColor(color1);
                    g.fillRect(_x, _y, boxDim, boxDim);
                    g.setColor(color2);
                    g.drawRect(_x, _y, boxDim, boxDim);
                    if (horzCells * i + j < rmsLevel) {
                        mSmallFont.drawString(g, String.valueOf(horzCells * i + j + 1), _x + (boxDim >> 1), _y + (boxDim >> 1) + 3, 16);
                    }
                    _x += boxDim;
                }
                _y += boxDim;
            }
            if (mGameMode == 1) {
                _x = 35;
                _y = 205 - offsetY;
                this.drawHighscorePage(g, 30, 185 - offsetY, 180, 65, mLanguageTexts[59] + " " + (mSelectedMenuItemIndex == 9 ? "10" : "0" + (mSelectedMenuItemIndex + 1)));
                for (i = 0; i < 3; ++i) {
                    mSmallFont.drawString(g, "" + (i + 1), _x, _y, 0);
                    mSmallFont.drawString(g, mTimeTrialScoreNames[mSelectedMenuItemIndex][i], _x + 10, _y, 0);
                    mSmallFont.drawString(g, "" + mTimeTrialScoreValues[mSelectedMenuItemIndex][i], _x + 120, _y, 0);
                    _y += 15;
                    _x = 35;
                }
            }
        } else {
            if (mCurrentState == 7) {
                g.drawImage(fondoGreenImg, 0, 0, 0);
                this.paintHelpPage(g);
                return;
            }
            if (mCurrentState == 9) {
                g.drawImage(fondoGreenImg, 0, 0, 0);
                this.paintAboutPage(g);
                return;
            }
            if (mCurrentState == 8) {
                int i;
                int _y;
                int _x;
                int offsetY = 50;
                if (mHighscorePageIndex > 0) {
                    mFlechitaSprite.drawAnimation(g, mFlechitaAnimationLeft, 40, 70 - offsetY, 0);
                }
                if (mHighscorePageIndex < 5) {
                    mFlechitaSprite.drawAnimation(g, mFlechitaAnimationRight, 280, 70 - offsetY, 0);
                }
                mFlechitaSprite.updateAnimation(mFlechitaAnimationLeft);
                mFlechitaSprite.updateAnimation(mFlechitaAnimationRight);
                if (mHighscorePageIndex == 0) {
                    mMediumFont.drawString(g, mLanguageTexts[55], this.getWidth() >> 1, 80 - offsetY, 16);
                    this.drawHighscorePage(g, 30, 120 - offsetY, 180, 100, mLanguageTexts[55]);
                    _x = 35;
                    _y = 140 - offsetY;
                    for (i = 0; i < 5; ++i) {
                        mSmallFont.drawString(g, "" + (i + 1), _x, _y, 0);
                        mSmallFont.drawString(g, mScoreNames[i], _x + 10, _y, 0);
                        mSmallFont.drawString(g, "" + mScoreValues[i], _x + 120, _y, 0);
                        _y += 15;
                        _x = 35;
                    }
                } else {
                    mMediumFont.drawString(g, mLanguageTexts[56], this.getWidth() >> 1, 80 - offsetY, 16);
                    _x = 35;
                    _y = 125 - offsetY;
                    if (mIsEnglish) {
                        this.drawHighscorePage(g, 30, 105 - offsetY, 180, 65, "STAGE 0" + (2 * mHighscorePageIndex - 1));
                    } else {
                        this.drawHighscorePage(g, 30, 105 - offsetY, 180, 65, "ESCENA 0" + (2 * mHighscorePageIndex - 1));
                    }
                    for (i = 0; i < 3; ++i) {
                        mSmallFont.drawString(g, "" + (i + 1), _x, _y, 0);
                        mSmallFont.drawString(g, mTimeTrialScoreNames[2 * mHighscorePageIndex - 2][i], _x + 10, _y, 0);
                        mSmallFont.drawString(g, "" + mTimeTrialScoreValues[2 * mHighscorePageIndex - 2][i], _x + 120, _y, 0);
                        _y += 15;
                        _x = 35;
                    }
                    _x = 35;
                    _y = 213 - offsetY;
                    if (mIsEnglish) {
                        this.drawHighscorePage(g, 30, 193 - offsetY, 180, 65, "STAGE " + (mHighscorePageIndex == 5 ? "10" : "0" + 2 * mHighscorePageIndex));
                    } else {
                        this.drawHighscorePage(g, 30, 193 - offsetY, 180, 65, "ESCENA " + (mHighscorePageIndex == 5 ? "10" : "0" + 2 * mHighscorePageIndex));
                    }
                    for (i = 0; i < 3; ++i) {
                        mSmallFont.drawString(g, "" + (i + 1), _x, _y, 0);
                        mSmallFont.drawString(g, mTimeTrialScoreNames[2 * mHighscorePageIndex - 1][i], _x + 10, _y, 0);
                        mSmallFont.drawString(g, "" + mTimeTrialScoreValues[2 * mHighscorePageIndex - 1][i], _x + 120, _y, 0);
                        _y += 15;
                        _x = 35;
                    }
                }
                this.drawSoftKeys(g, -1, 1);
                return;
            }
            if (mCurrentState == 20) {
                this.paintDialog(g, mLanguageTexts[37]);
                return;
            }
            if (mCurrentState == 21) {
                this.paintDialog(g, mLanguageTexts[38]);
                return;
            }
        }
        if (mCurrentState == 4) {
            this.drawSoftKeys(g, 0, -1);
        } else if (mCurrentState == 28) {
            this.drawSoftKeys(g, 0, -1);
        } else {
            this.drawSoftKeys(g, 0, 1);
        }
    }

    private void paintPlayingState(Graphics g) {
        if (mCurrentState == 15 || mCurrentState == 17) {
            g.drawImage(mSplashImage, 0, 0, 0);
        } else {
            g.drawImage(mBackgroundImage, 0, 0, 0);
        }
        if (mCurrentState == 11 || mCurrentState == 12 || mCurrentState == 13) {
            if (mCurrentState == 11) {
                if (mBriefingIndex == 0) {
                    String text = this.getBriefingMessage();
                    int textHeight = mSmallFont.getStringHeight(text);
                    this.paintWindowFrame(g, 5, (this.getHeight() >> 1) - (textHeight >> 1) - 10, this.getWidth() - 10, textHeight + 24);
                    mSmallFont.drawString(g, text, this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                    this.drawSoftKeys(g, 4, -1);
                } else if (mBriefingCounter >= 0) {
                    int textHeight = mMediumFont.getStringHeight(mLanguageTexts[71]);
                    int textWidth = mMediumFont.getStringWidth(mLanguageTexts[71]);
                    if (mBriefingCounter == 0) {
                        mMediumFont.drawString(g, mLanguageTexts[71], this.getWidth() >> 1, (this.getHeight() >> 1) + 10, 48);
                    } else {
                        mMediumFont.drawString(g, "" + mBriefingCounter, this.getWidth() >> 1, (this.getHeight() >> 1) + 10, 48);
                    }
                }
            } else if (mCurrentState == 12) {
                int i;
                for (i = 0; i < mActorList.length; ++i) {
                    if (mActorList[i] == null) continue;
                    mActorList[i].paint(g);
                }
                for (i = 0; i < mActorList.length; ++i) {
                    if (mActorList[i] == null) continue;
                    mActorList[i].paintMoco(g);
                }
                mFlechitaSprite.drawModule(g, 0, 2, this.getHeight() - mFlechitaSprite.getModuleHeight(0), 0);
            } else if (mCurrentState == 13) {
                int textHeight;
                boolean gameComplete = mGameMode == 0 ? mCurrentLevel == 30 : mCurrentLevel == 10;
                boolean bl = gameComplete = gameComplete && mIsWinLevel;
                int n = gameComplete ? mMediumFont.getStringHeight(mLanguageTexts[36]) : (mIsWinLevel ? mMediumFont.getStringHeight(mLanguageTexts[29]) : (textHeight = mLives > 0 ? mMediumFont.getStringHeight(mLanguageTexts[30]) : mMediumFont.getStringHeight(mLanguageTexts[31])));
                if (mGameMode == 0 && gameComplete) {
                    textHeight = mMediumFont.getStringHeight(mLanguageTexts[36]);
                } else if (gameComplete) {
                    textHeight = mMediumFont.getStringHeight(mLanguageTexts[63]);
                }
                if (mGameMode == 0 && gameComplete) {
                    mMediumFont.drawString(g, mLanguageTexts[36], this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                } else if (mGameMode == 1 && gameComplete && !mRMSTimeTrailFinished) {
                    mMediumFont.drawString(g, mLanguageTexts[63], this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                } else if (mIsWinLevel) {
                    mMediumFont.drawString(g, mLanguageTexts[29], this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                } else if (mLives > 0) {
                    mMediumFont.drawString(g, mLanguageTexts[30], this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                } else {
                    mMediumFont.drawString(g, mLanguageTexts[31], this.getWidth() >> 1, (this.getHeight() >> 1) + 5, 48);
                }
                if (mIsWinLevel) {
                    this.drawSoftKeys(g, 4, -1);
                } else {
                    this.drawSoftKeys(g, 0, -1);
                }
            }
            this.paintHUD(g);
            if (mCurrentState == 12) {
                mPlagueLimpiadorSprite.drawAnimation(g, mPlagueLimpiadorAnimation, 0, 0, 0);
            }
            if (mIsWinLevel && mCurrentState == 13) {
                mPetalos.paint(g);
            }
        } else if (mCurrentState == 24) {
            g.setColor(0);
            g.fillRect(0, 0, 320, 240);
            mMediumFont.drawString(g, mLanguageTexts[52], 160, 38, 16);
            g.drawImage(finalImg, 0, 0, 0);
            if (mEndingScrollY < 0) {
                mMediumFont.drawString(g, "FIN", 60, 175, 16);
            } else {
                g.setClip(0, 100, 150, 120);
                mSmallFont.drawString(g, mLanguageTexts[64], 60, mEndingScrollY, 48);
                g.setClip(0, 0, 320, 240);
            }
            this.drawSoftKeys(g, 4, -1);
        } else if (mCurrentState == 25) {
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(mLogoImage, this.getWidth() - mLogoImage.getWidth() >> 1, this.getHeight() - mLogoImage.getHeight() >> 1, 0);
        } else if (mCurrentState == 15) {
            if (mGameMode == 1) {
                mMediumFont.drawString(g, mLanguageTexts[33], 160, 80, 16);
            } else {
                mMediumFont.drawString(g, mLanguageTexts[33], 160, 30, 16);
            }
            int cellWidth = 66;
            int cellHeaderHeight = mSmallFont.getStringHeight("LEVEL") + 8;
            int tableHeight = mGameMode == 0 ? 170 : 42;
            int _x = 320 - 3 * cellWidth >> 1;
            int _y = mGameMode == 0 ? 75 : 135;
            g.setColor(0, 58, 64);
            g.fillRect(_x, _y, 3 * cellWidth, tableHeight);
            g.setColor(0xAEBBAE);
            g.fillRect(_x + 2, _y + 2, cellWidth - 3, cellHeaderHeight - 3);
            g.fillRect(_x + cellWidth + 1, _y + 2, cellWidth - 2, cellHeaderHeight - 3);
            g.fillRect(_x + 2 * cellWidth + 1, _y + 2, cellWidth - 3, cellHeaderHeight - 3);
            g.fillRect(_x + 2, _y + cellHeaderHeight + 1, cellWidth - 3, tableHeight - cellHeaderHeight - 3);
            g.fillRect(_x + cellWidth + 1, _y + cellHeaderHeight + 1, cellWidth - 2, tableHeight - cellHeaderHeight - 3);
            g.fillRect(_x + 2 * cellWidth + 1, _y + cellHeaderHeight + 1, cellWidth - 3, tableHeight - cellHeaderHeight - 3);
            if (mIsEnglish) {
                mSmallFont.drawString(g, "LEVEL", 2 * _x + cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
                mSmallFont.drawString(g, "ENEMIES", 2 * _x + 3 * cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
                mSmallFont.drawString(g, "SCORE", 2 * _x + 5 * cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
            } else {
                mSmallFont.drawString(g, "ESCENA", 2 * _x + cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
                mSmallFont.drawString(g, "ENEMIGOS", 2 * _x + 3 * cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
                mSmallFont.drawString(g, "PUNTOS", 2 * _x + 5 * cellWidth >> 1, (2 * _y + cellHeaderHeight >> 1) + 3, 48);
            }
            int startLevel = 0;
            if (mCurrentLevel == 6) {
                startLevel = Math.max(mGameLevelStartIndex, 1);
            } else if (mCurrentLevel == 15) {
                startLevel = Math.max(mGameLevelStartIndex, 7);
            } else if (mCurrentLevel == 24) {
                startLevel = Math.max(mGameLevelStartIndex, 16);
            } else if (mCurrentLevel == 30) {
                startLevel = Math.max(mGameLevelStartIndex, 25);
            }
            _y = _y + cellHeaderHeight + 12;
            if (mGameMode == 0) {
                for (int i = startLevel; i <= mCurrentLevel; ++i) {
                    mSmallFont.drawString(g, "" + i, 2 * _x + cellWidth >> 1, _y, 48);
                    mSmallFont.drawString(g, "" + mEnemigosEliminados[i - 1], 2 * _x + 3 * cellWidth >> 1, _y, 48);
                    mSmallFont.drawString(g, "" + mScoreNivel[i - 1], 2 * _x + 5 * cellWidth >> 1, _y, 48);
                    _y += cellHeaderHeight - 6;
                }
            } else {
                for (int i = 0; i < 1; ++i) {
                    mSmallFont.drawString(g, "" + mCurrentLevel, 2 * _x + cellWidth >> 1, _y, 48);
                    mSmallFont.drawString(g, "" + mEnemigosEliminados[mCurrentLevel - 1], 2 * _x + 3 * cellWidth >> 1, _y, 48);
                    mSmallFont.drawString(g, "" + mScoreNivel[mCurrentLevel - 1], 2 * _x + 5 * cellWidth >> 1, _y, 48);
                    _y += cellHeaderHeight - 6;
                }
            }
            this.drawSoftKeys(g, 0, -1);
        } else if (mCurrentState == 17) {
            int offsetY = 20;
            int _y = (mGameMode == 0 ? 60 : 41) - offsetY;
            int _x = 30;
            int[] inGameList = mGameMode == 0 ? INGAMEMENU_LIST : INGAMEMENU_LIST_2;
            _y += 35;
            for (int i = 0; i < inGameList.length; ++i) {
                String text = mLanguageTexts[inGameList[i]];
                if (mGameMode == 0 && i == 1 || mGameMode == 1 && i == 2) {
                    text = mIsSoundEnabled ? text + ": ON" : text + ": OFF";
                }
                mMediumFont.drawString(g, text, 160, _y, 16);
                if (i == mSelectedMenuItemIndex) {
                    g.drawImage(flechaImg, (this.getWidth() >> 1) - (mMediumFont.getStringWidth(text) >> 1) - flechaImg.getWidth() - 7, _y - mMediumFont.getStringHeight(text) / 2 - flechaImg.getHeight() / 3, 0);
                }
                _y += 35;
            }
            if (this.mInGameMenuSubstate == 1) {
                this.paintDialog(g, mLanguageTexts[40]);
            } else if (this.mInGameMenuSubstate == 2) {
                this.paintDialog(g, mLanguageTexts[37]);
            } else {
                this.drawSoftKeys(g, 0, -1);
            }
        } else if (mCurrentState != 16 && mCurrentState == 14) {
            mMediumFont.drawString(g, mLanguageTexts[14], this.getWidth() >> 1, 30, 16);
            mMediumFont.drawString(g, mLanguageTexts[39], this.getWidth() >> 1, 60, 16);
            int _y = 100;
            int cursorOffsetX = this.mScoreNewName.length() * (mMediumFont.getFrameWidth(0) + 1);
            if (System.currentTimeMillis() - mAuxiliarTime < 1000L || this.mScoreNewName.length() == 6) {
                cursorOffsetX -= mMediumFont.getFrameWidth(0) + 1;
            }
            int countLoop = mGameMode == 0 ? 5 : 3;
            for (int i = 0; i < countLoop; ++i) {
                if (i == this.mChangeScoreIndex) {
                    mMediumFont.drawString(g, this.mScoreNewName, 40, _y, 0);
                    mMediumFont.drawString(g, String.valueOf(mScore), 230, _y, 2);
                    if (System.currentTimeMillis() - this.mCursorTime < 200L) {
                        g.setColor(0xFFFFFF);
                        g.fillRect(40 + cursorOffsetX, _y - 1, 5, 2);
                        g.setColor(0);
                        g.drawRect(40 + cursorOffsetX, _y - 1, 5, 2);
                    } else if (System.currentTimeMillis() - this.mCursorTime > 400L) {
                        this.mCursorTime = System.currentTimeMillis();
                    }
                } else if (mGameMode == 0) {
                    mMediumFont.drawString(g, mScoreNames[i], 40, _y, 0);
                    mMediumFont.drawString(g, String.valueOf(mScoreValues[i]), 230, _y, 2);
                } else {
                    mMediumFont.drawString(g, mTimeTrialScoreNames[mCurrentLevel - 1][i], 40, _y, 0);
                    mMediumFont.drawString(g, String.valueOf(mTimeTrialScoreValues[mCurrentLevel - 1][i]), 230, _y, 2);
                }
                _y += 30;
            }
            this.drawSoftKeys(g, 0, 1);
        }
    }

    private void paintSoundQuestionState(Graphics g) {
        g.drawImage(backgroundImg, 0, 0, 0);
        int monoX = 160 - monoSoundImg.getWidth() / 2 - 10;
        int monoY = 240 - monoSoundImg.getHeight();
        g.drawImage(monoSoundImg, monoX, monoY, 0);
        g.drawImage(dialogoImg, 160 - (dialogoImg.getWidth() >> 1), 0, 0);
        mMediumFont.drawString(g, mLanguageTexts[27], this.getWidth() >> 1, 50, 48);
        this.drawSoftKeys(g, 2, 3);
    }

    private void paintSplashState(Graphics g) {
        g.drawImage(mSplashImage, 0, 0, 0);
        g.drawImage(mSplashLogoImage, 160 - (mSplashLogoImage.getWidth() >> 1), 240 - mSplashLogoImage.getHeight(), 0);
        if (System.currentTimeMillis() - mAuxiliarTime < 500L) {
            String text = "";
            text = mLanguageTexts[9];
            mSmallFont.drawString(g, text, this.getWidth() >> 1, 120, 48);
        }
    }

    private void quitLanguageQuestionState() {
    }

    private void quitLoadingState() {
    }

    private void quitLogoState() {
    }

    private void quitMainMenuState() {
    }

    private void quitPlayingState() {
    }

    private void quitSoundQuestionState() {
    }

    private void quitSplashState() {
        mSplashLogoImage = null;
    }

    private void setLives(int lives) {
        if (lives > 5) {
            lives = 5;
        }
        mLives = lives;
        if (lives >= 1) {
            mPlagueEnergySprite.setCurrentAnimation(mPlagueEnergyAnimation, Math.min(5, 5 - lives), false);
            mPlagueEnergyCounter = System.currentTimeMillis();
        }
    }

    private void updateEnduranceScore() {
        this.mChangeScoreIndex = mScoreValues.length - 1;
        ThePlagueCanvas.mScoreValues[4] = mScore;
        for (int i = mScoreValues.length - 2; i >= 0 && mScore > mScoreValues[i]; --i) {
            this.mChangeScoreIndex = i;
            ThePlagueCanvas.mScoreValues[i + 1] = mScoreValues[i];
            ThePlagueCanvas.mScoreValues[i] = mScore;
            ThePlagueCanvas.mScoreNames[i + 1] = mScoreNames[i];
        }
    }

    private void updateEnterScoreNameSubstate() {
        int keyCode = -1;
        if (ThePlagueCanvas.wasKeyPressed(4)) {
            keyCode = 0;
        } else if (ThePlagueCanvas.wasKeyPressed(8)) {
            keyCode = 1;
        } else if (ThePlagueCanvas.wasKeyPressed(16)) {
            keyCode = 2;
        } else if (ThePlagueCanvas.wasKeyPressed(32)) {
            keyCode = 3;
        } else if (ThePlagueCanvas.wasKeyPressed(64)) {
            keyCode = 4;
        } else if (ThePlagueCanvas.wasKeyPressed(128)) {
            keyCode = 5;
        } else if (ThePlagueCanvas.wasKeyPressed(256)) {
            keyCode = 6;
        } else if (ThePlagueCanvas.wasKeyPressed(512)) {
            keyCode = 7;
        }
        int maxChars = 6;
        if (ThePlagueCanvas.wasKeyPressed(8192) && this.mScoreNewName.length() > 0) {
            this.mScoreNewName = this.mScoreNewName.substring(0, this.mScoreNewName.length() - 1);
        } else if (ThePlagueCanvas.wasKeyPressed(4096) && this.mScoreNewName.length() > 0) {
            if (mGameMode == 0) {
                ThePlagueCanvas.mScoreNames[this.mChangeScoreIndex] = this.mScoreNewName;
                ThePlagueCanvas.mScoreValues[this.mChangeScoreIndex] = mScore;
                this.saveGameData();
                if (mIsWinLevel) {
                    this.changeState(4);
                } else {
                    mSelectedMenuItemIndex = 0;
                    mCurrentState = 28;
                }
            } else {
                ThePlagueCanvas.mTimeTrialScoreNames[ThePlagueCanvas.mCurrentLevel - 1][this.mChangeScoreIndex] = this.mScoreNewName;
                ThePlagueCanvas.mTimeTrialScoreValues[ThePlagueCanvas.mCurrentLevel - 1][this.mChangeScoreIndex] = mScore;
                this.saveGameData();
                mSelectedMenuItemIndex = 0;
                if (mCurrentLevel < 10 || mRMSTimeTrailFinished) {
                    mCurrentState = 28;
                } else {
                    mRMSTimeTrailFinished = true;
                    this.saveGameData();
                    this.changeState(4);
                    mCurrentState = 27;
                }
            }
        } else if (keyCode > -1 && this.mScoreNewName.length() <= maxChars) {
            char character = '\u0000';
            if (System.currentTimeMillis() - mAuxiliarTime < 1000L && KEYCHARSCODES[keyCode] == this.mPreviousScoreKeyCode) {
                ++this.mScoreLetterIndex;
                this.mScoreLetterIndex %= KEYCHARS[keyCode].length;
                character = KEYCHARS[keyCode][this.mScoreLetterIndex];
                this.mScoreNewName = this.mScoreNewName.substring(0, this.mScoreNewName.length() - 1) + character;
            } else if (this.mScoreNewName.length() < maxChars) {
                this.mScoreLetterIndex = 0;
                character = KEYCHARS[keyCode][this.mScoreLetterIndex];
                this.mScoreNewName = this.mScoreNewName + character;
            }
            this.mPreviousScoreKeyCode = KEYCHARSCODES[keyCode];
            mAuxiliarTime = System.currentTimeMillis();
        }
    }

    private void updateLanguageQuestionState() {
        int[] menuItems = LANGUAGE_LIST;
        if (ThePlagueCanvas.wasKeyReleased(4) || ThePlagueCanvas.wasKeyReleased(16384)) {
            mSelectedMenuItemIndex = --mSelectedMenuItemIndex < 0 ? menuItems.length - 1 : mSelectedMenuItemIndex;
        } else if (ThePlagueCanvas.wasKeyReleased(256) || ThePlagueCanvas.wasKeyReleased(32768)) {
            mSelectedMenuItemIndex = (mSelectedMenuItemIndex + 1) % menuItems.length;
        } else if (ThePlagueCanvas.wasKeyReleased(262144) || ThePlagueCanvas.wasKeyReleased(32) || ThePlagueCanvas.wasKeyReleased(4096)) {
            switch (mSelectedMenuItemIndex) {
                case 0: {
                    mLanguageTexts = this.loadLanguageTexts(0);
                    mIsEnglish = true;
                    break;
                }
                case 1: {
                    mLanguageTexts = this.loadLanguageTexts(1);
                    mIsEnglish = false;
                }
            }
            this.saveGameData();
            this.changeState(2);
        }
    }

    private void updateLoadingState() {
        this.changeState(18);
    }

    private void updateLogoState() {
        if (System.currentTimeMillis() - mAuxiliarTime > 3000L) {
            this.changeState(1);
        }
    }

    private void updateMainMenuState() {
        int[] menuItems = null;
        if (mCurrentState == 4) {
            menuItems = MAINMENU_LIST;
        } else if (mCurrentState == 5) {
            menuItems = OPTIONS_LIST;
        } else if (mCurrentState == 6) {
            menuItems = HELP_LIST;
        } else if (mCurrentState == 10) {
            menuItems = PLAY_LIST;
        } else if (mCurrentState == 26) {
            menuItems = GAMEMODE_LIST;
        } else if (mCurrentState == 19) {
            menuItems = LANGUAGE_LIST;
        } else if (mCurrentState == 28) {
            menuItems = mGameMode == 0 ? ENDURANCE_MENU_LIST : (mIsWinLevel && mCurrentLevel == 10 && mRMSTimeTrailFinished ? TIME_TRIAL_MENU_LIST_3 : (mIsWinLevel ? TIME_TRIAL_MENU_LIST : TIME_TRIAL_MENU_LIST_2));
        }
        if (mCurrentState == 27) {
            int avance;
            int prevIndex = mSelectedMenuItemIndex;
            int n = avance = mGameMode == 0 ? 6 : 5;
            if (ThePlagueCanvas.wasKeyPressed(4) || ThePlagueCanvas.wasKeyPressed(16384)) {
                mSelectedMenuItemIndex -= avance;
            } else if (ThePlagueCanvas.wasKeyPressed(256) || ThePlagueCanvas.wasKeyPressed(32768)) {
                mSelectedMenuItemIndex += avance;
            } else if (ThePlagueCanvas.wasKeyPressed(16) || ThePlagueCanvas.wasKeyPressed(65536)) {
                --mSelectedMenuItemIndex;
            } else if (ThePlagueCanvas.wasKeyPressed(64) || ThePlagueCanvas.wasKeyPressed(131072)) {
                ++mSelectedMenuItemIndex;
            }
            if (mSelectedMenuItemIndex < 0) {
                mSelectedMenuItemIndex = 0;
            }
            if (mGameMode == 0) {
                if (mSelectedMenuItemIndex >= mRMSLastLiberadoLevel) {
                    mSelectedMenuItemIndex = mRMSLastLiberadoLevel - 1;
                }
            } else if (mSelectedMenuItemIndex >= mRMSTimeTrialCurrentLevel) {
                mSelectedMenuItemIndex = mRMSTimeTrialCurrentLevel - 1;
            }
            if (ThePlagueCanvas.wasKeyPressed(32) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(4096)) {
                int limite;
                int n2 = limite = mGameMode == 0 ? mRMSLastLiberadoLevel : mRMSTimeTrialCurrentLevel;
                if (mSelectedMenuItemIndex + 1 <= limite) {
                    mLevelValue = mSelectedMenuItemIndex + 1;
                    this.changeState(22);
                }
            }
            if (ThePlagueCanvas.wasKeyPressed(8192)) {
                mCurrentState = mGameMode == 0 ? 10 : 26;
                mSelectedMenuItemIndex = 1;
            }
            return;
        }
        if (mCurrentState == 9 && --mAboutPageY < -420) {
            mAboutPageY = 280;
        }
        if (ThePlagueCanvas.wasKeyPressed(4) || ThePlagueCanvas.wasKeyPressed(16384)) {
            if (mCurrentState == 4 || mCurrentState == 5 || mCurrentState == 19 || mCurrentState == 6 || mCurrentState == 10 || mCurrentState == 26 || mCurrentState == 28) {
                mSelectedMenuItemIndex = --mSelectedMenuItemIndex < 0 ? menuItems.length - 1 : mSelectedMenuItemIndex;
            }
        } else if (ThePlagueCanvas.wasKeyPressed(256) || ThePlagueCanvas.wasKeyPressed(32768)) {
            if (mCurrentState == 4 || mCurrentState == 5 || mCurrentState == 19 || mCurrentState == 6 || mCurrentState == 10 || mCurrentState == 26 || mCurrentState == 28) {
                mSelectedMenuItemIndex = (mSelectedMenuItemIndex + 1) % menuItems.length;
            }
        } else if (ThePlagueCanvas.wasKeyPressed(16) || ThePlagueCanvas.wasKeyPressed(65536)) {
            if (mCurrentState == 10 && mSelectedMenuItemIndex == 1) {
                mLevelValue = mLevelValue == 1 ? mRMSCurrentLevel : (mLevelValue = mLevelValue - 1);
            } else if (mCurrentState == 8) {
                mHighscorePageIndex = mHighscorePageIndex == 0 ? mHighscorePageIndex : mHighscorePageIndex - 1;
            } else if (mCurrentState == 7) {
                mHelpPageIndex = Math.max(0, mHelpPageIndex - 1);
            }
        } else if (ThePlagueCanvas.wasKeyPressed(64) || ThePlagueCanvas.wasKeyPressed(131072)) {
            if (mCurrentState == 10 && mSelectedMenuItemIndex == 1) {
                mLevelValue = mGameMode == 0 ? (mLevelValue == Math.min(mRMSCurrentLevel, 30) ? 1 : (mLevelValue = mLevelValue + 1)) : (mLevelValue == Math.min(mRMSCurrentLevel, 10) ? 1 : (mLevelValue = mLevelValue + 1));
            } else if (mCurrentState == 8) {
                mHighscorePageIndex = mHighscorePageIndex == 5 ? mHighscorePageIndex : mHighscorePageIndex + 1;
            } else if (mCurrentState == 7) {
                int helpIndex = 0;
                if (this.mIsHelpInGameMenu) {
                    helpIndex = mGameMode == 0 ? 1 : 2;
                }
                mHelpPageIndex = Math.min(HELP_PAGES[helpIndex].length - 1, mHelpPageIndex + 1);
            }
        } else if (ThePlagueCanvas.wasKeyPressed(32) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(4096)) {
            if (mCurrentState == 4) {
                switch (mSelectedMenuItemIndex) {
                    case 0: {
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 26;
                        break;
                    }
                    case 1: {
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 5;
                        break;
                    }
                    case 2: {
                        mHelpPageIndex = 0;
                        mCurrentState = 7;
                        break;
                    }
                    case 3: {
                        mHighscorePageIndex = 0;
                        this.changeState(8);
                        break;
                    }
                    case 4: {
                        mAboutPageY = 280;
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 9;
                        break;
                    }
                    case 5: {
                        mCurrentState = 20;
                    }
                }
            } else if (mCurrentState == 5) {
                switch (mSelectedMenuItemIndex) {
                    case 0: {
                        boolean bl = mIsSoundEnabled = !mIsSoundEnabled;
                        if (mIsSoundEnabled) {
                            this.playSound(0, true);
                            break;
                        }
                        this.stopSound();
                        break;
                    }
                    case 1: {
                        mSelectedMenuItemIndex = mIsEnglish ? 0 : 1;
                        mCurrentState = 19;
                        break;
                    }
                    case 2: {
                        mCurrentState = 21;
                    }
                }
            } else if (mCurrentState == 6) {
                mHelpPageIndex = 0;
                mCurrentState = 7;
            } else if (mCurrentState == 10) {
                switch (mSelectedMenuItemIndex) {
                    case 0: {
                        this.changeState(23);
                        break;
                    }
                    case 1: {
                        mCurrentState = 27;
                        mSelectedMenuItemIndex = 0;
                    }
                }
            } else if (mCurrentState == 26) {
                switch (mSelectedMenuItemIndex) {
                    case 0: {
                        mCurrentState = 10;
                        break;
                    }
                    case 1: {
                        mCurrentState = 27;
                    }
                }
                mGameMode = mSelectedMenuItemIndex;
                if (mRMSLastLiberadoLevel == 0 && mGameMode == 0 || mRMSTimeTrialCurrentLevel <= 1 && mGameMode == 1) {
                    this.changeState(12);
                } else {
                    mLevelValue = mGameMode == 0 ? mRMSLastLiberadoLevel : mRMSTimeTrialCurrentLevel;
                    mSelectedMenuItemIndex = 0;
                }
            } else if (mCurrentState == 19) {
                switch (mSelectedMenuItemIndex) {
                    case 0: {
                        mLanguageTexts = this.loadLanguageTexts(0);
                        mIsEnglish = true;
                        break;
                    }
                    case 1: {
                        mLanguageTexts = this.loadLanguageTexts(1);
                        mIsEnglish = false;
                    }
                }
                this.saveGameData();
                mSelectedMenuItemIndex = 1;
                mCurrentState = 5;
            } else if (mCurrentState == 20) {
                mCurrentState = 4;
                this.exitGame();
            } else if (mCurrentState == 21) {
                this.resetGameData();
                this.saveGameData();
                mCurrentState = 5;
            } else if (mCurrentState == 28) {
                if (mGameMode == 0) {
                    switch (mSelectedMenuItemIndex) {
                        case 0: {
                            if (mIsWinLevel) {
                                ++mCurrentLevel;
                                this.chooseBackgroundImage();
                                mIsBackgroundChanged = true;
                            } else {
                                mScore = mRMSScore;
                            }
                            mCurrentState = 11;
                            mBriefingIndex = 0;
                            break;
                        }
                        case 1: {
                            this.changeState(4);
                        }
                    }
                } else if (mIsWinLevel) {
                    switch (mSelectedMenuItemIndex) {
                        case 0: {
                            if (mCurrentLevel == 10 && mRMSTimeTrailFinished) {
                                mIsViewEnding = true;
                                mEndingScrollY = 260;
                                mScrollCounter = 0;
                                mCurrentState = 24;
                                break;
                            }
                            ++mCurrentLevel;
                            this.chooseBackgroundImage();
                            mIsBackgroundChanged = true;
                            mCurrentState = 11;
                            mBriefingIndex = 0;
                            break;
                        }
                        case 1: {
                            mCurrentState = 11;
                            mBriefingIndex = 0;
                            break;
                        }
                        case 2: {
                            this.changeState(4);
                            mSelectedMenuItemIndex = 0;
                            mCurrentState = 27;
                            break;
                        }
                        case 3: {
                            this.changeState(4);
                        }
                    }
                } else {
                    switch (mSelectedMenuItemIndex) {
                        case 0: {
                            mCurrentState = 11;
                            mBriefingIndex = 0;
                            break;
                        }
                        case 1: {
                            this.changeState(4);
                            mSelectedMenuItemIndex = 0;
                            mCurrentState = 27;
                            break;
                        }
                        case 2: {
                            this.changeState(4);
                        }
                    }
                }
            }
        } else if (ThePlagueCanvas.wasKeyPressed(8192)) {
            if (mCurrentState == 5) {
                mSelectedMenuItemIndex = 1;
                mCurrentState = 4;
            } else if (mCurrentState == 6) {
                mCurrentState = 4;
            } else if (mCurrentState == 7) {
                if (this.mIsHelpInGameMenu) {
                    this.mIsHelpInGameMenu = false;
                    mCurrentState = 17;
                } else {
                    mCurrentState = 4;
                }
            } else if (mCurrentState == 9) {
                mSelectedMenuItemIndex = 4;
                mCurrentState = 4;
            } else if (mCurrentState == 10) {
                mSelectedMenuItemIndex = 0;
                mCurrentState = 26;
            } else if (mCurrentState == 26) {
                mSelectedMenuItemIndex = 0;
                mCurrentState = 4;
            } else if (mCurrentState == 8) {
                mCurrentState = 4;
            } else if (mCurrentState == 19) {
                mSelectedMenuItemIndex = 1;
                mCurrentState = 5;
            } else if (mCurrentState == 20) {
                mCurrentState = 4;
            } else if (mCurrentState == 21) {
                mCurrentState = 5;
            }
        }
    }

    private void updatePlayingState() {
        if (mCurrentState == 11) {
            if (!mIsBackgroundChoose) {
                this.chooseBackgroundImage();
            }
            if (mBriefingIndex == 0) {
                if (ThePlagueCanvas.wasKeyPressed(4096) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(32)) {
                    ++mBriefingIndex;
                    mBriefingCounter = 3;
                    mAuxiliarTime = System.currentTimeMillis();
                }
            } else {
                if (System.currentTimeMillis() - mAuxiliarTime > 1000L) {
                    --mBriefingCounter;
                    mAuxiliarTime = System.currentTimeMillis();
                }
                if (mBriefingCounter == -1) {
                    mIsBackgroundChoose = false;
                    for (int i = 0; i < 6; ++i) {
                        mActorList[i].setPosition(mRandom.nextInt(260) + 20, -10);
                    }
                    this.initializeLevel();
                    mAuxiliarTime = System.currentTimeMillis();
                    this.playSound(this.getSceneSoundId(), true);
                    mCurrentState = 12;
                }
            }
        } else if (mCurrentState == 13) {
            if (mIsWinLevel) {
                mPetalos.update();
                if (System.currentTimeMillis() - mAuxiliarTime > 10000L) {
                    mPetalos.reset();
                    mAuxiliarTime = System.currentTimeMillis();
                }
            }
            if (ThePlagueCanvas.wasKeyReleased(4096) || ThePlagueCanvas.wasKeyReleased(262144) || ThePlagueCanvas.wasKeyReleased(32)) {
                if (mGameMode == 1) {
                    if (mIsWinLevel) {
                        mRMSTimeTrialCurrentLevel = Math.max(mRMSTimeTrialCurrentLevel, Math.min(10, mCurrentLevel + 1));
                        this.saveGameData();
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 15;
                    } else {
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 28;
                    }
                } else if (mIsWinLevel) {
                    mCurrentState = 15;
                } else if (mScore > mScoreValues[4]) {
                    this.updateEnduranceScore();
                    this.mScoreNewName = "";
                    this.mCursorTime = System.currentTimeMillis();
                    mCurrentState = 14;
                } else {
                    mSelectedMenuItemIndex = 0;
                    mCurrentState = 28;
                }
            }
        } else if (mCurrentState == 24) {
            if (mScrollCounter == 2) {
                --mEndingScrollY;
                mScrollCounter = 0;
            } else {
                ++mScrollCounter;
            }
            if (ThePlagueCanvas.wasKeyPressed(4096) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(32)) {
                if (mGameMode == 1) {
                    if (!mIsViewEnding && mScore > mTimeTrialScoreValues[mCurrentLevel - 1][2]) {
                        this.updateTimeTrialScore(mCurrentLevel - 1);
                        this.mScoreNewName = "";
                        this.mCursorTime = System.currentTimeMillis();
                        mCurrentState = 14;
                    } else {
                        mIsViewEnding = false;
                        mRMSTimeTrailFinished = true;
                        this.saveGameData();
                        this.changeState(4);
                        mCurrentState = 27;
                        mAuxiliarTime = System.currentTimeMillis();
                    }
                } else if (mScore > mScoreValues[4]) {
                    this.updateEnduranceScore();
                    this.mScoreNewName = "";
                    this.mCursorTime = System.currentTimeMillis();
                    mCurrentState = 14;
                } else {
                    this.saveGameData();
                    this.changeState(4);
                }
            }
        } else if (mCurrentState == 25) {
            if (ThePlagueCanvas.wasKeyPressed(4096) || System.currentTimeMillis() - mAuxiliarTime > 3000L) {
                if (mScore > mScoreValues[4]) {
                    this.mChangeScoreIndex = mScoreValues.length - 1;
                    ThePlagueCanvas.mScoreValues[4] = mScore;
                    for (int i = mScoreValues.length - 2; i >= 0 && mScore > mScoreValues[i]; --i) {
                        this.mChangeScoreIndex = i;
                        ThePlagueCanvas.mScoreValues[i + 1] = mScoreValues[i];
                        ThePlagueCanvas.mScoreValues[i] = mScore;
                        ThePlagueCanvas.mScoreNames[i + 1] = mScoreNames[i];
                    }
                    this.mScoreNewName = "";
                    this.mCursorTime = System.currentTimeMillis();
                    mCurrentState = 14;
                } else {
                    this.changeState(4);
                }
            }
        } else if (mCurrentState != 16) {
            if (mCurrentState == 14) {
                this.updateEnterScoreNameSubstate();
            } else if (mCurrentState == 17) {
                int[] inGameList;
                int[] nArray = inGameList = mGameMode == 0 ? INGAMEMENU_LIST : INGAMEMENU_LIST_2;
                if ((ThePlagueCanvas.wasKeyPressed(4) || ThePlagueCanvas.wasKeyPressed(16384)) && this.mInGameMenuSubstate == 0) {
                    mSelectedMenuItemIndex = --mSelectedMenuItemIndex < 0 ? inGameList.length - 1 : mSelectedMenuItemIndex;
                } else if ((ThePlagueCanvas.wasKeyPressed(256) || ThePlagueCanvas.wasKeyPressed(32768)) && this.mInGameMenuSubstate == 0) {
                    mSelectedMenuItemIndex = (mSelectedMenuItemIndex + 1) % inGameList.length;
                } else if (ThePlagueCanvas.wasKeyPressed(32) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(4096)) {
                    if (this.mInGameMenuSubstate == 0) {
                        if (mGameMode == 0) {
                            switch (mSelectedMenuItemIndex) {
                                case 0: {
                                    if (this.mInterruptionInIntro) {
                                        mBriefingIndex = 0;
                                        this.mInterruptionInIntro = false;
                                        mCurrentState = 11;
                                    } else {
                                        mCurrentState = 12;
                                    }
                                    this.playSound(this.getSceneSoundId(), true);
                                    break;
                                }
                                case 1: {
                                    boolean bl = mIsSoundEnabled = !mIsSoundEnabled;
                                    if (mIsSoundEnabled) {
                                        this.playSound(2);
                                        break;
                                    }
                                    this.stopSound();
                                    break;
                                }
                                case 2: {
                                    this.mIsHelpInGameMenu = true;
                                    mHelpPageIndex = 0;
                                    mCurrentState = 7;
                                    break;
                                }
                                case 3: {
                                    this.mInGameMenuSubstate = 1;
                                    break;
                                }
                                case 4: {
                                    this.mInGameMenuSubstate = 2;
                                }
                            }
                        } else {
                            switch (mSelectedMenuItemIndex) {
                                case 0: {
                                    if (this.mInterruptionInIntro) {
                                        mBriefingIndex = 0;
                                        this.mInterruptionInIntro = false;
                                        mCurrentState = 11;
                                    } else {
                                        mCurrentState = 12;
                                    }
                                    this.playSound(this.getSceneSoundId(), true);
                                    break;
                                }
                                case 1: {
                                    mScore = 0;
                                    mBriefingIndex = 1;
                                    mBriefingCounter = 3;
                                    mAuxiliarTime = System.currentTimeMillis();
                                    mLevelTime = 180;
                                    mCurrentState = 11;
                                    this.playSound(this.getSceneSoundId(), true);
                                    break;
                                }
                                case 2: {
                                    boolean bl = mIsSoundEnabled = !mIsSoundEnabled;
                                    if (mIsSoundEnabled) {
                                        this.playSound(2);
                                        break;
                                    }
                                    this.stopSound();
                                    break;
                                }
                                case 3: {
                                    this.mIsHelpInGameMenu = true;
                                    mHelpPageIndex = 0;
                                    mCurrentState = 7;
                                    break;
                                }
                                case 4: {
                                    this.mInGameMenuSubstate = 1;
                                    break;
                                }
                                case 5: {
                                    this.mInGameMenuSubstate = 2;
                                }
                            }
                        }
                    } else if (this.mInGameMenuSubstate == 1 && ThePlagueCanvas.wasKeyPressed(4096)) {
                        this.changeState(4);
                        this.playSound(0, true);
                    } else if (this.mInGameMenuSubstate == 2 && ThePlagueCanvas.wasKeyPressed(4096)) {
                        this.exitGame();
                    }
                } else if (ThePlagueCanvas.wasKeyPressed(8192)) {
                    this.mInGameMenuSubstate = 0;
                }
            } else if (mCurrentState == 15) {
                if (ThePlagueCanvas.wasKeyPressed(32) || ThePlagueCanvas.wasKeyPressed(262144) || ThePlagueCanvas.wasKeyPressed(4096)) {
                    if (mGameMode == 1) {
                        if (mCurrentLevel == 10 && !mRMSTimeTrailFinished) {
                            mPetalos.reset();
                            mEndingScrollY = 260;
                            mScrollCounter = 0;
                            mCurrentState = 24;
                        } else if (mScore > mTimeTrialScoreValues[mCurrentLevel - 1][2]) {
                            this.updateTimeTrialScore(mCurrentLevel - 1);
                            this.mScoreNewName = "";
                            this.mCursorTime = System.currentTimeMillis();
                            mCurrentState = 14;
                        } else {
                            mSelectedMenuItemIndex = 0;
                            mCurrentState = 28;
                        }
                    } else if (mCurrentLevel == 30) {
                        mPetalos.reset();
                        mEndingScrollY = 260;
                        mScrollCounter = 0;
                        mCurrentState = 24;
                    } else {
                        mSelectedMenuItemIndex = 0;
                        mCurrentState = 28;
                    }
                }
            } else if (mCurrentState == 12) {
                int i;
                if (ThePlagueCanvas.wasKeyPressed(4096)) {
                    mSelectedMenuItemIndex = 0;
                    this.mInGameMenuSubstate = 0;
                    mCurrentState = 17;
                    this.stopSound();
                }
                if ((ThePlagueCanvas.wasKeyPressed(2048) || ThePlagueCanvas.wasKeyPressed(1024)) && !mIsLimpiadorEnabled) {
                    mIsLimpiadorEnabled = true;
                    mPlagueLimpiadorSprite.setCurrentAnimation(mPlagueLimpiadorAnimation, 0, false);
                    mScore -= 20;
                }
                if (mIsLimpiadorEnabled) {
                    mPlagueLimpiadorSprite.updateAnimation(mPlagueLimpiadorAnimation);
                    int currentFrame = mPlagueLimpiadorSprite.getAnimationCurrentFrame(mPlagueLimpiadorAnimation);
                    int ax = 0;
                    int ay = 0;
                    if (currentFrame == 4) {
                        ax = 128;
                        ay = -62;
                    } else if (currentFrame == 5) {
                        ax = 127;
                        ay = -257;
                    } else if (currentFrame == 6) {
                        ax = 0;
                        ay = -329;
                    } else if (currentFrame == 7) {
                        ax = -117;
                        ay = -235;
                    } else if (currentFrame == 8) {
                        ax = -112;
                        ay = -56;
                    } else if (currentFrame == 9) {
                        ax = -112;
                        ay = 0;
                    }
                    for (i = 0; i < mActorList.length; ++i) {
                        if (mActorList[i] == null || mActorList[i].getType() != 0) continue;
                        int bx = mActorList[i].getMocoPositionX() - 212;
                        int by = mActorList[i].getMocoPositionY() - 313;
                        if (!mActorList[i].isMocoEnabled() || ax * by - ay * bx <= 0) continue;
                        mActorList[i].setMocoEnabled(false);
                    }
                    if (mPlagueLimpiadorSprite.isAnimationOver(mPlagueLimpiadorAnimation)) {
                        mIsLimpiadorEnabled = false;
                    }
                }
                this.pressKey = -1;
                if (ThePlagueCanvas.wasKeyPressed(1)) {
                    this.pressKey = 0;
                } else if (ThePlagueCanvas.wasKeyPressed(2)) {
                    this.pressKey = 1;
                } else if (ThePlagueCanvas.wasKeyPressed(4)) {
                    this.pressKey = 2;
                } else if (ThePlagueCanvas.wasKeyPressed(8)) {
                    this.pressKey = 3;
                } else if (ThePlagueCanvas.wasKeyPressed(16)) {
                    this.pressKey = 4;
                } else if (ThePlagueCanvas.wasKeyPressed(32)) {
                    this.pressKey = 5;
                } else if (ThePlagueCanvas.wasKeyPressed(64)) {
                    this.pressKey = 6;
                } else if (ThePlagueCanvas.wasKeyPressed(128)) {
                    this.pressKey = 7;
                } else if (ThePlagueCanvas.wasKeyPressed(256)) {
                    this.pressKey = 8;
                } else if (ThePlagueCanvas.wasKeyPressed(512)) {
                    this.pressKey = 9;
                }
                int maxGremlinsActivos = ENEMIGOS_EN_PANTALLA[mCurrentLevel - 1];
                if (mGameMode == 1) {
                    maxGremlinsActivos = TIME_TRIAL_ENEMIGOS_EN_PANTALLA[mCurrentLevel - 1];
                }
                int gremlinsActivos = 0;
                boolean pressedCorrectCharacter = false;
                for (i = 0; i < mActorList.length; ++i) {
                    if (mActorList[i] == null || !mActorList[i].isEnabled()) continue;
                    if (mActorList[i].isEnabled()) {
                        ++gremlinsActivos;
                    }
                    mActorList[i].update();
                    if (mActorList[i].getPositionY() > 250) {
                        mActorList[i].setEnabled(false);
                        if (mActorList[i].getActorState() == 0) {
                            mScore -= 50;
                            this.setLives(mLives - 1);
                            ++this.penal;
                        } else if (mActorList[i].getActorState() == 2) {
                            // empty if block
                        }
                    }
                    if (this.pressKey == -1 || mActorList[i].getType() != 0 || mActorList[i].getActorState() != 0 || mActorList[i].getPositionY() <= 10) continue;
                    char c = mActorList[i].getText().charAt(0);
                    if (c == 48 + this.pressKey) {
                        pressedCorrectCharacter = true;
                        if (mActorList[i].getText().length() > 1) {
                            mActorList[i].setText(mActorList[i].getText().substring(1));
                        } else {
                            mActorList[i].setText("");
                        }
                    } else {
                        block21: for (int j = 0; j < KEYCHARS.length; ++j) {
                            for (int k = 0; k < KEYCHARS[j].length; ++k) {
                                if (KEYCHARS[j][k] != c || this.pressKey != j + 2) continue;
                                if (mActorList[i].getText().length() > 1) {
                                    mActorList[i].setText(mActorList[i].getText().substring(1));
                                } else {
                                    mActorList[i].setText("");
                                }
                                pressedCorrectCharacter = true;
                                break block21;
                            }
                        }
                    }
                    if (!mActorList[i].getText().equals("")) continue;
                    String text = mActorList[i].getCacheText();
                    for (int j = 0; j < text.length(); ++j) {
                        char character = text.charAt(j);
                        if (character >= '0' && character <= '9') {
                            mScore += 20;
                            continue;
                        }
                        mScore += 30;
                    }
                    if (mActorList[i].getPositionY() <= 50) {
                        mScore += 100;
                    } else if (mActorList[i].getPositionY() <= 250) {
                        mScore += -100 * mActorList[i].getPositionY() / 200 + 25 + 100;
                    }
                    mActorList[i].setActorState(1);
                    ++mTotalGremlinsMuertos;
                }
                if (!pressedCorrectCharacter && this.pressKey != -1) {
                    mScore -= 20;
                    this.setLives(mLives - 1);
                    ++this.penal;
                }
                int index = 0;
                while (maxGremlinsActivos - gremlinsActivos != 0) {
                    if (mActorList[index] != null && mActorList[index].getType() == 0 && !mActorList[index].isEnabled()) {
                        this.resetGremlin(mActorList[index]);
                        ++gremlinsActivos;
                    }
                    ++index;
                }
                if (mGameMode == 0) {
                    if (mTotalGremlinsMuertos != (mCurrentLevel - 1) * 20 || !mIsContinueSelected) {
                        // empty if block
                    }
                    if (mTotalGremlinsMuertos >= mCurrentLevel * 20) {
                        if (mCurrentLevel == 1) {
                            ThePlagueCanvas.mEnemigosEliminados[ThePlagueCanvas.mCurrentLevel - 1] = mTotalGremlinsMuertos;
                            ThePlagueCanvas.mScoreNivel[ThePlagueCanvas.mCurrentLevel - 1] = mScore;
                        } else {
                            int i2;
                            int prevTotal = 0;
                            for (i2 = 0; i2 < mCurrentLevel - 1; ++i2) {
                                prevTotal += mEnemigosEliminados[i2];
                            }
                            ThePlagueCanvas.mEnemigosEliminados[ThePlagueCanvas.mCurrentLevel - 1] = mTotalGremlinsMuertos - prevTotal;
                            prevTotal = 0;
                            for (i2 = 0; i2 < mCurrentLevel - 1; ++i2) {
                                prevTotal += mScoreNivel[i2];
                            }
                            ThePlagueCanvas.mScoreNivel[ThePlagueCanvas.mCurrentLevel - 1] = mScore - prevTotal;
                        }
                        if (mCurrentLevel == 3 || mCurrentLevel == 9 || mCurrentLevel == 12 || mCurrentLevel == 18 || mCurrentLevel == 21 || mCurrentLevel == 27) {
                            this.setLives(mLives + 1);
                        }
                        mRMSLastLiberadoLevel = Math.max(mRMSLastLiberadoLevel, Math.min(mCurrentLevel + 1, 30));
                        mRMSCurrentLevel = Math.min(mCurrentLevel + 1, 30);
                        mRMSLives = mCurrentLevel == 30 ? 5 : mLives;
                        mRMSScore = mCurrentLevel == 30 ? 0 : mScore;
                        mRMSEnemigosDerrotados = mCurrentLevel == 30 ? 0 : mTotalGremlinsMuertos;
                        this.saveGameData();
                        if (mCurrentLevel == 6 || mCurrentLevel == 15 || mCurrentLevel == 24 || mCurrentLevel == 30) {
                            mPetalos.reset();
                            mIsWinLevel = true;
                            mAuxiliarTime = System.currentTimeMillis();
                            mCurrentState = 13;
                            this.playSound(3);
                        } else {
                            ++mCurrentLevel;
                        }
                        if (mCurrentLevel != 30) {
                            this.chooseBackgroundImage();
                        }
                    }
                } else if (mGameMode == 1) {
                    ThePlagueCanvas.mEnemigosEliminados[ThePlagueCanvas.mCurrentLevel - 1] = mTotalGremlinsMuertos;
                    ThePlagueCanvas.mScoreNivel[ThePlagueCanvas.mCurrentLevel - 1] = mScore;
                    try {
                        if (mLevelTime == 60) {
                            mBackgroundImage = Image.createImage((String)("/bk" + (Integer.valueOf(TIME_TRIAL_ORDEN_NIVELES[mCurrentLevel - 1]) + 2) + ".png"));
                        } else if (mLevelTime == 120) {
                            mBackgroundImage = Image.createImage((String)("/bk" + (Integer.valueOf(TIME_TRIAL_ORDEN_NIVELES[mCurrentLevel - 1]) + 1) + ".png"));
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - mAuxiliarTime >= 1000L) {
                        --mLevelTime;
                        mAuxiliarTime = System.currentTimeMillis();
                    }
                    if (mLevelTime <= 0) {
                        mIsWinLevel = true;
                        mCurrentState = 13;
                        this.playSound(4);
                    }
                }
                if (mLives <= 0) {
                    mIsWinLevel = false;
                    mCurrentState = 13;
                    this.stopSound();
                }
            }
        }
    }

    private void updateSoundQuestionState() {
        if (ThePlagueCanvas.wasKeyReleased(4096) || ThePlagueCanvas.wasKeyReleased(262144) || ThePlagueCanvas.wasKeyReleased(32) || ThePlagueCanvas.wasKeyReleased(8192)) {
            mIsSoundEnabled = ThePlagueCanvas.wasKeyReleased(4096) || ThePlagueCanvas.wasKeyReleased(262144) || ThePlagueCanvas.wasKeyReleased(32);
            this.changeState(3);
        }
    }

    private void updateSplashState() {
        if (ThePlagueCanvas.isAnyKeyPressed()) {
            this.changeState(4);
        }
        if (System.currentTimeMillis() - mAuxiliarTime >= 1000L) {
            mAuxiliarTime = System.currentTimeMillis();
        }
    }

    private void resetGameData() {
        int i;
        mRMSLastLiberadoLevel = 0;
        mRMSCurrentLevel = 0;
        mRMSScore = 0;
        mRMSLives = 3;
        mRMSEnemigosDerrotados = 0;
        for (i = 0; i < 5; ++i) {
            ThePlagueCanvas.mScoreNames[i] = "CPU";
            ThePlagueCanvas.mScoreValues[i] = 100;
        }
        mRMSTimeTrailFinished = false;
        mRMSTimeTrialCurrentLevel = 1;
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                ThePlagueCanvas.mTimeTrialScoreNames[i][j] = "CPU";
                ThePlagueCanvas.mTimeTrialScoreValues[i][j] = 100;
            }
        }
        this.saveGameData();
    }

    private void getGameData() {
        boolean isInitialScore = false;
        RecordManager.open(true);
        if (RecordManager.getDataSize() == 0) {
            int i;
            mIsEnglish = false;
            mRMSLastLiberadoLevel = 0;
            mRMSCurrentLevel = 0;
            mRMSScore = 0;
            mRMSLives = 3;
            mRMSEnemigosDerrotados = 0;
            isInitialScore = true;
            for (i = 0; i < 5; ++i) {
                ThePlagueCanvas.mScoreNames[i] = "CPU";
                ThePlagueCanvas.mScoreValues[i] = 100;
            }
            mRMSTimeTrailFinished = false;
            mRMSTimeTrialCurrentLevel = 1;
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ThePlagueCanvas.mTimeTrialScoreNames[i][j] = "CPU";
                    ThePlagueCanvas.mTimeTrialScoreValues[i][j] = 100;
                }
            }
        } else {
            int i;
            mIsEnglish = RecordManager.readBoolean();
            mRMSLastLiberadoLevel = RecordManager.readInt();
            mRMSCurrentLevel = RecordManager.readInt();
            mRMSScore = RecordManager.readInt();
            mRMSLives = RecordManager.readInt();
            mRMSEnemigosDerrotados = RecordManager.readInt();
            for (i = 0; i < 5; ++i) {
                ThePlagueCanvas.mScoreNames[i] = RecordManager.readString();
                ThePlagueCanvas.mScoreValues[i] = RecordManager.readInt();
            }
            mRMSTimeTrailFinished = RecordManager.readBoolean();
            mRMSTimeTrialCurrentLevel = RecordManager.readInt();
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ThePlagueCanvas.mTimeTrialScoreNames[i][j] = RecordManager.readString();
                    ThePlagueCanvas.mTimeTrialScoreValues[i][j] = RecordManager.readInt();
                }
            }
        }
        RecordManager.close();
        if (isInitialScore) {
            this.saveGameData();
        }
    }

    private void saveGameData() {
        int i;
        RecordManager.open(false);
        RecordManager.writeBoolean(mIsEnglish);
        RecordManager.writeInt(mRMSLastLiberadoLevel);
        RecordManager.writeInt(mRMSCurrentLevel);
        RecordManager.writeInt(mRMSScore);
        RecordManager.writeInt(mRMSLives);
        RecordManager.writeInt(mRMSEnemigosDerrotados);
        for (i = 0; i < 5; ++i) {
            RecordManager.writeString(mScoreNames[i]);
            RecordManager.writeInt(mScoreValues[i]);
        }
        RecordManager.writeBoolean(mRMSTimeTrailFinished);
        RecordManager.writeInt(mRMSTimeTrialCurrentLevel);
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                RecordManager.writeString(mTimeTrialScoreNames[i][j]);
                RecordManager.writeInt(mTimeTrialScoreValues[i][j]);
            }
        }
        RecordManager.close();
    }

    private void paintDialog(Graphics g, String message) {
        int padding = 30;
        int height = mSmallFont.getStringHeight(message) + 2 * padding;
        this.paintWindowFrame(g, -12, this.getHeight() - height >> 1, this.getWidth() + 24, height);
        mSmallFont.drawString(g, message, this.getWidth() >> 1, (this.getHeight() - height >> 1) + padding, 16);
        this.drawSoftKeys(g, 2, 3);
    }

    private void updateTimeTrialScore(int level) {
        if (mScore > mTimeTrialScoreValues[level][2]) {
            this.mChangeScoreIndex = mTimeTrialScoreValues[level].length - 1;
            ThePlagueCanvas.mTimeTrialScoreValues[level][2] = mScore;
            for (int i = mTimeTrialScoreValues[level].length - 2; i >= 0 && mScore > mTimeTrialScoreValues[level][i]; --i) {
                this.mChangeScoreIndex = i;
                ThePlagueCanvas.mTimeTrialScoreValues[level][i + 1] = mTimeTrialScoreValues[level][i];
                ThePlagueCanvas.mTimeTrialScoreValues[level][i] = mScore;
                ThePlagueCanvas.mTimeTrialScoreNames[level][i + 1] = mTimeTrialScoreNames[level][i];
            }
        }
    }

    protected void keyReleased(int keyCode) {
        this.mKeyCode = keyCode;
        if (keyCode >= 65 && keyCode <= 90 || keyCode >= 97 && keyCode <= 122) {
            if (mCurrentState == 14) {
                if (this.mScoreNewName.length() < 6) {
                    this.mScoreNewName = this.mScoreNewName + (char)keyCode;
                }
                mAuxiliarTime = System.currentTimeMillis();
            } else {
                super.keyReleased(keyCode);
            }
        } else {
            super.keyReleased(keyCode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TUTORIAL = new int[]{41, 42, 43, 44, 45, 46, 47, 48, 49, 50};
        SOUND_FILE_LIST = new String[]{"/theme.mid", "/gameOver.mid", "/select.mid", "/levelPass.mid", "/winGame.aac", "/rusianGreek.mid", "/orientScaleA.mid", "/frenckItaly.mid"};
        SOUND_ID_LIST = new int[]{0, 1, 2, 4, 3, 5, 6, 7};
        USO_CARACTERES = new String[]{"1", "1", "1", "A", "A", "A", "11", "11", "11", "1A", "1A", "1A", "AA", "AA", "AA", "111", "111", "111", "11A", "11A", "11A", "1AA", "1AA", "1AA", "AAA", "AAA", "AAA", "AAA", "AAA", "AAA"};
        TIME_TRIAL_USO_CARACTERES = new String[]{"1", "A", "11", "1A", "AA", "111", "11A", "1AA", "AAA", "AAA"};
        USO_DE_LETRAS = new String[]{"0", "0", "0", "1:3", "1:2", "1:1", "0", "0", "0", "1:3", "1:2", "1:1", "1:3", "1:2", "1:1", "0", "0", "0", "1:3", "1:2", "1:1", "1:3", "1:2", "1:1", "1:3", "1:2", "1:1", "1:3", "1:2", "1:1"};
        TIME_TRIAL_USO_DE_LETRAS = new String[]{"0", "1:2", "0", "1:2", "1:2", "0", "1:2", "1:2", "1:2", "1:1"};
        VISIBILIDAD_DE_CARACTERES = new String[]{"100", "100", "100", "100", "100", "100", "80", "80", "80", "70", "70", "70", "60", "60", "60", "i60", "i60", "i60", "i50", "i50", "i50", "i40", "i40", "i40", "i40", "i40", "i40", "i40", "i40", "i40"};
        TIME_TRIAL_VISIBILIDAD_DE_CARACTERES = new String[]{"100", "90", "80", "70", "60", "i60", "i50", "i40", "i30", "i20"};
        ENEMIGOS_EN_PANTALLA = new int[]{4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
        TIME_TRIAL_ENEMIGOS_EN_PANTALLA = new int[]{4, 4, 5, 5, 5, 6, 6, 6, 6, 6};
        VELOCIDAD_DE_CAIDA = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4};
        TIME_TRIAL_VELOCIDAD_DE_CAIDA = new int[]{1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
        ATAQUE_DE_ENEMIGOS = new int[]{3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        TIME_TRIAL_ATAQUE_DE_ENEMIGOS = new int[]{3, 3, 2, 2, 2, 1, 1, 1, 0, 0};
        ERRORES_PERMITIDOS = new int[]{4, 4, 4, 5, 5, 5, 4, 4, 4, 5, 5, 5, 5, 5, 5, 4, 4, 4, 5, 5, 5, 5, 5, 5, 4, 4, 4, 5, 5, 5};
        ORDEN_NIVELES_ENDURANCE = new String[]{"24", "21", "3", "9", "18", "12", "27", "0", "15", "6"};
        TIME_TRIAL_ORDEN_NIVELES = new String[]{"12", "0", "6", "27", "15", "18", "3", "24", "9", "21"};
        mCaracteresEntrados = new char[3];
        mEnemigosEliminados = new int[30];
        mScoreNivel = new int[30];
        mActorList = new Actor[12];
        mStringBuffer = new StringBuffer(3);
        mIsChangingState = false;
        mScoreNames = new String[5];
        mScoreValues = new int[5];
        mTimeTrialScoreNames = new String[10][3];
        mTimeTrialScoreValues = new int[10][3];
        offsetMenuX = 30;
        mIsViewEnding = false;
        mIsBackgroundChoose = false;
    }
}

