/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Particles {
    public static int TYPE_CHORRO = 0;
    private static Random mRandom;
    private int mType;
    private int mActiveParticlesCount;
    private int mParticlesCount;
    private int mStartPositionX;
    private int mStartPositionY;
    private int[] mPositionX;
    private int[] mPositionY;
    private int[] mStartVelocityX;
    private int[] mStartVelocityY;
    private int mChorroRetraso;
    private int mGravity;
    private float mTime;
    private static MSprite mParticleSprite;
    private MSprite.AnimationProfile[] mParticleAnimations;
    static /* synthetic */ Class class$Particles;

    private Particles() {
        if (mRandom == null) {
            mRandom = new Random(System.currentTimeMillis());
        }
        if (mParticleSprite == null) {
            mParticleSprite = new MSprite(Particles.readFile("/petalos.bsprite"), Particles.readFile("/petalos.png"));
        }
    }

    private static byte[] readFile(String name) {
        try {
            InputStream is = (class$Particles == null ? (class$Particles = Particles.class$("Particles")) : class$Particles).getResourceAsStream(name);
            byte[] result = new byte[is.available()];
            is.read(result);
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Particles createChorro(int x, int y, int numParticles, int retraso) {
        Particles particles = new Particles();
        particles.mType = TYPE_CHORRO;
        particles.mStartPositionX = x;
        particles.mStartPositionY = y;
        particles.mPositionX = new int[numParticles];
        particles.mPositionY = new int[numParticles];
        particles.mStartVelocityX = new int[numParticles];
        particles.mStartVelocityY = new int[numParticles];
        particles.mChorroRetraso = retraso;
        particles.mParticleAnimations = new MSprite.AnimationProfile[numParticles];
        for (int i = 0; i < numParticles; ++i) {
            particles.mParticleAnimations[i] = mParticleSprite.createAnimationProfile();
            mParticleSprite.setAnimationDelay(particles.mParticleAnimations[i], 4);
            mParticleSprite.setCurrentAnimation(particles.mParticleAnimations[i], 0, true);
        }
        particles.mParticlesCount = numParticles;
        particles.mActiveParticlesCount = -1;
        particles.mGravity = 2;
        particles.mTime = 0.0f;
        return particles;
    }

    public void update() {
        if (this.mType == TYPE_CHORRO) {
            this.updateChorro();
        }
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.mActiveParticlesCount; ++i) {
            mParticleSprite.drawAnimation(g, this.mParticleAnimations[i], this.mPositionX[i], this.mPositionY[i], 0);
        }
    }

    public void reset() {
        if (this.mType == TYPE_CHORRO) {
            this.mActiveParticlesCount = 0;
            this.mTime = 0.0f;
        }
    }

    private void updateChorro() {
        this.mTime = (float)((double)this.mTime + 0.2);
        for (int i = 0; i <= this.mActiveParticlesCount; ++i) {
            mParticleSprite.updateAnimation(this.mParticleAnimations[i]);
            this.mPositionX[i] = (int)((float)this.mStartVelocityX[i] * this.mTime + (float)this.mStartPositionX);
            this.mPositionY[i] = (int)((float)this.mGravity * this.mTime * this.mTime + (float)this.mStartVelocityY[i] * this.mTime + (float)this.mStartPositionY);
        }
        if (this.mActiveParticlesCount < this.mParticlesCount - 1) {
            ++this.mActiveParticlesCount;
            this.mPositionX[this.mActiveParticlesCount] = this.mStartPositionX;
            this.mPositionY[this.mActiveParticlesCount] = this.mStartPositionY;
            this.mStartVelocityX[this.mActiveParticlesCount] = mRandom.nextInt(10) - 5;
            this.mStartVelocityY[this.mActiveParticlesCount] = -25 - mRandom.nextInt(20);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

