/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordManager {
    private static final String RMSNAME = "inode_mingzhu";
    private static RecordStore mRecordStore;
    private static DataInputStream mDataInputStream;
    private static ByteArrayOutputStream mByteArrayOutputStream;
    private static DataOutputStream mDataOutputStream;
    private static byte[] mData;
    private static boolean mIsReading;

    public static void open(boolean reading) {
        RecordManager.openRecordStore();
        mIsReading = reading;
        if (reading) {
            mData = RecordManager.getData();
            if (mData != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mData);
                mDataInputStream = new DataInputStream(byteArrayInputStream);
            }
        } else {
            mByteArrayOutputStream = new ByteArrayOutputStream(50);
            mDataOutputStream = new DataOutputStream(mByteArrayOutputStream);
        }
    }

    public static int getDataSize() {
        if (mData == null) {
            return 0;
        }
        return mData.length;
    }

    public static String readString() {
        try {
            return mDataInputStream.readUTF();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeString(String value) {
        try {
            mDataOutputStream.writeUTF(value);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static int readInt() {
        try {
            return mDataInputStream.readInt();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static void writeInt(int value) {
        try {
            mDataOutputStream.writeInt(value);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static int readByte() {
        try {
            return mDataInputStream.readByte();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static void writeByte(byte value) {
        try {
            mDataOutputStream.writeByte(value);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean readBoolean() {
        try {
            return mDataInputStream.readBoolean();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void writeBoolean(boolean value) {
        try {
            mDataOutputStream.writeBoolean(value);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void close() {
        try {
            if (!mIsReading) {
                try {
                    mData = mByteArrayOutputStream.toByteArray();
                    mRecordStore.setRecord(1, mData, 0, mData.length);
                }
                catch (InvalidRecordIDException ex) {
                    mRecordStore.addRecord(mData, 0, mData.length);
                }
                mDataOutputStream.close();
                mByteArrayOutputStream.close();
            } else if (mDataInputStream != null) {
                mDataInputStream.close();
            }
            mRecordStore.closeRecordStore();
            mData = null;
            mDataOutputStream = null;
            mByteArrayOutputStream = null;
            mDataInputStream = null;
            mRecordStore = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void saveData(byte[] data) {
        RecordManager.openRecordStore();
        try {
            mRecordStore.setRecord(1, data, 0, data.length);
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (InvalidRecordIDException ex) {
            try {
                mRecordStore.addRecord(data, 0, data.length);
            }
            catch (RecordStoreNotOpenException ex1) {
                ex1.printStackTrace();
            }
            catch (RecordStoreException ex1) {
                ex1.printStackTrace();
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static byte[] getData() {
        RecordManager.openRecordStore();
        byte[] data = null;
        try {
            data = mRecordStore.getRecord(1);
        }
        catch (RecordStoreException ex) {
            data = null;
        }
        return data;
    }

    private static void openRecordStore() {
        if (mRecordStore == null) {
            try {
                mRecordStore = RecordStore.openRecordStore((String)RMSNAME, (boolean)true);
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }
}

