/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import datay.MyRMS;
import datay.Share;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlayCanvas
extends FullCanvas
implements Runnable {
    private GameMidlet theMidlet = null;
    public int winnum = 0;
    public int High = 0;
    public boolean FirstRun = false;
    public int level = 0;
    public int Lives = 0;
    public int Times = 0;
    public boolean GameLoad = false;
    private boolean running = true;
    private final int MAX_CPS;
    private final long MAX_FRAME;
    private int Width = 176;
    private int Height = 208;
    private int HalfWidth = this.Width >> 1;
    private int HalfHeight = this.Height >> 1;
    private byte MainState = 0;
    private final byte MAIN_LOGO;
    private final byte MAIN_MENU;
    private final byte MAIN_INIT = (byte)2;
    private final byte MAIN_START = (byte)3;
    private final byte MAIN_RELEASE = (byte)4;
    private Image imgLogo = null;
    private MenuCanvas Menu = null;
    private PlayGame playgame = null;
    private long lastTime = 0L;

    public PlayCanvas(GameMidlet midlet) {
        this.MAX_CPS = 50;
        this.MAX_FRAME = 20L;
        this.MAIN_LOGO = 0;
        this.MAIN_MENU = 1;
        this.theMidlet = midlet;
        Thread t = new Thread(this);
        t.start();
    }

    private void SetScreen() {
        this.Width = 240;
        this.Height = 320;
        this.HalfWidth = this.Width >> 1;
        this.HalfHeight = this.Height >> 1;
    }

    public void paint(Graphics g) {
        switch (this.MainState) {
            case 0: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.Width, this.Height);
                g.drawImage(this.imgLogo, this.HalfWidth, this.HalfHeight, 3);
                break;
            }
            case 1: {
                this.Menu.DrawMenu(g);
                break;
            }
            case 2: {
                this.DrawInit(g);
                break;
            }
            case 3: {
                this.playgame.DrawGame(g);
            }
        }
    }

    private void GameEvent() {
        long msUseLastCycle = System.currentTimeMillis() - this.lastTime;
        switch (this.MainState) {
            case 0: {
                break;
            }
            case 1: {
                this.Menu.LogicMenu(msUseLastCycle);
                break;
            }
            case 2: {
                this.Logic_Init();
                break;
            }
            case 3: {
                this.playgame.LogicGame(msUseLastCycle);
                break;
            }
            case 4: {
                this.Logic_Release();
            }
        }
        this.lastTime = System.currentTimeMillis();
    }

    private void DrawInit(Graphics g) {
    }

    private void Logic_Init() {
        this.Menu = null;
        System.gc();
        if (this.playgame == null) {
            this.playgame = new PlayGame(this);
        }
        this.MainState = (byte)3;
    }

    private void Logic_Release() {
        if (this.playgame != null) {
            this.playgame = null;
        }
        System.gc();
        if (this.Menu == null) {
            this.Menu = new MenuCanvas(this);
        }
        this.MainState = 1;
    }

    private void GameInit() {
        this.running = true;
        this.SetScreen();
        this.imgLogo = Share.LoadImage("/logo.png");
        this.MainState = 0;
        this.repaint(0, 0, this.Width, this.Height);
        this.CheckMyRMS();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Menu = new MenuCanvas(this);
        this.imgLogo = null;
        System.gc();
        this.MainState = 1;
    }

    private void CheckMyRMS() {
        MyRMS.CreateRMS("FrogRoad", true);
        this.FirstRun = MyRMS.CheckRMS();
        MyRMS.close();
        if (this.FirstRun) {
            this.High = 0;
            this.Lives = 4;
            this.Times = 99;
            this.level = 0;
            this.winnum = 0;
            int[] data = new int[]{this.Lives, this.Times, this.High, this.level, this.winnum};
            MyRMS.CreateRMS("FrogRoad", true);
            MyRMS.save(1, data);
            MyRMS.close();
        } else {
            MyRMS.CreateRMS("FrogRoad", true);
            int[] data = new int[5];
            MyRMS.load(1, data);
            this.Lives = data[0];
            this.Times = data[1];
            this.High = data[2];
            this.level = data[3];
            this.winnum = data[4];
            MyRMS.close();
        }
    }

    protected void keyPressed(int keycode) {
        short keyState = Share.GetKey((short)keycode);
        switch (this.MainState) {
            case 1: {
                this.Menu.KeyMenu(keyState);
                break;
            }
            case 3: {
                this.playgame.KeyGame(keyState);
            }
        }
    }

    public void keyReleased(int keycode) {
    }

    public void hideNotify() {
    }

    public int getWidth() {
        return this.Width;
    }

    public int getHeight() {
        return this.Height;
    }

    public int getHalfWidth() {
        return this.HalfWidth;
    }

    public int getHalfHeight() {
        return this.HalfHeight;
    }

    public void run() {
        this.GameInit();
        while (this.running) {
            long endtime = System.currentTimeMillis() + 20L;
            this.GameEvent();
            this.repaint(0, 0, this.Width, this.Height);
            this.serviceRepaints();
            long nowtime = System.currentTimeMillis();
            if (nowtime >= endtime) continue;
            try {
                Thread.sleep(endtime - nowtime);
            }
            catch (Exception e) {}
        }
        this.theMidlet.exit();
    }

    public void Exit() {
        this.running = false;
    }

    public void ToInit() {
        this.MainState = (byte)2;
    }

    public void ToMenu() {
        this.MainState = (byte)4;
    }
}

