/*
 * Decompiled with CFR 0.152.
 */
import datay.Share;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Frog {
    private PlayCanvas game = null;
    private int x = 0;
    private int y = 0;
    protected int OnRoad = 0;
    private Image[] drawImg = null;
    private int[] RoadY = new int[]{311, 279, 244, 201, 165, 135, 100, 40};
    private int MyLives = 0;
    private final int vspeed;
    private final int MaxRoad;
    private int cnt = 0;
    public byte FrogState = 0;
    private final byte STAND;
    private final byte JUMP_UP;
    private final byte JUMP_DOWN = (byte)2;
    private final byte JUMP_LEFT = (byte)3;
    private final byte JUMP_RIGHT = (byte)4;
    private final byte DEAD = (byte)5;
    private final byte HIDE = (byte)6;
    private int Arrow = 0;
    private int Frame = 0;
    private long fluff = 0L;
    private long step = 100L;
    private short[][][] npcItem = new short[][][]{new short[][]{{0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {3, 0, 0}}, new short[][]{{0, 0, 0}, {4, 0, -11}}, new short[][]{{1, 0, 0}, {5, 0, 10}}, new short[][]{{2, 0, 0}, {6, -4, -4}}, new short[][]{{3, 0, 0}, {7, 4, -4}}, new short[][]{{8, 0, 0}}};
    private short[][] nDrawPos = new short[][]{{0, 17, 0, 18, 15}, {0, 0, 0, 16, 15}, {0, 36, 0, 18, 17, 4}, {0, 36, 0, 18, 17}, {0, 21, 16, 14, 21}, {0, 21, 16, 14, 21, 5}, {0, 36, 18, 22, 20, 4}, {0, 36, 18, 22, 20}, {0, 58, 0, 17, 20}};

    public Frog(PlayCanvas gameArg, int xArg, int roadnum) {
        this.vspeed = 10;
        this.MaxRoad = 7;
        this.STAND = 0;
        this.JUMP_UP = 1;
        this.game = gameArg;
        this.x = xArg;
        this.OnRoad = roadnum;
        this.y = this.RoadY[this.OnRoad];
        this.MyLives = 4;
        this.Arrow = 0;
        this.drawImg = new Image[1];
        this.drawImg[0] = Share.LoadImage("/frog.png");
    }

    public void Dead() {
        this.Frame = 0;
        this.cnt = 0;
        this.FrogState = (byte)5;
    }

    public void Hide() {
        this.Frame = 0;
        this.cnt = 0;
        this.FrogState = (byte)6;
    }

    public void SetLife(int newLife) {
        this.MyLives = newLife;
    }

    public int getLife() {
        return this.MyLives;
    }

    public int getHalf() {
        return 10;
    }

    public int getOnRoad() {
        return this.OnRoad;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void SetX(int newX) {
        this.x = newX;
        if (this.x < 13) {
            this.x += 10;
        }
        if (this.x > 223) {
            this.x -= 10;
        }
    }

    public void SetY(int newY) {
        this.y = newY;
    }

    public void Draw(Graphics g) {
        if (this.FrogState == 0) {
            this.DrawItem(g, this.FrogState, this.Arrow, this.x, this.y);
        } else if (this.FrogState == 1) {
            this.DrawItem(g, this.FrogState, this.Frame, this.x, this.y);
        } else if (this.FrogState == 2) {
            this.DrawItem(g, this.FrogState, this.Frame, this.x, this.y);
        } else if (this.FrogState == 3) {
            this.DrawItem(g, this.FrogState, this.Frame, this.x, this.y);
        } else if (this.FrogState == 4) {
            this.DrawItem(g, this.FrogState, this.Frame, this.x, this.y);
        } else if (this.FrogState == 5) {
            this.DrawItem(g, this.FrogState, 0, this.x, this.y);
        }
    }

    public boolean CheckState() {
        return this.FrogState != 5 && this.FrogState != 6;
    }

    public void MoveLeft() {
        if (this.FrogState == 0) {
            this.Arrow = 2;
            this.Frame = 0;
            this.FrogState = (byte)3;
        }
    }

    public void MoveRight() {
        if (this.FrogState == 0) {
            this.Frame = 0;
            this.Arrow = 3;
            this.FrogState = (byte)4;
        }
    }

    public void MoveUp() {
        if (this.FrogState == 0) {
            this.Frame = 0;
            this.Arrow = 0;
            this.FrogState = 1;
        }
    }

    public void MoveDown() {
        if (this.FrogState == 0) {
            this.Frame = 0;
            this.Arrow = 1;
            this.FrogState = (byte)2;
        }
    }

    public void Cycle(long deltaMS) {
        long ticks = (deltaMS + this.fluff) / this.step;
        this.fluff += deltaMS - ticks * this.step;
        if (ticks > 0L && this.FrogState != 0) {
            if (this.FrogState == 1) {
                if (this.Frame < 1) {
                    ++this.Frame;
                } else {
                    if (this.OnRoad < 7) {
                        ++this.OnRoad;
                    }
                    this.SetY(this.RoadY[this.OnRoad]);
                    this.Frame = 0;
                    this.FrogState = 0;
                }
            } else if (this.FrogState == 2) {
                if (this.Frame < 1) {
                    ++this.Frame;
                } else {
                    if (this.OnRoad > 0) {
                        --this.OnRoad;
                    }
                    this.SetY(this.RoadY[this.OnRoad]);
                    this.Frame = 0;
                    this.FrogState = 0;
                }
            } else if (this.FrogState == 3) {
                if (this.Frame < 1) {
                    ++this.Frame;
                } else {
                    this.SetX(this.getX() - 10);
                    this.Frame = 0;
                    this.FrogState = 0;
                }
            } else if (this.FrogState == 4) {
                if (this.Frame < 1) {
                    ++this.Frame;
                } else {
                    this.SetX(this.getX() + 10);
                    this.Frame = 0;
                    this.FrogState = 0;
                }
            } else if (this.FrogState == 5 || this.FrogState == 6) {
                ++this.cnt;
                if (this.cnt > 10) {
                    this.Frame = 0;
                    this.cnt = 0;
                    this.OnRoad = 0;
                    this.SetY(this.RoadY[this.OnRoad]);
                    this.SetX(123);
                    this.Arrow = 0;
                    --this.MyLives;
                    if (this.MyLives >= 0) {
                        this.FrogState = 0;
                    }
                }
            }
        }
    }

    public void init() {
        this.Frame = 0;
        this.cnt = 0;
        this.OnRoad = 0;
        this.SetY(this.RoadY[this.OnRoad]);
        this.SetX(123);
        this.Arrow = 0;
        this.FrogState = 0;
    }

    private void DrawItem(Graphics g, int state, int frame, int x, int y) {
        int picnum = this.npcItem[state][frame].length / 3;
        for (int i = 0; i < picnum; ++i) {
            int temp = i * 3;
            int tempx = x + this.npcItem[state][frame][temp + 1];
            int tempy = y + this.npcItem[state][frame][temp + 2];
            short width = this.nDrawPos[this.npcItem[state][frame][temp]][3];
            short height = this.nDrawPos[this.npcItem[state][frame][temp]][4];
            short startx = this.nDrawPos[this.npcItem[state][frame][temp]][1];
            short starty = this.nDrawPos[this.npcItem[state][frame][temp]][2];
            short type = 0;
            if (this.nDrawPos[this.npcItem[state][frame][temp]].length > 5) {
                type = this.nDrawPos[this.npcItem[state][frame][temp]][5];
                Share.SetClip(g, this.game.getWidth(), this.game.getHeight(), this.drawImg[this.nDrawPos[this.npcItem[state][frame][temp]][0]], tempx, tempy, width, height, startx, starty, 1, type);
                continue;
            }
            Share.SetClip(g, this.game.getWidth(), this.game.getHeight(), this.drawImg[this.nDrawPos[this.npcItem[state][frame][temp]][0]], tempx, tempy, width, height, startx, starty, 1);
        }
    }
}

