/*
 * Decompiled with CFR 0.152.
 */
package datay;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

public class MyRMS {
    public static RecordStore rs;

    public static final void CreateRMS(String name, boolean createIfNecessary) {
        try {
            rs = RecordStore.openRecordStore((String)name, (boolean)createIfNecessary);
        }
        catch (Exception e) {
            System.out.println("open " + name + " record store error: " + e.getMessage());
        }
    }

    public static final boolean CheckRMS() {
        boolean firstrun = true;
        try {
            firstrun = rs.getNumRecords() < 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return firstrun;
    }

    public static final void close() {
        try {
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception e) {
            System.out.println("close record store error: " + e.getMessage());
        }
    }

    public static final void save(int id, byte[] data) {
        int num = 0;
        try {
            num = rs.getNumRecords();
            if (id > num) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(id, data, 0, data.length);
            }
        }
        catch (Exception e) {
            System.out.println("add " + id + " record error: " + e.getMessage());
        }
    }

    public static final void save(int id, int[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int count = data.length;
        for (int i = 0; i < count; ++i) {
            try {
                dos.writeInt(data[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println("write data[" + i + "] int error: " + e.getMessage());
            }
        }
        byte[] newData = baos.toByteArray();
        MyRMS.save(id, newData);
    }

    public static final void load(int id, int[] newData) {
        byte[] data = MyRMS.load(id);
        if (data != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            int count = newData.length;
            for (int i = 0; i < count; ++i) {
                try {
                    newData[i] = dis.readInt();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("read data[" + i + "] int error: " + e.getMessage());
                }
            }
        }
    }

    public static final byte[] load(int id) {
        byte[] data = null;
        try {
            data = rs.getRecord(id);
        }
        catch (Exception e) {
            System.out.println("get record byte[] error: " + e.getMessage());
        }
        return data;
    }
}

