/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

public class RMSData {
    public static final String GameName = "ultramanftg_v2";
    public static final int DataLen = 56;
    public static final int RMS_msnMax = 4;
    public static final int RMS_mission = 516;
    public static final int RMS_live = 708;
    public static final int REP_msnMax = 8;
    public static final int REP_mission = 3;
    public static final int REP_live = 3;
    private static final int Id = 1;
    private byte[] bytes = new byte[56];

    public RMSData() {
        this.LoadData();
    }

    public void close() {
        this.SaveFile();
        this.bytes = null;
    }

    public void SaveFile() {
        System.out.println("RMS ---- SaveFile ");
        RecordStore recordstore = null;
        try {
            recordstore = RecordStore.openRecordStore((String)GameName, (boolean)true);
            if (recordstore == null) {
                return;
            }
            recordstore.setRecord(1, this.bytes, 0, this.bytes.length);
            if (recordstore != null) {
                recordstore.closeRecordStore();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        recordstore = null;
        System.out.println("RMS ---- SaveFile END");
    }

    private void LoadData() {
        System.out.println("RMS ---- LoadData");
        RecordStore recordstore = null;
        try {
            recordstore = RecordStore.openRecordStore((String)GameName, (boolean)true);
            if (recordstore == null) {
                return;
            }
            if (recordstore.getNumRecords() == 0) {
                System.out.println("RMS ---- LoadData: FirstRun");
                this.bytes = null;
                this.bytes = new byte[56];
                recordstore.addRecord(this.bytes, 0, 56);
            } else {
                this.bytes = null;
                this.bytes = recordstore.getRecord(1);
            }
            if (recordstore != null) {
                recordstore.closeRecordStore();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        recordstore = null;
        System.out.println("RMS ---- LoadData END");
    }

    public byte readByte(int rmsitem) {
        int off = rmsitem >> 4;
        if (off < this.bytes.length) {
            return this.bytes[off];
        }
        return 0;
    }

    public int readValue(int rmsitem, int reindex) {
        int v = 0;
        int len = rmsitem & 0xF;
        int off = rmsitem >> 4;
        if ((off += reindex * len) >= 56) {
            return 0;
        }
        int b = off;
        for (int cnt = 0; b < 56 && cnt < len; ++cnt, ++b) {
            v |= (0xFF & this.bytes[b]) << (cnt << 3);
        }
        return v;
    }

    public void writeByte(byte value, int rmsitem) {
        int off = rmsitem >> 4;
        if (off < 56) {
            this.bytes[off] = value;
        }
    }

    public void writeValue(int value, int rmsitem, int reindex) {
        int len = rmsitem & 0xF;
        int off = rmsitem >> 4;
        if ((off += reindex * len) >= 56) {
            return;
        }
        int b = off;
        for (int cnt = 0; b < 56 && cnt < len; ++cnt, ++b) {
            this.bytes[b] = (byte)(0xFF & value);
            value >>= 8;
        }
    }
}

