/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class Bin {
    private static final int PltOffset = 41;
    private char fileName;
    public int numResource = 0;
    private int numRawImage = 0;
    private byte[] rawImageData;
    private int[] offsetRawImage;
    public Image imgImageTemp;
    private DataInputStream dis;
    private int idata;
    private short SizeCache = 0;
    private Image[] imgCache;
    private short[] idCache;
    private short[] cntCache;
    private byte[] pltCache;

    public Bin(char file, int numRaw, int cachesize) {
        this.fileName = file;
        this.numRawImage = numRaw;
        this.idata = 0;
        try {
            this.dis = new DataInputStream("".getClass().getResourceAsStream("/" + this.fileName));
            this.numResource = this.dis.readUnsignedByte();
            this.offsetRawImage = new int[this.numResource];
            for (int n = 0; n < this.numResource; ++n) {
                this.offsetRawImage[n] = this.dis.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.SizeCache = (short)cachesize;
        this.readRawImageData();
        this.idata = this.numRawImage;
    }

    public Bin(DataInputStream DIS, int numRaw, int cachesize) {
        this.dis = DIS;
        this.fileName = '\u0000';
        this.numRawImage = numRaw;
        this.idata = 0;
        try {
            this.numResource = this.dis.readUnsignedByte();
            this.offsetRawImage = new int[this.numResource];
            for (int n = 0; n < this.numResource; ++n) {
                this.offsetRawImage[n] = this.dis.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.SizeCache = (short)cachesize;
        this.readRawImageData();
        this.idata = this.numRawImage;
    }

    public void dispose() {
        this.clearCache();
        this.rawImageData = null;
        this.offsetRawImage = null;
    }

    private void readRawImageData() {
        if (this.numRawImage <= 0) {
            return;
        }
        try {
            int picdatasize = this.offsetRawImage[this.numRawImage];
            this.rawImageData = new byte[picdatasize];
            this.dis.read(this.rawImageData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.SizeCache > 0) {
            this.imgCache = new Image[this.SizeCache];
            this.idCache = new short[this.SizeCache];
            this.cntCache = new short[this.SizeCache];
            this.pltCache = new byte[this.SizeCache];
            this.clearCache();
        }
    }

    public DataInputStream open(int sourceid) {
        Bin.closeBinData(this.dis);
        try {
            this.dis = new DataInputStream("".getClass().getResourceAsStream("/" + this.fileName));
            this.dis.skip((this.numResource << 2) + 1 + this.offsetRawImage[sourceid]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bin.closeBinData(this.dis);
        }
        this.idata = sourceid;
        return this.dis;
    }

    public void close() {
        Bin.closeBinData(this.dis);
        this.dis = null;
    }

    public static void closeBinData(DataInputStream dis) {
        if (dis != null) {
            try {
                dis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dis = null;
    }

    public DataInputStream getStream() {
        ++this.idata;
        return this.dis;
    }

    public Image loadImageFromStream() {
        Image img = null;
        try {
            int picsize = this.offsetRawImage[this.idata + 1] - this.offsetRawImage[this.idata];
            byte[] tmp = new byte[picsize];
            this.dis.read(tmp);
            img = Image.createImage((byte[])tmp, (int)0, (int)tmp.length);
            Object var3_4 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.idata;
        return img;
    }

    public int getDataLength(int id) {
        return this.offsetRawImage[id + 1] - this.offsetRawImage[id];
    }

    public int getDataLength() {
        return this.offsetRawImage[this.idata + 1] - this.offsetRawImage[this.idata];
    }

    private short searchCache(int i, byte[] plt, int pltindex) {
        for (short c = 0; c < this.SizeCache; c = (short)(c + 1)) {
            if (this.idCache[c] != i || plt != null && this.pltCache[c] != pltindex) continue;
            return c;
        }
        short minc = 0;
        for (short c = 0; c < this.SizeCache; c = (short)(c + 1)) {
            if (this.cntCache[c] != 0) continue;
            minc = c;
            break;
        }
        this.imgCache[minc] = this.createRawTemp(i, plt, pltindex);
        this.idCache[minc] = (short)i;
        this.pltCache[minc] = (byte)pltindex;
        return minc;
    }

    public void clearCache() {
        this.imgImageTemp = null;
        for (short c = 0; c < this.SizeCache; c = (short)(c + 1)) {
            this.idCache[c] = -1;
            this.cntCache[c] = c;
            this.imgCache[c] = null;
            this.pltCache[c] = -1;
        }
    }

    public void loadRawTemp(int i) {
        this.loadRawTemp(i, null, -1);
    }

    public void loadRawTemp(int i, byte[] plt, int pltindex) {
        this.imgImageTemp = null;
        if (this.SizeCache > 0) {
            short icache = this.searchCache(i, plt, pltindex);
            short cnt = this.cntCache[icache];
            this.cntCache[icache] = this.SizeCache;
            for (short c = 0; c < this.SizeCache; c = (short)(c + 1)) {
                if (this.cntCache[c] <= cnt) continue;
                short s = c;
                this.cntCache[s] = (short)(this.cntCache[s] - 1);
            }
            this.imgImageTemp = this.imgCache[icache];
        } else {
            this.imgImageTemp = this.createRawTemp(i, plt, pltindex);
        }
    }

    public Image createRawTemp(int i, byte[] plt, int pltindex) {
        Image img = null;
        try {
            int offset = this.offsetRawImage[i];
            int datalen = this.offsetRawImage[i + 1] - this.offsetRawImage[i];
            if (datalen == 0) {
                return null;
            }
            if (plt != null) {
                int pltsize = plt[0] * 3 + 4;
                int pltstart = pltindex * pltsize + 1;
                System.arraycopy(plt, pltstart, this.rawImageData, offset + 41, pltsize);
            }
            img = Image.createImage((byte[])this.rawImageData, (int)offset, (int)datalen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public int getRawHeight(int i) {
        if (i >= this.numRawImage) {
            return 0;
        }
        int offset = this.offsetRawImage[i];
        return 0xFF & this.rawImageData[offset + 23];
    }

    public int getRawWidth(int i) {
        if (i >= this.numRawImage) {
            return 0;
        }
        int offset = this.offsetRawImage[i];
        return 0xFF & this.rawImageData[offset + 19];
    }
}

