/*
 * Decompiled with CFR 0.152.
 */
class Anim {
    int type;
    int actionFrame;
    int frameId;
    int frameTick;
    int frameDuration;
    int oldAction;
    int curAction;
    int newAction;
    static int aniEvent_flag;
    static byte aniEvent_mmtype;
    static short[] aniEvent_mmpar;
    static byte[] aniEvent_pColBoxData;

    Anim() {
    }

    void setFrame(int frame) {
        byte[] frameData = Actor.aniData[this.type].frames[frame];
        this.frameDuration = frameData[1] & 0xFF;
        this.frameTick = 0;
        aniEvent_flag |= 2;
        int i = 0;
        while (i < 4) {
            Anim.aniEvent_pColBoxData[i] = frameData[2 + i];
            ++i;
        }
        this.frameId = frame;
    }

    void build(int t, int newAct) {
        this.type = t;
        this.newAction = newAct;
        this.initNewAction(true);
    }

    void initNewAction(boolean bInitMModel) {
        AnimData data = Actor.aniData[this.type];
        byte[] mmParam = data.mmParam[this.newAction];
        int nbFrames = data.actions[this.newAction][0] & 0xFF;
        aniEvent_flag = 0;
        if (bInitMModel && (data.flag & 1) != 0) {
            aniEvent_flag |= 1;
            aniEvent_mmtype = (byte)((mmParam[0] & 0xF0) >> 4);
            int i = 0;
            while (i < 6) {
                if (i < mmParam.length - 1) {
                    byte param = mmParam[1 + i];
                    Anim.aniEvent_mmpar[i] = param < 0 ? (short)(-(-param << 5)) : (short)(param << 5);
                }
                ++i;
            }
        }
        this.actionFrame = 0;
        this.curAction = this.newAction;
        if (nbFrames > 0) {
            this.setFrame(data.actions[this.newAction][1] & 0xFF);
        } else {
            this.frameId = -1;
        }
    }

    void step(boolean bInitMModel) {
        ++this.frameTick;
        if (this.newAction != this.curAction) {
            this.initNewAction(bInitMModel);
        } else if (this.frameTick == this.frameDuration) {
            byte[] actionData = Actor.aniData[this.type].actions[this.newAction];
            ++this.actionFrame;
            if (this.actionFrame == (actionData[0] & 0xFF)) {
                this.actionFrame = 0;
            }
            if ((actionData[0] & 0xFF) > 0) {
                this.setFrame(actionData[this.actionFrame + 1] & 0xFF);
            }
        }
    }

    void draw(int nx, int ny, int nflag) {
        if (this.frameId < 0) {
            return;
        }
        int nsx = 0;
        int nsy = 0;
        int geflag = 0;
        AnimData data = Actor.aniData[this.type];
        byte[] frameData = data.frames[this.frameId];
        byte[] pModule = null;
        int frameOffset = 0;
        int nbSprite = frameData[0] & 0xFF;
        if (this.type == 0) {
            Game.raymanAnim = 0;
        }
        int i = 0;
        while (i < nbSprite) {
            if (i == nbSprite - 1 && this.type == 0 && Game.pFist[0].anim.curAction != 0 && Game.pRayman.anim.curAction != 10 && Game.pRayman.anim.curAction != 36) break;
            boolean flag = true;
            if (i == 0 && this.type == 0 && Game.pFist[1].anim.curAction != 0) {
                flag = false;
            }
            pModule = data.modules[frameData[6 + frameOffset] & 0x7F];
            if ((nflag & 1) != 0) {
                nsx = nx - frameData[6 + frameOffset + 1] - (pModule[2] & 0xFF);
                geflag = frameData[6 + frameOffset + 0] < 0 ? 0 : 16384;
            } else {
                nsx = nx + frameData[6 + frameOffset + 1];
                geflag = frameData[6 + frameOffset + 0] < 0 ? 16384 : 0;
            }
            nsy = ny + frameData[6 + frameOffset + 2];
            if (this.type == 0) {
                Game.raymanAnim = nsx;
            }
            if (flag) {
                GameMidlet.Instance_Game.drawImageEx(nsx, nsy, pModule[2] & 0xFF, pModule[3] & 0xFF, data.resID, pModule[0] & 0xFF, pModule[1] & 0xFF, geflag | nflag & 0xFFFF0000);
            }
            frameOffset += 3;
            ++i;
        }
    }

    static {
        aniEvent_mmpar = new short[6];
        aniEvent_pColBoxData = new byte[4];
    }
}

