/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KFont;
import kernel.KMath;
import kernel.KRes;

public final class KGraphics {
    private static Graphics s_g;
    private static int s_anchorMode;
    private static final KRes s_hackForDeprecated;
    public static KFont s_fontFG;
    public static KFont s_fontBG;
    public static boolean s_shadow;
    public static int s_shadowOffsetX;
    public static int s_shadowOffsetY;

    public static Graphics setGraphics(Graphics graphics) {
        Graphics graphics2 = s_g;
        s_g = graphics;
        return graphics2;
    }

    public static Graphics getGraphics() {
        return s_g;
    }

    public static void drawImage(Image image, int n, int n2) {
        KGraphics.s_hackForDeprecated.ro_ref = image;
        KGraphics.drawImage(s_hackForDeprecated, n, n2);
        KGraphics.s_hackForDeprecated.ro_ref = null;
    }

    public static void drawImage(KRes kRes, int n, int n2) {
        s_g.drawImage((Image)kRes.ro_ref, n, n2, s_anchorMode);
    }

    public static void drawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        KGraphics.s_hackForDeprecated.ro_ref = image;
        KGraphics.drawRegion(s_hackForDeprecated, n, n2, n3, n4, n5, n6, n7);
        KGraphics.s_hackForDeprecated.ro_ref = null;
    }

    public static void drawRegion(KRes kRes, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        kRes = (Image)kRes.ro_ref;
        s_g.drawRegion((Image)kRes, n, n2, n3, n4, n5, n6, n7, s_anchorMode);
    }

    public static final void png_fixPaletteCRC(byte[] byArray, int n) {
        n = ((byArray[35] & 0xFF) << 8) + (byArray[36] & 0xFF);
        int n2 = KMath.crc32(1269336405, byArray, 41, n);
        n += 41;
        byArray[n++] = n2 >> 24;
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    public static Image createImage$512099a1(int n) {
        Image image = Image.createImage((int)1, (int)1);
        if (image != null && image.getWidth() == 1 && image.getHeight() == 1) {
            return image;
        }
        System.gc();
        image = Image.createImage((int)1, (int)1);
        if (image != null && image.getWidth() == 1 && image.getHeight() == 1) {
            return image;
        }
        return null;
    }

    public static Image createGradient$7db24bf5$761a86b2(int n, int n2) {
        return KGraphics.createGradient(n, n2, 0, true);
    }

    public static Image createGradient(int n, int n2, int n3, boolean bl) {
        if (n < 1) {
            n = 1;
        }
        int[] nArray = new int[n << 1];
        Image image = bl ? Image.createImage((int)8, (int)n) : Image.createImage((int)n, (int)8);
        if (image == null) {
            return null;
        }
        Graphics graphics = image.getGraphics();
        int n4 = n2 & 0xF80000;
        int n5 = n3 & 0xF80000;
        int n6 = n2 << 8 & 0xF80000;
        int n7 = n3 << 8 & 0xF80000;
        n2 = n2 << 16 & 0xF80000;
        n3 = n3 << 16 & 0xF80000;
        n5 = (n5 - n4) / n;
        n7 = (n7 - n6) / n;
        n3 = (n3 - n2) / n;
        int n8 = 0;
        while (n8 < n) {
            int n9;
            int n10 = n9 = n4 >> 16 << 16 | n6 >> 16 << 8 | n2 >> 16;
            if ((n8 & 1) == 0) {
                n9 += 263172;
            } else {
                n10 += 263172;
            }
            if (bl) {
                nArray[n8 << 1] = 0xFF000000 | n9;
                nArray[(n8 << 1) + 1] = 0xFF000000 | n10;
            } else {
                nArray[n8] = 0xFF000000 | n9;
                nArray[n8 + n] = 0xFF000000 | n10;
            }
            ++n8;
            n4 += n5;
            n6 += n7;
            n2 += n3;
        }
        if (bl) {
            graphics.drawRGB(nArray, 0, 2, 0, 0, 2, n, false);
            graphics.drawRGB(nArray, 0, 2, 2, 0, 2, n, false);
            graphics.drawRGB(nArray, 0, 2, 4, 0, 2, n, false);
            graphics.drawRGB(nArray, 0, 2, 6, 0, 2, n, false);
        } else {
            graphics.drawRGB(nArray, 0, n, 0, 0, n, 2, false);
            graphics.drawRGB(nArray, 0, n, 0, 2, n, 2, false);
            graphics.drawRGB(nArray, 0, n, 0, 4, n, 2, false);
            graphics.drawRGB(nArray, 0, n, 0, 6, n, 2, false);
        }
        return image;
    }

    public static int textWidth(char[] cArray, int n, int n2) {
        int n3;
        int n4 = s_fontFG.textWidth(cArray, n, n2);
        if (s_shadow && (n3 = s_fontBG.textWidth(cArray, n, n2) + s_shadowOffsetX) > n4) {
            n4 = n3;
        }
        return n4;
    }

    public static int textHeight() {
        return KGraphics.s_fontFG.m_height;
    }

    public static void drawText(char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            return;
        }
        if (s_shadow) {
            KGraphics.drawTextNoEffect(s_fontBG, cArray, n, n2, n3 + s_shadowOffsetX, n4 + s_shadowOffsetY);
        }
        KGraphics.drawTextNoEffect(s_fontFG, cArray, n, n2, n3, n4);
    }

    private static void drawTextNoEffect(KFont kFont, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n3;
        while (n2 > 0) {
            int n6 = cArray[n];
            switch (n6) {
                case 10: {
                    n3 = n5;
                    n4 += kFont.m_height;
                    break;
                }
                case 3: {
                    n6 = 32;
                    break;
                }
                case 173: {
                    if (n2 != 1 && cArray[n + 1] != '\n') break;
                    n6 = 45;
                }
            }
            byte by = kFont.m_metrics[(n6 &= 0xFF) + 256];
            if (by != 0) {
                byte by2 = kFont.m_metrics[n6 + 512];
                if (by2 > 0) {
                    byte by3 = kFont.m_metrics[n6];
                    byte by4 = kFont.m_metrics[n6 + 768];
                    int n7 = kFont.m_metrics[n6 + 1024] & 0xFF;
                    Image image = kFont.m_images[n6 >> kFont.selectionMask];
                    KGraphics.drawRegion(image, (int)by4, n7, (int)by, (int)by2, 0, n3, n4 + by3);
                    if (kFont.m_bold) {
                        KGraphics.drawRegion(image, (int)by4, n7, (int)by, (int)by2, 0, ++n3, n4 + by3);
                    }
                }
                n3 += by + 1;
            }
            ++n;
            --n2;
        }
    }

    public static void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        s_g.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    static {
        s_anchorMode = 20;
        s_hackForDeprecated = new KRes();
        (new int[1])[0] = -65536;
    }
}

