/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.HeapManager;
import javax.microedition.lcdui.Graphics;
import kernel.KCanvas;
import kernel.KFont;
import kernel.KGraphics;
import kernel.KRes;

public final class TextViewport {
    public KFont m_foregroundFont;
    public KFont m_foregroundFontSelected;
    public KFont m_foregroundFontInactive;
    private KFont m_backgroundFont;
    public boolean m_loopOnLastChoice = false;
    private boolean m_wrapLine = true;
    private byte m_justify = 0;
    public int m_x;
    public int m_y;
    public int m_width;
    public int m_height;
    public int m_interlineHeight = 1;
    public int m_currentChoice;
    public int m_currentLine;
    public int m_firstDisplayedChoice;
    public int m_nbLines;
    public int m_nbVisibleLines;
    public char[][] m_text;
    public boolean[] m_itemNotActive;
    private int[][] m_lines;
    private int[][] m_lengths;
    public int[][] m_widths;
    public int m_boldOffset = -1;
    public int m_boldLenght = -1;
    public TextViewport m_title;

    public TextViewport(KFont kFont, KFont kFont2, KFont kFont3, KFont kFont4, char[][] cArray, int n, int n2, int n3, int n4, boolean bl, byte by, int n5, boolean bl2) {
        if (kFont2 == null) {
            kFont2 = kFont;
        }
        if (kFont3 == null) {
            kFont3 = kFont;
        }
        this.m_interlineHeight = n5;
        this.recycle(kFont, kFont2, kFont3, kFont4, cArray, n, n2, n3, n4, bl, by, bl2);
    }

    public final void recycle(KFont kFont, KFont kFont2, KFont kFont3, KFont kFont4, char[][] cArray, int n, int n2, int n3, int n4, boolean bl, byte by, boolean bl2) {
        this.m_firstDisplayedChoice = 0;
        this.m_currentChoice = 0;
        this.m_currentLine = 0;
        this.m_nbLines = 0;
        this.m_boldOffset = -1;
        this.m_boldLenght = -1;
        if (kFont != null) {
            this.m_foregroundFont = kFont;
        }
        if (kFont2 != null) {
            this.m_foregroundFontSelected = kFont2;
        }
        if (kFont3 != null) {
            this.m_foregroundFontInactive = kFont3;
        }
        if (kFont4 != null) {
            this.m_backgroundFont = kFont4;
        }
        this.m_wrapLine = bl2;
        this.m_justify = by;
        this.m_x = n;
        this.m_y = n2;
        this.m_height = n4;
        this.m_width = n3;
        this.m_text = new char[cArray.length][];
        this.m_lines = new int[cArray.length][];
        this.m_lengths = new int[cArray.length][];
        this.m_widths = new int[cArray.length][];
        this.m_itemNotActive = new boolean[cArray.length];
        int n5 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n6 = this.refreshText(cArray[i], i);
            if (bl || n6 <= n5) continue;
            n5 = n6;
        }
        if (!bl && (bl2 || n5 < this.m_width)) {
            this.m_width = n5;
        }
        this.m_height = this.m_nbLines * this.m_foregroundFont.m_height + (this.m_nbLines - 1) * this.m_interlineHeight;
        if (this.m_height > n4) {
            this.m_height = n4;
        }
        int n7 = this.m_interlineHeight;
        n5 = this.m_height;
        KFont kFont5 = this.m_foregroundFont;
        int n8 = (n5 + n7) / (kFont5.m_height + n7);
        if (n8 < 1) {
            n8 = 1;
        }
        this.m_nbVisibleLines = n8;
        n7 = this.m_interlineHeight;
        n5 = this.m_nbVisibleLines;
        KFont kFont6 = this.m_foregroundFont;
        this.m_height = (n5 - 1) * n7 + n5 * kFont6.m_height;
        ++this.m_width;
    }

    public final int refreshText(char[] cArray, int n) {
        this.initTextRendering();
        int n2 = this.m_lines[n] == null ? 0 : this.m_lines[n].length;
        int n3 = 0;
        int n4 = 0;
        if (!this.m_wrapLine) {
            this.m_text[n] = cArray;
            this.m_lines[n] = new int[1];
            this.m_lengths[n] = new int[1];
            this.m_widths[n] = new int[1];
            this.m_lines[n][0] = 0;
            this.m_lengths[n][0] = this.m_text[n].length;
            this.m_widths[n][0] = this.m_foregroundFont.textWidth(this.m_text[n], this.m_lines[n][0], this.m_lengths[n][0]) - 1;
            n3 = this.m_widths[n][0];
        } else {
            int n5 = this.m_width;
            char[] cArray2 = cArray;
            KFont kFont = this.m_foregroundFont;
            int n6 = TextViewport.nextLine(kFont, cArray2, 0, n5);
            int n7 = 1;
            while (n6 >= 0) {
                ++n7;
                n6 = TextViewport.nextLine(kFont, cArray2, n6, n5);
            }
            int n8 = n7;
            this.m_text[n] = cArray;
            this.m_lines[n] = new int[n8];
            this.m_lengths[n] = new int[n8];
            this.m_widths[n] = new int[n8];
            for (int i = 0; i < n8; ++i) {
                int n9;
                this.m_lines[n][i] = n4;
                this.m_lengths[n][i] = (n4 = TextViewport.nextLine(this.m_foregroundFont, this.m_text[n], n4, this.m_width)) >= 0 ? n4 - this.m_lines[n][i] : this.m_text[n].length - this.m_lines[n][i];
                for (n9 = this.m_lengths[n][i]; n9 > 0 && this.m_text[n][this.m_lines[n][i] + n9 - 1] <= ' '; --n9) {
                }
                this.m_lengths[n][i] = n9;
                this.m_widths[n][i] = this.m_foregroundFont.textWidth(this.m_text[n], this.m_lines[n][i], this.m_lengths[n][i]) - 1;
                if (this.m_widths[n][i] <= n3) continue;
                n3 = this.m_widths[n][i];
            }
        }
        this.m_nbLines += this.m_lines[n].length - n2;
        return n3;
    }

    public final boolean scrollTextDown(int n) {
        if (n > 0 && n < this.m_nbLines) {
            this.m_currentLine += n;
        }
        return this.m_currentLine == this.m_nbLines - this.m_nbVisibleLines;
    }

    public final boolean scrollChoiceUp() {
        boolean bl = this.isTextScrollableUp();
        if (bl && this.m_currentLine > 0) {
            --this.m_currentLine;
        }
        return bl;
    }

    public final boolean scrollChoiceDown() {
        boolean bl = this.isTextScrollableDown();
        if (bl) {
            if (this.m_currentLine < this.m_lines[this.m_firstDisplayedChoice].length - 1) {
                ++this.m_currentLine;
            } else {
                ++this.m_firstDisplayedChoice;
                this.m_currentLine = 0;
            }
        }
        return bl;
    }

    public final boolean gotoNextChoice() {
        do {
            if (this.isChoiceScrollableDown()) {
                ++this.m_currentChoice;
                int n = this.m_lines[this.m_firstDisplayedChoice].length - this.m_currentLine;
                for (int i = this.m_firstDisplayedChoice + 1; i < this.m_currentChoice; ++i) {
                    n += this.m_lines[i].length;
                }
                if (this.m_nbVisibleLines - n != 0) continue;
                if (this.m_currentLine < this.m_lines[this.m_firstDisplayedChoice].length - 1) {
                    ++this.m_currentLine;
                    continue;
                }
                ++this.m_firstDisplayedChoice;
                this.m_currentLine = 0;
                continue;
            }
            if (!this.m_loopOnLastChoice) continue;
            this.m_firstDisplayedChoice = 0;
            this.m_currentChoice = 0;
            this.m_currentLine = 0;
        } while (this.m_itemNotActive[this.m_currentChoice]);
        return this.isChoiceScrollableDown();
    }

    public final boolean gotoPreviousChoice() {
        do {
            int n = 0;
            if (this.isChoiceScrollableUp()) {
                --this.m_currentChoice;
                this.m_currentLine = 0;
                if (this.m_firstDisplayedChoice > this.m_currentChoice) {
                    this.m_firstDisplayedChoice = this.m_currentChoice;
                }
            } else if (this.m_loopOnLastChoice) {
                this.m_currentChoice = this.m_text.length - 1;
                n = 1;
            }
            if (n == 0) continue;
            this.m_firstDisplayedChoice = this.m_currentChoice;
            this.m_currentLine = 0;
            if (this.m_nbVisibleLines <= this.m_lines[this.m_currentChoice].length) continue;
            for (n = this.m_nbVisibleLines - this.m_lines[this.m_currentChoice].length; n > 0; n -= this.m_lines[this.m_firstDisplayedChoice].length) {
                --this.m_firstDisplayedChoice;
            }
            if (n >= 0) continue;
            this.m_currentLine = -n;
        } while (this.m_itemNotActive[this.m_currentChoice]);
        return this.isChoiceScrollableUp();
    }

    public final boolean isTextScrollableUp() {
        return this.m_firstDisplayedChoice == this.m_currentChoice && this.m_currentLine > 0;
    }

    public final boolean isTextScrollableDown() {
        int n = 0;
        if (this.m_firstDisplayedChoice == this.m_currentChoice) {
            n = this.m_currentLine < this.m_lines[this.m_currentChoice].length - this.m_nbVisibleLines ? 1 : 0;
        } else {
            n = this.m_lines[this.m_firstDisplayedChoice].length - this.m_currentLine;
            for (int i = this.m_firstDisplayedChoice + 1; i < this.m_currentChoice; ++i) {
                n += this.m_lines[i].length;
            }
            n = this.m_lines[this.m_currentChoice].length > this.m_nbVisibleLines - n ? 1 : 0;
        }
        return n != 0;
    }

    private boolean isChoiceScrollableUp() {
        boolean bl = false;
        int n = this.m_currentChoice;
        while (n > 0 && !bl) {
            bl = !this.m_itemNotActive[--n];
        }
        return bl;
    }

    private boolean isChoiceScrollableDown() {
        boolean bl = false;
        int n = this.m_currentChoice;
        while (n < this.m_text.length - 1 && !bl) {
            bl = !this.m_itemNotActive[++n];
        }
        return bl;
    }

    public final void initTextRendering() {
        if (this.m_foregroundFont == null) {
            this.m_foregroundFont = (KFont)((KRes)HeapManager.instance.get((String)"fontCutScene.fpak", (int)0xFFFFFF, (boolean)false)).ro_ref;
        }
        KGraphics.s_fontFG = this.m_foregroundFont;
        KGraphics.s_fontBG = this.m_backgroundFont;
        KGraphics.s_shadow = this.m_backgroundFont != null;
        KGraphics.s_shadowOffsetX = 1;
        KGraphics.s_shadowOffsetY = 0;
    }

    public final void initSelectTextRendering() {
        if (this.m_foregroundFontSelected == null) {
            this.m_foregroundFontSelected = (KFont)((KRes)HeapManager.instance.get((String)"fontCutScene.fpak", (int)0xFFFFFF, (boolean)false)).ro_ref;
        }
        KGraphics.s_fontFG = this.m_foregroundFontSelected;
        KGraphics.s_fontBG = this.m_backgroundFont;
        KGraphics.s_shadow = this.m_backgroundFont != null;
        KGraphics.s_shadowOffsetX = 1;
        KGraphics.s_shadowOffsetY = 0;
    }

    public final void initInactiveTextRendering() {
        if (this.m_foregroundFontInactive == null) {
            this.m_foregroundFontInactive = (KFont)((KRes)HeapManager.instance.get((String)"fontCutScene.fpak", (int)0xFFFFFF, (boolean)false)).ro_ref;
        }
        KGraphics.s_fontFG = this.m_foregroundFontInactive;
        KGraphics.s_fontBG = this.m_backgroundFont;
        KGraphics.s_shadow = this.m_backgroundFont != null;
        KGraphics.s_shadowOffsetX = 1;
        KGraphics.s_shadowOffsetY = 0;
    }

    public final void draw() {
        Graphics graphics = KGraphics.getGraphics();
        this.initTextRendering();
        int n = this.m_y;
        int n2 = 0;
        boolean bl = false;
        for (int i = this.m_firstDisplayedChoice; n2 < this.m_nbVisibleLines && i < this.m_text.length; ++i) {
            int n3;
            int n4 = i == this.m_currentChoice ? 1 : 0;
            int n5 = n3 = i == this.m_firstDisplayedChoice ? this.m_currentLine : 0;
            if (this.m_itemNotActive[i]) {
                this.initInactiveTextRendering();
            } else if (n4 != 0) {
                this.initSelectTextRendering();
            } else {
                this.initTextRendering();
            }
            while (n2 < this.m_nbVisibleLines && n3 < this.m_lines[i].length) {
                n4 = this.m_lines[i][n3];
                int n6 = this.m_lengths[i][n3];
                int n7 = this.m_widths[i][n3];
                int n8 = this.m_x;
                switch (this.m_justify) {
                    case 2: {
                        if (n7 >= this.m_width) break;
                        n8 += this.m_width - n7 >> 1;
                        break;
                    }
                    case 1: {
                        n8 += this.m_width - n7;
                    }
                }
                graphics.setClip(n8 - 1, n - 1, this.m_width + 2, this.m_foregroundFont.m_height + 2);
                if (!bl && this.m_boldOffset >= 0 && n3 == 0) {
                    bl = true;
                    KGraphics.drawText(this.m_text[i], this.m_boldOffset, this.m_boldLenght, n8 + 1, n);
                }
                KGraphics.drawText(this.m_text[i], n4, n6, n8, n);
                graphics.setClip(0, 0, KCanvas.m_width, KCanvas.m_height);
                ++n2;
                ++n3;
                n += this.m_foregroundFont.m_height + this.m_interlineHeight;
            }
        }
    }

    private static int nextLine(KFont kFont, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '\n') {
                ++n;
                break;
            }
            if ((n3 += kFont.charWidth(c)) > n2) {
                if (n4 < 0) break;
                n = n4;
                break;
            }
            ++n;
            if (c == ' ' || c == '-') {
                n4 = n;
                continue;
            }
            if (c != '\u00ad') continue;
            n4 = n;
        }
        while (n < cArray.length) {
            if (cArray[n] != ' ') {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

