/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import kernel.KFileBuffer;
import kernel.KRes;
import kernel.KResource;

public final class RBSound
implements PlayerListener {
    private KRes file;
    private boolean is_playing = false;
    private boolean is_prefetch = false;
    public static RBSound instance;
    boolean soundOff = true;
    private short songIdLoaded = (short)-1;
    Player s_playerSong;
    private VolumeControl playerCtrl;

    public final void setSong(short s) {
        if (this.songIdLoaded != s) {
            this.file = KResource.load(s, 10);
            this.songIdLoaded = s;
        }
    }

    public final void restartSong(int n) {
        if (this.soundOff) {
            return;
        }
        long l = System.currentTimeMillis();
        this.prefetch("audio/midi");
        l = System.currentTimeMillis() - l;
        if (n > 10) {
            if (l < (long)n) {
                l = (long)n - l;
            } else if (l % (long)n > (long)n) {
                l = l % (long)n - (long)n;
            }
            if (l > 10L) {
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {}
            }
        }
        this.Play();
    }

    private void prefetch(String string) {
        if (this.is_playing) {
            try {
                this.s_playerSong.stop();
            }
            catch (Exception exception) {}
        }
        try {
            this.s_playerSong = Manager.createPlayer((InputStream)((KFileBuffer)this.file.ro_ref).getInputStream(), (String)string);
            this.s_playerSong.addPlayerListener((PlayerListener)this);
            this.s_playerSong.realize();
            this.s_playerSong.prefetch();
            this.playerCtrl = (VolumeControl)this.s_playerSong.getControl("VolumeControl");
            this.is_prefetch = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void Play() {
        if (this.soundOff) {
            return;
        }
        if (this.is_playing) {
            return;
        }
        if (!this.is_prefetch) {
            this.prefetch("audio/midi");
        }
        try {
            this.playerCtrl.setLevel(75);
            this.s_playerSong.start();
            this.is_playing = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void Stop() {
        if (!this.is_playing) {
            return;
        }
        try {
            this.s_playerSong.stop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void playerUpdate(Player player, String string, Object object) {
        if (string.equals("stopped") || string.equals("stoppedAtTime") || string.equals("error") || string.equals("endOfMedia")) {
            player.deallocate();
            player.close();
            this.is_prefetch = false;
            this.is_playing = false;
        }
    }
}

