/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Random;
import kernel.KFileBuffer;
import kernel.KRes;
import kernel.KResource;

public final class KMath {
    private static short[] s_sin_table;
    private static int[] s_crc_table;

    public static int crc32(int n, byte[] byArray, int n2, int n3) {
        if (s_crc_table == null) {
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = -306674912;
            s_crc_table = new int[256];
            for (int i = 0; i < 256; ++i) {
                int n4 = i;
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                KMath.s_crc_table[i] = n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
            }
        }
        n3 += 41;
        while (n2 < n3) {
            n = s_crc_table[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        return n;
    }

    public static void loadSinTable(short s) {
        if (s_sin_table == null) {
            s_sin_table = new short[91];
            KRes kRes = KResource.load((short)0, 125);
            KFileBuffer kFileBuffer = (KFileBuffer)kRes.ro_ref;
            for (int i = 0; i < 91; ++i) {
                KMath.s_sin_table[i] = kFileBuffer.readShort();
            }
            KResource.releaseRes(kRes.ro_hHandle);
        }
    }

    public static void unloadSinTable() {
        s_sin_table = null;
    }

    public static int cos(int n) {
        if ((n = (n + 90) % 360) < 0) {
            n += 360;
        }
        if (n < 90) {
            return s_sin_table[n];
        }
        if (n < 180) {
            return s_sin_table[180 - n];
        }
        if (n < 270) {
            return -s_sin_table[n - 180];
        }
        return -s_sin_table[360 - n];
    }

    static {
        new Random();
    }
}

