/*
 * Decompiled with CFR 0.152.
 */
package animation;

import animation.Animation;
import javax.microedition.lcdui.Image;
import kernel.KGraphics;
import kernel.KRes;
import kernel.KResource;

public final class AnimInstance {
    private KRes m_animRes;
    private Animation m_anim;
    private int m_currentActionID;
    private int m_nextActionID = -1;
    private int m_frameIndex;
    private int m_pageID;
    private int m_endPage;
    private int m_animDir;
    private byte m_frameTime;
    private AnimInstance[] m_hotspotAnim;
    private boolean m_hotspotAutoReleased;
    private boolean m_facingUp;
    private boolean m_dirDependentX;
    private boolean m_dirDependentY;
    private byte[] m_imageStates;
    private boolean m_imageLoading;

    public AnimInstance(short s) {
        this.m_animRes = KResource.load(s, 4);
        this.m_anim = (Animation)this.m_animRes.ro_ref;
        this.m_imageStates = new byte[this.m_anim.m_images.length];
        this.m_dirDependentY = true;
        this.m_dirDependentX = true;
        this.m_facingUp = true;
        this.m_currentActionID = -1;
        if (this.m_anim.m_numHotspot >= 0) {
            this.m_hotspotAnim = new AnimInstance[this.m_anim.m_numHotspot];
        }
        this.m_hotspotAutoReleased = true;
        this.m_animDir = 1;
    }

    public final AnimInstance release() {
        if (this.m_animRes != null) {
            AnimInstance animInstance = this;
            if (animInstance.m_hotspotAnim != null) {
                for (int i = animInstance.m_hotspotAnim.length - 1; i >= 0; --i) {
                    if (animInstance.m_hotspotAnim[i] != null && animInstance.m_hotspotAnim[i].m_hotspotAutoReleased) {
                        animInstance.m_hotspotAnim[i].release();
                    }
                    animInstance.m_hotspotAnim[i] = null;
                }
            }
            this.releaseImages();
            KResource.releaseRes(this.m_animRes.ro_hHandle);
        }
        this.m_animRes = null;
        return null;
    }

    public final int getOffsetTop() {
        return this.m_anim.m_bbox[1 + (this.m_facingUp ? 0 : 4)];
    }

    public final int getOffsetBottom() {
        return this.m_anim.m_bbox[3 + (this.m_facingUp ? 0 : 4)];
    }

    public final int getLeft() {
        return 0 + this.m_anim.m_bbox[0];
    }

    public final int getRight() {
        return 0 + this.m_anim.m_bbox[2];
    }

    public final int getTop() {
        return 0 + this.m_anim.m_bbox[1 + (this.m_facingUp ? 0 : 4)];
    }

    public final int getBottom() {
        return 0 + this.m_anim.m_bbox[3 + (this.m_facingUp ? 0 : 4)];
    }

    private int getFrameIndex(int n) {
        return this.m_anim.m_frames[n][this.m_pageID << 1] & 0xFF;
    }

    public final void changeAction(int n, boolean bl, boolean n2) {
        boolean bl2 = false;
        AnimInstance animInstance = this;
        if (!animInstance.m_facingUp && animInstance.m_dirDependentY) {
            n |= 1;
        }
        if (n >= animInstance.m_anim.m_nFrame.length) {
            n = animInstance.m_anim.m_nFrame.length - 1;
        }
        if (n == animInstance.m_currentActionID) {
            return;
        }
        animInstance.m_nextActionID = n;
        animInstance.m_imageLoading = false;
        if (animInstance.m_anim.m_autoManageHeap) {
            n2 = animInstance.m_nextActionID;
            AnimInstance animInstance2 = animInstance;
            if (n2 != -1) {
                int n3;
                for (n3 = animInstance2.m_imageStates.length - 1; n3 >= 0; --n3) {
                    if (animInstance2.m_imageStates[n3] != 2) continue;
                    animInstance2.m_imageStates[n3] = 1;
                }
                n3 = animInstance2.m_pageID;
                animInstance2.m_pageID = animInstance2.m_anim.m_nFrame[n2] - 1;
                while (animInstance2.m_pageID >= 0) {
                    int n4;
                    int n5 = n4 = animInstance2.getFrameIndex(n2);
                    Object object = animInstance2.m_anim;
                    int n6 = 4;
                    if ((((Animation)object).m_encodingFlags & 2) != 0) {
                        n6 += 2;
                    }
                    if (((Animation)object).m_moduleUseShort) {
                        ++n6;
                    }
                    for (int i = ((Animation)object).m_sprites[n5].length / n6 - 1; i >= 0; --i) {
                        n6 = n4;
                        n5 = i;
                        object = animInstance2.m_anim;
                        if (Animation.s_transient_module == null) {
                            Animation.s_transient_module = new int[4];
                        }
                        Animation.s = ((Animation)object).m_sprites[n6];
                        n6 = 4;
                        if ((((Animation)object).m_encodingFlags & 2) != 0) {
                            n6 += 2;
                        }
                        if (((Animation)object).m_moduleUseShort) {
                            ++n6;
                        }
                        Animation.s_transient_module[0] = Animation.s[n5 *= n6];
                        Animation.s_transient_module[1] = 0;
                        Animation.s_transient_module[2] = 0;
                        if ((((Animation)object).m_encodingFlags & 2) != 0) {
                            Animation.s_transient_module[1] = (Animation.flag & 1) != 0 ? Animation.s_transient_module[1] - (Animation.s[n5 - 1 + 1] << 8 | Animation.s[n5 + 1] & 0xFF) : Animation.s_transient_module[1] + (Animation.s[++n5 - 1 + 1] << 8 | Animation.s[n5 + 1] & 0xFF);
                            Animation.s_transient_module[2] = (Animation.flag & 2) != 0 ? Animation.s_transient_module[2] - (Animation.s[n5 - 1 + 2] << 8 | Animation.s[n5 + 2] & 0xFF) : Animation.s_transient_module[2] + (Animation.s[++n5 - 1 + 2] << 8 | Animation.s[n5 + 2] & 0xFF);
                        } else {
                            Animation.s_transient_module[1] = (Animation.flag & 1) != 0 ? Animation.s_transient_module[1] - Animation.s[n5 + 1] : Animation.s_transient_module[1] + Animation.s[n5 + 1];
                            Animation.s_transient_module[2] = (Animation.flag & 2) != 0 ? Animation.s_transient_module[2] - Animation.s[n5 + 2] : Animation.s_transient_module[2] + Animation.s[n5 + 2];
                        }
                        if (((Animation)object).m_moduleUseShort) {
                            Animation.s_transient_module[3] = 0xFFFF & (Animation.s[++n5 - 1 + 3] << 8 | Animation.s[n5 + 3] & 0xFF);
                            Animation.s_transient_module[3] = Animation.s_transient_module[3] == 65535 ? -1 : Animation.s_transient_module[3] * 5;
                        } else {
                            Animation.s_transient_module[3] = Animation.s[n5 + 3] & 0xFF;
                            Animation.s_transient_module[3] = Animation.s_transient_module[3] == 255 ? -1 : Animation.s_transient_module[3] * 5;
                        }
                        object = Animation.s_transient_module;
                        if (Animation.s_transient_module[3] == -1) continue;
                        short s = animInstance2.m_anim.m_modules[object[3]];
                        if (animInstance2.m_imageStates[s] == 1) {
                            animInstance2.m_imageStates[s] = 2;
                            continue;
                        }
                        if (animInstance2.m_imageStates[s] != 0) continue;
                        animInstance2.m_imageStates[s] = 3;
                    }
                    --animInstance2.m_pageID;
                }
                animInstance2.m_pageID = n3;
            }
            animInstance2 = animInstance;
            for (n2 = animInstance2.m_imageStates.length - 1; n2 >= 0; --n2) {
                if (animInstance2.m_imageStates[n2] != 3) continue;
                animInstance2.m_imageStates[n2] = 2;
                animInstance2.m_anim.m_images[n2] = KResource.load(animInstance2.m_anim.m_imgLoadingList[n2], 1);
                animInstance2.m_imageLoading = true;
            }
        }
        if (!animInstance.m_imageLoading || animInstance.m_currentActionID == -1) {
            animInstance.m_nextActionID = -1;
            animInstance.m_currentActionID = n;
            animInstance.resetFrameCounter();
        }
    }

    private void resetFrameCounter() {
        if (this.m_animDir == 1) {
            this.m_endPage = this.m_anim.m_nFrame[this.m_currentActionID] - 1;
            this.m_pageID = 0;
        } else {
            this.m_endPage = 0;
            this.m_pageID = this.m_anim.m_nFrame[this.m_currentActionID] - 1;
        }
        this.m_frameIndex = this.getFrameIndex(this.m_currentActionID);
        this.m_frameTime = 0;
    }

    public final void updateAnimation() {
        if (!this.m_imageLoading) {
            this.m_frameTime = (byte)(this.m_frameTime + 1);
            if (this.m_frameTime < this.m_anim.m_frames[this.m_currentActionID][(this.m_pageID << 1) + 1]) {
                return;
            }
            if (this.m_pageID != this.m_endPage) {
                this.m_pageID += this.m_animDir;
                this.m_frameIndex = this.getFrameIndex(this.m_currentActionID);
            }
            this.m_frameTime = 0;
            return;
        }
        this.m_imageLoading = false;
        if (!this.m_imageLoading) {
            if (this.m_nextActionID == -1) {
                this.updateAnimation();
                return;
            }
            this.releaseUnusedImages();
            System.gc();
            this.m_currentActionID = this.m_nextActionID;
            this.resetFrameCounter();
            this.m_nextActionID = -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void draw(int var1_1, int var2_2, boolean var3_3, boolean var4_4) {
        var3_3 = this.m_dirDependentX != false ? var3_3 : false;
        var6_5 = this.m_hotspotAnim;
        var5_6 = this.m_frameIndex;
        this = this.m_anim;
        Animation.s = this.m_sprites[var5_6];
        var7_7 = 0;
        var8_8 = KGraphics.getGraphics().getClipX();
        var9_9 = KGraphics.getGraphics().getClipY();
        var10_10 = var8_8 + KGraphics.getGraphics().getClipWidth();
        var11_11 = var9_9 + KGraphics.getGraphics().getClipHeight();
        for (var12_12 = 0; var12_12 < Animation.s.length; var12_12 += 4) {
            block7: {
                Animation.flag = Animation.s[var12_12] & 255;
                Animation.flipXs = var3_3 ^ (Animation.flag & 1) != 0;
                Animation.flipYs = var4_4 ^ (Animation.flag & 2) != 0;
                Animation.rotate = (Animation.flag & 4) != 0;
                Animation.posX = var1_1;
                Animation.posY = var2_2;
                if ((this.m_encodingFlags & 2) != 0) {
                    Animation.posX = var3_3 ? (Animation.posX -= Animation.s[var12_12 - 1 + 1] << 8 | Animation.s[var12_12 + 1] & 255) : (Animation.posX += Animation.s[++var12_12 - 1 + 1] << 8 | Animation.s[var12_12 + 1] & 255);
                    Animation.posY = var4_4 ? (Animation.posY -= Animation.s[var12_12 - 1 + 2] << 8 | Animation.s[var12_12 + 2] & 255) : (Animation.posY += Animation.s[++var12_12 - 1 + 2] << 8 | Animation.s[var12_12 + 2] & 255);
                } else {
                    Animation.posX = var3_3 ? (Animation.posX -= Animation.s[var12_12 + 1]) : (Animation.posX += Animation.s[var12_12 + 1]);
                    Animation.posY = var4_4 ? (Animation.posY -= Animation.s[var12_12 + 2]) : (Animation.posY += Animation.s[var12_12 + 2]);
                }
                Animation.modID = this.m_moduleUseShort != false ? (Animation.s[++var12_12 - 1 + 3] << 8 | Animation.s[var12_12 + 3] & 255) * 5 : (Animation.s[var12_12 + 3] & 255) * 5;
                if (!(Animation.s[var12_12 + 3] != -1 || this.m_moduleUseShort && Animation.s[var12_12 - 1 + 3] != -1)) {
                    if (var6_5 != null && var7_7 < var6_5.length && var6_5[var7_7] != null) {
                        var6_5[var7_7].draw(Animation.posX, Animation.posY, Animation.flipXs, Animation.flipYs);
                        Animation.s = this.m_sprites[var5_6];
                    }
                    ++var7_7;
                    continue;
                }
                Animation.modW = this.m_modules[Animation.modID + 3];
                Animation.modH = this.m_modules[Animation.modID + 4];
                if (Animation.rotate) break block7;
                if ((Animation.posX -= Animation.flipXs != false ? Animation.modW : 0) + Animation.modW < var8_8 || Animation.posX + Animation.modW < 0 || (Animation.posY -= Animation.flipYs != false ? Animation.modH : 0) + Animation.modH < var9_9 || Animation.posY + Animation.modH < 0 || Animation.posX > var10_10 || Animation.posY > var11_11) continue;
                v0 = !Animation.flipXs && !Animation.flipYs ? 0 : (Animation.flipXs && !Animation.flipYs ? 2 : (!Animation.flipXs && Animation.flipYs ? 1 : 3));
                ** GOTO lbl43
            }
            if ((Animation.posX -= Animation.flipXs == false ? Animation.modH : 0) + Animation.modH < var8_8 || Animation.posX + Animation.modH < 0 || (Animation.posY -= Animation.flipYs != false ? Animation.modW : 0) + Animation.modW < var9_9 || Animation.posY + Animation.modW < 0 || Animation.posX > var10_10 || Animation.posY > var11_11) continue;
            if (Animation.flipYs) {
                Animation.dgflag = Animation.flipXs != false ? 6 : 7;
            } else {
                v0 = Animation.flipXs != false ? 4 : 5;
lbl43:
                // 2 sources

                Animation.dgflag = v0;
            }
            var13_13 = (Image)this.m_images[this.m_modules[Animation.modID]].ro_ref;
            if (var13_13 == null) break;
            Animation.modX = this.m_modules[Animation.modID + 1];
            Animation.modY = this.m_modules[Animation.modID + 2];
            KGraphics.drawRegion(var13_13, Animation.modX, Animation.modY, Animation.modW, Animation.modH, Animation.dgflag, Animation.posX, Animation.posY);
        }
    }

    private void releaseUnusedImages() {
        for (int i = this.m_imageStates.length - 1; i >= 0; --i) {
            if (this.m_imageStates[i] != 1) continue;
            KResource.releaseRes(this.m_anim.m_images[i].ro_hHandle);
            this.m_imageStates[i] = 0;
        }
    }

    private void releaseImages() {
        int n;
        if (this.m_anim.m_autoManageHeap) {
            for (n = this.m_imageStates.length - 1; n >= 0; --n) {
                if (this.m_imageStates[n] != 2) continue;
                this.m_imageStates[n] = 1;
            }
            this.releaseUnusedImages();
        } else {
            this.m_anim.releaseAllImages();
        }
        for (n = this.m_hotspotAnim.length - 1; n >= 0; --n) {
            if (this.m_hotspotAnim[n] == null || !this.m_hotspotAnim[n].m_hotspotAutoReleased) continue;
            this.m_hotspotAnim[n].releaseImages();
        }
    }
}

