/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import core.Game;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KGraphics;
import kernel.KSound;
import kernel.KUtils;

public final class KCanvas
extends Canvas
implements Runnable {
    public static int m_width;
    public static int m_height;
    private static byte width_height_sample;
    public static KCanvas s_instance;
    public static boolean s_threadIsRunning;
    private static boolean s_pauseRun;
    private static int UNIT_TIMER;
    private Image m_offscreen_image;
    private Graphics m_offscreen_graphics;
    private int elapsedTime;
    public static int m_actionCode;
    public static short m_keyPressed;
    public static int s_debugKeyCode;
    private boolean key_is_press;
    public static boolean s_gameIsRunning;
    public static boolean s_timeAjusted;
    public static boolean s_interrupted;
    private static boolean s_sound_was_enable;

    public KCanvas() {
        this.setFullScreenMode(true);
        s_instance = this;
        UNIT_TIMER = 60;
        m_width = this.getWidth();
        m_height = this.getHeight();
    }

    protected final void paint(Graphics graphics) {
        KUtils.updateElapsedMS();
        if (KUtils.s_elapsedTime > 500) {
            if (KUtils.s_elapsedTime > 3000) {
                s_interrupted = true;
            }
            KUtils.s_elapsedTime = 500;
            s_timeAjusted = true;
        }
        if (width_height_sample < 10) {
            m_width = (short)this.getWidth();
            short s = (short)(0 + this.getHeight());
            if (s > m_height) {
                m_height = s;
            }
            if ((s = (short)(0 + graphics.getClipHeight())) > m_height) {
                m_height = s;
            }
            width_height_sample = (byte)(width_height_sample + 1);
        }
        if (this.m_offscreen_graphics == null) {
            this.m_offscreen_image = Image.createImage((int)m_width, (int)m_height);
            this.m_offscreen_graphics = this.m_offscreen_image.getGraphics();
        }
        Graphics graphics2 = graphics;
        graphics = this.m_offscreen_graphics;
        KGraphics.setGraphics(graphics);
        graphics.setClip(0, 0, m_width, m_height);
        Game.m_instance.Frame(graphics);
        graphics2.drawImage(this.m_offscreen_image, 0, 0, 20);
    }

    public final void run() {
        while (s_threadIsRunning) {
            if (!s_pauseRun && !this.key_is_press) {
                Game.m_instance.Move();
                m_actionCode = 0;
                this.repaint();
                this.serviceRepaints();
            }
            this.elapsedTime = (int)((long)UNIT_TIMER - (System.currentTimeMillis() - KUtils.s_previousTime));
            if (this.elapsedTime > 50) {
                try {
                    Thread.sleep(this.elapsedTime);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.key_is_press = false;
            s_pauseRun = !this.isShown();
        }
        KUtils.NullifyMidlet();
    }

    public final void keyPressed(int n) {
        this.key_is_press = true;
        switch (n) {
            case 48: {
                m_keyPressed = 0;
                break;
            }
            case 49: {
                m_keyPressed = (short)128;
                break;
            }
            case 50: {
                m_actionCode = 1;
                break;
            }
            case 51: {
                m_keyPressed = (short)256;
                break;
            }
            case 52: {
                m_actionCode = 2;
                break;
            }
            case 53: {
                m_actionCode = 8;
                break;
            }
            case 54: {
                m_actionCode = 5;
                break;
            }
            case 55: {
                m_keyPressed = (short)512;
                break;
            }
            case 56: {
                m_actionCode = 6;
                break;
            }
            case 57: {
                m_keyPressed = (short)1024;
                break;
            }
            case 42: {
                m_keyPressed = Short.MIN_VALUE;
                break;
            }
            case 35: {
                m_keyPressed = 1;
                break;
            }
            case -1: 
            case 1: {
                m_actionCode = 1;
                break;
            }
            case -2: 
            case 2: {
                m_actionCode = 6;
                break;
            }
            case -3: 
            case 3: {
                m_actionCode = 2;
                break;
            }
            case -4: 
            case 4: {
                m_actionCode = 5;
                break;
            }
            case -5: 
            case 5: {
                m_actionCode = 8;
                break;
            }
            case -6: 
            case 6: {
                m_actionCode = -6;
                break;
            }
            case -7: 
            case 7: {
                m_actionCode = -7;
                break;
            }
            case -10: 
            case 10: {
                break;
            }
            case -8: 
            case 8: {
                m_actionCode = 97;
            }
        }
        switch (m_actionCode) {
            case 1: {
                m_keyPressed = (short)8;
                break;
            }
            case 6: {
                m_keyPressed = (short)16;
                break;
            }
            case 2: {
                m_keyPressed = (short)2;
                break;
            }
            case 5: {
                m_keyPressed = (short)4;
                break;
            }
            case 8: {
                m_keyPressed = (short)64;
            }
        }
        s_debugKeyCode = n;
    }

    private int SafeGetGameAction(int n) {
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {}
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public final void keyReleased(int n) {
        int n2 = this.SafeGetGameAction(n);
        if (m_keyPressed == 2 ? n2 == 2 : (m_keyPressed == 4 ? n2 == 5 : (m_keyPressed == 8 ? n2 == 1 : m_keyPressed != 16 || n2 == 6))) {
            m_keyPressed = 0;
        }
    }

    public static void GameRunning(boolean bl) {
        if (s_gameIsRunning != bl) {
            s_gameIsRunning = bl;
            if (s_gameIsRunning) {
                if (s_sound_was_enable) {
                    KSound.Enable();
                    return;
                }
            } else {
                s_sound_was_enable = KSound.s_enabled;
                if (s_sound_was_enable) {
                    KSound.Disable();
                }
            }
        }
    }

    protected final void hideNotify() {
        if (!s_interrupted) {
            s_interrupted = true;
            KCanvas.GameRunning(false);
        }
    }

    protected final void showNotify() {
        KCanvas.GameRunning(true);
    }

    static {
        s_instance = null;
        s_threadIsRunning = true;
        s_pauseRun = false;
        m_keyPressed = 0;
        s_gameIsRunning = false;
        s_timeAjusted = false;
        s_interrupted = false;
        s_sound_was_enable = false;
    }
}

