/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.DeviceImage;

public class Animator {
    private static final int INITIAL_ANIMATORS = 15;
    private static int handleCount;
    public static int[] numFrames;
    public static byte[][] frames;
    public static DeviceImage[][] frameImages;
    public static int[] frameIndex;
    public static int[] frame;
    public static int[] frameRate;
    public static int[] frameDelay;
    public static boolean[] allocated;

    public static int createAnimator() {
        if (handleCount == 0) {
            numFrames = new int[15];
            frames = new byte[15][];
            frameImages = new DeviceImage[15][];
            frameIndex = new int[15];
            frame = new int[15];
            frameRate = new int[15];
            frameDelay = new int[15];
            allocated = new boolean[15];
        }
        for (int i = 0; i < 15; ++i) {
            if (allocated[i]) continue;
            Animator.allocated[i] = true;
            ++handleCount;
            return i;
        }
        return -1;
    }

    public static void releaseResources() {
        handleCount = 0;
        numFrames = null;
        frames = null;
        frameImages = null;
        frameIndex = null;
        frame = null;
        frameRate = null;
        frameDelay = null;
        allocated = null;
    }

    public static void release(int n) {
        Animator.allocated[n] = false;
        --handleCount;
    }

    public static void interrupt(int n, byte[] byArray, int n2) {
        if (frames[n] == byArray) {
            return;
        }
        int n3 = frame[n];
        Animator.reset(n, byArray, n2);
        int n4 = byArray.length;
        while (--n4 >= 0) {
            if (n3 != byArray[n4]) continue;
            Animator.frameIndex[n] = n4;
            Animator.frame[n] = n3;
            break;
        }
    }

    public static void interrupt(int n, DeviceImage[] deviceImageArray, int n2) {
        if (deviceImageArray == frameImages[n]) {
            return;
        }
        Animator.reset(n, deviceImageArray, n2);
    }

    public static void reset(int n, int n2) {
        Animator.numFrames[n] = n2;
        Animator.frames[n] = null;
        Animator.frameIndex[n] = 0;
        Animator.frame[n] = 0;
        Animator.frameDelay[n] = 1;
        Animator.frameRate[n] = 1;
    }

    public static void reset(int n, DeviceImage[] deviceImageArray, int n2) {
        if (n == 7) {
            boolean bl = false;
        }
        Animator.reset(n, deviceImageArray.length);
        Animator.frameRate[n] = n2;
        Animator.frameDelay[n] = n2;
        Animator.frameImages[n] = deviceImageArray;
    }

    public static void reset(int n, DeviceImage[] deviceImageArray) {
        if (n == 7) {
            boolean bl = false;
        }
        Animator.reset(n, deviceImageArray.length);
        Animator.frameDelay[n] = 0;
        Animator.frameImages[n] = deviceImageArray;
    }

    public static void reset(int n, byte[] byArray) {
        Animator.reset(n, byArray, 1);
    }

    public static void reset(int n, byte[] byArray, int n2) {
        if (frames[n] == byArray) {
            return;
        }
        Animator.numFrames[n] = byArray.length;
        Animator.frames[n] = byArray;
        Animator.frameRate[n] = n2;
        Animator.frameIndex[n] = 0;
        Animator.frame[n] = frames[n][0];
        Animator.frameDelay[n] = n2;
    }

    public static void animate(int n) {
        int n2 = n;
        frameDelay[n2] = frameDelay[n2] - 1;
        if (frameDelay[n2] <= 0) {
            int n3 = n;
            frameIndex[n3] = frameIndex[n3] + 1;
            if (frameIndex[n] == numFrames[n]) {
                Animator.frameIndex[n] = 0;
            }
            Animator.frameDelay[n] = frameRate[n];
            int n4 = frameIndex[n];
            Animator.frame[n] = frames[n] == null ? n4 : frames[n][n4];
        }
    }

    public static void setFrame(int n, int n2) {
        Animator.frameIndex[n] = n2 %= numFrames[n];
        Animator.frame[n] = frames[n] == null ? n2 : frames[n][n2];
    }
}

