/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Animator;
import STH2P1_S40P1.Constants;
import STH2P1_S40P1.Debug;
import STH2P1_S40P1.Device;
import STH2P1_S40P1.DeviceConstants;
import STH2P1_S40P1.DeviceImage;
import STH2P1_S40P1.DeviceSound;
import STH2P1_S40P1.Engine;
import STH2P1_S40P1.GluGMGDemo;
import STH2P1_S40P1.ResourceMaster;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameWorld
implements DeviceConstants,
Debug {
    public static Engine engine;
    public static boolean isLoadingFinished;
    public static final int GS_START_GAME = 0;
    public static final int GS_START_LEVEL = 1;
    public static final int GS_PLAYING = 2;
    public static final int GS_LOST_A_LIFE = 3;
    public static final int GS_GAME_OVER = 4;
    public static final int GS_LEVEL_COMPLETE = 5;
    public static final int GS_ZONE_SCREEN = 6;
    public static int gameState;
    private static final int ZONE_ID_EMERALD_HILL = 0;
    private static final int ZONE_ID_CASINO_NIGHT = 1;
    private static final int ZONE_ID_HILL_TOP = 2;
    public static final int TILE_SIZE = 16;
    private static final int METATILE_TILES_WIDTH = 2;
    private static final int METATILE_TILES_HEIGHT = 1;
    private static final int METATILE_PIXELS_WIDTH = 32;
    private static final int METATILE_PIXELS_HEIGHT = 16;
    private static final int BLOCK_TILES_WIDTH_SHIFT = 3;
    private static final int BLOCK_TILES_HEIGHT_SHIFT = 3;
    private static final int BLOCK_METATILES_WIDTH = 4;
    private static final int BLOCK_METATILES_HEIGHT = 8;
    private static final int BLOCK_METATILES_WIDTH_SHIFT = 2;
    private static final int BLOCK_METATILES_SIZE_SHIFT = 5;
    private static final int BLOCK_PIXELS_WIDTH = 128;
    private static final int BLOCK_PIXELS_HEIGHT = 128;
    private static final int METATILE_HSHIFT = 5;
    private static final int METATILE_VSHIFT = 4;
    private static final int BLOCK_SHIFT = 7;
    private static DeviceImage[] tiles;
    private static DeviceImage treetop;
    private static short[] metaTiles;
    private static DeviceImage[] metatile_images;
    private static short[] blocks;
    private static short[] map;
    private static int actWidth;
    private static int actHeight;
    private static int maxTileX;
    private static int maxTileY;
    public static final int ZONE_BG_Y = 32;
    private static final int ZONE_BG_SCROLL_RX = 2;
    private static final int ZONE_BG_SCROLL_RY = 5;
    private static final int[][] COLORS_ZONES;
    private static final int[] MARBLE_ZONE_GROUND_LEVELS;
    private static final int MARBLE_ZONE_UNDERGROUND_COLOR = 0x222222;
    private static DeviceImage background;
    private static final int CAMERA_LOOK_UP = 28;
    private static final int CAMERA_LOOK_DOWN = 42;
    private static final int CAMERA_LOOK_SPEED = 3;
    private static final int CAMERA_JUMP_SLACK = 28;
    private static final int CAMERA_JUMP_RETURN_SPEED = 10;
    private static int camX;
    private static int camY;
    private static int camOy;
    private static int camAy;
    private static int camSlackOffsetY;
    public static int endCamX;
    public static int endCamY;
    public static int camLimitX;
    public static int camLimitY;
    private static final int ONE = 128;
    private static final int HALF = 64;
    private static final int TILE_LOGIC_WIDTH = 2048;
    private static final int TILE_LOGIC_HEIGHT = 2048;
    private static DeviceImage[][] img_sonic;
    private static int sonicAnimator;
    private static int sonicFrameControl;
    private static int plState;
    private static int plStateTicks;
    private static int plX;
    private static int plY;
    private static int plPrevX;
    private static int plPrevY;
    private static int plVelocity;
    private static int plVelX;
    private static int plVelY;
    private static int plFacing;
    private static boolean plSprung;
    public static boolean plPaused;
    public static boolean plShowVector;
    public static boolean plSetVector;
    private static int plPlatform;
    private static int obAlwaysUpdateIndex;
    private static int plPixelOy;
    private static final int PL_STATE_IDLE = 0;
    private static final int PL_STATE_IDLING = 1;
    private static final int PL_STATE_CROUCHING = 2;
    private static final int PL_STATE_LOOKING = 3;
    private static final int PL_STATE_RUNNING = 5;
    private static final int PL_STATE_ROLLING = 6;
    private static final int PL_STATE_FALLING = 7;
    private static final int PL_STATE_JUMPING = 8;
    private static final int PL_STATE_SPRUNG = 9;
    private static final int PL_STATE_HIT = 10;
    private static final int PL_STATE_DEATH = 11;
    private static final int PL_STATE_ENDOFLEVEL = 12;
    private static final int PL_STATE_DASH = 13;
    private static final int PL_STATE_FRUITING = 14;
    private static final int PL_STATE_LOOPING = 15;
    private static final int PL_NUM_STATES_WILL_JUMP = 7;
    private static final int[] SONIC_START_LOCATION;
    private static final int HIT_POSITION_BODY = 0;
    private static final int HIT_POSITION_FEET = 1;
    private static final int JUMP_DIR_LEFT = 0;
    private static final int JUMP_DIR_CENTRE = 1;
    private static final int JUMP_DIR_RIGHT = 2;
    private static final int HIT_NONE = -1;
    private static final int HIT_STOP = 0;
    private static final int HIT_LAND = 1;
    private static final int FACING_LEFT = -1;
    private static final int FACING_RIGHT = 1;
    public static final int SONIC_BOX_WIDTH = 16;
    public static final int SONIC_BOX_HEIGHT = 15;
    public static final int SONIC_OFFSET_X = -13;
    public static final int SONIC_OFFSET_Y = -24;
    public static final int SONIC_OFFSET_X_INSET = 4;
    public static final int SONIC_RADIUS = 9;
    private static final int SONIC_BOX_X1 = -9;
    private static final int SONIC_BOX_Y1 = -15;
    private static final int SONIC_BOX_X2 = 6;
    private static final int SONIC_BOX_Y2 = -1;
    private static final int SONIC_CENTER_OX = -1;
    private static final int SONIC_CENTER_OY = -8;
    private static final int SONIC_BOX_X1_WORLD = -1152;
    private static final int SONIC_BOX_X2_WORLD = 768;
    private static final int SONIC_BOX_Y1_WORLD = -1920;
    private static final int SONIC_BOX_Y2_WORLD = -128;
    private static final int SONIC_CENTER_OX_WORLD = -128;
    private static final int SONIC_CENTER_OY_WORLD = -1024;
    public static final int SONIC_STEP_UP = 6;
    public static final int PLATFORM_SONIC_STEP_UP = 9;
    private static int SONIC_PAUSED_SPEED;
    private static int SONIC_PHYS_INITIAL_AX;
    private static final int SONIC_PHYS_AX = 48;
    private static final int SONIC_PHYS_DX = 384;
    private static int SONIC_PHYS_MAX_SPEED;
    private static int SONIC_PHYS_MAX_DASH_SPEED;
    private static int SONIC_PHYS_MAX_SPRUNG_SPEED;
    private static final int SONIC_PHYS_JUMP_VX = 96;
    private static final int SONIC_PHYS_JUMP_VY = 1664;
    private static final int SONIC_PHYS_JUMP_BOOST_CUTOFF = 896;
    private static final int SONIC_PHYS_GRAVITY = 224;
    private static final int SONIC_PHYS_SPRING_VY_SMALL = 2200;
    private static final int SONIC_PHYS_SPRING_VY_BIG = 2750;
    private static final int SONIC_PHYS_SPRING_VY_VERY_BIG = 3300;
    private static final int SONIC_PHYS_SPRING_VX = 2816;
    private static final int SONIC_PHYS_BOUNCE_VY = 1664;
    private static final int SONIC_PHYS_BUMP_V = 832;
    private static final int SONIC_PHYS_FLIPPER_V = 2750;
    private static final int SONIC_PHYS_DESTROY_THRESHOLD = 256;
    private static final int SONIC_PHYS_DEATH_VY = 1360;
    private static final int SONIC_PHYS_HIT_VX = 512;
    private static final int SONIC_PHYS_HIT_VY = 1024;
    private static final int FRAMERATE_SONIC = 1;
    private static final int FRAMERATE_SONIC_IDLING = 4;
    private static final int FRAMERATE_SONIC_BALANCING = 3;
    private static final int TICKS_IDLING = 30;
    private static int plLives;
    private static int plRings;
    private static int plScore;
    private static boolean plScoreUpdated;
    private static int plComboPtr;
    public static long plTimeStartedMillis;
    private static long gameOverDisplayMillis;
    private static boolean plTimeOver;
    private static boolean plInvincible;
    private static int plInvincibilityTimer;
    private static final int INVINCIBILITY_DURATION = 70;
    private static boolean plSparkles;
    private static int plSparklesTimer;
    private static final int SPARKLES_DURATION = 350;
    private static boolean plBarrier;
    private static int levelCompleteTimeBonus;
    private static int levelCompleteRingBonus;
    private static int plSavePoint;
    private static long plSaveTimeMillis;
    private static boolean objectPaintFirst;
    private static final int MAX_TILES = 64;
    private static final byte TILE_OUT_OF_BOUNDS = -2;
    private static final byte TILE_EMPTY = -1;
    private static final byte TILE_BLOCK = 0;
    private static final byte TILE_FLOOR_0 = 1;
    private static final byte TILE_FLOOR_30L = 2;
    private static final byte TILE_FLOOR_45L = 3;
    private static final byte TILE_FLOOR_30R = 4;
    private static final byte TILE_FLOOR_45R = 5;
    private static final byte TILE_FLOOR_CURVETL = 6;
    private static final byte TILE_FLOOR_CURVEBL = 7;
    private static final byte TILE_FLOOR_CURVETR = 8;
    private static final byte TILE_FLOOR_CURVEBR = 9;
    private static final byte TILE_UNDERGROUND = 10;
    private static final byte TILE_FLOOR_CN_CURVETL = 11;
    private static final byte TILE_FLOOR_CN_CURVETR = 12;
    private static final int NUM_FLOOR_TYPES = 19;
    private static final byte[] FLOOR_NORMAL_X;
    private static final byte[] FLOOR_NORMAL_Y;
    private static final short[] FLOOR_ANGLE;
    private static byte[] tileTypes;
    private static byte[] tileFloorOffsets;
    private static final int TILE_Z1_BLOCK = 0;
    private static final int TILE_Z1_EDGE_L = 2;
    private static final int TILE_Z1_EDGE_R = 3;
    private static final int TILE_Z1_TUNNEL = 12;
    private static final int TILE_Z1_TREE_TOPLEFT = 44;
    private static final int TILE_Z1_TREE_BOTTOMLEFT = 45;
    private static final int TILE_Z1_TREE_TOPRIGHT = 46;
    private static final int TILE_Z1_TREE_BOTTOMRIGHT = 47;
    private static final int LAVA_TILE_1 = 38;
    private static final int LAVA_TILE_2 = 39;
    private static DeviceImage[][] img_commonObjects;
    private static DeviceImage[][] img_zoneObjects;
    private static short[] obBlockIndex;
    private static byte[] obBlockSize;
    private static byte[] obData;
    private static final int OB_DATA_TYPE = 0;
    private static final int OB_DATA_SUBTYPE = 1;
    private static final int OB_DATA_X = 2;
    private static final int OB_DATA_Y = 3;
    private static final int OB_DATA_STATE = 4;
    private static final int OB_DATA_VAR = 5;
    private static final int OB_DATA_BLOCK_X = 7;
    private static final int OB_DATA_BLOCK_Y = 8;
    private static final int OB_DATASIZE = 9;
    private static final int OB_DATASIZE_IN = 4;
    private static final int OB_ID_RINGS_H = 0;
    private static final int OB_ID_RINGS_V = 1;
    private static final int OB_ID_P_TV = 2;
    private static final int OB_ID_P_SPIKE_UP = 3;
    private static final int OB_ID_P_SPRING = 4;
    private static final int OB_ID_P_BRIDGE = 5;
    private static final int OB_ID_P_FALLING = 7;
    private static final int OB_ID_SAVE = 8;
    private static final int OB_ID_GOAL = 9;
    private static final int OB_ID_GENERATOR = 10;
    private static final int OB_ID_P_HORIZ_SPRING = 15;
    private static final int OB_ID_P_GH_VERTICAL = 23;
    private static final int OB_ID_P_GH_HORIZONTAL = 24;
    private static final int OB_ID_P_STATIC = 25;
    private static final int OB_ID_P_DIAGONAL_SPRING = 48;
    private static final int OB_ID_P_MINE_CART = 49;
    private static final int OB_ID_RINGS_TRIANGLE = 50;
    private static final int OB_ID_P_HT_HORIZONTAL = 51;
    private static final int OB_ID_P_HT_VERTICAL = 52;
    private static final int OB_ID_P_DINO_BACK = 53;
    private static final int OB_ID_P_CN_BUMPER = 54;
    private static final int OB_ID_P_HT_VERTICAL_TALL = 55;
    private static final int OB_ID_P_CN_VERTICAL_BOX = 56;
    private static final int OB_ID_P_CN_HORIZONTAL_BOX = 57;
    private static final int OB_ID_CN_CORNER_BUMPER = 58;
    private static final int OB_ID_P_CN_LIFT = 59;
    private static final int OB_ID_P_HT_MOVEABLE_MAP = 60;
    private static final int OB_ID_CN_FRUIT_MACHINE = 61;
    private static final int OB_ID_P_HT_LAVA = 62;
    private static final int OB_ID_P_CN_CONVEYOR_BELT = 63;
    private static final int OB_ID_P_CN_FLIPPER_LEFT = 64;
    private static final int OB_ID_P_CN_FLIPPER_RIGHT = 65;
    private static final int OB_ID_P_HT_FALLING = 66;
    private static final int OB_ID_LOOP_TRIGGER_BALL_RIGHT = 67;
    private static final int OB_ID_LOOP_OVERLAY = 68;
    private static final int OB_ID_LOOP_TRIGGER_BALL_LEFT = 69;
    private static final int OB_ID_LOOP_SWITCH_RIGHT = 70;
    private static final int OB_ID_LOOP_SWITCH_LEFT = 71;
    private static final int OB_ID_CURVE_SWITCH = 73;
    private static final int OB_TYPE_TV_RINGS = 0;
    private static final int OB_TYPE_TV_SPARKLES = 1;
    private static final int OB_TYPE_TV_BARRIER = 2;
    private static final int OB_TYPE_TV_LIFE = 3;
    private static final int OB_STATE_PASSIVE = 0;
    private static final int OB_STATE_ACTIVATED = 1;
    private static final int OB_STATE_DESTROYED = 2;
    private static final int OB_STATE_SPECIAL = 3;
    private static final int OB_STATE_SPECIAL_DELAY = 20;
    private static final int OB_TV_STATE_ICON_RISING = 3;
    private static final int OB_TV_STATE_ICON_PAUSED = 4;
    private static final int BLK_LOOP_OPEN_LEFT = 17;
    private static final int BLK_LOOP_OPEN_RIGHT = 60;
    private static final int BLK_LOOP_OPEN_LEFT_CN = 93;
    private static final int BLK_LOOP_OPEN_RIGHT_CN = 275;
    private static final int[] TV_BOUNCE_PX;
    private static final int TV_ICON_RISE_HEIGHT = 28;
    private static final int TV_ICON_PAUSE_TICKS = 20;
    private static int tvHeight;
    private static final int DESTRUCTABLE_SCENERY_SPEED_THRESHOLD = 768;
    private static final int DESTRUCTABLE_SCENERY_COLLISION_DX = 64;
    private static final int DESTRUCTABLE_SCENERY_DISPLACEMENT_X = 3;
    private static byte FLAME_WIDTH;
    private static byte FLAME_HEIGHT;
    private static final int OB_SPIKE_SPACING = 8;
    private static final int OB_SPIKE_DEFAULT_NUMBER = 3;
    private static final int OB_SPIKE_WIDTH = 4;
    private static final int OB_SPIKE_HEIGHT = 16;
    private static final int OB_CN_FRUIT_MACHINE_STATE_SPIN_FIRST = 10;
    private static final int OB_CN_FRUIT_MACHINE_STATE_SPIN_SECOND = 11;
    private static final int OB_CN_FRUIT_MACHINE_STATE_SPIN_THIRD = 12;
    private static final int OB_CN_FRUIT_MACHINE_STATE_REWARD = 13;
    private static final int OB_CN_FRUIT_MACHINE_STATE_SPUN = 14;
    private static final int OB_CN_FRUIT_MACHINE_FRUITS = 6;
    private static final int OB_CN_FRUIT_MACHINE_SPIN_RATE = 4;
    private static final int OB_CN_FRUIT_MACHINE_MIN_SPIN_TICKS = 8;
    private static final int OB_CN_FRUIT_MACHINE_MAX_SPIN_TICKS = 20;
    private static byte[] obFruitData;
    private static final int OB_CN_FRUIT_SONIC = 0;
    private static final int OB_CN_FRUIT_TAILS = 1;
    private static final int OB_CN_FRUIT_DR_ROBOTNIK = 2;
    private static final int OB_CN_FRUIT_JACKPOT = 3;
    private static final int OB_CN_FRUIT_RINGS = 4;
    private static final int OB_CN_FRUIT_BAR = 5;
    private static final int OB_CN_CONVEYOR_BELT_SPEED = -100;
    private static final int OB_CN_P_FLIPPER_SPEED = 100;
    private static final int OB_CN_P_FLIPPER_NORMAL = 30;
    private static final byte OB_CN_P_FLIPPER_COUNT = 4;
    private static DeviceImage spikeUp;
    private static DeviceImage spikeDown;
    private static DeviceImage spikeLeft;
    private static DeviceImage spikeRight;
    private static final int GH_BRIDGE_TLY = 0;
    private static final int GH_MOVING_TLY = 1;
    private static final int MZ_MOVING_TLY = 2;
    private static final int HT_MOVING_TLY = 3;
    private static final int HT_MOVING_TALL_TLY = 4;
    private static final int CN_LIFT_TLY = 5;
    private static final int HT_MOVEABLE_MAP_TLY = 6;
    private static final int CN_CONVEYOR_BELT_TLY = 7;
    private static final int HT_MOVEABLE_LAVA_TLY = 8;
    private static final int[][] PLATFORM_MAP_ZONES;
    private static final int[] PLATFORM_MAPS;
    private static final int NUM_PLATFORMS;
    private static short[][] platformMaps;
    private static byte[] platformWidths;
    private static byte[] platformHeights;
    private static final int PLATFORM_TYPE_BRIDGE = 0;
    private static final int PLATFORM_TYPE_FALLING = 1;
    private static final int PLATFORM_TYPE_EH_VERTICAL = 2;
    private static final int PLATFORM_TYPE_GH_HORIZONTAL = 3;
    private static final int PLATFORM_TYPE_MZ_HORIZONTAL = 4;
    private static final int PLATFORM_TYPE_STATIC = 5;
    private static final int PLATFORM_TYPE_PILLAR = 6;
    private static final int PLATFORM_TYPE_SPIKE_UP = 7;
    private static final int PLATFORM_TYPE_TILE_OBJECT = 8;
    private static final int PLATFORM_TYPE_HT_HORIZONTAL = 9;
    private static final int PLATFORM_TYPE_HT_VERTICAL = 10;
    private static final int PLATFORM_TYPE_MINE_CART = 11;
    private static final int PLATFORM_TYPE_SEESAW_LEFT = 12;
    private static final int PLATFORM_TYPE_SEESAW_LEVEL = 13;
    private static final int PLATFORM_TYPE_SEESAW_RIGHT = 14;
    private static final int PLATFORM_TYPE_HT_VERTICAL_TALL = 15;
    private static final int PLATFORM_TYPE_LIFT = 16;
    private static final int PLATFORM_TYPE_MOVEABLE_MAP = 17;
    private static final int PLATFORM_TYPE_MOVEABLE_LAVA = 18;
    private static final int PLATFORM_TYPE_CONVEYOR_BELT = 19;
    private static final int PLATFORM_TYPE_FLIPPER_LEFT = 20;
    private static final int PLATFORM_TYPE_FLIPPER_RIGHT = 21;
    private static final int PLATFORM_TYPE_HT_FALLING = 22;
    private static final int PLATFORM_TYPE_COUNT = 22;
    private static final int PLATFORM_BEHAVIOUR_STATIC = 0;
    private static final int PLATFORM_BEHAVIOUR_FALLING = 1;
    private static final int PLATFORM_BEHAVIOUR_VERTICAL = 2;
    private static final int PLATFORM_BEHAVIOUR_HORIZONTAL = 3;
    private static final int PLATFORM_BEHAVIOUR_SPIKE = 4;
    private static final int PLATFORM_BEHAVIOUR_DIAGONAL_COLLAPSING = 5;
    private static final int PLATFORM_BEHAVIOUR_LIFT = 6;
    private static final int PLATFORM_BEHAVIOUR_MOVEABLE_MAP = 7;
    private static final int PLATFORM_BEHAVIOUR_MOVEABLE_LAVA = 8;
    private static final int[] PLATFORM_TYPE_BEHAVIOURS;
    private static final int[] PLATFORM_TYPE_MAPS;
    private static final int[] PLATFORM_TYPE_WIDTHS;
    private static int[] platformData;
    private static final int PLATFORM_DATA_TYPE = 0;
    private static final int PLATFORM_DATA_STATE = 1;
    private static final int PLATFORM_DATA_VAR = 2;
    private static final int PLATFORM_DATA_X = 3;
    private static final int PLATFORM_DATA_Y = 4;
    private static final int PLATFORM_DATA_VX = 5;
    private static final int PLATFORM_DATA_VY = 6;
    private static final int PLATFORM_DATASIZE = 7;
    private static final int PLATFORM_STATE_OUTGOING = 0;
    private static final int PLATFORM_STATE_INCOMING = 1;
    private static final int SWINGING_PLATFORM_STATE_ANTICLOCKWISE = 0;
    private static final int SWINGING_PLATFORM_STATE_CLOCKWISE = 1;
    private static final int CHAINED_PLATFORM_STATE_DROPPING = 0;
    private static final int CHAINED_PLATFORM_STATE_WAITING = 1;
    private static final int CHAINED_PLATFORM_STATE_RETRACTING = 2;
    private static final int SPIKES_STATE_EXTENDING = 0;
    private static final int SPIKES_STATE_HOLDING_OUT = 1;
    private static final int SPIKES_STATE_RETRACTING = 2;
    private static final int SPIKES_STATE_HOLDING_IN = 3;
    private static final int SPIKES_HOLD_TICKS = 20;
    private static final int COLLAPSING_PLATFORM_STATE_INIT = 0;
    private static final int COLLAPSING_PLATFORM_STATE_HOLDING = 1;
    private static final int COLLAPSING_PLATFORM_STATE_COLLAPSING = 2;
    private static final int COLLAPSING_PLATFORM_HOLDING_TICKS = 5;
    private static final int COLLAPSE_PLATFORM_GRAVITY = 224;
    private static final int COLLAPSE_PLATFORM_LOSE_GRIP_THRESHOLD = 1344;
    private static final int FALLING_PLATFORM_GRAVITY = 224;
    private static final int FALLING_PLATFORM_LOSE_GRIP_THRESHOLD = 1344;
    private static final int MOVING_PLATFORM_AX = 32;
    private static final int MOVING_PLATFORM_MAX_VEL = 288;
    private static final int MOVING_PLATFORM_DX_DISTANCE = 9;
    private static final int MOVING_MAP_AX = 32;
    private static final int MOVING_MAP_MAX_VEL = 288;
    private static final int MOVING_MAP_DX_DISTANCE = 9;
    private static final int MOVING_LAVA_AX = 4;
    private static final int MOVING_LAVA_MAX_VEL = 24;
    private static final int MOVING_LAVA_DX_DISTANCE = 6;
    private static final int BURNING_PLATFORM_BURN_SPEED = 96;
    private static final int BURNING_PLATFORM_SAFE_DISTANCE = 4;
    private static final int PILLAR_HEIGHT = 72;
    private static final int MOVEABLE_MAP_HEIGHT = 48;
    private static DeviceImage pillarTop;
    private static DeviceImage pillarLeft;
    private static DeviceImage pillarRight;
    private static DeviceImage pillarBottom;
    private static DeviceImage weightBase;
    private static DeviceImage weightLink;
    private static DeviceImage weightAttachment;
    private static DeviceImage weightFarLeft;
    private static DeviceImage weightLeft;
    private static DeviceImage weightRight;
    private static DeviceImage weightFarRight;
    private static DeviceImage[] weightSegments;
    private static final int WEIGHT_PLATFORM_OFFSET = 4;
    private static int spikedPlatformWidth;
    private static int spikedPlatformLeftOffset;
    private static int spikedPlatformSpikeSpacing;
    private static final int[] SPIKED_PLATFORM_SEGMENT_REPS;
    private static final int[] SMALL_SPIKED_PLATFORM_SEGMENT_REPS;
    private static final int SPIKED_PLATFORM_SPIKES = 5;
    private static int smallSpikedPlatformWidth;
    private static int smallSpikedPlatformLeftOffset;
    private static int smallSpikedPlatformSpikeSpacing;
    private static final int CHAINED_PLATFORM_AX = 512;
    private static final int CHAINED_PLATFORM_MAX_VEL = 4096;
    private static final int CHAINED_PLATFORM_RETRACT_AX = 144;
    private static final int CHAINED_PLATFORM_RETRACT_MAX_VEL = 128;
    private static final int CHAINED_PLATFORM_WAIT_TICKS = 30;
    private static final int CHAINED_PLATFORM_RETRACT_AX_specialCaseForMarbleAct1 = 256;
    private static final int SPIKES_AX = 128;
    public static int[] movingPlatformDataPtr;
    private static DeviceImage[][] img_commonEnemies;
    private static DeviceImage[][] img_zoneEnemies;
    private static final int ENEMY_FISH = 1;
    private static final int ENEMY_ANIMAL = 4;
    private static final int ENEMY_WASP = 5;
    private static final int ENEMY_DINOSAUR_FACING_LEFT = 6;
    private static final int ENEMY_DINOSAUR_FACING_RIGHT = 7;
    private static final int ENEMY_SEESAW_RIGHT = 8;
    private static final int ENEMY_CN_CRAB = 9;
    private static final int ENEMY_SEESAW_LEFT = 10;
    private static final int ENEMY_DATA_TYPE = 0;
    private static final int ENEMY_DATA_GENERATOR_Y = 1;
    private static final int ENEMY_DATA_X = 2;
    private static final int ENEMY_DATA_Y = 3;
    private static final int ENEMY_DATA_VX = 4;
    private static final int ENEMY_DATA_VY = 5;
    private static final int ENEMY_DATA_STATE = 6;
    private static final int ENEMY_DATA_VAR1 = 7;
    private static final int ENEMY_DATA_VAR2 = 8;
    private static final int ENEMY_DATA_ANIMATOR = 9;
    private static final int ENEMY_DATA_GENERATOR_PTR = 10;
    private static final int ENEMY_DATA_GENERATOR_X = 11;
    private static final int ENEMY_DATASIZE = 12;
    private static int[] enemyData;
    private static final int ENEMY_STATE_MOVING = 0;
    private static final int BEETLE_STATE_TRUNDLING = 0;
    private static final int BEETLE_STATE_HOLDING = 1;
    private static final int BEETLE_HOLD_TICKS = 10;
    private static final int BEETLE_PHYS_VX = 300;
    private static final int FISH_PHYS_GRAVITY = 112;
    private static final int FISH_PHYS_VY = 1424;
    private static final int WASP_STATE_FLY = 0;
    private static final int WASP_STATE_HOLDING = 1;
    private static final int WASP_STATE_SHOOT = 2;
    private static final int WASP_PHYS_VX = 600;
    private static final int WASP_PHYS_GRAVITY = 101;
    private static final int WASP_X_LIMIT = 10000;
    private static final int WASP_HOLD_TICKS = 2;
    private static final int WASP_BULLET_VY = 336;
    private static final int CRAB_STATE_WALKING = 0;
    private static final int CRAB_STATE_HOLDING = 1;
    private static final int CRAB_STATE_FIRING = 4;
    private static final int CRAB_HOLD_TICKS = 14;
    private static final int CRAB_PHYS_VX = 176;
    private static final int CRAB_BULLET_VX = 216;
    private static final int CRAB_BULLET_VY = 848;
    private static final int CRAB_PHYS_GRAVITY = 101;
    private static final int ANIMAL_STATE_BREAK_FREE = 0;
    private static final int ANIMAL_STATE_HOPPING = 1;
    private static final int ANIMAL_PHYS_VX = 592;
    private static final int ANIMAL_PHYS_VY = 1280;
    private static final int ANIMAL_PHYS_GRAVITY = 224;
    private static final int DINOSAUR_STATE_READY = 0;
    private static final int DINOSAUR_STATE_SHOOT = 1;
    private static final int DINOSAUR_PHYS_AX = 13;
    private static final int DINOSAUR_X_LIMIT = 1024;
    private static final int DINOSAUR_BULLET_VX = 336;
    private static final int DINOSAUR_BULLET_VY = 168;
    private static final int DINOSAUR_BODY_PARTS = 4;
    private static final int DINOSOUR_BODY_OVERLAP = 1;
    private static final int SEESAW_STATE_RESTING = 0;
    private static final int SEESAW_STATE_FLYING_LEFT = 1;
    private static final int SEESAW_STATE_FLYING_RIGHT = 2;
    private static final int SEESAW_MINIMUM_VY = 2016;
    private static final int SEESAW_SPEED_INCREMENT = 224;
    private static final int SEESAW_MAXIMUM_VY = 3136;
    private static final int SEESAW_PHYS_GRAVITY = 224;
    private static final int SEESAW_LEFT_TO_X;
    private static final int SEESAW_RIGHT_FROM_X;
    private static final int CN_CRAB_STATE_WALKING = 0;
    private static final int CN_CRAB_STATE_HOLDING = 1;
    private static final int CN_CRAB_STATE_BLOCKING_UP = 2;
    private static final int CN_CRAB_STATE_BLOCKING_FRONT = 3;
    private static final int CN_CRAB_X_LIMIT = 4096;
    private static final int CN_CRAB_PHYS_VX = 128;
    private static final int CN_CRAB_HOLD_TICKS = 10;
    private static final int CN_CRAB_BLOCK_TICKS = 5;
    private static final int CN_CRAB_FRAME_RATE = 1;
    private static int[] eruptionData;
    private static final short ERUPTION_DATA_OFFSET = 0;
    private static final short ERUPTION_DATA_VELOCITY = 1;
    private static final int ERUPTION_DATASIZE = 2;
    private static final int ERUPTION_INITIAL_DELAY = 10;
    private static final int ERUPTION_SUBSEQUENT_DELAY = 10;
    private static final int ERUPTION_VELOCITY = 1344;
    private static final int ERUPTION_GRAVITY = 112;
    private static int[] fireballData;
    private static final int FIREBALL_DATA_COUNTDOWN = 0;
    private static final int FIREBALL_DATA_X = 1;
    private static final int FIREBALL_DATA_Y = 2;
    private static final int FIREBALL_DATASIZE = 3;
    private static final int FIREBALL_DELAY_TICKS = 20;
    private static final int FIREBALL_VEL = 336;
    private static int[] gushData;
    private static final int GUSH_DATA_COUNTDOWN = 0;
    private static final int GUSH_DATA_HEAD = 1;
    private static final int GUSH_DATA_VEL = 2;
    private static final int GUSH_DATASIZE = 3;
    private static final int GUSH_DELAY_TICKS = 20;
    private static final int GUSH_AX = 80;
    private static final int GUSH_DISTANCE = 23040;
    private static final int GUSH_LENGTH = 14720;
    private static int ringAnimator;
    private static final int OB_RING_RADIUS = 5;
    private static final int OB_RING_PIXEL_OX = 4;
    private static final int OB_RING_PIXEL_OY = 4;
    private static final int OB_RING_SPACING = 12;
    private static int tvAnimator;
    private static final int OB_BRIDGE_TILE_WIDTH = 8;
    private static final int OB_BRIDGE_NUM_OFFSETS = 3;
    private static final byte[] OB_BRIDGE_OFFSETS;
    private static final byte[] OB_BRIDGE_MAX_OFFSET;
    private static final byte[] bridgeOffsets;
    private static final int OB_ROCK_FRAME = 0;
    private static final int OB_ROCK_OFFSET = 5;
    private static final int OB_ROCK_WIDTH = 16;
    private static final int OB_SAVE_WIDTH = 8;
    private static final int OB_SAVE_HEIGHT = 26;
    private static boolean hiddenPassage;
    private static int hiddenPassage_leftX;
    private static int hiddenPassage_rightX;
    private static final int RINGS_DATA_X = 0;
    private static final int RINGS_DATA_Y = 1;
    private static final int RINGS_DATA_VX = 2;
    private static final int RINGS_DATA_VY = 3;
    private static final int RINGS_DATASIZE = 4;
    private static final int MAX_HIT_RINGS = 32;
    private static int[] ringsData;
    private static int bouncingRingsCount;
    private static int lastBouncingRingPtr;
    private static final int BOUNCING_RINGS_VX = 1024;
    private static final int BOUNCING_RINGS_PHYS_GRAVITY = 112;
    private static final int BOUNCING_RINGS_STAY_TICKS = 60;
    private static final int BOUNCING_RINGS_UNPICKUPABLE_TICKS = 15;
    private static int bouncingRingsTicks;
    private static int ringSize;
    private static DeviceImage[] img_numbers;
    private static DeviceImage img_lives;
    private static DeviceImage img_rings;
    private static DeviceImage img_hudpanel;
    private static DeviceImage img_loop_overlay;
    private static boolean fillStatusArea;
    private static final int TOPLEFT = 20;
    private static final int TOPRIGHT = 24;
    private static final int BOTTOMLEFT = 36;
    private static final int BOTTOMRIGHT = 40;
    private static boolean baseResourcesLoaded;
    private static int currentZone;
    private static int currentAct;
    private static int currentActState;
    public static boolean loading;
    private static final int LOAD_BASE = -1;
    private static final int LOAD_ZONE_TILESET = 0;
    private static final int LOAD_ZONE_PARALLAX = 1;
    private static final int LOAD_ZONE_META_TILES = 2;
    private static final int LOAD_ZONE_BLOCKS = 3;
    private static final int LOAD_ZONE_TILE_TYPES = 4;
    private static final int LOAD_ZONE_FLORR_OFFSETS = 5;
    private static final int LOAD_ZONE_PLATFORMS = 6;
    private static final int LOAD_ZONE_ENEMIES = 7;
    private static final int LOAD_ZONE_OBJECTS = 8;
    private static final int LOAD_ACT = 9;
    public static int levelLoadState;
    public static final int UNLOAD_FULL = 0;
    public static final int UNLOAD_ZONE = 1;
    public static final int UNLOAD_ACT = 2;
    private static boolean debugCoords;
    private static boolean debug_invincibility;
    public static int bgYOffset;
    private static final int WEIGHT = 0;
    private static final int SPIKED_PLATFORM = 1;
    private static final int SMALL_SPIKED_PLATFORM = 2;
    private static boolean hud_ringsUpdated;
    private static boolean hud_livesUpdated;
    private static boolean hud_timeUpdated;
    public static final int HUD_LABEL_LEFT = 2;
    public static final int HUD_LABEL_RIGHT = 126;
    public static final int HUD_LABEL_TOP = 2;
    public static final int HUD_LABEL_BOTTOM = 147;
    public static final int GAMEOVER_LEFT_COLUMN_LEFT_EDGE = 10;
    public static final int GAMEOVER_RIGHT_COLUMN_RIGHT_EDGE = 118;
    private static final byte[] loopOffsetY;
    private static final byte[] loopOffsetX;
    private static int fakeLoopIdx;
    private static int loopVelocity;
    private static int loopDir;
    private static int loopInitialX;
    private static int loopInitialY;
    private static short[][] loopID;
    private static final int HIT_TYPE_NORMAL = 0;
    private static final int HIT_TYPE_NO_INVINCIBILITY = 1;
    private static final int HIT_TYPE_NO_INVINCIBILITY_OR_SPARKLES = 2;
    private static final int HIT_TYPE_NO_PROTECTION = 3;
    private static final int HIT_TYPE_DEATH = 4;
    private static final int COLLISION_REPEAT = -2;
    private static final int COLLISION_NONE = -1;
    private static final int COLLISION_NORTH = 0;
    private static final int COLLISION_EAST = 1;
    private static final int COLLISION_SOUTH = 2;
    private static final int COLLISION_WEST = 3;
    private static final int DIRECTION_LEFT = 0;
    private static final int DIRECTION_RIGHT = 1;
    static int colx;
    static int coly;
    private static final int LOOP_THRESH_SLOW = 512;
    private static final int LOOP_THRESH_FAST = 1536;
    private static int bulletType;
    private static final int LOOK_UP = 0;
    private static final int LOOK_DOWN = 1;
    private static int debug_pausedSteppingSize_ptr;
    private static int[] PAUSED_STEPPING_SIZES;
    private static int debugJumping_plX;
    private static int debugJumping_plY;
    private static int debugJumping_plVelX;
    private static int debugJumping_plVelY;
    private static final short[] TIME_BONUS_TABLE;
    private static final short[] COMBO_SCORES;
    private static int oldPlScore;
    private static long lastHudUpdateTimeSecs;
    public static boolean whileLoading;
    private static long zoneScrTime;
    private static short[] lut;
    private static final int PI2 = 90;
    private static final int[] sinData;

    public static boolean loadLevel(int n, int n2, int n3) throws Exception {
        Engine.debugWrite("*** loadLevel(zone=" + n + ", act=" + n2 + ")");
        loading = true;
        Engine.loadingInterrupted = false;
        boolean bl = currentZone != n;
        boolean bl2 = currentZone != n || currentAct != n2;
        boolean bl3 = bl2 || currentActState == -1;
        currentZone = n;
        currentAct = n2;
        currentActState = n2;
        Engine.doRepaint();
        if (!baseResourcesLoaded) {
            GameWorld.loadBaseResources();
            baseResourcesLoaded = true;
        }
        if (bl) {
            GameWorld.loadZoneResources(n);
        }
        if (bl2) {
            GameWorld.loadActResources(n, n2);
        }
        if (bl3) {
            GameWorld.loadActObjects(n, n2);
        }
        Engine.debugWrite("end of loadLevel", true);
        loading = false;
        return true;
    }

    public static void loadBaseResources() throws Exception {
        Engine.debugWrite("*** loadBaseResources", true);
        img_lives = new DeviceImage(2, "lives");
        img_rings = new DeviceImage(3, "rings");
        img_numbers = new DeviceImage(4, "numbers").divide(11);
        img_sonic = Engine.loadSprite(8, 9, 40, -1);
        for (int i = 0; i < img_sonic.length; ++i) {
            for (int j = 0; j < img_sonic[i].length; ++j) {
                img_sonic[i][j].manipulateOffsets();
            }
        }
        Engine.debugWrite("object sprite", true);
        img_commonObjects = Engine.loadSprite(10, 11, 12, -1);
        Engine.debugWrite("object anims", true);
        spikeUp = img_commonObjects[0][0];
        spikeLeft = img_commonObjects[11][0];
        spikeRight = img_commonObjects[9][0];
        spikeDown = img_commonObjects[10][0];
        tvHeight = GameWorld.img_commonObjects[1][0].height;
        ringSize = GameWorld.img_commonObjects[6][0].height;
        Engine.debugWrite("common enemy sprite", true);
        img_commonEnemies = Engine.loadSprite(13, 14, 15, -1);
    }

    private static void loadZoneResources(int n) throws Exception {
        Engine.debugWrite("*** loadZoneResources(" + n + ")", true);
        isLoadingFinished = false;
        GameWorld.loadTileSet(n);
        img_loop_overlay = new DeviceImage(Constants.TILESET_LOOP_OVERLAYS[n], Constants.TILESET_RESOURCES_PALETTE[n], "loop");
        System.gc();
        Thread.yield();
        GameWorld.loadParallax(n);
        System.gc();
        Thread.yield();
        GameWorld.loadMetatiles(n);
        System.gc();
        Thread.yield();
        GameWorld.loadBlocks(n);
        System.gc();
        Thread.yield();
        GameWorld.loadTileTypes(n);
        System.gc();
        Thread.yield();
        GameWorld.loadFloorOffsets(n);
        System.gc();
        Thread.yield();
        GameWorld.loadPlatforms(n);
        System.gc();
        Thread.yield();
        GameWorld.loadEnemies(n);
        System.gc();
        Thread.yield();
        GameWorld.loadObjects(n);
    }

    private static void loadTileSet(int n) throws Exception {
        tiles = Engine.loadNonAnimatedSprite(16 + n, 19 + n, 41 + n, Constants.TILESET_RESOURCES_FIRSTIMG[n], Constants.TILESET_RESOURCES_PALETTE[n]);
        for (int i = 0; i < tiles.length; ++i) {
            tiles[i].manipulateOffsets();
        }
    }

    private static void loadParallax(int n) throws Exception {
        if (n == 0) {
            background = new DeviceImage(98, "Z" + n + "_BG_32X24_PNG");
        } else if (n == 2) {
            background = new DeviceImage(99, "Z" + n + "_BG_32X24_PNG");
        }
    }

    private static void loadMetatiles(int n) throws Exception {
        Engine.debugWrite("metatiles", true);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResourceAsBytes(65 + n)));
        int n2 = dataInputStream.readShort() << 1;
        metaTiles = new short[n2];
        for (int i = 0; i < n2; ++i) {
            GameWorld.metaTiles[i] = dataInputStream.readShort();
        }
    }

    private static void loadBlocks(int n) throws Exception {
        Engine.debugWrite("blocks", true);
        boolean bl = ResourceMaster.isCached(68 + n);
        blocks = ResourceMaster.getResourceAsShorts(68 + n);
    }

    private static void loadTileTypes(int n) throws Exception {
        Engine.debugWrite("tiletypes", true);
        tileTypes = ResourceMaster.getResourceAsBytes(71 + n);
    }

    private static void loadFloorOffsets(int n) throws Exception {
        Engine.debugWrite("floor offsets", true);
        tileFloorOffsets = ResourceMaster.getResourceAsBytes(74 + n);
    }

    private static void loadPlatforms(int n) throws Exception {
        Engine.debugWrite("platform maps", true);
        platformMaps = new short[NUM_PLATFORMS][];
        platformWidths = new byte[NUM_PLATFORMS];
        platformHeights = new byte[NUM_PLATFORMS];
        int[] nArray = PLATFORM_MAP_ZONES[currentZone];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = PLATFORM_MAPS[n2];
            if (n3 == -1) continue;
            DataInputStream dataInputStream = ResourceMaster.getResourceAsStream(n3);
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            GameWorld.platformWidths[n2] = by;
            GameWorld.platformHeights[n2] = by2;
            GameWorld.platformMaps[n2] = new short[by * by2];
            for (int j = 0; j < by * by2; ++j) {
                GameWorld.platformMaps[n2][j] = (short)dataInputStream.readUnsignedByte();
            }
        }
    }

    private static void loadEnemies(int n) throws Exception {
        img_zoneEnemies = Engine.loadSprite(22 + n, 25 + n, 28 + n, Constants.ZONE_ENEMIES_RESOURCES_FIRSTIMG[n]);
    }

    private static void loadObjects(int n) throws Exception {
        Engine.debugWrite("zoneObjects", true);
        if (n == 1) {
            img_zoneObjects = Engine.loadSprite(32, 35, 38, -1);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 4; ++j) {
                    GameWorld.img_zoneObjects[6 + i][j].frameWidth = (byte)16;
                    GameWorld.img_zoneObjects[6 + i][j].frameHeight = (byte)16;
                    img_zoneObjects[6 + i][j].manipulateOffsets();
                }
            }
            GameWorld.img_zoneObjects[7][2].offset_y = 0;
        }
    }

    private static void loadActResources(int n, int n2) throws Exception {
        Engine.debugWrite("*** loadActResources(" + n + "," + n2 + ")", true);
        short[] sArray = ResourceMaster.getResourceAsShorts(Constants.MAP_RESOURCES[n] + n2);
        actWidth = sArray[0];
        actHeight = sArray[1];
        int n3 = actWidth * actHeight;
        map = new short[n3];
        System.arraycopy(sArray, 2, map, 0, map.length);
        maxTileX = actWidth << 3;
        maxTileY = actHeight << 3;
        camLimitX = (actWidth << 7) - 128;
        camLimitY = (actHeight << 7) - 115;
    }

    private static void loadActObjects(int n, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Engine.debugWrite("*** loadActObjects(" + n + "," + n2 + ")");
        Animator.releaseResources();
        sonicAnimator = Animator.createAnimator();
        tvAnimator = Animator.createAnimator();
        Animator.reset(tvAnimator, 2);
        ringAnimator = Animator.createAnimator();
        Animator.reset(ringAnimator, img_commonObjects[6].length);
        Engine.debugWrite("obData", true);
        DataInputStream dataInputStream = ResourceMaster.getResourceAsStream(Constants.OBJECT_PLACEMENT_RESOURCES[n] + n2);
        int n9 = dataInputStream.readShort();
        obBlockIndex = new short[n9];
        obBlockSize = new byte[n9];
        int n10 = 0;
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = dataInputStream.read();
            GameWorld.obBlockIndex[n8] = (short)n10;
            GameWorld.obBlockSize[n8] = (byte)n7;
            n10 += n7 * 9;
        }
        n8 = dataInputStream.readShort();
        obData = new byte[n8 * 9];
        n10 = 0;
        n7 = 0;
        int n11 = 0;
        int n12 = obBlockSize[n11];
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            while (n12 == 0) {
                n12 = obBlockSize[++n11];
                ++n7;
            }
            dataInputStream.read(obData, n10, 4);
            n5 = obData[n10 + 0];
            n4 = n7 % actWidth;
            n3 = n7 / actWidth;
            GameWorld.obData[n10 + 7] = (byte)n4;
            GameWorld.obData[n10 + 8] = (byte)n3;
            byte by = 0;
            int n17 = 0;
            switch (obData[n10 + 0]) {
                case 10: {
                    int n18 = n13;
                    n13 = (byte)(n13 + 1);
                    n17 = n18;
                    break;
                }
                case 23: 
                case 24: 
                case 51: 
                case 52: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 60: 
                case 62: {
                    n15 = (byte)(n15 + 1);
                }
                case 3: 
                case 5: 
                case 7: 
                case 25: 
                case 49: 
                case 53: 
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    int n19 = n14;
                    n14 = (byte)(n14 + 1);
                    n17 = n19;
                    break;
                }
                case 61: {
                    int n20 = n16;
                    n16 = (byte)(n16 + 1);
                    n17 = n20;
                }
            }
            GameWorld.obData[n10 + 4] = by;
            GameWorld.obData[n10 + 5] = n17;
            n10 += 9;
            --n12;
        }
        Engine.debugWrite("enemyData", true);
        enemyData = new int[n13 * 12];
        for (n6 = 0; n6 < enemyData.length; n6 += 12) {
            GameWorld.enemyData[n6 + 0] = -1;
        }
        Engine.debugWrite("platformData", true);
        platformData = new int[n14 * 7];
        Vector<Integer> vector = new Vector<Integer>();
        for (n5 = 0; n5 < obData.length; n5 += 9) {
            n4 = obData[n5 + 5] * 7;
            n3 = -1;
            switch (obData[n5 + 0]) {
                case 5: {
                    n3 = 0;
                    break;
                }
                case 7: {
                    n3 = 1;
                    break;
                }
                case 66: {
                    n3 = 22;
                    break;
                }
                case 23: {
                    n3 = 2;
                    break;
                }
                case 52: {
                    n3 = 10;
                    break;
                }
                case 56: {
                    n3 = 6;
                    break;
                }
                case 59: {
                    n3 = 16;
                    break;
                }
                case 57: {
                    n3 = 4;
                    break;
                }
                case 55: {
                    n3 = 15;
                    break;
                }
                case 24: {
                    n3 = 3;
                    break;
                }
                case 51: {
                    n3 = 9;
                    break;
                }
                case 25: {
                    n3 = 5;
                    break;
                }
                case 3: {
                    n3 = 7;
                    break;
                }
                case 49: {
                    n3 = 11;
                    break;
                }
                case 53: {
                    n3 = 8;
                    break;
                }
                case 60: {
                    n3 = 17;
                    break;
                }
                case 62: {
                    n3 = 18;
                    break;
                }
                case 63: {
                    n3 = 19;
                    break;
                }
                case 64: {
                    n3 = 20;
                    break;
                }
                case 65: {
                    n3 = 21;
                }
            }
            if (n3 == -1) continue;
            GameWorld.platformData[n4 + 0] = n3;
            if (PLATFORM_TYPE_BEHAVIOURS[n3] != 2 && PLATFORM_TYPE_BEHAVIOURS[n3] != 3) continue;
            vector.addElement(new Integer(n5));
        }
        movingPlatformDataPtr = new int[vector.size()];
        for (n5 = 0; n5 < vector.size(); ++n5) {
            GameWorld.movingPlatformDataPtr[n5] = (Integer)vector.elementAt(n5);
        }
        vector = null;
        obFruitData = new byte[n16 * 3];
        for (n5 = 0; n5 < obFruitData.length; ++n5) {
            GameWorld.obFruitData[n5] = (byte)Engine.rndPositive(6);
        }
    }

    public static void unloadResources(int n) {
        Engine.debugWrite("*** unloadResources()");
        if (n == 0) {
            img_lives = null;
            img_rings = null;
            img_numbers = null;
            img_hudpanel = null;
            img_sonic = null;
            img_commonObjects = null;
            spikeUp = null;
            spikeLeft = null;
            spikeRight = null;
            spikeDown = null;
            img_commonEnemies = null;
            baseResourcesLoaded = false;
        }
        if (n <= 1) {
            tiles = null;
            background = null;
            metaTiles = null;
            blocks = null;
            tileTypes = null;
            tileFloorOffsets = null;
            img_zoneEnemies = null;
            img_zoneObjects = null;
            platformMaps = null;
            platformWidths = null;
            platformHeights = null;
            pillarTop = null;
            pillarLeft = null;
            pillarRight = null;
            pillarBottom = null;
            weightBase = null;
            weightLink = null;
            weightAttachment = null;
            weightFarLeft = null;
            weightLeft = null;
            weightRight = null;
            weightFarRight = null;
            weightSegments = null;
            currentZone = -1;
        }
        if (n <= 2) {
            map = null;
            currentAct = -1;
        }
        System.gc();
    }

    public static void abandonCurrentGame() {
        obBlockIndex = null;
        System.gc();
        obBlockSize = null;
        System.gc();
        obData = null;
        System.gc();
        enemyData = null;
        System.gc();
        platformData = null;
        System.gc();
        eruptionData = null;
        System.gc();
        fireballData = null;
        System.gc();
        gushData = null;
        System.gc();
        gameState = 0;
        currentActState = -1;
    }

    private static void resetLevel(boolean bl) {
        plState = 0;
        if (bl) {
            loading = true;
            try {
                GameWorld.loadActObjects(currentZone, currentAct);
            }
            catch (Exception exception) {
                Engine.debugWrite("ex in resetLevel: " + exception.toString());
            }
            loading = false;
            plTimeStartedMillis = System.currentTimeMillis();
        } else {
            plTimeStartedMillis = System.currentTimeMillis();
            plTimeOver = false;
            plSavePoint = 0;
            plSaveTimeMillis = 0L;
            GameWorld.sonicSetState(0);
            GameWorld.sonicLand();
        }
        GameWorld.sonicSetStartLocation();
        camSlackOffsetY = 0;
        camAy = 0;
        camOy = 0;
        GameWorld.targetCamera();
        GameWorld.repaintHud();
        Engine.clearDebug();
        Engine.resetKeyBuffers();
        Device.soundFunction(3, 1 + currentZone * 2);
    }

    public static void setZoneMusic() {
        DeviceSound.curSoundIndex = 1 + currentZone * 2;
    }

    public static void repaintHud() {
        fillStatusArea = true;
        hud_livesUpdated = true;
        hud_ringsUpdated = true;
        hud_timeUpdated = true;
        plScoreUpdated = true;
    }

    private static void sonicSetStartLocation() {
        GameWorld.sonicReset();
        if (plSavePoint == 0) {
            int n = currentZone * 2 + currentAct << 1;
            plX = SONIC_START_LOCATION[n];
            plY = SONIC_START_LOCATION[n + 1];
            plX <<= 1035;
            plY <<= 11;
            GameWorld.sonicSetState(0);
            GameWorld.sonicLand();
        } else {
            byte by = obData[plSavePoint + 7];
            byte by2 = obData[plSavePoint + 8];
            plX = (by << 7) + (obData[plSavePoint + 2] & 0xFF) << 7;
            plY = (by2 << 7) + (obData[plSavePoint + 3] & 0xFF) << 7;
            plPrevX = plX;
            plPrevY = (plY += GameWorld.img_commonObjects[4][0].height + 2 << 7) - 2048;
            GameWorld.sonicSetState(0);
        }
    }

    public static void resume(long l) {
        if (gameState == 2 || gameState == 6 || Engine.resSound) {
            Device.soundFunction(3, 1 + currentZone * 2 + 1);
            plTimeStartedMillis += l;
            GameWorld.repaintHud();
        }
    }

    public static void paint(Graphics graphics) {
        if (loading || gameState == 6) {
            Engine.paintZoneScreen(graphics, currentZone, currentAct + 1, false);
            return;
        }
        graphics.translate(0, 17);
        graphics.setClip(0, 0, 128, 115);
        GameWorld.paintBackground(graphics);
        GameWorld.paintTilemap(graphics);
        int n = (plX >> 7) - camX;
        int n2 = (plY >> 7) - camY;
        objectPaintFirst = true;
        GameWorld.paintObjects(graphics);
        GameWorld.paintEnemies(graphics);
        int n3 = Animator.frame[sonicAnimator];
        if (gameState == 2) {
            boolean bl = true;
            if (hiddenPassage) {
                if (hiddenPassage_rightX != 0) {
                    Engine.clipRect(graphics, 0, 0, hiddenPassage_rightX - camX, 115);
                } else if (hiddenPassage_leftX != 0) {
                    Engine.clipRect(graphics, hiddenPassage_leftX - camX, 0, 128, 115);
                } else {
                    hiddenPassage = false;
                    bl = false;
                }
            }
            if ((!plInvincible || (plInvincibilityTimer & 1) == 0) && bl) {
                Animator.frameImages[sonicAnimator][n3].drawImageClipStack(graphics, n + -13, n2 + plPixelOy + -24);
            }
            if (plBarrier && bl) {
                img_sonic[22][Engine.tick & 1].drawImageClipStack(graphics, n + -13, n2 + plPixelOy + -24);
            }
            if (plSparkles && bl) {
                img_sonic[21][Engine.tick & 1].drawImageClipStack(graphics, n + -13, n2 + plPixelOy + -24);
            }
            if (plState == 14) {
                short s = GameWorld.img_zoneObjects[3][0].height;
                int n4 = n - (GameWorld.img_zoneObjects[3][0].width >> 1) + -1;
                int n5 = n2 - (s * 5 >> 1) + -8;
                for (int i = 0; i < 3; ++i) {
                    img_zoneObjects[3][Engine.tick & 1].drawImageClipStack(graphics, n4, n5);
                    n5 += s << 1;
                }
            }
            if (hiddenPassage) {
                hiddenPassage = false;
                hiddenPassage_leftX = 0;
                hiddenPassage_rightX = 0;
                graphics.setClip(0, 0, 128, 115);
            }
        }
        if (bouncingRingsCount > 0) {
            GameWorld.paintBouncingRings(graphics);
        }
        objectPaintFirst = false;
        GameWorld.paintObjects(graphics);
        if (gameState == 4 || gameState == 5) {
            GameWorld.paintGameOver(graphics);
        }
        graphics.translate(0, -17);
        if (!fillStatusArea) {
            // empty if block
        }
        GameWorld.paintHud(graphics);
        fillStatusArea = false;
    }

    private static void paintDebug(Graphics graphics) {
        graphics.setClip(0, 0, 128, 149);
        int n = (plX >> 7) - camX;
        int n2 = (plY >> 7) - camY;
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(n, n2, n, n2);
        if (plShowVector) {
            GameWorld.paintWalkingDebug(graphics);
            GameWorld.paintFallingDebug(graphics);
            graphics.setColor(0xFFFFFF);
            graphics.drawLine(n, n2, n + (plVelX >> 7), n2 + (plVelY >> 7));
            graphics.setColor(0xFF00FF);
            graphics.drawLine(n, n2, n, n2);
        }
    }

    private static void paintBackground(Graphics graphics) {
        int n;
        boolean bl;
        boolean bl2 = currentZone == 0 || currentZone == 2;
        boolean bl3 = false;
        boolean bl4 = bl = bl2 && bl3;
        if (bl2 || bl) {
            int n2;
            n = GameWorld.background.width;
            short s = GameWorld.background.height;
            int n3 = camX >> 2;
            int n4 = 32 - (camY >> 5);
            if (n4 > 0) {
                graphics.setColor(COLORS_ZONES[currentZone][0]);
                graphics.fillRect(0, 0, 128, n4);
            }
            if ((n2 = n4 + s) >= 0) {
                for (int i = -n3; i < 128; i += n) {
                    background.drawImageAndRestoreClip(graphics, 0 + i, bgYOffset != 0 ? bgYOffset : n4);
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 < 115) {
                graphics.setColor(COLORS_ZONES[currentZone][1]);
                graphics.fillRect(0, n2, 128, 115 - n2);
            }
        }
        if (bl) {
            n = (MARBLE_ZONE_GROUND_LEVELS[currentAct] << 4) - camY;
            graphics.setColor(0x222222);
            graphics.fillRect(0, n, 128, 115 - n);
        }
        if (currentZone == 1) {
            graphics.setColor(COLORS_ZONES[currentZone][0]);
            graphics.fillRect(0, 0, 128, 115);
        }
    }

    private static void paintTilemap(Graphics graphics) {
        int n = camX >> 7;
        int n2 = camY >> 7;
        int n3 = camX >> 5;
        int n4 = camY >> 4;
        int n5 = n3 % 4;
        int n6 = n4 % 8;
        int n7 = camX + 128 - 1;
        int n8 = camY + 115 - 1;
        int n9 = n7 >> 7;
        int n10 = n8 >> 7;
        int n11 = n5 << 5;
        int n12 = n6 << 4;
        int n13 = n6 << 2;
        int n14 = -(camX % 32);
        int n15 = -(camY % 16);
        int n16 = n14;
        int n17 = n15;
        int n18 = n16 - (n5 << 5);
        int n19 = n17 - (n6 << 4);
        for (int i = n2; i <= n10; ++i) {
            int n20 = n5;
            int n21 = n11;
            int n22 = n18;
            int n23 = i * actWidth;
            for (int j = n; j <= n9; ++j) {
                int n24 = n23 + j;
                short s = map[n24];
                int n25 = (s << 5) + n13 + n20;
                int n26 = n17;
                for (int k = n6; k < 8; ++k) {
                    int n27 = n16;
                    for (int i2 = n20; i2 < 4; ++i2) {
                        int n28 = blocks[n25++];
                        if (n27 >= 128) {
                            n25 += 4 - i2 - 1;
                            break;
                        }
                        int n29 = -1;
                        int n30 = -1;
                        if ((n28 <<= 1) >= metaTiles.length || n28 + 1 >= metaTiles.length) continue;
                        n29 = metaTiles[n28];
                        n30 = metaTiles[n28 + 1];
                        graphics.setColor(0xFF0000);
                        try {
                            if (n29 != -1) {
                                tiles[n29].drawImageClipStack(graphics, n27, n26);
                            }
                            if (n30 != -1) {
                                tiles[n30].drawImageClipStack(graphics, n27 + 16, n26);
                            }
                        }
                        catch (Exception exception) {
                            Engine.debugWrite("error drawing tile " + tiles.length + " " + n29 + " " + n30);
                        }
                        n27 += 32;
                    }
                    if ((n26 += 16) >= 115) break;
                    n25 += n20;
                }
                n16 += 128 - n21;
                n21 = 0;
                n20 = 0;
                n22 += 128;
            }
            n16 = n14;
            n17 += 128 - n12;
            n13 = 0;
            n6 = 0;
            n12 = 0;
            n19 += 128;
        }
    }

    private static void paintObjects(Graphics graphics) {
        int n = camX >> 7;
        int n2 = camY >> 7;
        int n3 = endCamX >> 7;
        int n4 = endCamY >> 7;
        int n5 = -(camX % 128);
        int n6 = -(camY % 128);
        if (n > 0) {
            --n;
            n5 -= 128;
        }
        if (n2 > 0) {
            --n2;
            n6 -= 128;
        }
        if (n3 < actWidth - 1) {
            ++n3;
        }
        if (n4 < actHeight - 1) {
            ++n4;
        }
        int n7 = n5;
        for (int i = n2; i <= n4; ++i) {
            int n8 = i * actWidth + n;
            for (int j = n; j <= n3; ++j) {
                GameWorld.paintObjects(graphics, n8, n5, n6);
                n5 += 128;
                ++n8;
            }
            n5 = n7;
            n6 += 128;
        }
        if (obAlwaysUpdateIndex != -1) {
            GameWorld.paintObject(graphics, obAlwaysUpdateIndex, obData[obAlwaysUpdateIndex + 7] * 128 - camX, obData[obAlwaysUpdateIndex + 8] * 128 - camY);
        }
    }

    private static void paintObjects(Graphics graphics, int n, int n2, int n3) {
        if (n >= obBlockIndex.length) {
            return;
        }
        int n4 = obBlockSize[n];
        int n5 = obBlockIndex[n];
        int n6 = 0;
        while (n6 < n4) {
            if (n5 != obAlwaysUpdateIndex) {
                GameWorld.paintObject(graphics, n5, n2, n3);
            }
            ++n6;
            n5 += 9;
        }
    }

    private static void paintObject(Graphics graphics, int n, int n2, int n3) {
        byte by = obData[n + 0];
        if (by < 0) {
            return;
        }
        int n4 = obData[n + 1];
        byte by2 = obData[n + 4];
        byte by3 = obData[n + 5];
        int n5 = n2 + (obData[n + 2] & 0xFF);
        int n6 = n3 + (obData[n + 3] & 0xFF);
        if (by == 68 && !objectPaintFirst) {
            img_loop_overlay.drawImageClipStack(graphics, n5, n6);
            return;
        }
        if (!objectPaintFirst) {
            return;
        }
        switch (by) {
            case 0: {
                if (n4 == 0) {
                    n4 = 7;
                }
                int n7 = Animator.frame[ringAnimator];
                int n8 = n4;
                while (n8 > 0) {
                    if ((n8 & 1) > 0) {
                        img_commonObjects[6][n7].drawImageClipStack(graphics, n5, n6);
                    }
                    n8 >>= 1;
                    n5 += 12;
                }
                break;
            }
            case 1: {
                if (n4 == 0) {
                    n4 = 7;
                }
                int n9 = Animator.frame[ringAnimator];
                int n10 = n4;
                while (n10 > 0) {
                    if ((n10 & 1) > 0) {
                        img_commonObjects[6][n9].drawImageClipStack(graphics, n5, n6);
                    }
                    n10 >>= 1;
                    n6 += 12;
                }
                break;
            }
            case 50: {
                if (n4 == 0) {
                    n4 = 63;
                }
                int n11 = n5 + 12;
                int n12 = Animator.frame[ringAnimator];
                int n13 = 1;
                int n14 = n4;
                while (n14 > 0) {
                    n5 = n11 - 6 * (n13 - 1);
                    int n15 = 0;
                    while (n15 < n13) {
                        if ((n14 & 1) != 0) {
                            img_commonObjects[6][n12].drawImageClipStack(graphics, n5, n6);
                        }
                        n14 >>= 1;
                        ++n15;
                        n5 += 12;
                    }
                    ++n13;
                    n6 += 12;
                }
                break;
            }
            case 2: {
                if (by2 == 0 || by2 == 1) {
                    if (by2 == 0 && obData[n + 5] > 0) {
                        n6 -= TV_BOUNCE_PX[obData[n + 5]];
                    }
                    img_commonObjects[1][0].drawImageClipStack(graphics, n5, n6);
                    if (Animator.frame[tvAnimator] == 0) {
                        img_commonObjects[3][0].drawImageClipStack(graphics, n5, n6);
                    } else {
                        img_commonObjects[1][1 + n4].drawImageClipStack(graphics, n5, n6);
                    }
                } else {
                    img_commonObjects[2][0].drawImageClipStack(graphics, n5, n6);
                }
                GameWorld.paintHiddenObjectCamouflage(graphics, n);
                if (by2 == 3) {
                    img_commonObjects[1][1 + n4].drawImageClipStack(graphics, n5, n6 - by3);
                    break;
                }
                if (by2 != 4) break;
                img_commonObjects[1][1 + n4].drawImageClipStack(graphics, n5, n6 - 28);
                break;
            }
            case 3: {
                int n16;
                int n17 = n5;
                int n18 = 0;
                int n19 = 3;
                if (n4 == -1) {
                    n19 = 17;
                } else if (n4 == -2) {
                    n19 = 20;
                } else {
                    n16 = n4 & 3;
                    if (n16 > 0) {
                        n19 = n4 & 3;
                    }
                    if ((n4 & 4) > 0) {
                        int n20 = obData[n + 5] * 7;
                        n18 = platformData[n20 + 4] >> 7;
                        n6 += n18;
                    }
                }
                Engine.clipRect(graphics, n5, n6, n19 * 8, 16 - n18);
                for (n16 = 0; n16 < n19; ++n16) {
                    spikeUp.drawImageClipStack(graphics, n5, n6);
                    n5 += 8;
                }
                graphics.setClip(0, 0, 128, 115);
                break;
            }
            case 4: {
                img_commonObjects[20 + (n4 & 3)][0].drawImageClipStack(graphics, n5, n6);
                GameWorld.paintHiddenObjectCamouflage(graphics, n);
                break;
            }
            case 15: {
                img_commonObjects[16 + n4][0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 48: {
                img_commonObjects[12 + n4][0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 5: {
                GameWorld.paintPlatform(graphics, n, n5, n6);
                break;
            }
            case 7: 
            case 23: 
            case 24: 
            case 25: 
            case 49: 
            case 51: 
            case 52: 
            case 55: 
            case 60: 
            case 63: 
            case 66: {
                if (by2 == 2) break;
                GameWorld.paintPlatform(graphics, n, n5, n6);
                break;
            }
            case 62: {
                if (currentAct == 1) {
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            GameWorld.paintPlatform(graphics, n, n5 + j * 128, n6 + i * 128);
                        }
                    }
                    break;
                }
                GameWorld.paintPlatform(graphics, n, n5, n6);
                break;
            }
            case 8: {
                img_commonObjects[4][0].drawImageClipStack(graphics, n5, n6);
                if (by2 != 1) break;
                img_commonObjects[5][0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 9: {
                if (by2 == 1) {
                    img_commonObjects[8][0].drawImageClipStack(graphics, n5, n6);
                    break;
                }
                img_commonObjects[7][0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 53: {
                img_zoneEnemies[0][0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 54: {
                if (obData[n + 5] == 0) {
                    img_zoneObjects[0][0].drawImageClipStack(graphics, n5, n6);
                    break;
                }
                img_zoneObjects[0][1].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 58: {
                int n21 = n4 & 0xF;
                img_zoneObjects[6 + n21][0].drawImageClipStack(graphics, n5, n6);
                img_zoneObjects[6 + n21][1].drawImageClipStack(graphics, n5 + 16, n6);
                img_zoneObjects[6 + n21][2].drawImageClipStack(graphics, n5, n6 + 16);
                img_zoneObjects[6 + n21][3].drawImageClipStack(graphics, n5 + 16, n6 + 16);
                break;
            }
            case 56: 
            case 57: {
                int n22 = obData[n + 5] * 7;
                img_zoneObjects[1][0].drawImageClipStack(graphics, n5 += platformData[n22 + 3] >> 7, n6 += platformData[n22 + 4] >> 7);
                img_zoneObjects[1][1].drawImageClipStack(graphics, n5 + 16, n6);
                img_zoneObjects[1][2].drawImageClipStack(graphics, n5, n6 + 16);
                img_zoneObjects[1][3].drawImageClipStack(graphics, n5 + 16, n6 + 16);
                break;
            }
            case 59: {
                int n23 = obData[n + 5] * 7;
                tiles[42].drawImageClipStack(graphics, n5 += platformData[n23 + 3] >> 7, n6 += platformData[n23 + 4] >> 7);
                break;
            }
            case 61: {
                int n24;
                short s = GameWorld.img_zoneObjects[3][0].height;
                for (n24 = 0; n24 < 3; ++n24) {
                    img_zoneObjects[3][0].drawImageClipStack(graphics, n5, n6);
                    n6 += s << 1;
                }
                n24 = GameWorld.img_zoneObjects[2][0].width;
                n6 -= s * 5 + 8 + n24;
                n5 += (GameWorld.img_zoneObjects[3][0].width - n24 >> 1) - n24;
                int n25 = obData[n + 5] * 3;
                for (int i = 0; i < 3; ++i) {
                    img_zoneObjects[2][obFruitData[n25 + i]].drawImageClipStack(graphics, n5, n6);
                    n5 += n24;
                }
                break;
            }
            case 65: {
                img_zoneObjects[5][obData[n + 4] == 1 ? 1 : 0].drawImageClipStack(graphics, n5, n6);
                break;
            }
            case 64: {
                img_zoneObjects[4][obData[n + 4] == 1 ? 1 : 0].drawImageClipStack(graphics, n5, n6);
            }
        }
    }

    private static void paintEnemies(Graphics graphics) {
        block12: for (int i = 0; i < enemyData.length; i += 12) {
            int n = enemyData[i + 0];
            if (n == -1) continue;
            int n2 = enemyData[i + 2];
            int n3 = enemyData[i + 3];
            int n4 = n2 >> 7;
            int n5 = n3 >> 7;
            int n6 = n4 - camX;
            int n7 = n5 - camY;
            int n8 = enemyData[i + 9];
            int n9 = Animator.frame[n8];
            DeviceImage deviceImage = Animator.frameImages[n8][n9];
            switch (n) {
                case 1: 
                case 4: {
                    deviceImage.drawImageClipStack(graphics, n6, n7);
                    continue block12;
                }
                case 5: {
                    deviceImage.drawImageClipStack(graphics, n6, n7);
                    if (enemyData[i + 6] != 2) continue block12;
                    DeviceImage deviceImage2 = img_zoneEnemies[6][0];
                    int n10 = deviceImage2.width << 7;
                    int n11 = enemyData[i + 7];
                    int n12 = enemyData[i + 8];
                    int n13 = (n2 += deviceImage.width << 6) - n11 - (n10 >> 1) >> 7;
                    int n14 = n3 + n12 >> 7;
                    n6 = n13 - camX;
                    n7 = n14 - camY;
                    n6 = deviceImage.manipulation == 0 ? (n6 -= 5) : (n6 += 5);
                    deviceImage2.drawImageClipStack(graphics, n6, n7 -= 10);
                    continue block12;
                }
                case 6: 
                case 7: {
                    deviceImage.drawImageClipStack(graphics, n6, n7);
                    DeviceImage deviceImage3 = img_zoneEnemies[n == 7 ? 3 : 1][0];
                    int n10 = n7 + deviceImage.height - 1;
                    int n11 = n == 7 ? n6 - (deviceImage.width - deviceImage3.width) : n6 + (deviceImage.width - deviceImage3.width);
                    int n12 = (enemyData[i + 2] - enemyData[i + 11]) / 4;
                    for (int j = 0; j < 4; ++j) {
                        deviceImage3.drawImageClipStack(graphics, n11 - ((j + 1) * n12 >> 7), n10);
                        n10 += deviceImage3.height - 1;
                    }
                    if (enemyData[i + 6] != 1) continue block12;
                    DeviceImage deviceImage4 = img_commonEnemies[0][bulletType];
                    n2 = enemyData[i + 11];
                    int n14 = deviceImage4.width << 7;
                    int n15 = enemyData[i + 7];
                    int n16 = enemyData[i + 8];
                    int n17 = n2 + n15 - (n14 >> 1) >> 7;
                    int n18 = n3 + n16 >> 7;
                    n6 = n17 - camX;
                    n7 = n18 - camY;
                    deviceImage4.drawImageClipStack(graphics, n6, n7);
                    continue block12;
                }
                case 8: 
                case 10: {
                    int n19 = (enemyData[i + 11] >> 7) - camX;
                    int n10 = (enemyData[i + 1] >> 7) - camY;
                    switch (enemyData[i + 7]) {
                        case 12: {
                            img_zoneEnemies[5][0].drawImageClipStack(graphics, n19, n10);
                            break;
                        }
                        case 13: {
                            img_zoneEnemies[6][0].drawImageClipStack(graphics, n19, n10);
                            break;
                        }
                        case 14: {
                            img_zoneEnemies[7][0].drawImageClipStack(graphics, n19, n10);
                        }
                    }
                    deviceImage.drawImageClipStack(graphics, n6, n7);
                    continue block12;
                }
                case 9: {
                    deviceImage.drawImageClipStack(graphics, n6, n7);
                }
            }
        }
    }

    private static void paintPlatform(Graphics graphics, int n, int n2, int n3) {
        int n4 = obData[n + 5] * 7;
        int n5 = platformData[n4 + 0];
        int n6 = PLATFORM_TYPE_MAPS[n5];
        short[] sArray = platformMaps[n6];
        int n7 = platformWidths[n6];
        int n8 = platformHeights[n6];
        if (n5 == 0 && n == plPlatform) {
            int n9 = 0;
            int n10 = n3;
            int n11 = n8;
            while (--n11 >= 0) {
                int n12 = n2;
                int n13 = n7;
                int n14 = 0;
                while (--n13 >= 0) {
                    int n15 = sArray[n9++] << 1;
                    short s = metaTiles[n15];
                    short s2 = metaTiles[n15 + 1];
                    tiles[s].drawImageClipStack(graphics, n12, n10 + bridgeOffsets[n14]);
                    tiles[s2].drawImageClipStack(graphics, n12 + 16, n10 + bridgeOffsets[n14 + 1]);
                    n12 += 32;
                    n14 += 2;
                }
                n10 += 16;
            }
        } else {
            if ((n2 += platformData[n4 + 3] >> 7) > 128 || (n3 += platformData[n4 + 4] >> 7) > 115) {
                return;
            }
            int n16 = 0;
            int n17 = n3;
            int n18 = n8;
            while (--n18 >= 0) {
                if (n17 > 115) {
                    return;
                }
                if (n17 + 16 < 0) {
                    n16 += n7;
                } else {
                    int n19 = n2;
                    int n20 = n7;
                    while (--n20 >= 0) {
                        if (n19 > -32 && n19 < 128) {
                            int n21 = sArray[n16] << 1;
                            short s = metaTiles[n21];
                            short s3 = metaTiles[n21 + 1];
                            tiles[s].drawImageClipStack(graphics, n19, n17);
                            tiles[s3].drawImageClipStack(graphics, n19 + 16, n17);
                        }
                        n19 += 32;
                        ++n16;
                    }
                }
                n17 += 16;
            }
        }
    }

    private static void paintMedievalTortureInstrument(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n4 == 1) {
            nArray = SPIKED_PLATFORM_SEGMENT_REPS;
            n5 = spikedPlatformLeftOffset;
            n6 = spikedPlatformSpikeSpacing;
            n7 = 6;
        } else if (n4 == 2) {
            nArray = SMALL_SPIKED_PLATFORM_SEGMENT_REPS;
            n5 = smallSpikedPlatformLeftOffset;
            n6 = smallSpikedPlatformSpikeSpacing;
            n7 = 5;
        }
        short s = GameWorld.weightLink.height;
        if (n4 > 0) {
            n += n5;
        }
        Engine.clipRect(graphics, n, n2 + GameWorld.weightBase.height, GameWorld.weightBase.width, n3);
        int n8 = n2 + GameWorld.weightBase.height + n3;
        while (n8 > n2 + GameWorld.weightBase.height) {
            weightLink.drawImageClipStack(graphics, n, n8 -= s);
        }
        graphics.setClip(0, 0, 128, 115);
        weightBase.drawImageClipStack(graphics, n, n2);
        weightAttachment.drawImageClipStack(graphics, n, n2 += GameWorld.weightBase.height + n3);
        n2 += GameWorld.weightAttachment.height;
        if (n4 == 0) {
            weightFarLeft.drawImageClipStack(graphics, n, n2);
            weightLeft.drawImageClipStack(graphics, n += GameWorld.weightFarLeft.width, n2);
            weightRight.drawImageClipStack(graphics, n += GameWorld.weightLeft.width, n2);
            weightFarRight.drawImageClipStack(graphics, n += GameWorld.weightRight.width, n2);
            n += GameWorld.weightFarRight.width;
        } else {
            int n9;
            int n10 = GameWorld.spikeDown.width >> 1;
            int n11 = (n -= n5) + n6 - n10;
            for (n9 = 0; n9 < nArray.length; ++n9) {
                for (int i = 0; i < nArray[n9]; ++i) {
                    DeviceImage deviceImage = weightSegments[n9];
                    deviceImage.drawImageClipStack(graphics, n, n2);
                    n += deviceImage.width;
                }
            }
            n2 += GameWorld.weightSegments[0].height;
            for (n9 = 0; n9 < n7; ++n9) {
                spikeDown.drawImageClipStack(graphics, n11 - n10, n2);
                n11 += n6;
            }
        }
    }

    private static void paintHiddenObjectCamouflage(Graphics graphics, int n) {
        int n2 = (obData[n + 7] << 7) + (obData[n + 2] & 0xFF);
        int n3 = n2 >> 4;
        int n4 = (obData[n + 8] << 7) + (obData[n + 3] & 0xFF);
        int n5 = n4 >> 4;
        if (GameWorld.getTile(n3, n5) == 44) {
            int n6 = (n3 << 4) - camX;
            int n7 = (n5 << 4) - camY;
            tiles[44].drawImageClipStack(graphics, n6, n7);
            tiles[46].drawImageClipStack(graphics, n6 + 16, n7);
            tiles[45].drawImageClipStack(graphics, n6, n7 + 16);
            tiles[47].drawImageClipStack(graphics, n6 + 16, n7 + 16);
        }
    }

    private static void paintBouncingRings(Graphics graphics) {
        for (int i = 0; i <= lastBouncingRingPtr; i += 4) {
            int n = ringsData[i + 1];
            if (n == 0) continue;
            int n2 = (ringsData[i + 0] >> 7) - camX;
            n = (n >> 7) - camY;
            int n3 = Animator.frame[ringAnimator];
            img_commonObjects[6][n3].drawImageClipStack(graphics, n2, n);
        }
    }

    private static String milliSecsToString(int n) {
        int n2 = n / 1000;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n3);
        stringBuffer.append(':');
        if (n2 < 10) {
            stringBuffer.append(0);
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private static void paintNumbers(Graphics graphics, String string, int n, int n2, int n3) {
        char[] cArray = string.toCharArray();
        if ((n3 & 8) != 0) {
            n -= cArray.length * 6 - 1;
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            img_numbers[c - 48].drawImageClipStack(graphics, n, n2);
            n += 6;
        }
    }

    private static void paintHudBackgroundQuarter(Graphics graphics, int n, int n2) {
        int n3 = Constants.COLOR_STATUSBAR[0];
        int n4 = Constants.COLOR_STATUSBAR[0] ^ Constants.COLOR_STATUSBAR[1];
        for (int i = n2 - 1; i >= n2 - 17; --i) {
            graphics.setColor(n3);
            n3 ^= n4;
            graphics.fillRect(n, i, 64, 1);
        }
    }

    private static void paintHud(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if (!plScoreUpdated) {
            // empty if block
        }
        graphics.setClip(0, 0, 128, 149);
        GameWorld.paintHudBackgroundQuarter(graphics, 64, 149);
        GameWorld.paintNumbers(graphics, "" + plScore, 126 - Engine.img_backicon.width - 2 - n, 140 - n2, 8);
        graphics.setClip(0, 0, 128, 149);
        if (gameState != 5) {
            Engine.img_backicon.drawImageNoClipping(graphics, 126, 147, 40);
        }
        plScoreUpdated = false;
        if (!hud_ringsUpdated) {
            // empty if block
        }
        graphics.setClip(0, 0, 128, 149);
        GameWorld.paintHudBackgroundQuarter(graphics, 0, 17);
        img_rings.drawImageClipStack(graphics, 2, 2);
        GameWorld.paintNumbers(graphics, String.valueOf(plRings), 2 + GameWorld.img_rings.width + 5, 2, 20);
        hud_ringsUpdated = false;
        if (!hud_livesUpdated) {
            // empty if block
        }
        graphics.setClip(0, 0, 128, 149);
        GameWorld.paintHudBackgroundQuarter(graphics, 0, 149);
        int n3 = 2;
        short s = GameWorld.img_lives.width;
        img_lives.drawImageClipStack(graphics, n3, 147 - GameWorld.img_lives.height);
        GameWorld.paintNumbers(graphics, "" + Math.max(plLives, 0), n3 + s + 2, 140 - n2, 4);
        hud_livesUpdated = false;
        if (!hud_timeUpdated) {
            // empty if block
        }
        graphics.setClip(0, 0, 128, 149);
        GameWorld.paintHudBackgroundQuarter(graphics, 64, 17);
        if (Engine.returnFromPause && Engine.loadingInterrupted) {
            plTimeStartedMillis = System.currentTimeMillis();
            Engine.returnFromPause = false;
            Engine.loadingInterrupted = false;
        }
        String string = plTimeOver ? GameWorld.milliSecsToString(599000) : GameWorld.milliSecsToString((int)(System.currentTimeMillis() - plTimeStartedMillis));
        GameWorld.paintNumbers(graphics, string, 126, 2, 8);
        hud_timeUpdated = false;
    }

    private static void paintGameOver(Graphics graphics) {
        graphics.setClip(0, 0, 128, 149);
        if (gameState == 4) {
            int n = 64;
            int n2 = 57;
            if (plTimeOver && plLives > 0) {
                Engine.paintBorderedString(graphics, Engine.text[29], n, n2, 17);
            } else {
                Engine.paintBorderedString(graphics, Engine.text[30], n, n2, 17);
            }
        } else {
            int n = 64;
            int n3 = Device.FONT.getHeight() * 5;
            int n4 = 115 - n3 >> 1;
            int n5 = Device.FONT.getHeight();
            Engine.paintBorderedString(graphics, Engine.text[28], n, n4, 17);
            Engine.paintBorderedString(graphics, Engine.text[35] + " " + (currentAct + 1), n, n4 += n5, 17);
            n = 10;
            int n6 = n4 += n5;
            Engine.paintBorderedString(graphics, Engine.text[25], n, n4, 20);
            Engine.paintBorderedString(graphics, Engine.text[26], n, n4 += n5, 20);
            Engine.paintBorderedString(graphics, Engine.text[27], n, n4 += n5, 20);
            n = 118;
            n4 = n6;
            Engine.paintBorderedString(graphics, "" + plScore, n, n4, 24);
            Engine.paintBorderedString(graphics, "" + levelCompleteTimeBonus, n, n4 += n5, 24);
            Engine.paintBorderedString(graphics, "" + levelCompleteRingBonus, n, n4 += n5, 24);
        }
    }

    private static void sonicSetState(int n) {
        if (plState == 12) {
            return;
        }
        switch (n) {
            case 0: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 4 : 14], 1);
                break;
            }
            case 1: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 5 : 15], 4);
                break;
            }
            case 13: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 24 : 23], 1);
                break;
            }
            case 2: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 1 : 11], 1);
                break;
            }
            case 3: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 0 : 10], 1);
                break;
            }
            case 6: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 9 : 19], 1);
                break;
            }
            case 15: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 9 : 19], 1);
                break;
            }
            case 7: {
                plPlatform = -1;
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 6 : 16], 1);
                break;
            }
            case 8: 
            case 14: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 9 : 19], 1);
                break;
            }
            case 10: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 2 : 12], 1);
                break;
            }
            case 9: {
                Animator.reset(sonicAnimator, img_sonic[plFacing == 1 ? 3 : 13], 1);
                break;
            }
            case 11: {
                Animator.reset(sonicAnimator, img_sonic[20], 1);
            }
        }
        plState = n;
        plStateTicks = 0;
    }

    public static void sonicSetFacing(int n) {
        if (n != plFacing) {
            plFacing = n;
            GameWorld.sonicSetState(plState);
        }
    }

    private static void sonicUpdate() {
        int n;
        int n2;
        if (plSetVector) {
            return;
        }
        if (plPaused) {
            if (Engine.isPressed(1)) {
                plY -= SONIC_PAUSED_SPEED;
            }
            if (Engine.isPressed(2)) {
                plY += SONIC_PAUSED_SPEED;
            }
            if (Engine.isPressed(4)) {
                plX -= SONIC_PAUSED_SPEED;
            }
            if (Engine.isPressed(8)) {
                plX += SONIC_PAUSED_SPEED;
            }
            return;
        }
        plPrevX = plX;
        plPrevY = plY;
        plPixelOy = 0;
        ++plStateTicks;
        boolean bl = Engine.isPressed(4);
        boolean bl2 = Engine.isPressed(8);
        if (bl && bl2) {
            bl2 = false;
            bl = false;
        }
        if (plState != 10) {
            if (bl) {
                GameWorld.sonicSetFacing(-1);
            }
            if (bl2) {
                GameWorld.sonicSetFacing(1);
            }
        }
        if (plState < 7) {
            if (Engine.key(1)) {
                GameWorld.sonicJump(1);
                return;
            }
            if (Engine.key(256)) {
                GameWorld.sonicJump(0);
                return;
            }
            if (Engine.key(512)) {
                GameWorld.sonicJump(2);
                return;
            }
        }
        switch (plState) {
            case 0: {
                if (GameWorld.enterDashStateCheck()) {
                    return;
                }
                if (plStateTicks >= 30) {
                    GameWorld.sonicSetState(1);
                }
            }
            case 1: {
                if (GameWorld.enterDashStateCheck()) {
                    return;
                }
                if (Engine.isPressed(16)) {
                    GameWorld.sonicSetState(3);
                    GameWorld.sonicLook(0);
                    break;
                }
                if (Engine.isPressed(2)) {
                    GameWorld.sonicSetState(2);
                    GameWorld.sonicLook(1);
                    break;
                }
                if (bl) {
                    plVelocity = -SONIC_PHYS_INITIAL_AX;
                    GameWorld.sonicSetState(5);
                    GameWorld.sonicUpdate();
                    return;
                }
                if (!bl2) break;
                plVelocity = SONIC_PHYS_INITIAL_AX;
                GameWorld.sonicSetState(5);
                GameWorld.sonicUpdate();
                return;
            }
            case 13: {
                if (Engine.isPressed(1024) || Engine.isPressed(2048) || Engine.isPressed(2)) break;
                plSprung = true;
                plVelocity = SONIC_PHYS_MAX_DASH_SPEED * plFacing;
                GameWorld.sonicSetState(6);
                return;
            }
            case 2: {
                if (Engine.isPressed(16) && GameWorld.enterDashStateCheck()) {
                    return;
                }
                if (Engine.isPressed(2)) {
                    GameWorld.sonicLook(1);
                    break;
                }
                GameWorld.sonicSetState(0);
                break;
            }
            case 3: {
                if (Engine.isPressed(16)) {
                    GameWorld.sonicLook(0);
                    break;
                }
                GameWorld.sonicSetState(0);
                break;
            }
            case 5: {
                if (Engine.isPressed(2)) {
                    GameWorld.sonicSetState(6);
                    GameWorld.sonicUpdate();
                    return;
                }
                if (plVelocity > 0 || plVelocity == 0 && plFacing > 0) {
                    if (bl2) {
                        plVelocity += 48;
                    } else if (bl) {
                        plVelocity -= 384;
                    } else if ((plVelocity -= 48) <= 0) {
                        plVelocity = 0;
                        GameWorld.sonicSetState(0);
                        return;
                    }
                    if (!plSprung) {
                        if (plVelocity > SONIC_PHYS_MAX_SPEED) {
                            plVelocity = SONIC_PHYS_MAX_SPEED;
                        }
                    } else {
                        if (plVelocity > SONIC_PHYS_MAX_SPRUNG_SPEED) {
                            plVelocity = SONIC_PHYS_MAX_SPRUNG_SPEED;
                        }
                        if (plVelocity < SONIC_PHYS_MAX_SPEED) {
                            plSprung = false;
                        }
                    }
                } else if (plVelocity < 0 || plVelocity == 0 && plFacing < 0) {
                    if (bl) {
                        plVelocity -= 48;
                    } else if (bl2) {
                        plVelocity += 384;
                    } else if ((plVelocity += 48) >= 0) {
                        plVelocity = 0;
                        GameWorld.sonicSetState(0);
                        return;
                    }
                    if (!plSprung) {
                        if (plVelocity < -SONIC_PHYS_MAX_SPEED) {
                            plVelocity = -SONIC_PHYS_MAX_SPEED;
                        }
                    } else {
                        if (plVelocity < -SONIC_PHYS_MAX_SPRUNG_SPEED) {
                            plVelocity = -SONIC_PHYS_MAX_SPRUNG_SPEED;
                        }
                        if (plVelocity > -SONIC_PHYS_MAX_SPEED) {
                            plSprung = false;
                        }
                    }
                }
                int n3 = n2 = plVelocity > 0 ? plVelocity : -plVelocity;
                if (n2 >= SONIC_PHYS_MAX_SPEED) {
                    Animator.interrupt(sonicAnimator, img_sonic[plFacing == 1 ? 8 : 18], 1);
                } else {
                    Animator.interrupt(sonicAnimator, img_sonic[plFacing == 1 ? 6 : 16], 1);
                }
                GameWorld.sonicWalk();
                break;
            }
            case 6: {
                n = 0;
                if (plVelocity > 0 || plVelocity == 0 && plFacing > 0) {
                    if (bl) {
                        plVelocity -= 48;
                    }
                    if ((plVelocity -= 48) <= 0) {
                        n = 1;
                    }
                } else if (plVelocity < 0 || plVelocity == 0 && plFacing < 0) {
                    if (bl2) {
                        plVelocity += 48;
                    }
                    if ((plVelocity += 48) >= 0) {
                        n = 1;
                    }
                }
                if (n != 0) {
                    plVelocity = 0;
                    if (Engine.isPressed(2)) {
                        GameWorld.sonicSetState(2);
                    } else {
                        GameWorld.sonicSetState(0);
                    }
                }
                GameWorld.sonicWalk();
                break;
            }
            case 15: {
                GameWorld.sonicLoop();
                break;
            }
            case 9: {
                if (plVelY > 0) {
                    GameWorld.sonicSetState(7);
                    Animator.frameRate[GameWorld.sonicAnimator] = 2;
                }
            }
            case 7: 
            case 8: 
            case 10: {
                GameWorld.sonicFall();
                break;
            }
            case 11: {
                if ((plY >> 7) + -15 > endCamY) {
                    if (plLives > 0 && !plTimeOver) {
                        gameState = 3;
                    } else {
                        gameOverDisplayMillis = System.currentTimeMillis();
                        gameState = 4;
                    }
                }
                plY += plVelY;
                plVelY += 224;
                break;
            }
            case 12: {
                GameWorld.sonicSetFacing(1);
                if (plState == 12) {
                    plVelocity += 48;
                }
                if (plVelocity >= SONIC_PHYS_MAX_SPEED) {
                    Animator.interrupt(sonicAnimator, img_sonic[8], 1);
                } else {
                    Animator.interrupt(sonicAnimator, img_sonic[6], 1);
                }
                GameWorld.sonicWalk();
                if (plX <= maxTileX + 1 << 11) break;
                gameOverDisplayMillis = System.currentTimeMillis();
                gameState = 5;
            }
        }
        if (plState == 5 || plState == 6) {
            n2 = Math.max(plVelocity, SONIC_PHYS_MAX_SPEED >> 1);
            sonicFrameControl += Math.abs(n2);
            n = (sonicFrameControl %= SONIC_PHYS_MAX_SPEED * 15) / SONIC_PHYS_MAX_SPEED;
            Animator.setFrame(sonicAnimator, n);
        } else {
            Animator.animate(sonicAnimator);
        }
    }

    private static boolean enterDashStateCheck() {
        if (Engine.isPressed(1024) || Engine.isPressed(2048) || Engine.isPressed(2) && Engine.isPressed(16)) {
            plFacing = Engine.isPressed(1024) ? -1 : plFacing;
            plFacing = Engine.isPressed(2048) ? 1 : plFacing;
            GameWorld.sonicSetState(13);
            GameWorld.sonicUpdate();
            return true;
        }
        return false;
    }

    private static void sonicReset() {
        plBarrier = false;
        plInvincible = false;
        plSparkles = false;
        bouncingRingsCount = 0;
        plComboPtr = 0;
        GameWorld.setRings(0);
        plSprung = false;
        plPlatform = -1;
        obAlwaysUpdateIndex = -1;
        plPixelOy = 0;
        plPrevX = plX;
        plPrevY = plY;
        plVelX = 0;
        plVelY = 0;
        plVelocity = 0;
        GameWorld.sonicSetFacing(1);
    }

    private static void initSonicLoop(int n, int n2, int n3) {
        GameWorld.sonicSetState(15);
        colx = n << 7;
        coly = n2 << 7;
        loopInitialX = colx;
        loopInitialY = coly - 1536;
        int n4 = loopInitialX - plX >> 7;
        fakeLoopIdx = n3 == 1 ? 160 + n4 : loopOffsetX.length - 144 + n4;
        loopDir = n3;
    }

    private static void sonicLoop() {
        if (fakeLoopIdx >= loopOffsetX.length || fakeLoopIdx < 0) {
            fakeLoopIdx = 0;
            GameWorld.sonicSetState(5);
            return;
        }
        loopVelocity = (plVelocity >> 8) + 5 * loopDir;
        if (loopDir == 1) {
            plX = loopInitialX + (loopOffsetX[fakeLoopIdx] - 32 << 7);
            plY = loopInitialY - (loopOffsetY[fakeLoopIdx] - 64 << 7);
        } else {
            plX = loopInitialX + (loopOffsetX[fakeLoopIdx] + 48 << 7);
            plY = loopInitialY - (loopOffsetY[fakeLoopIdx] - 64 << 7);
        }
        fakeLoopIdx += loopVelocity;
    }

    private static void sonicWalk() {
        if (plPlatform >= 0) {
            GameWorld.sonicOnPlatform();
            return;
        }
        int n = plX >> 11;
        int n2 = plY >> 11;
        int n3 = plX - (n << 11);
        int n4 = plVelocity > 0 ? 1 : -1;
        int n5 = plVelocity * n4;
        int n6 = plVelocity < 0 ? n3 : 2048 - (n3 + 1);
        boolean bl = true;
        while (bl) {
            int n7;
            int n8;
            int n9;
            int n10 = GameWorld.getTile(n, n2);
            int n11 = GameWorld.getTileType(n10);
            if (n11 == -1) {
                n9 = plY - (n2 << 11);
                if (n9 == 0) {
                    --n2;
                    continue;
                }
                if (GameWorld.getTileType(GameWorld.getTile(n, ++n2)) != -1) continue;
                plX += n4;
                plVelX = plVelocity;
                plVelY = 224;
                if (plState == 6) {
                    GameWorld.sonicSetState(8);
                    break;
                }
                GameWorld.sonicSetState(7);
                break;
            }
            n9 = n2 << 11;
            byte[] byArray = DeviceConstants.FLOOR_MAPS[n11];
            n3 = plX - (n << 11);
            if (n3 >= 0 && n3 < 2048) {
                n8 = byArray[n3 >> 7] + tileFloorOffsets[n10];
                plY = n9 + (n8 << 7);
                n7 = FLOOR_ANGLE[n11];
                if (n7 != 0) {
                    if ((n7 += 90) > 180 && plFacing == 1 || n7 < 180 && plFacing == -1) {
                        plVelocity = GameWorld.sin(n7) * plVelocity >> 10;
                    } else if (n7 > 180 && plFacing == -1) {
                        plVelocity -= 24;
                    } else if (n7 < 180 && plFacing == 1) {
                        plVelocity += 24;
                    }
                }
            }
            if (n5 == 0) break;
            if (n5 > n6) {
                n5 -= n6;
                n8 = byArray[(n3 += n6 * n4) >> 7] + tileFloorOffsets[n10];
                plY = n9 + (n8 << 7);
                n7 = GameWorld.checkTileHit(plX += n6 * n4, plY, n4, 0, true);
                switch (n7) {
                    case 0: {
                        plVelocity = 0;
                        n5 = 0;
                        break;
                    }
                    case -1: {
                        plX += n4;
                        plVelX = plVelocity;
                        plVelY = 224;
                        if (plState == 6) {
                            GameWorld.sonicSetState(8);
                        } else {
                            GameWorld.sonicSetState(7);
                        }
                        n5 = 0;
                        bl = false;
                        break;
                    }
                    default: {
                        n6 = 2048;
                        n += n4;
                        break;
                    }
                }
            } else {
                plX += n4 * n5;
                n5 = 0;
            }
            n2 = plY >> 11;
        }
    }

    private static void paintWalkingDebug(Graphics graphics) {
        if (plState != 5 || plPaused) {
            return;
        }
        if (plPlatform >= 0) {
            return;
        }
        int n = plX;
        int n2 = plY;
        int n3 = plVelX;
        int n4 = plVelY;
        int n5 = plVelocity;
        if (n5 > 0 || n5 == 0 && plFacing > 0) {
            if (Engine.isPressed(8)) {
                n5 += 48;
            } else if (Engine.isPressed(4)) {
                n5 -= 384;
            } else if ((n5 -= 48) <= 0) {
                return;
            }
            if (n5 > SONIC_PHYS_MAX_SPEED) {
                n5 = SONIC_PHYS_MAX_SPEED;
            }
        } else if (n5 < 0 || n5 == 0 && plFacing < 0) {
            if (Engine.isPressed(4)) {
                n5 -= 48;
            } else if (Engine.isPressed(8)) {
                n5 += 384;
            } else if ((n5 += 48) >= 0) {
                n5 = 0;
                return;
            }
            if (n5 > SONIC_PHYS_MAX_SPEED) {
                n5 = SONIC_PHYS_MAX_SPEED;
            }
        }
        int n6 = n >> 11;
        int n7 = n2 >> 11;
        int n8 = n - (n6 << 11);
        int n9 = n5 > 0 ? 1 : -1;
        int n10 = n5 * n9;
        int n11 = n5 < 0 ? n8 : 2048 - (n8 + 1);
        boolean bl = true;
        while (bl) {
            int n12;
            int n13;
            int n14;
            int n15 = GameWorld.getTile(n6, n7);
            int n16 = GameWorld.getTileType(n15);
            if (n16 == -1) {
                Engine.debugWrite("heading out over slope");
                n14 = n2 - (n7 << 11);
                if (n14 == 0) {
                    --n7;
                    continue;
                }
                ++n7;
                continue;
            }
            n14 = n7 << 11;
            byte[] byArray = DeviceConstants.FLOOR_MAPS[n16];
            n8 = n - (n6 << 11);
            if (n8 >= 0 && n8 < 2048) {
                n13 = byArray[n8 >> 7] + tileFloorOffsets[n15];
                n2 = n14 + (n13 << 7);
                n12 = FLOOR_ANGLE[n16] + 90;
                if (n12 > 180 && plFacing == 1 || n12 < 180 && plFacing == -1) {
                    n5 = GameWorld.sin(n12) * n5 >> 10;
                }
            }
            if (n10 == 0) break;
            if (n10 > n11) {
                n10 -= n11;
                n13 = byArray[(n8 += n11 * n9) >> 7] + tileFloorOffsets[n15];
                n2 = n14 + (n13 << 7);
                n12 = GameWorld.checkTileHit(n += n11 * n9, n2, n9, 0, true);
                switch (n12) {
                    case 0: {
                        n5 = 0;
                        n10 = 0;
                        graphics.setColor(0xFF0000);
                        break;
                    }
                    case -1: {
                        n += n9;
                        n3 = n5;
                        n4 = 224;
                        n10 = 0;
                        bl = false;
                        graphics.setColor(0xFFFF00);
                        break;
                    }
                    default: {
                        n11 = 2048;
                        n6 += n9;
                        graphics.setColor(0xFFFFFF);
                        break;
                    }
                }
            } else {
                graphics.setColor(65280);
                n += n9 * n10;
                n10 = 0;
            }
            n12 = n >> 7;
            int n17 = n2 >> 7;
            int n18 = n12 - n12 % 16 - camX;
            int n19 = n17 - n17 % 16 - camY;
            graphics.drawRect(n18, n19, 16, 16);
            graphics.setColor(0xFF00FF);
            int n20 = n12 - camX;
            int n21 = n17 - camY;
            graphics.drawLine(n20, n21, n20, n21);
            n7 = n2 >> 11;
        }
    }

    private static void sonicOnPlatform() {
        int n;
        int n2;
        int n3;
        int n4;
        byte by = obData[plPlatform + 0];
        int n5 = (obData[plPlatform + 2] & 0xFF) + (obData[plPlatform + 7] << 7) << 7;
        int n6 = (obData[plPlatform + 3] & 0xFF) + (obData[plPlatform + 8] << 7) << 7;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        switch (by) {
            case 2: 
            case 4: 
            case 15: {
                n7 = 8;
                break;
            }
            case 3: {
                n4 = 3;
                n3 = obData[plPlatform + 1];
                if (n3 == -1) {
                    n4 = 17;
                } else {
                    n2 = n3 & 3;
                    if (n2 > 0) {
                        n4 = n2;
                    }
                }
                n7 = 7;
                n9 = n4 * 8 << 7;
                break;
            }
            case 5: {
                n7 = 0;
                break;
            }
            case 10: {
                n4 = obData[plPlatform + 5];
                n3 = n4 * 12;
                n7 = enemyData[n3 + 7];
                break;
            }
            case 62: {
                n9 = PLATFORM_TYPE_WIDTHS[18] << 7;
                if (currentAct == 1) {
                    n9 *= 3;
                }
            }
            default: {
                n8 = obData[plPlatform + 5] * 7;
                n7 = platformData[n8 + 0];
                n5 += platformData[n8 + 3];
                n6 += platformData[n8 + 4];
            }
        }
        if (n9 == -1) {
            n9 = PLATFORM_TYPE_WIDTHS[n7] << 7;
        }
        n4 = plX - n5;
        n3 = plVelocity > 0 ? 1 : -1;
        n2 = plVelocity * n3;
        int n10 = n = plVelocity > 0 ? n9 - (n4 + 1) : n4;
        while (n2 > 0) {
            int n11;
            int n12 = plX >> 11;
            int n13 = plX - (n12 << 11);
            int n14 = n11 = plVelocity < 0 ? n13 : 2048 - (n13 + 1);
            if (n2 > n11) {
                n2 -= n11;
                int n15 = GameWorld.checkTileHit(plX += n11 * n3, plY, n3, 0, true);
                switch (n15) {
                    case 0: {
                        plVelocity = 0;
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        plX += 128 * n3;
                        plPlatform = -1;
                        GameWorld.sonicLand();
                        GameWorld.sonicSetState(5);
                        break;
                    }
                    default: {
                        plX += n3;
                        --n2;
                        break;
                    }
                }
                continue;
            }
            plX += n3 * n2;
            n2 = 0;
        }
        if (plX < n5 || plX > n5 + n9) {
            plPlatform = -1;
            plVelX = plVelocity;
            plVelY = 224;
            if (plState == 6) {
                GameWorld.sonicSetState(8);
            } else {
                GameWorld.sonicSetState(7);
            }
        } else {
            plY = n6 + GameWorld.getPlatformY(n7, plX - n5);
        }
    }

    private static void sonicJump(int n) {
        short s;
        if (plPlatform < 0) {
            int n2 = plX >> 11;
            int n3 = plY >> 11;
            int n4 = GameWorld.getTile(n2, n3);
            int n5 = GameWorld.getTileType(n4);
            if (n5 == -1) {
                n4 = GameWorld.getTile(n2, n3 + 1);
                n5 = tileTypes[n4];
            }
            s = FLOOR_ANGLE[n5];
        } else {
            s = FLOOR_ANGLE[0];
        }
        GameWorld.sonicJump(n, s, 1664);
    }

    private static void sonicJump(int n, int n2, int n3) {
        plVelX = (GameWorld.sin(n2) * n3 >> 10) + plVelocity;
        plVelY = -(GameWorld.cos(n2) * n3 >> 10);
        if (n == 0) {
            plVelX -= 96;
        } else if (n == 2) {
            plVelX += 96;
        }
        plPlatform = -1;
        GameWorld.camJump();
        GameWorld.sonicSetState(8);
        GameWorld.sonicFall();
    }

    private static void sonicFall() {
        int n;
        int n2;
        int n3;
        if (plState == 14) {
            return;
        }
        if (plPlatform != -1 && (obData[plPlatform + 0] == 64 || obData[plPlatform + 0] == 65)) {
            if (Engine.isPressed(1)) {
                plVelocity = 0;
                n3 = platformData[obData[plPlatform + 5] * 7 + 2] * 30 / (PLATFORM_TYPE_WIDTHS[20] << 7);
                if (obData[plPlatform + 0] == 64) {
                    n3 = 330 + n3;
                }
                GameWorld.obData[GameWorld.plPlatform + 4] = 1;
                GameWorld.obData[GameWorld.plPlatform + 1] = 4;
                GameWorld.sonicJump(1, n3, 2750);
            } else {
                return;
            }
        }
        if (plY >= maxTileY - 1 << 11) {
            GameWorld.sonicHit(4);
            return;
        }
        n3 = Engine.isPressed(4);
        int n4 = Engine.isPressed(8);
        if (n3 != 0 && n4 != 0) {
            n4 = 0;
            n3 = 0;
        }
        if (Engine.isPressed(256) && n4 == 0) {
            n3 = 1;
            GameWorld.sonicSetFacing(-1);
        } else if (Engine.isPressed(512) && n3 == 0) {
            n4 = 1;
            GameWorld.sonicSetFacing(1);
        }
        if (plState != 10 && plState != 11) {
            if (plState != 9 && !plSprung) {
                if (-896 <= plVelY) {
                    Engine.releaseKey(1);
                    Engine.releaseKey(256);
                    Engine.releaseKey(512);
                } else if (!(Engine.isPressed(1) || Engine.isPressed(256) || Engine.isPressed(512))) {
                    plVelY = -896;
                }
            }
            if (n3 != 0) {
                if (plVelX == 0) {
                    plVelX -= 192;
                } else if ((plVelX -= 96) > 0) {
                    plVelX -= 192;
                }
            } else if (n4 != 0) {
                if (plVelX == 0) {
                    plVelX += 192;
                } else if ((plVelX += 96) < 0) {
                    plVelX += 192;
                }
            }
        }
        if (plVelX > SONIC_PHYS_MAX_SPEED && !plSprung) {
            plVelX = SONIC_PHYS_MAX_SPEED;
        } else if (plVelX > SONIC_PHYS_MAX_SPRUNG_SPEED && plSprung) {
            plVelX = SONIC_PHYS_MAX_SPRUNG_SPEED;
        }
        if (plVelX < -SONIC_PHYS_MAX_SPEED && !plSprung) {
            plVelX = -SONIC_PHYS_MAX_SPEED;
        } else if (plVelX < -SONIC_PHYS_MAX_SPRUNG_SPEED && plSprung) {
            plVelX = -SONIC_PHYS_MAX_SPRUNG_SPEED;
        }
        int n5 = plX;
        int n6 = plY;
        if (plVelY < 0) {
            n6 -= 1920;
        }
        int n7 = n5 >> 11;
        int n8 = n6 >> 11;
        int n9 = plVelX <= 0 ? n5 : 2048 - ((n5 -= n7 << 11) + 1);
        int n10 = n2 = plVelY <= 0 ? n6 : 2048 - ((n6 -= n8 << 11) + 1);
        int n11 = plVelX == 0 ? 0 : (n = plVelX < 0 ? -1 : 1);
        int n12 = plVelY == 0 ? 0 : (plVelY < 0 ? -1 : 1);
        int n13 = plVelX;
        int n14 = plVelY;
        if (n13 < 0) {
            n13 = -n13;
        }
        if (n14 < 0) {
            n14 = -n14;
        }
        boolean bl = false;
        if (plVelY > 0 && GameWorld.checkTileHit(plX, plY, 0, 0, 1, false) == 1) {
            bl = true;
        }
        while (n13 > 0 || n14 > 0) {
            int n15;
            int n16;
            int n17;
            if (bl) {
                n17 = GameWorld.sonicLand();
                GameWorld.sonicSetState(5);
                if (n17 == 0) break;
                GameWorld.sonicWalk();
                break;
            }
            if (n13 <= n9 && n14 <= n2) {
                plX += n13 * n;
                plY += n14 * n12;
                break;
            }
            n17 = n9 * n14;
            int n18 = n2 * n13;
            if (n17 < n18) {
                plX += n9 * n;
                n16 = n13 == 0 ? 0 : n17 / n13;
                n13 -= n9;
                n14 -= n16;
                n9 = 2048;
                n2 -= n16;
                n15 = GameWorld.checkTileHit(plX, plY += n16 * n12, n, 0, false);
                if (n15 == 0) {
                    n13 = 0;
                    plVelX = 0;
                    continue;
                }
                if (n15 != 1) continue;
                plX += n;
                bl = true;
                continue;
            }
            plY += n2 * n12;
            n16 = n14 == 0 ? 0 : n18 / n14;
            n13 -= n16;
            n14 -= n2;
            n9 -= n16;
            n2 = 2048;
            n15 = GameWorld.checkTileHit(plX += n16 * n, plY, 0, n12, false);
            if (n15 == 0) {
                n14 = 0;
                plVelY = 0;
                continue;
            }
            if (n15 != 1) continue;
            plY += n12;
            bl = true;
            plVelocity = plVelX;
            GameWorld.sonicWalk();
        }
        plVelY += 224;
    }

    private static void paintFallingDebug(Graphics graphics) {
        int n;
        int n2;
        graphics.setClip(0, 0, 128, 115);
        if (plState != 8 && plState != 7 && !plPaused) {
            return;
        }
        int n3 = plX;
        int n4 = plY;
        int n5 = plVelX;
        int n6 = plVelY;
        if (plState != 10 && plState != 11) {
            if (!(plState == 9 || -896 <= n6 || Engine.isPressed(1) || Engine.isPressed(256) || Engine.isPressed(512))) {
                n6 = -896;
            }
            if (Engine.isPressed(4)) {
                if (n5 == 0) {
                    n5 -= 192;
                } else if ((n5 -= 96) > 0) {
                    n5 -= 96;
                }
            } else if (Engine.isPressed(8)) {
                if (n5 == 0) {
                    n5 += 192;
                } else if ((n5 += 96) < 0) {
                    n5 += 96;
                }
            }
        }
        if (n5 > SONIC_PHYS_MAX_SPEED) {
            n5 = SONIC_PHYS_MAX_SPEED;
        }
        if (n5 < -SONIC_PHYS_MAX_SPEED) {
            n5 = -SONIC_PHYS_MAX_SPEED;
        }
        int n7 = n3;
        int n8 = n4;
        if (n6 < 0) {
            n8 -= 1920;
        }
        int n9 = n7 >> 11;
        int n10 = n8 >> 11;
        int n11 = n5 <= 0 ? n7 : 2048 - ((n7 -= n9 << 11) + 1);
        int n12 = n2 = n6 <= 0 ? n8 : 2048 - ((n8 -= n10 << 11) + 1);
        int n13 = n5 == 0 ? 0 : (n = n5 < 0 ? -1 : 1);
        int n14 = n6 == 0 ? 0 : (n6 < 0 ? -1 : 1);
        int n15 = n5;
        int n16 = n6;
        if (n15 < 0) {
            n15 = -n15;
        }
        if (n16 < 0) {
            n16 = -n16;
        }
        boolean bl = n6 > 0 && GameWorld.checkTileHit(n3, n4, 0, 0, 1, false) == 1;
        int n17 = n3 >> 7;
        int n18 = n4 >> 7;
        int n19 = n17 - n17 % 16 - camX;
        int n20 = n18 - n18 % 16 - camY;
        while (n15 > 0 || n16 > 0) {
            int n21;
            int n22;
            if (bl) {
                graphics.setColor(65280);
                graphics.drawRect(n19, n20, 16, 16);
                break;
            }
            if (n15 <= n11 && n16 <= n2) {
                n17 = (n3 += n15 * n) >> 7;
                n18 = (n4 += n16 * n14) >> 7;
                n19 = n17 - n17 % 16 - camX;
                n20 = n18 - n18 % 16 - camY;
                graphics.setColor(0xFF0000);
                graphics.drawRect(n19, n20, 16, 16);
                graphics.setColor(0xFFFF00);
                graphics.fillRect(n17 - camX, n18 - camY, 1, 1);
                break;
            }
            int n23 = n11 * n16;
            int n24 = n2 * n15;
            if (n23 < n24) {
                n22 = n15 == 0 ? 0 : n16 * n11 / n15;
                n15 -= n11;
                n16 -= n22;
                n11 = 2048;
                n2 -= n22;
                n21 = GameWorld.checkTileHit(n3 += n11 * n, n4 += n22 * n14, n, 0, false);
                n17 = n3 >> 7;
                n18 = n4 >> 7;
                n19 = n17 - n17 % 16 - camX;
                n20 = n18 - n18 % 16 - camY;
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(n19, n20, 16, 16);
                if (n21 == 0) {
                    n15 = 0;
                    n5 = 0;
                    n3 += n;
                    bl = true;
                }
            } else {
                n22 = n16 == 0 ? 0 : n15 * n2 / n16;
                n15 -= n22;
                n16 -= n2;
                n11 -= n22;
                n2 = 2048;
                n21 = GameWorld.checkTileHit(n3 += n22 * n, n4 += n2 * n14, 0, n14, false);
                n17 = n3 >> 7;
                n18 = n4 >> 7;
                n19 = n17 - n17 % 16 - camX;
                n20 = n18 - n18 % 16 - camY;
                graphics.setColor(0xDDDDDD);
                graphics.drawRect(n19, n20, 16, 16);
                if (n21 == 0) {
                    n16 = 0;
                    n6 = 0;
                } else if (n21 == 1) {
                    n4 += n14;
                    bl = true;
                }
            }
            n17 = n3 >> 7;
            n18 = n4 >> 7;
            graphics.setColor(0xFF00FF);
            graphics.fillRect(n17 - camX, n18 - camY, 1, 1);
        }
    }

    private static boolean sonicLand() {
        int n = plX >> 11;
        int n2 = plY >> 11;
        int n3 = GameWorld.getTile(n, n2);
        int n4 = GameWorld.getTileType(n3);
        if (n4 < 0 || n4 >= 19) {
            return false;
        }
        int n5 = (plX >> 7) - (n << 4);
        int n6 = (plY >> 7) - (n2 << 4);
        int n7 = tileFloorOffsets[n3] + DeviceConstants.FLOOR_MAPS[n4][n5];
        plY = (n2 << 4) + n7 << 7;
        GameWorld.camLand();
        plComboPtr = 0;
        return true;
    }

    private static void sonicHit(int n) {
        if (plState == 15) {
            return;
        }
        if (n == 1) {
            plInvincible = false;
        }
        if (n == 2) {
            plInvincible = false;
            plSparkles = false;
        }
        if (n == 3 || n == 4) {
            plInvincible = false;
            plSparkles = false;
            plBarrier = false;
        }
        if (n == 4) {
            GameWorld.setRings(0);
        }
        if (plSparkles || plInvincible) {
            return;
        }
        if (plBarrier) {
            plBarrier = false;
            plVelX = -512 * plFacing;
            plVelY = -1024;
            plInvincible = true;
            plInvincibilityTimer = 70;
            plPlatform = -1;
            GameWorld.sonicSetState(10);
            GameWorld.sonicUpdate();
            return;
        }
        plComboPtr = 0;
        if (plRings == 0) {
            --plLives;
            hud_livesUpdated = true;
            fillStatusArea = true;
            plInvincible = false;
            plVelX = 0;
            plVelY = -1360;
            GameWorld.sonicSetState(11);
        } else {
            int n2 = plRings;
            if (n2 > 32) {
                n2 = 32;
            }
            int n3 = 16;
            bouncingRingsCount = n2;
            lastBouncingRingPtr = (n2 - 1) * 4;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5;
                int n6;
                if (i > n3) {
                    n6 = 512;
                    n5 = i - n3;
                } else {
                    n6 = 1024;
                    n5 = i;
                }
                int n7 = (n5 >> 1) * 2250 + 1125;
                if ((i & 1) == 1) {
                    n7 = 36000 - n7;
                }
                int n8 = lut[n7 /= 100] * n6 >> 10;
                int n9 = GameWorld.cos(n7) * n6 >> 10;
                GameWorld.ringsData[n4 + 0] = plX + -128;
                GameWorld.ringsData[n4 + 1] = plY + -1920 - 512;
                GameWorld.ringsData[n4 + 2] = n8;
                GameWorld.ringsData[n4 + 3] = -n9;
                n4 += 4;
            }
            bouncingRingsTicks = 60;
            plPlatform = -1;
            GameWorld.setRings(0);
            plInvincible = true;
            plInvincibilityTimer = 70;
            plVelX = -512 * plFacing;
            plVelY = -1024;
            GameWorld.sonicSetFacing(plFacing * -1);
            GameWorld.sonicSetState(10);
        }
        Device.vibrate(1000);
    }

    private static int getTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 >= maxTileY) {
            return -2;
        }
        if (n >= maxTileX) {
            return GameWorld.getTile(n - 2, n2);
        }
        int n3 = n >> 3;
        int n4 = n2 >> 3;
        int n5 = n3 + actWidth * n4;
        int n6 = map[n5] << 5;
        int n7 = (n -= n3 << 3) & 1;
        int n8 = n6 + (n >> 1) + ((n2 -= n4 << 3) << 2);
        short s = blocks[n8];
        int n9 = -1;
        if (s >= 0) {
            if ((s << 1) + n7 >= metaTiles.length) {
                return -1;
            }
            n9 = metaTiles[(s << 1) + n7];
            if (n9 == 255) {
                n9 = -1;
            }
            if (n9 == 127) {
                n9 = -1;
            }
        }
        return n9;
    }

    private static int getTileType(int n) {
        int n2 = n;
        if (n2 >= tileTypes.length) {
            n2 = -1;
        } else if (n >= 0) {
            n2 = tileTypes[n];
        }
        return n2;
    }

    private static boolean hasType(int n) {
        return n >= 0 && n < tileTypes.length && tileTypes[n] >= 0;
    }

    private static boolean canCrossTiles(int n, int n2) {
        return true;
    }

    private static int checkTileHit(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = -1;
        int n6 = -1;
        if (n4 >= 0 && (n5 = GameWorld.checkTileHit(n += n3, n2 += n4, n3, n4, 1, bl)) == 0) {
            return 0;
        }
        if (n4 <= 0 && (n6 = GameWorld.checkTileHit(n, n2, n3, n4, 0, bl)) == 0) {
            return 0;
        }
        return n5;
    }

    private static int checkTileHit(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8 = n >> 7;
        int n9 = n2 >> 7;
        if (n5 == 0) {
            n9 = n4 == 0 ? (n9 -= 7) : (n9 -= 15);
        }
        int n10 = n8 >> 4;
        int n11 = n9 >> 4;
        int n12 = n8 - (n10 << 4);
        int n13 = n9 - (n11 << 4);
        int n14 = GameWorld.getTile(n10, n11);
        int n15 = GameWorld.getTileType(n14);
        int n16 = -1;
        if (bl && n5 == 1 && n15 == -1) {
            if (n13 == 0) {
                n7 = GameWorld.getTile(n10, n11 - 1);
                n6 = GameWorld.getTileType(n7);
                if (n6 >= 0 && n6 < 19 && tileFloorOffsets[n7] >= 0) {
                    n14 = n7;
                    n15 = n6;
                    n13 += 16;
                }
            } else {
                n7 = GameWorld.getTile(n10, n11 + 1);
                n6 = GameWorld.getTileType(n7);
                if (n6 >= 0 && n6 < 19 && tileFloorOffsets[n7] <= 0) {
                    n14 = n7;
                    n15 = n6;
                    n13 -= 16;
                }
            }
        }
        if (n15 == -2) {
            n16 = 0;
        } else if (n15 != -1 && n15 < 19) {
            n7 = DeviceConstants.FLOOR_MAPS[n15][n12] + tileFloorOffsets[n14];
            if (bl) {
                n6 = GameWorld.getTile(n10, n11 - 1);
                int n17 = GameWorld.getTileType(n6);
                if (n17 != -1) {
                    return 0;
                }
                if (n5 == 1) {
                    n16 = n13 <= n7 + 6 ? 1 : 0;
                } else if (n13 > n7) {
                    n16 = 0;
                }
            } else {
                n6 = GameWorld.getTileType(GameWorld.getTile(n10, n11 + 1));
                int n18 = GameWorld.getTileType(GameWorld.getTile(n10, n11 - 1));
                if (n18 != -1) {
                    return 0;
                }
                if (currentZone == 1 && n4 < 0 && n15 != -1) {
                    n16 = 0;
                }
                if (n5 == 1) {
                    if (n13 <= n7 + 6 && plVelY > 0) {
                        n16 = 1;
                    } else if (plVelY > 0 || n6 == 0) {
                        n16 = 0;
                    }
                }
            }
        }
        return n16;
    }

    private static void checkPlatform(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        n3 <<= 7;
        n4 <<= 7;
        switch (n2) {
            case 7: {
                n8 = 3;
                n7 = obData[n + 1];
                if (n7 == -1) {
                    n8 = 17;
                } else {
                    n6 = n7 & 3;
                    if (n7 > 0) {
                        n8 = n6;
                    }
                }
                n5 = n8 * 8 << 7;
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                n5 = PLATFORM_TYPE_WIDTHS[n2] << 7;
                break;
            }
            case 18: {
                n5 = PLATFORM_TYPE_WIDTHS[n2] << 7;
                if (currentAct == 1) {
                    n5 *= 3;
                }
                n4 += platformData[obData[n + 5] * 7 + 4];
                break;
            }
            default: {
                n5 = PLATFORM_TYPE_WIDTHS[n2] << 7;
                n8 = obData[n + 5] * 7;
                n3 += platformData[n8 + 3];
                n4 += platformData[n8 + 4];
                break;
            }
        }
        if (plX < n3 || plX >= n3 + n5) {
            return;
        }
        n8 = -1;
        if (plPrevX >= n3 && plPrevX < n3 + n5 && (n8 = GameWorld.getPlatformY(n2, plPrevX - n3)) >= 0) {
            n8 += n4;
        }
        n7 = GameWorld.getPlatformY(n2, plX - n3);
        n6 = n8 < 0 && plY <= (n7 += n4) + 1152 || plPrevY <= n8 ? 1 : 0;
        boolean bl2 = bl = plY >= n7 - 1152;
        if (n6 != 0 && bl) {
            plY = n7;
            if (plState != 5 && plState != 6) {
                plVelocity = plVelX;
            }
            plPlatform = n;
            GameWorld.camLand();
            plComboPtr = 0;
            int n9 = PLATFORM_TYPE_BEHAVIOURS[n2];
            if ((n9 == 1 || n9 == 5 || n9 == 6) && obData[n + 4] == 0) {
                GameWorld.obData[n + 4] = 1;
            }
            if (n2 == 20 || n2 == 21) {
                if (plState != 8) {
                    GameWorld.sonicSetState(8);
                }
            } else if (n2 == 16) {
                GameWorld.sonicSetState(0);
            } else {
                GameWorld.sonicSetState(5);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getPlatformY(int n, int n2) {
        block10: {
            int n3 = PLATFORM_TYPE_MAPS[n];
            if (n3 == -1) {
                if (n == 8) {
                    n = currentZone == 0 ? 3 : (currentZone == 1 ? 4 : 9);
                    break block10;
                } else {
                    if (n == 12 || n == 20) {
                        return ((PLATFORM_TYPE_WIDTHS[n] + 4 << 7) - n2) / 2;
                    }
                    if (n == 14 || n == 21) {
                        return n2 / 2;
                    }
                    if (n == 13) {
                        return (PLATFORM_TYPE_WIDTHS[n] + 8 << 7) / 4;
                    }
                    if (n != 6 && n != 4) {
                        return 0;
                    }
                    return 256;
                }
            }
            if (n == 18) {
                return tileFloorOffsets[38] << 7;
            }
            if (n == 6 || n == 4) {
                return 256;
            }
        }
        int n4 = GameWorld.getPlatformFloor(n, n2);
        if (n4 == -1) {
            return 0;
        }
        int n5 = GameWorld.getTileType(n4);
        int n6 = (n2 >>= 7) >> 4;
        int n7 = tileFloorOffsets[n4] + DeviceConstants.FLOOR_MAPS[n5][n2 -= n6 << 4];
        return n7 << 7;
    }

    private static int getPlatformFloor(int n, int n2) {
        int n3;
        int n4;
        short s;
        int n5;
        int n6;
        int n7 = PLATFORM_TYPE_MAPS[n];
        short[] sArray = platformMaps[n7];
        if (sArray == null) {
            n6 = 0;
        }
        if ((n5 = GameWorld.getTileType(s = metaTiles[(sArray[n4 = (n2 >>= 7) >> 5] << 1) + (n3 = (n6 = n2 >> 4) & 1)])) >= 0 && n5 < 19) {
            return s;
        }
        return -1;
    }

    private static int getObjectCollision(int n, int n2, int n3, int n4) {
        return GameWorld.getObjectCollisionWorld(n << 7, n2 << 7, n3 << 7, n4 << 7);
    }

    private static int getTriangleObjectCollision(int n, int n2, int n3, int n4, int n5) {
        return GameWorld.getTriangleObjectCollisionWorld(n << 7, n2 << 7, n3 << 7, n4 << 7, n5);
    }

    private static int getTriangleObjectCollisionWorld(int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        int n7 = n + n3;
        int n8 = n2 + n4;
        boolean bl = plX + 768 >= n && plX + -1152 < n7;
        boolean bl2 = plY + -128 >= n2 && plY + -1920 < n8;
        boolean bl3 = false;
        if (n5 == 0) {
            boolean bl4 = bl3 = plX + 768 - n <= plY - n2 || plX + -1152 - n < plY - n2;
        }
        if (bl && bl2 && bl3) {
            int n9 = -1;
            int n10 = plX - plPrevX;
            int n11 = plY - plPrevY;
            if (n10 > 0) {
                n9 = n + n10 - (plX + 768);
            } else if (n10 < 0) {
                n9 = plX + -1152 - (n10 + n7);
            }
            int n12 = -1;
            if (n11 > 0) {
                n12 = n2 + n11 - (plY + -128);
            } else if (n11 < 0) {
                n12 = plY + -1920 - (n11 + n8);
            }
            if (n9 >= 0 && n12 >= 0) {
                int n13;
                int n14 = n10 > 0 ? n10 : -n10;
                int n15 = n13 = n11 > 0 ? n11 : -n11;
                if (n9 * n13 > n12 * n14) {
                    n9 = -1;
                } else {
                    n12 = -1;
                }
            }
            n6 = n12 >= 0 ? (n11 > 0 ? 0 : 2) : (n9 >= 0 ? (n10 > 0 ? 3 : 1) : -2);
        }
        return n6;
    }

    private static int getObjectCollisionWorld(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = -1;
        int n6 = n + n3;
        int n7 = n2 + n4;
        boolean bl2 = plX + 768 >= n && plX + -1152 < n6;
        boolean bl3 = bl = plY + -128 >= n2 && plY + -1920 < n7;
        if (bl2 && bl) {
            int n8 = -1;
            int n9 = plX - plPrevX;
            int n10 = plY - plPrevY;
            if (n9 > 0) {
                n8 = n + n9 - (plX + 768);
            } else if (n9 < 0) {
                n8 = plX + -1152 - (n9 + n6);
            }
            int n11 = -1;
            if (n10 > 0) {
                n11 = n2 + n10 - (plY + -128);
            } else if (n10 < 0) {
                n11 = plY + -1920 - (n10 + n7);
            }
            if (n8 >= 0 && n11 >= 0) {
                int n12;
                int n13 = n9 > 0 ? n9 : -n9;
                int n14 = n12 = n10 > 0 ? n10 : -n10;
                if (n8 * n12 > n11 * n13) {
                    n8 = -1;
                } else {
                    n11 = -1;
                }
            }
            n5 = n11 >= 0 ? (n10 > 0 ? 0 : 2) : (n8 >= 0 ? (n9 > 0 ? 3 : 1) : -2);
        }
        return n5;
    }

    private static void pushCollision(int n, int n2, int n3, int n4, int n5, boolean bl) {
        n2 <<= 7;
        n3 <<= 7;
        n4 <<= 7;
        n5 <<= 7;
        switch (n) {
            case 0: {
                plY = n3 - 0;
                if (!bl) break;
                plVelY = 0;
                break;
            }
            case 1: {
                plX = n2 + n4 - -1152;
                if (!bl) break;
                plVelX = 0;
                plVelocity = 0;
                break;
            }
            case 2: {
                plY = n3 + n5 - -1920;
                plY = plPrevY;
                if (!bl) break;
                plVelY = -(plVelY - (plVelY >> 2));
                break;
            }
            case 3: {
                plX = n2 - 896;
                if (!bl) break;
                plVelX = 0;
                plVelocity = 0;
            }
        }
    }

    private static void bounceSonic() {
        if (plVelX < 0) {
            plVelX = Math.max(plVelX, -416);
        } else if (plVelX > 0) {
            plVelX = Math.min(plVelX, 416);
        }
        plVelY = -1664;
        GameWorld.sonicSetState(8);
        GameWorld.sonicFall();
    }

    private static void updateObjects() {
        int n;
        int n2;
        int n3 = camX >> 7;
        int n4 = camY >> 7;
        int n5 = endCamX >> 7;
        int n6 = endCamY >> 7;
        n4 -= 4;
        n5 += 4;
        n6 += 4;
        if ((n3 -= 4) < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 >= actWidth) {
            n5 = actWidth - 1;
        }
        if (n6 >= actHeight) {
            n6 = actHeight - 1;
        }
        for (n2 = n4; n2 <= n6; ++n2) {
            for (n = n3; n <= n5; ++n) {
                GameWorld.updateObjects(n, n2);
            }
        }
        for (n2 = 0; n2 < movingPlatformDataPtr.length; ++n2) {
            n = movingPlatformDataPtr[n2];
            byte by = obData[n + 1];
            int n7 = obData[n + 5] * 7;
            if (platformData[n7 + 2] == 0) {
                GameWorld.updatePlatform(n, by, 0, 0);
                GameWorld.platformData[n7 + 2] = 0;
                continue;
            }
            GameWorld.platformData[n7 + 2] = 0;
        }
        if (obAlwaysUpdateIndex != -1) {
            if (obData[obAlwaysUpdateIndex + 4] == 2) {
                obAlwaysUpdateIndex = -1;
            } else {
                GameWorld.updateObject(obAlwaysUpdateIndex, obData[obAlwaysUpdateIndex + 7] << 7, obData[obAlwaysUpdateIndex + 8] << 7);
            }
        }
        Animator.animate(ringAnimator);
        Animator.animate(tvAnimator);
    }

    private static void updateObjects(int n, int n2) {
        int n3 = n + n2 * actWidth;
        if (n3 >= obBlockSize.length) {
            return;
        }
        int n4 = obBlockSize[n3];
        int n5 = obBlockIndex[n3];
        n <<= 7;
        n2 <<= 7;
        int n6 = 0;
        while (n6 < n4) {
            if (n5 != obAlwaysUpdateIndex) {
                GameWorld.updateObject(n5, n, n2);
            }
            ++n6;
            n5 += 9;
        }
    }

    private static void updateObject(int n, int n2, int n3) {
        block206: {
            int n4 = (plX >> 7) + -1;
            int n5 = (plY >> 7) + -8;
            byte by = obData[n + 0];
            if (by < 0) {
                return;
            }
            int n6 = obData[n + 1];
            byte by2 = obData[n + 5];
            int n7 = n2 + (obData[n + 2] & 0xFF);
            int n8 = n3 + (obData[n + 3] & 0xFF);
            byte by3 = obData[n + 4];
            block0 : switch (by) {
                case 71: {
                    int n9 = GameWorld.getObjectCollision(n7 - 32, n8, 48, 192);
                    if (n9 == -1) break;
                    GameWorld.map[GameWorld.loopID[GameWorld.currentAct + GameWorld.currentZone * 2][n6]] = (short)(currentZone == 1 ? 93 : 17);
                    break;
                }
                case 70: {
                    int n10 = GameWorld.getObjectCollision(n7, n8, 48, 192);
                    if (n10 == -1) break;
                    GameWorld.map[GameWorld.loopID[GameWorld.currentAct + GameWorld.currentZone * 2][n6]] = (short)(currentZone == 1 ? 275 : 60);
                    break;
                }
                case 69: {
                    int n11;
                    if (plState == 10 || plState == 15 || map[loopID[currentAct + currentZone * 2][n6]] != 60 && map[loopID[currentAct + currentZone * 2][n6]] != 275 || Math.abs(plVelocity) < 512 || (n11 = GameWorld.getObjectCollision(n7, n8, 16, 16)) == -1 || n11 == 0) break;
                    GameWorld.initSonicLoop(n7, n8, -1);
                    break;
                }
                case 67: {
                    if (plState == 10 || plState == 15 || map[loopID[currentAct + currentZone * 2][n6]] != 17 && map[loopID[currentAct + currentZone * 2][n6]] != 93 || Math.abs(plVelocity) < 512) break;
                    int n12 = GameWorld.getObjectCollision(n7, n8, 16, 16);
                    if (n12 != -1 && n12 != 0) {
                        GameWorld.initSonicLoop(n7, n8, 1);
                        break;
                    }
                    if (plVelocity < 1536 || (n12 = GameWorld.getObjectCollision(n7 - 16, n8, 32, 32)) == -1 || n12 == 0) break;
                    GameWorld.initSonicLoop(n7, n8, 1);
                    break;
                }
                case 0: {
                    if (plState == 10) break;
                    n7 += 4;
                    n8 += 4;
                    if (n6 == 0) {
                        n6 = 7;
                    }
                    int n13 = n6;
                    int n14 = 1;
                    while (n13 > 0) {
                        int n15;
                        if ((n13 & 1) > 0 && (n15 = GameWorld.getMagnitude(n4 - n7, n5 - n8)) < 14) {
                            if ((n6 = (int)((byte)(n6 & ~n14))) == 0) {
                                GameWorld.obData[n + 0] = -1;
                            }
                            GameWorld.setRings(plRings + 1);
                        }
                        n13 >>= 1;
                        n14 <<= 1;
                        n7 += 12;
                    }
                    GameWorld.obData[n + 1] = n6;
                    break;
                }
                case 1: {
                    if (plState == 10) break;
                    n7 += 4;
                    n8 += 4;
                    if (n6 == 0) {
                        n6 = 7;
                    }
                    int n16 = n6;
                    int n17 = 1;
                    while (n16 > 0) {
                        int n18;
                        if ((n16 & 1) > 0 && (n18 = GameWorld.getMagnitude(n4 - n7, n5 - n8)) < 14) {
                            if ((n6 = (int)((byte)(n6 & ~n17))) == 0) {
                                GameWorld.obData[n + 0] = -1;
                            }
                            GameWorld.setRings(plRings + 1);
                        }
                        n16 >>= 1;
                        n17 <<= 1;
                        n8 += 12;
                    }
                    GameWorld.obData[n + 1] = n6;
                    break;
                }
                case 50: {
                    if (plState == 10) break;
                    if (n6 == 0) {
                        n6 = 63;
                    }
                    int n19 = n7 + 4 + 12;
                    n8 += 4;
                    int n20 = 1;
                    int n21 = 1;
                    int n22 = n6;
                    while (n22 > 0) {
                        n7 = n19 - 6 * (n20 - 1);
                        int n23 = 0;
                        while (n23 < n20) {
                            int n24;
                            if ((n22 & 1) != 0 && (n24 = GameWorld.getMagnitude(n4 - n7, n5 - n8)) < 14) {
                                if ((n6 = (int)((byte)(n6 & ~n21))) == 0) {
                                    GameWorld.obData[n + 0] = -1;
                                }
                                GameWorld.setRings(plRings + 1);
                            }
                            n21 <<= 1;
                            n22 >>= 1;
                            ++n23;
                            n7 += 12;
                        }
                        ++n20;
                        n8 += 12;
                    }
                    GameWorld.obData[n + 1] = n6;
                    break;
                }
                case 9: {
                    if (plX >> 7 > n7) {
                        GameWorld.obData[n + 4] = 1;
                    }
                    if (plState >= 7 || obData[n + 4] != 1) break;
                    GameWorld.sonicSetState(12);
                    plFacing = 1;
                    break;
                }
                case 2: {
                    if (plPlatform == n) break;
                    if (by3 == 0) {
                        int n25 = GameWorld.getObjectCollision(n7, n8, 16, 16);
                        if (n25 != -1) {
                            int n26;
                            int n27;
                            boolean bl = false;
                            if (plState == 10 || plState == 7 || plPlatform != -1) {
                                GameWorld.checkPlatform(n, 8, n7, n8);
                                break;
                            }
                            if (n25 == 0) {
                                GameWorld.bounceSonic();
                                bl = true;
                            } else if (n25 == 3 || n25 == 1) {
                                if (plState == 5) {
                                    plVelocity = 0;
                                } else if (plState == 6) {
                                    bl = true;
                                } else if (Math.abs(plVelX) > 256) {
                                    bl = true;
                                    plVelX >>= 1;
                                    plVelY = -1664;
                                }
                            } else if (n25 == 2) {
                                plVelY = -(plVelY - (plVelY >> 2));
                                n27 = (obData[n + 7] << 7) + (obData[n + 2] & 0xFF);
                                int n28 = n27 >> 4;
                                n26 = (obData[n + 8] << 7) + (obData[n + 3] & 0xFF);
                                int n29 = n26 >> 4;
                                if (GameWorld.getTile(n28, n29) == 44) {
                                    GameWorld.obData[n + 4] = 1;
                                    GameWorld.obData[n + 5] = 1;
                                    break;
                                }
                                GameWorld.obData[n + 5] = (byte)(TV_BOUNCE_PX.length - 1);
                            }
                            if (bl) {
                                GameWorld.obData[n + 4] = 3;
                                GameWorld.obData[n + 5] = 0;
                                GameWorld.tvBonus(n6);
                            } else {
                                if (n25 == -2) {
                                    n27 = Math.abs(plVelX);
                                    n25 = n27 >= (n26 = Math.abs(plVelY)) ? (n27 < 0 ? 1 : 3) : (n26 < 0 ? 2 : 0);
                                }
                                GameWorld.pushCollision(n25, n7, n8, 16, 16, false);
                            }
                        }
                        if (obData[n + 5] <= 0) break;
                        int n30 = n + 5;
                        obData[n30] = (byte)(obData[n30] - 1);
                        break;
                    }
                    if (by3 == 1) {
                        byte by4 = obData[n + 5];
                        int n31 = n + 3;
                        obData[n31] = (byte)(obData[n31] + by4);
                        int n32 = (obData[n + 7] << 7) + (obData[n + 2] & 0xFF);
                        int n33 = n32 >> 4;
                        int n34 = (obData[n + 8] << 7) + (obData[n + 3] & 0xFF);
                        int n35 = n34 >> 4;
                        int n36 = GameWorld.getTileType(GameWorld.getTile(n33, n35));
                        if (n36 >= 0 && n36 < 19) {
                            int n37 = (n35 << 4) - n3;
                            GameWorld.obData[n + 3] = (byte)(n37 - tvHeight);
                            GameWorld.obData[n + 4] = 0;
                            GameWorld.obData[n + 5] = 0;
                            break;
                        }
                        if (by4 > 8) break;
                        int n38 = n + 5;
                        obData[n38] = (byte)(obData[n38] << 1);
                        break;
                    }
                    if (by3 == 3) {
                        int n39 = n + 5;
                        obData[n39] = (byte)(obData[n39] + 2);
                        if (obData[n + 5] <= 28) break;
                        GameWorld.obData[n + 5] = 0;
                        GameWorld.obData[n + 4] = 4;
                        break;
                    }
                    if (by3 != 4) break;
                    int n40 = n + 5;
                    obData[n40] = (byte)(obData[n40] + 1);
                    if (obData[n40] <= 20) break;
                    GameWorld.obData[n + 4] = 2;
                    break;
                }
                case 3: {
                    int n41;
                    int n42;
                    if ((plSparkles || plInvincible) && plPlatform == -1) {
                        GameWorld.checkPlatform(n, 7, n7, n8);
                    }
                    if (!plSparkles && !plInvincible && plPlatform == n) {
                        GameWorld.sonicHit(3);
                        break;
                    }
                    int n43 = 3;
                    int n44 = 16;
                    if (n6 == -1) {
                        n43 = 17;
                    } else if (n6 == -2) {
                        n43 = 20;
                    } else {
                        n42 = n6 & 3;
                        if (n42 > 0) {
                            n43 = n42;
                        }
                        if ((n6 & 4) > 0) {
                            GameWorld.updatePlatform(n, n6, n7, n8);
                            n41 = obData[n + 5] * 7;
                            if (platformData[n41 + 1] == 1) break;
                            int n45 = platformData[n41 + 4] >> 7;
                            n8 += n45;
                            n44 -= n45;
                        }
                    }
                    n42 = 4 + 8 * (n43 - 1);
                    int n46 = GameWorld.getObjectCollision(n7, n8, n42, n44);
                    if (n46 == -1 || plState == 11) break;
                    int n47 = n41 = n46 == 0 || n46 == -2 ? 1 : 0;
                    if (n41 != 0) {
                        if ((n6 & 4) > 0) {
                            GameWorld.updatePlatform(n, n6, n7, n8);
                        }
                        GameWorld.sonicHit(0);
                        break;
                    }
                    if (n46 == 2) break;
                    GameWorld.pushCollision(n46, n7, n8, n42, 16, true);
                    break;
                }
                case 68: {
                    break;
                }
                case 4: {
                    int n48 = GameWorld.getObjectCollision(n7, n8, 16, 16);
                    if (n48 < 0) break;
                    int n49 = n6 >> 1 & 1;
                    int n50 = (n6 & 1) + (n6 >> 2 & 1);
                    GameWorld.pushCollision(n48, n7, n8, 16, 16, true);
                    if (n48 == 0 && n49 == 0) {
                        plVelY = n50 == 0 ? -2200 : (n50 == 1 ? -2750 : -3300);
                        GameWorld.sonicSetState(9);
                        break;
                    }
                    if (n48 != 2 || n49 != 1) break;
                    if (n50 == 0) {
                        plVelY = 2200;
                        break;
                    }
                    if (n50 == 1) {
                        plVelY = 2750;
                        break;
                    }
                    plVelY = 3300;
                    break;
                }
                case 15: {
                    int n51;
                    int n52;
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 8, n7, n8);
                    }
                    int n53 = n6 >> 1 & 1;
                    int n54 = n52 = (n6 & 1) == 0 ? 2816 : 5632;
                    if (plPlatform == -1) {
                        n51 = GameWorld.getObjectCollision(n7, n8, 8, 16);
                        if (n51 == 3 && n53 == 0) {
                            plVelocity = -n52;
                            plSprung = true;
                            GameWorld.sonicSetState(5);
                        } else if (n51 == 1 && n53 == 1) {
                            plVelocity = n52;
                            plSprung = true;
                            GameWorld.sonicSetState(5);
                        }
                    }
                    if (n53 == 0) {
                        n51 = GameWorld.getObjectCollision(n7 - 16, n8, 8, 16);
                        if (n51 != 0 && (plPlatform != n || n51 != -2)) break;
                        plVelocity = -n52;
                        plSprung = true;
                        GameWorld.sonicSetState(5);
                        break;
                    }
                    if (n53 != 1 || (n51 = GameWorld.getObjectCollision(n7 + 16, n8, 8, 16)) != 0 && (plPlatform != n || n51 != -2)) break;
                    plVelocity = n52;
                    plSprung = true;
                    GameWorld.sonicSetState(5);
                    break;
                }
                case 48: {
                    int n55 = GameWorld.getObjectCollision(n7, n8, 16, 16);
                    if (n55 < 0) break;
                    GameWorld.pushCollision(n55, n7, n8, 16, 16, true);
                    int n56 = n6 >> 1 & 1;
                    if (n55 != 0 && (n55 != 3 || n56 != 0) && (n55 != 1 || n56 != 1)) break;
                    int n57 = 2200;
                    int n58 = 2816;
                    if (n6 != 0) {
                        n57 = 2750;
                        n58 = 2816;
                    }
                    plVelY = -n57;
                    plVelX = n56 == 0 ? -n58 : n58;
                    GameWorld.sonicSetState(9);
                    break;
                }
                case 5: {
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 0, n7, n8);
                    }
                    if (plPlatform != n) break;
                    int n59 = (plX >> 7) - n7 >> 4;
                    for (int i = 7; i >= 0; --i) {
                        int n60;
                        int n61 = i - n59;
                        if (n61 < 0) {
                            n61 = -n61;
                        }
                        if ((n60 = 3 - n61) < 0) {
                            n60 = 0;
                        } else if (n60 > OB_BRIDGE_MAX_OFFSET[n59]) {
                            n60 = OB_BRIDGE_MAX_OFFSET[n59];
                        } else if (n60 > OB_BRIDGE_MAX_OFFSET[i]) {
                            n60 = OB_BRIDGE_MAX_OFFSET[i];
                        }
                        GameWorld.bridgeOffsets[i] = OB_BRIDGE_OFFSETS[n60];
                        if (i != n59) continue;
                        plPixelOy = OB_BRIDGE_OFFSETS[n60];
                    }
                    break;
                }
                case 8: {
                    int n62;
                    if (plState == 10 || plState == 11 || by3 == 1 || (n62 = GameWorld.getObjectCollision(n7, n8, 8, 26)) == -1) break;
                    plSavePoint = n;
                    plSaveTimeMillis = System.currentTimeMillis() - plTimeStartedMillis;
                    GameWorld.obData[n + 4] = 1;
                    break;
                }
                case 10: {
                    byte by5;
                    int n63;
                    if (by3 == 2 || enemyData[(n63 = (by5 = obData[n + 5]) * 12) + 0] != -1 || n7 + 16 >= camX && n7 <= endCamX && n8 + 16 >= camY && n8 <= endCamY) break;
                    GameWorld.generateEnemy(n7 << 7, n8 << 7, n63, n);
                    break;
                }
                case 7: 
                case 49: 
                case 59: 
                case 66: {
                    int n64;
                    int n65 = n64 = currentZone == 0 ? 1 : 22;
                    if (plPlatform == -1) {
                        if (by == 49) {
                            n64 = 11;
                        } else if (by == 59) {
                            n64 = 16;
                        }
                        GameWorld.checkPlatform(n, n64, n7, n8);
                    }
                    if (obData[n + 4] == 1) {
                        if (by == 7 || by == 66) {
                            GameWorld.obData[n + 4] = 3;
                        } else if (obAlwaysUpdateIndex != n && (plPlatform == -1 || plPlatform != obAlwaysUpdateIndex)) {
                            obAlwaysUpdateIndex = n;
                        }
                        GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    }
                    if (obData[n + 4] == 23) {
                        GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                        break;
                    }
                    if (obData[n + 4] < 3) break;
                    int n66 = n + 4;
                    obData[n66] = (byte)(obData[n66] + 1);
                    break;
                }
                case 24: 
                case 51: 
                case 53: {
                    if (plPlatform == -1) {
                        int n67 = obData[n + 5] * 7;
                        int n68 = platformData[n67 + 0];
                        GameWorld.checkPlatform(n, n68, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6, n7, n8);
                    break;
                }
                case 23: 
                case 52: {
                    int n69 = obData[n + 5] * 7;
                    int n70 = platformData[n69 + 0];
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, n70, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6, n7, n8);
                    if (plPlatform != -1) break;
                    GameWorld.checkPlatform(n, n70, n7, n8);
                    break;
                }
                case 60: {
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 17, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 17, n7, n8);
                    }
                    int n71 = obData[n + 5] * 7;
                    int n72 = platformData[n71 + 4];
                    int n73 = n72 >> 7;
                    n8 += n72 + GameWorld.getPlatformY(17, 0) >> 7;
                    int n74 = 0;
                    int n75 = 0;
                    n7 += n74;
                    int n76 = obData[n + 5] * 7;
                    int n77 = platformData[n76 + 0];
                    int n78 = PLATFORM_TYPE_MAPS[n77];
                    int n79 = platformWidths[n78] * 2 * 16 - (n74 + n75);
                    int n80 = platformHeights[n78] * 1 * 16;
                    int n81 = GameWorld.getObjectCollision(n7, n8, n79, n80);
                    switch (n81) {
                        case -2: {
                            if (plY > n8 + n80 << 7) {
                                if (plState >= 7) {
                                    plVelY = 224;
                                    plY = (n8 + n80 + 15 << 7) + 128;
                                    break;
                                }
                                GameWorld.sonicHit(4);
                                break;
                            }
                            GameWorld.pushCollision(0, n7, n8, n79, 48, true);
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            GameWorld.pushCollision(n81, n7, n8, n79, 48, true);
                        }
                    }
                    if (plPlatform != n) break;
                    n71 = obData[n + 5] * 7;
                    if (GameWorld.checkTileHit(plX, plY, 0, 0, 1, false) != 1 || platformData[n71 + 6] < 0) break;
                    plPlatform = -1;
                    n72 = plX >> 11;
                    n73 = plY >> 11;
                    n74 = GameWorld.getTile(n72, n73);
                    n75 = GameWorld.getTileType(n74);
                    byte[] byArray = DeviceConstants.FLOOR_MAPS[n75];
                    n77 = plX - (n72 << 11);
                    n78 = byArray[n77 >> 7] + tileFloorOffsets[n74];
                    n79 = n73 << 11;
                    plY = n79 + (n78 << 7);
                    break;
                }
                case 25: 
                case 55: {
                    int n82;
                    int n83;
                    int n84 = obData[n + 5] * 7;
                    int n85 = platformData[n84 + 0];
                    int n86 = PLATFORM_TYPE_WIDTHS[n85];
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, n85, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6, n7, n8);
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, n85, n7, n8);
                    }
                    if (plPlatform != -1) break;
                    int n87 = GameWorld.getObjectCollision(n7 += platformData[n84 + 3] >> 7, n8 += platformData[n84 + 4] >> 7, n86, 80);
                    int n88 = n83 = plState < 7 ? plVelocity : plVelX;
                    if (n83 > 0) {
                        int n89;
                        if (n87 == 3) {
                            GameWorld.pushCollision(n87, n7, n8, n86, 16, true);
                            break;
                        }
                        if (n87 != -2 || plX >= (n89 = (n7 << 7) + (n86 << 6))) break;
                        GameWorld.pushCollision(3, n7, n8, n86, 16, true);
                        break;
                    }
                    if (n83 >= 0) break;
                    if (n87 == 1) {
                        GameWorld.pushCollision(n87, n7, n8, n86, 16, true);
                        break;
                    }
                    if (n87 != -2 || plX <= (n82 = (n7 << 7) + (n86 << 6))) break;
                    GameWorld.pushCollision(1, n7, n8, n86, 16, true);
                    break;
                }
                case 54: {
                    int n90 = GameWorld.img_zoneObjects[0][1].width >> 1;
                    int n91 = n7 + n90;
                    int n92 = n8 + n90;
                    int n93 = GameWorld.img_zoneObjects[0][0].width / 4 * 3;
                    int n94 = GameWorld.getObjectCollision(n91 - n93, n92 - n93, (n93 << 1) - 2, (n93 << 1) - 2);
                    if (n94 >= 0) {
                        switch (n94) {
                            case 1: 
                            case 3: {
                                plVelX = n94 == 3 ? -832 : 832;
                                plVelY = (n5 + Engine.rnd(2) - n92) * (832 / (n90 >> 1));
                                if (plVelY < 832) {
                                    plVelY = -832;
                                    break;
                                }
                                if (plVelY <= 832) break;
                                plVelY = 832;
                                break;
                            }
                            case 0: 
                            case 2: {
                                plVelY = n94 == 0 ? -832 : 832;
                                plVelX = (n4 + Engine.rnd(2) - n91) * (832 / (n90 >> 1));
                                if (plVelX < 832) {
                                    plVelX = -832;
                                    break;
                                }
                                if (plVelX <= 832) break;
                                plVelX = 832;
                            }
                        }
                        GameWorld.obData[n + 5] = 4;
                        GameWorld.sonicSetState(9);
                        break;
                    }
                    if (obData[n + 5] <= 0) break;
                    int n95 = n + 5;
                    obData[n95] = (byte)(obData[n95] - 1);
                    break;
                }
                case 58: {
                    int n96 = n6 & 0xF;
                    int n97 = GameWorld.getObjectCollision(n7 + n96 * 22, n8, 10, 10);
                    int n98 = GameWorld.getObjectCollision(n7 + n96 * 10, n8 + 10, 22, 22);
                    int n99 = GameWorld.getObjectCollision(n7 + (1 - n96) * 22, n8 + 22, 10, 10);
                    int n100 = n97 != -1 && n97 != -2 ? n97 : (n98 != -1 && n98 != -2 ? n98 : (n99 != -1 && n99 != -2 ? n99 : n98));
                    int n101 = n6 >> 4 & 0xF;
                    if (n101 == 0) {
                        n101 = 2;
                    }
                    switch (n100) {
                        case 0: {
                            if (n96 == 0) {
                                GameWorld.sonicSetState(9);
                                plVelX = plVelY * n101;
                                plVelY = 0;
                                break;
                            }
                            if (n96 != 1) break;
                            GameWorld.sonicSetState(9);
                            plVelX = -plVelY * n101;
                            plVelY = 0;
                            break;
                        }
                        case -2: {
                            int n102 = (plY >> 7) - n8;
                            int n103 = 0;
                            if (Math.abs(plY) > Math.abs(plX)) {
                                n103 = n96 == 0 ? 1 : 3;
                            }
                            GameWorld.pushCollision(n103, n7, n8, n102, 32 - n102, false);
                            break;
                        }
                        case 1: {
                            if (n96 != 0) break;
                            GameWorld.sonicSetState(9);
                            plVelY = plVelX * n101;
                            if (plVelY > -2200) {
                                plVelY = -2200;
                            }
                            plVelX = 0;
                            break;
                        }
                        case 3: {
                            if (n96 != 1) break;
                            GameWorld.sonicSetState(9);
                            plVelY = -plVelX * n101;
                            if (plVelY > -2200) {
                                plVelY = -2200;
                            }
                            plVelX = 0;
                        }
                    }
                    break;
                }
                case 56: {
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 6, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 6, n7, n8);
                    }
                    if (plPlatform == n) break;
                    int n104 = obData[n + 5] * 7;
                    int n105 = platformData[n104 + 4];
                    int n106 = n105 >> 7;
                    int n107 = 5;
                    int n108 = 8;
                    int n109 = 32 - (n107 + n108);
                    int n110 = GameWorld.getObjectCollision(n7 += n107, n8 += n105 + GameWorld.getPlatformY(6, 0) >> 7, n109, 32);
                    switch (n110) {
                        case -2: {
                            if (plY < n8 + 32 << 7) break;
                        }
                        case 2: {
                            if (plState >= 7) {
                                plVelY = 224;
                                plY = (n8 + 32 + 15 << 7) + 128;
                                break;
                            }
                            GameWorld.sonicHit(4);
                            break;
                        }
                        case 1: 
                        case 3: {
                            GameWorld.pushCollision(n110, n7, n8, n109, 32, true);
                        }
                    }
                    break;
                }
                case 57: {
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 4, n7, n8);
                    }
                    GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    if (plPlatform == n) break;
                    int n111 = obData[n + 5] * 7;
                    int n112 = platformData[n111 + 3];
                    int n113 = n112 >> 7;
                    n7 += n113;
                    int n114 = 5;
                    int n115 = 8;
                    int n116 = 32 - (n114 + n115);
                    int n117 = GameWorld.getObjectCollision(n7 += n114, n8 += GameWorld.getPlatformY(4, 0) >> 7, n116, 32);
                    switch (n117) {
                        case -2: {
                            n117 = plX < n7 + n116 / 2 << 7 ? 3 : 1;
                        }
                        case 1: 
                        case 3: {
                            GameWorld.pushCollision(n117, n7, n8, n116, 32, true);
                            plPlatform = -1;
                            if (plState < 10 && GameWorld.getTileType(GameWorld.getTile(plX >> 11, plY + -1920 >> 11)) != -1) {
                                GameWorld.sonicHit(4);
                                break;
                            }
                            if (plState != 8 && plState != 7) {
                                int n118 = plX >> 11;
                                int n119 = plY + -1920 >> 11;
                                if (GameWorld.getTileType(GameWorld.getTile(n118, n119 + 1)) != -1) break block0;
                                plVelX = plVelocity;
                                plVelY = 224;
                                if (plState == 6) {
                                    GameWorld.sonicSetState(8);
                                    break;
                                }
                                GameWorld.sonicSetState(7);
                                break;
                            }
                            break block206;
                        }
                        case 2: {
                            GameWorld.pushCollision(2, n7, n8, n116, n116, true);
                        }
                    }
                    break;
                }
                case 61: {
                    switch (obData[n + 4]) {
                        case 0: {
                            if (GameWorld.getObjectCollision(n7, n8, GameWorld.img_zoneObjects[3][0].width, GameWorld.img_zoneObjects[3][0].height) == -1) break;
                            GameWorld.obData[n + 4] = 10;
                            GameWorld.obData[n + 1] = (byte)Math.max(8, Engine.rndPositive(20));
                            GameWorld.sonicSetState(14);
                            plX = n7 + (GameWorld.img_zoneObjects[3][0].width >> 1) - -1 << 7;
                            plY = n8 + (GameWorld.img_zoneObjects[3][0].height * 5 >> 1) - -8 << 7;
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            int n120;
                            int n121;
                            int n122 = obData[n + 5] * 3;
                            int n123 = n + 1;
                            obData[n123] = (byte)(obData[n123] - 1);
                            if (obData[n123] % 4 == 0) {
                                for (n121 = obData[n + 4] - 10; n121 < 3; ++n121) {
                                    GameWorld.obFruitData[n122 + n121] = (byte)((obFruitData[n122 + n121] + 1) % 6);
                                }
                            }
                            if (obData[n + 1] == 0 && obData[n + 4] > 10 && obData[n + 4] <= 12 && Engine.rndPositive(2) == 0 && obFruitData[n122 + (n121 = obData[n + 4] - 10)] != obFruitData[n122 + (n120 = obData[n + 4] - 10 - 1)]) {
                                int n124 = n + 1;
                                obData[n124] = (byte)(obData[n124] + 1);
                            }
                            if (obData[n + 1] != 0) break;
                            GameWorld.obData[n + 1] = (byte)Math.max(8, Engine.rndPositive(20));
                            int n125 = n + 4;
                            obData[n125] = (byte)(obData[n125] + 1);
                            break;
                        }
                        case 13: {
                            int n126 = 0;
                            int n127 = obData[n + 5] * 3;
                            block82: for (int i = 0; i < 3; ++i) {
                                switch (obFruitData[n127 + i]) {
                                    case 0: {
                                        n126 += 5;
                                        continue block82;
                                    }
                                    case 1: {
                                        n126 += 4;
                                        continue block82;
                                    }
                                    case 2: {
                                        n126 -= 5;
                                        continue block82;
                                    }
                                    case 3: {
                                        n126 += 6;
                                        continue block82;
                                    }
                                    case 5: {
                                        n126 += 3;
                                        continue block82;
                                    }
                                    case 4: {
                                        n126 += 2;
                                    }
                                }
                            }
                            if (n126 >= 18) {
                                GameWorld.setRings(plRings + 150);
                            } else if (n126 >= 15) {
                                GameWorld.setRings(plRings + 30);
                            } else if (n126 >= 12) {
                                GameWorld.setRings(plRings + 25);
                            } else if (n126 >= 9) {
                                GameWorld.setRings(plRings + 12);
                            } else if (n126 >= 6) {
                                GameWorld.setRings(plRings + 10);
                            } else if (n126 == -15) {
                                if (plRings > 100) {
                                    GameWorld.setRings(plRings - 100);
                                } else {
                                    GameWorld.setRings(0);
                                }
                            }
                            GameWorld.obData[n + 4] = 14;
                            break;
                        }
                        case 14: {
                            plVelocity = 0;
                            plVelX = 0;
                            plVelY = 0;
                            GameWorld.sonicSetState(8);
                            GameWorld.obData[n + 4] = 1;
                            break;
                        }
                        case 1: {
                            if (GameWorld.getObjectCollision(n7, n8, GameWorld.img_zoneObjects[3][0].width, GameWorld.img_zoneObjects[3][0].height) != -1) break;
                            GameWorld.obData[n + 4] = 0;
                        }
                    }
                    break;
                }
                case 62: {
                    int n128 = 0;
                    int n129 = 0;
                    int n130 = platformData[obData[n + 5] * 7 + 0];
                    int n131 = PLATFORM_TYPE_WIDTHS[n130];
                    int n132 = n131 - (n128 + n129);
                    if (currentAct == 1) {
                        n131 *= 2;
                        n132 *= 3;
                    }
                    GameWorld.checkPlatform(n, 18, n7, n8);
                    int n133 = n8 + (platformData[obData[n + 5] * 7 + 4] + GameWorld.getPlatformY(18, 0) >> 7);
                    int n134 = GameWorld.getObjectCollision(n7 += n128, n133, n132, n131);
                    GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 18, n7, n8);
                    }
                    if (!plInvincible && !plSparkles) {
                        if (!(plPlatform != n && n134 == -1 || plState == 11 && plState == 10)) {
                            GameWorld.sonicHit(0);
                        }
                    } else if ((plSparkles || plInvincible) && n134 != -1) {
                        if (n134 == -2) {
                            if (plY < n8 << 7) {
                                GameWorld.pushCollision(3, n7, n8, n132, n131, true);
                            } else {
                                GameWorld.pushCollision(0, n7, n8, n132, n131, true);
                            }
                        } else {
                            GameWorld.pushCollision(n134, n7, n8, n132, n131, true);
                        }
                    }
                    GameWorld.updatePlatform(n, n6 * 16, n7, n8);
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 18, n7, n8);
                    }
                    if (currentAct != 1 || obAlwaysUpdateIndex == n) break;
                    obAlwaysUpdateIndex = n;
                    break;
                }
                case 63: {
                    if (plPlatform == -1) {
                        GameWorld.checkPlatform(n, 19, n7, n8);
                    }
                    if (plPlatform != n) break;
                    plX += -100;
                    if (plState != 0 && plState != 1) break;
                    GameWorld.sonicOnPlatform();
                    break;
                }
                case 64: 
                case 65: {
                    switch (obData[n + 4]) {
                        case 0: {
                            int n135;
                            int n136 = n135 = by == 64 ? 20 : 21;
                            if (plPlatform == -1) {
                                GameWorld.checkPlatform(n, n135, n7, n8);
                            }
                            if (plPlatform != n) break;
                            if ((plX += by == 64 ? -100 : 100) < (n7 <<= 7) || plX > n7 + (PLATFORM_TYPE_WIDTHS[n135] << 7)) {
                                plVelX = by == 64 ? -100 : 100;
                                plVelY = 224;
                                plPlatform = -1;
                                break;
                            }
                            int n137 = plX - n7;
                            GameWorld.platformData[GameWorld.obData[n + 5] * 7 + 2] = plX - n7;
                            plY = (n8 << 7) + GameWorld.getPlatformY(n135, n137);
                            break;
                        }
                        case 1: {
                            int n138 = n + 1;
                            obData[n138] = (byte)(obData[n138] - 1);
                            if (obData[n138] != 0) break;
                            GameWorld.obData[n + 4] = 0;
                        }
                    }
                    break;
                }
                case 73: {
                    int n139;
                    if (plState != 5 && plState != 6 || (n139 = GameWorld.getObjectCollision(n7, n8, 16, 16)) != 2) break;
                    plSprung = true;
                    plVelY = -2750;
                    plVelX = 0;
                    plX -= 4;
                    GameWorld.sonicSetState(8);
                }
            }
        }
    }

    private static void updatePlatform(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        n2 = 100 * n2 / 100;
        boolean bl = false;
        boolean bl2 = false;
        int n9 = obData[n + 5] * 7;
        int n10 = platformData[n9 + 0];
        int n11 = PLATFORM_TYPE_BEHAVIOURS[n10];
        switch (n11) {
            case 5: {
                n8 = platformData[n9 + 3];
                if (n8 != (n2 <<= 7)) {
                    n7 = n2 > 0 ? 288 : -288;
                    if (n7 > 0 && (n8 += n7) > n2 || n7 < 0 && n8 < n2) {
                        n8 = n2;
                    }
                    if (plPlatform == n) {
                        plX += n8 - platformData[n9 + 3];
                        plY += Math.abs(n8 / 2) - platformData[n9 + 4];
                        n6 = n8 & 0x7F;
                        plX = plX & 0xFFFFFF80 | n6;
                    }
                    GameWorld.platformData[n9 + 3] = n8;
                    GameWorld.platformData[n9 + 4] = Math.abs(n8 / 2);
                    break;
                }
                n3 += platformData[n9 + 3] >> 7;
                n4 += platformData[n9 + 4] >> 7;
            }
            case 1: {
                int n12 = n9 + 6;
                platformData[n12] = platformData[n12] + 224;
                int n13 = n9 + 4;
                platformData[n13] = platformData[n13] + platformData[n9 + 6];
                n8 = PLATFORM_TYPE_WIDTHS[n10];
                if (n3 < camX - n8 || n3 > endCamX || n4 < camY - 16 || n4 > endCamY) {
                    n7 = (n4 << 7) + platformData[n9 + 4];
                    if (n7 >> 14 > actHeight) {
                        GameWorld.platformData[n9 + 4] = 0;
                        GameWorld.platformData[n9 + 6] = 0;
                        GameWorld.obData[n + 4] = (byte)(n11 == 1 ? 0 : 2);
                    }
                    bl = true;
                    break;
                }
                if (plPlatform != n) break;
                if (platformData[n9 + 6] > 1344) {
                    plVelY = 1344;
                    bl = true;
                    break;
                }
                plY += platformData[n9 + 6];
                break;
            }
            case 7: {
                bl2 = GameWorld.updateMovingPlatform(n3, n4, n2, n, 32, 288, 9);
                break;
            }
            case 8: {
                n7 = Math.abs((plX >> 7) - 200 - n3 >> 2);
                if (n7 >= 250) break;
                bl2 = GameWorld.updateMovingPlatform(n3, n4, n2, n, 4, 24, 6);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                bl2 = GameWorld.updateMovingPlatform(n3, n4, n2, n, 32, 288, 9);
                break;
            }
            case 4: {
                n6 = platformData[n9 + 4];
                n5 = platformData[n9 + 6];
                switch (platformData[n9 + 1]) {
                    case 0: {
                        if ((n6 += (n5 += 128)) <= 2048) break;
                        n6 = 2048;
                        GameWorld.platformData[n9 + 2] = 20;
                        GameWorld.platformData[n9 + 1] = 1;
                        break;
                    }
                    case 1: {
                        int n14 = n9 + 2;
                        platformData[n14] = platformData[n14] - 1;
                        if (platformData[n14] != 0) break;
                        n5 = 0;
                        GameWorld.platformData[n9 + 1] = 2;
                        break;
                    }
                    case 2: {
                        if ((n6 -= (n5 += 128)) > 0) break;
                        n6 = 0;
                        GameWorld.platformData[n9 + 2] = 20;
                        GameWorld.platformData[n9 + 1] = 3;
                        break;
                    }
                    case 3: {
                        int n15 = n9 + 2;
                        platformData[n15] = platformData[n15] - 1;
                        if (platformData[n15] != 0) break;
                        n5 = 0;
                        GameWorld.platformData[n9 + 1] = 0;
                    }
                }
                GameWorld.platformData[n9 + 4] = n6;
                GameWorld.platformData[n9 + 6] = n5;
                break;
            }
        }
        if (plPlatform == n) {
            if (bl2 && plState != 10) {
                n8 = n2 > 0 ? 1 : 0;
                int n16 = n7 = platformData[n9 + 1] == 1 || platformData[n9 + 1] == 2 ? 1 : 0;
                if ((n8 != 0 && n7 != 0 || n8 == 0 && n7 == 0) && GameWorld.getTileType(GameWorld.getTile(n6 = plX >> 11, n5 = plY + -1920 >> 11)) != -1) {
                    GameWorld.sonicHit(4);
                    return;
                }
            }
            if (bl) {
                plPlatform = -1;
                plVelX = plVelocity;
                GameWorld.sonicSetState(7);
                GameWorld.sonicFall();
            }
        }
    }

    private static void generateEnemy(int n, int n2, int n3, int n4) {
        int n5;
        GameWorld.enemyData[n3 + 1] = n2;
        GameWorld.enemyData[n3 + 11] = n;
        GameWorld.enemyData[n3 + 2] = n;
        GameWorld.enemyData[n3 + 3] = n2;
        GameWorld.enemyData[n3 + 0] = n5 = obData[n4 + 1];
        GameWorld.enemyData[n3 + 6] = 0;
        GameWorld.enemyData[n3 + 10] = n4;
        int n6 = Animator.createAnimator();
        switch (n5) {
            case 1: {
                GameWorld.enemyData[n3 + 5] = -1424;
                Animator.reset(n6, img_zoneEnemies[2]);
                break;
            }
            case 5: {
                GameWorld.enemyData[n3 + 4] = -600;
                int n7 = enemyData[n3 + 4] < 0 ? 4 : 0;
                Animator.reset(n6, img_zoneEnemies[n7], 3);
                break;
            }
            case 6: {
                GameWorld.enemyData[n3 + 6] = 0;
                Animator.reset(n6, img_zoneEnemies[2]);
                break;
            }
            case 7: {
                GameWorld.enemyData[n3 + 6] = 0;
                Animator.reset(n6, img_zoneEnemies[4]);
                break;
            }
            case 8: 
            case 10: {
                GameWorld.enemyData[n3 + 6] = 0;
                GameWorld.enemyData[n3 + 7] = n5 == 10 ? 12 : 14;
                int n8 = n3 + 2;
                enemyData[n8] = enemyData[n8] + (n5 == 10 ? 0 : PLATFORM_TYPE_WIDTHS[14] - GameWorld.img_zoneEnemies[8][0].width << 7);
                int n9 = n3 + 3;
                enemyData[n9] = enemyData[n9] + ((PLATFORM_TYPE_WIDTHS[14] >> 1) - GameWorld.img_zoneEnemies[8][0].height << 7);
                Animator.reset(n6, img_zoneEnemies[8], 2);
                break;
            }
            case 9: {
                GameWorld.enemyData[n3 + 4] = -128;
                Animator.reset(n6, img_zoneEnemies[0]);
            }
        }
        GameWorld.enemyData[n3 + 9] = n6;
        GameWorld.updateEnemies();
    }

    /*
     * Unable to fully structure code
     */
    private static void updateEnemies() {
        if (GameWorld.plState == 11) {
            return;
        }
lbl3:
        // 33 sources

        block13: for (var0 = 0; var0 < GameWorld.enemyData.length; var0 += 12) {
            var1_1 = GameWorld.enemyData[var0 + 0];
            if (var1_1 == -1) continue;
            var2_2 = GameWorld.enemyData[var0 + 2];
            var3_3 = GameWorld.enemyData[var0 + 3];
            var4_4 = var2_2 >> 14;
            var5_5 = var3_3 >> 14;
            var6_6 = var2_2 >> 7;
            var7_7 = var3_3 >> 7;
            var8_8 = GameWorld.plX >> 14;
            var9_9 = GameWorld.plY >> 14;
            var10_10 = var4_4 - var8_8;
            var11_11 = var5_5 - var9_9;
            if (!(Math.abs(var10_10) <= 8 && Math.abs(var11_11) <= 8 || var6_6 + 16 >= GameWorld.camX && var6_6 <= GameWorld.endCamX && var7_7 + 16 >= GameWorld.camY && var7_7 <= GameWorld.endCamY)) {
                GameWorld.removeEnemy(var0, false);
                continue;
            }
            var12_12 = GameWorld.enemyData[var0 + 9];
            var13_13 = null;
            var14_14 = Animator.frame[var12_12];
            var13_13 = Animator.frameImages[var12_12][var14_14];
            var15_15 = var13_13.width << 7;
            var16_16 = var13_13.height << 7;
            if (var1_1 != 4 && GameWorld.plState != 10 && (var17_17 = var1_1 == 5 ? GameWorld.getObjectCollision(var6_6, var7_7, 24, 16) : GameWorld.getObjectCollision(var6_6, var7_7, var13_13.width, var13_13.height)) != -1) {
                if (var1_1 == 8 || var1_1 == 10) {
                    if (!GameWorld.plInvincible && !GameWorld.plSparkles) {
                        GameWorld.sonicHit(0);
                    }
                } else if (GameWorld.plState == 8 || GameWorld.plState == 6) {
                    if (var1_1 == 9) {
                        if (var17_17 == 0) {
                            GameWorld.enemyData[var0 + 6] = 2;
                            GameWorld.enemyData[var0 + 7] = 5;
                            GameWorld.plVelY = -832;
                            GameWorld.sonicSetState(8);
                        } else if (GameWorld.enemyData[var0 + 4] < 0 && var17_17 == 3 || GameWorld.enemyData[var0 + 4] > 0 && var17_17 == 1) {
                            GameWorld.enemyData[var0 + 6] = 3;
                            GameWorld.enemyData[var0 + 7] = 5;
                            var18_18 = GameWorld.enemyData[var0 + 4] < 0 ? 2 : 3;
                            Animator.reset(var12_12, GameWorld.img_zoneEnemies[var18_18]);
                            GameWorld.plVelX = GameWorld.plVelocity < 0 ? 2816 : -2816;
                            GameWorld.plVelocity = GameWorld.plVelX;
                        } else if (var17_17 != -2) {
                            GameWorld.removeEnemy(var0 + 0, true);
                        }
                    } else {
                        if (GameWorld.plState == 8 && GameWorld.plVelY >= 0) {
                            GameWorld.bounceSonic();
                        }
                        GameWorld.removeEnemy(var0 + 0, true);
                    }
                } else if (GameWorld.plSparkles) {
                    GameWorld.removeEnemy(var0 + 0, true);
                } else if (!GameWorld.plInvincible) {
                    GameWorld.sonicHit(0);
                    return;
                }
            }
            block0 : switch (GameWorld.enemyData[var0 + 0]) {
                case 1: {
                    Animator.animate(var12_12);
                    var17_17 = GameWorld.enemyData[var0 + 3];
                    var18_18 = GameWorld.enemyData[var0 + 5];
                    var19_19 = GameWorld.enemyData[var0 + 1];
                    if (var18_18 > 0 && var17_17 > var19_19) {
                        GameWorld.enemyData[var0 + 3] = var19_19;
                        GameWorld.enemyData[var0 + 5] = -1424;
                    }
                    v0 = var0 + 5;
                    GameWorld.enemyData[v0] = GameWorld.enemyData[v0] + 112;
                    v1 = var0 + 3;
                    GameWorld.enemyData[v1] = GameWorld.enemyData[v1] + GameWorld.enemyData[var0 + 5];
                    continue block13;
                }
                case 5: {
                    if (GameWorld.enemyData[var0 + 0] == 5 && GameWorld.enemyData[var0 + 6] == 0) {
                        Animator.animate(var12_12);
                        var15_15 = var13_13.width << 7;
                        var16_16 = var13_13.height << 7;
                        v2 = var0 + 2;
                        GameWorld.enemyData[v2] = GameWorld.enemyData[v2] + GameWorld.enemyData[var0 + 4];
                        var2_2 = GameWorld.enemyData[var0 + 2];
                        var20_20 = GameWorld.enemyData[var0 + 4] < 0 ? var2_2 >> 11 : var2_2 + var15_15 - 1 >> 11;
                        if (var20_20 < 0) {
                            if (var2_2 + var15_15 >= 0) continue block13;
                            GameWorld.removeEnemy(var0, false);
                            continue block13;
                        }
                        var21_21 = var3_3 + var16_16 + 1024 >> 11;
                        var22_22 = GameWorld.getTile(var20_20, var21_21);
                        var23_23 = GameWorld.getTileType(var22_22);
                        var24_24 = 0;
                        if (GameWorld.enemyData[var0 + 0] == 5) {
                            var25_25 = GameWorld.enemyData[var0 + 11];
                            var24_24 = var25_25 + 10000 < GameWorld.enemyData[var0 + 2] || var25_25 - 10000 > GameWorld.enemyData[var0 + 2] ? 1 : 0;
                        } else {
                            v3 = var24_24 = var23_23 != 1 ? 1 : 0;
                        }
                        if (var24_24 != 0) {
                            GameWorld.enemyData[var0 + 2] = GameWorld.enemyData[var0 + 4] < 0 ? var20_20 + 1 << 11 : (var20_20 << 4) - var13_13.width << 7;
                        }
                        if (GameWorld.enemyData[var0 + 0] == 5 && ((var25_25 = GameWorld.enemyData[var0 + 2]) < GameWorld.plX + 600 && var25_25 > GameWorld.plX && GameWorld.enemyData[var0 + 4] < 0 || var25_25 > GameWorld.plX - 600 && var25_25 < GameWorld.plX && GameWorld.enemyData[var0 + 4] > 0)) {
                            GameWorld.enemyData[var0 + 7] = 0;
                            GameWorld.enemyData[var0 + 8] = 3000;
                            GameWorld.enemyData[var0 + 6] = 2;
                            continue block13;
                        }
                        if (var24_24 == 0) {
                            var25_25 = var4_4 + var5_5 * GameWorld.actWidth;
                            var26_26 = GameWorld.obBlockSize[var25_25];
                            var27_27 = GameWorld.obBlockIndex[var25_25];
                            var28_28 = var2_2 + var15_15 - 1;
                            var29_29 = GameWorld.obData[var27_27 + 8] << 7;
                            var30_30 = var7_7 + var13_13.height;
                            var31_31 = 0;
                            while (var31_31 < var26_26) {
                                v4 = var32_32 = GameWorld.obData[var27_27 + 0] == 3 || GameWorld.obData[var27_27 + 0] == 4 || GameWorld.obData[var27_27 + 0] == 15 ? 1 : 0;
                                if (var32_32 != 0) {
                                    var33_33 = var29_29 + (GameWorld.obData[var27_27 + 3] & 255);
                                    var34_34 = var33_33 + 16;
                                    v5 = var35_35 = var33_33 < var30_30 && var34_34 > var7_7;
                                    if (var35_35) {
                                        var36_36 = (var4_4 << 7) + (GameWorld.obData[var27_27 + 2] & 255) << 7;
                                        var37_37 = var36_36 + 2048;
                                        if (var2_2 < var36_36 && var28_28 > var36_36) {
                                            GameWorld.enemyData[var0 + 2] = var36_36 - var15_15;
                                            var24_24 = 1;
                                            break;
                                        }
                                        if (var2_2 < var37_37 && var28_28 > var37_37) {
                                            GameWorld.enemyData[var0 + 2] = var37_37;
                                            var24_24 = 1;
                                            break;
                                        }
                                    }
                                }
                                ++var31_31;
                                var27_27 += 9;
                            }
                        }
                        if (var24_24 == 0 || var1_1 != 5) continue block13;
                        GameWorld.enemyData[var0 + 6] = 1;
                        GameWorld.enemyData[var0 + 7] = 2;
                        continue block13;
                    }
                    if (var1_1 != 5) continue block13;
                    if (GameWorld.enemyData[var0 + 6] == 1) {
                        v6 = var0 + 7;
                        GameWorld.enemyData[v6] = GameWorld.enemyData[v6] - 1;
                        if (GameWorld.enemyData[v6] != 0) continue block13;
                        GameWorld.enemyData[var0 + 6] = 0;
                        GameWorld.enemyData[var0 + 4] = -GameWorld.enemyData[var0 + 4];
                        var20_20 = GameWorld.enemyData[var0 + 4] < 0 ? 4 : 0;
                        Animator.reset(var12_12, GameWorld.img_zoneEnemies[var20_20], 3);
                        continue block13;
                    }
                    if (GameWorld.enemyData[var0 + 6] != 2) continue block13;
                    var20_20 = GameWorld.enemyData[var0 + 4] < 0 ? 5 : 1;
                    Animator.reset(var12_12, GameWorld.img_zoneEnemies[var20_20], 4);
                    var21_21 = GameWorld.enemyData[var0 + 7];
                    var22_22 = GameWorld.enemyData[var0 + 8];
                    var23_23 = GameWorld.enemyData[var0 + 4] < 0 ? 336 : -336;
                    var21_21 += var23_23;
                    var24_24 = var3_3 + (var22_22 += Math.abs(var23_23));
                    if (var24_24 >> 7 > GameWorld.endCamY) {
                        var20_20 = GameWorld.enemyData[var0 + 4] < 0 ? 4 : 0;
                        Animator.reset(var12_12, GameWorld.img_zoneEnemies[var20_20], 4);
                        GameWorld.enemyData[var0 + 6] = 0;
                        continue block13;
                    }
                    var25_25 = GameWorld.img_zoneEnemies[6][0].width << 7;
                    var26_26 = var2_2 + (var15_15 >> 1) - var21_21 - (var25_25 >> 1);
                    if (GameWorld.getObjectCollisionWorld(var26_26, var24_24, var25_25, var25_25) != -1 && !GameWorld.plInvincible && !GameWorld.plSparkles) {
                        GameWorld.sonicHit(0);
                        continue block13;
                    }
                    GameWorld.enemyData[var0 + 7] = var21_21;
                    GameWorld.enemyData[var0 + 8] = var22_22;
                    GameWorld.bulletType = GameWorld.bulletType + 1 & 1;
                    continue block13;
                }
                case 4: {
                    Animator.animate(var12_12);
                    v7 = var0 + 5;
                    GameWorld.enemyData[v7] = GameWorld.enemyData[v7] + 224;
                    v8 = var0 + 2;
                    GameWorld.enemyData[v8] = GameWorld.enemyData[v8] + GameWorld.enemyData[var0 + 4];
                    v9 = var0 + 3;
                    GameWorld.enemyData[v9] = GameWorld.enemyData[v9] + GameWorld.enemyData[var0 + 5];
                    var2_2 = GameWorld.enemyData[var0 + 2];
                    var3_3 = GameWorld.enemyData[var0 + 3];
                    if (GameWorld.enemyData[var0 + 5] <= 0) continue block13;
                    var20_20 = var3_3 + var16_16;
                    var21_21 = var2_2 >> 11;
                    var22_22 = var20_20 >> 11;
                    var23_23 = GameWorld.getTile(var21_21, var22_22);
                    var24_24 = GameWorld.getTileType(var23_23);
                    var25_25 = var20_20 >> 7;
                    var26_26 = var25_25 - (var22_22 << 4);
                    if (var24_24 < 0 || var24_24 >= 19 || var26_26 < GameWorld.tileFloorOffsets[var23_23]) continue block13;
                    v10 = var0 + 3;
                    GameWorld.enemyData[v10] = GameWorld.enemyData[v10] - (var26_26 - GameWorld.tileFloorOffsets[var23_23] + 1 << 7);
                    GameWorld.enemyData[var0 + 4] = -592;
                    GameWorld.enemyData[var0 + 5] = -1280;
                    if (GameWorld.enemyData[var0 + 6] != 0) continue block13;
                    Animator.reset(var12_12, GameWorld.img_commonEnemies[2]);
                    continue block13;
                }
                case 6: 
                case 7: {
                    if (GameWorld.enemyData[var0 + 4] < 0) {
                        v11 = var0 + 4;
                        GameWorld.enemyData[v11] = GameWorld.enemyData[v11] - 13;
                    } else {
                        v12 = var0 + 4;
                        GameWorld.enemyData[v12] = GameWorld.enemyData[v12] + 13;
                    }
                    v13 = var0 + 2;
                    GameWorld.enemyData[v13] = GameWorld.enemyData[v13] + GameWorld.enemyData[var0 + 4];
                    var27_27 = Math.abs(GameWorld.plX - GameWorld.enemyData[var0 + 2]) >> 7;
                    var28_28 = Math.abs(GameWorld.plY - GameWorld.enemyData[var0 + 3]) >> 7;
                    if (Math.abs(GameWorld.enemyData[var0 + 2] - GameWorld.enemyData[var0 + 11]) > 1024) {
                        if (GameWorld.enemyData[var0 + 4] < 0) {
                            GameWorld.enemyData[var0 + 2] = GameWorld.enemyData[var0 + 11] - 1024;
                            GameWorld.enemyData[var0 + 4] = 13;
                            if (var1_1 == 6 && GameWorld.enemyData[var0 + 6] != 1 && var27_27 < 150 && var28_28 < 150) {
                                GameWorld.enemyData[var0 + 7] = -1024;
                                GameWorld.enemyData[var0 + 8] = var13_13.height >> 1 << 7;
                                GameWorld.enemyData[var0 + 6] = 1;
                            }
                        } else {
                            GameWorld.enemyData[var0 + 2] = GameWorld.enemyData[var0 + 11] + 1024;
                            GameWorld.enemyData[var0 + 4] = -13;
                            if (var1_1 == 7 && GameWorld.enemyData[var0 + 6] != 1 && var27_27 < 150 && var28_28 < 150) {
                                GameWorld.enemyData[var0 + 7] = 1024 + (var13_13.width << 7);
                                GameWorld.enemyData[var0 + 8] = var13_13.height >> 1 << 7;
                                GameWorld.enemyData[var0 + 6] = 1;
                            }
                        }
                    }
                    if (GameWorld.enemyData[var0 + 6] != 1) continue block13;
                    var29_29 = GameWorld.enemyData[var0 + 7];
                    var30_30 = GameWorld.enemyData[var0 + 8];
                    var29_29 += var1_1 == 7 ? 336 : -336;
                    var31_31 = var3_3 + (var30_30 += 168);
                    if (var31_31 >> 7 > GameWorld.endCamY + 42) {
                        GameWorld.enemyData[var0 + 6] = 0;
                        continue block13;
                    }
                    var32_32 = GameWorld.img_commonEnemies[0][0].width << 7;
                    var33_33 = GameWorld.enemyData[var0 + 11] + var29_29 - (var32_32 >> 1);
                    if (GameWorld.getObjectCollisionWorld(var33_33, var31_31, var32_32, var32_32) != -1 && !GameWorld.plInvincible && !GameWorld.plSparkles) {
                        GameWorld.sonicHit(0);
                        continue block13;
                    }
                    GameWorld.enemyData[var0 + 7] = var29_29;
                    GameWorld.enemyData[var0 + 8] = var30_30;
                    GameWorld.bulletType = GameWorld.bulletType + 1 & 1;
                    continue block13;
                }
                case 8: 
                case 10: {
                    Animator.animate(var12_12);
                    var27_27 = GameWorld.enemyData[var0 + 10];
                    var28_28 = GameWorld.enemyData[var0 + 7];
                    var29_29 = GameWorld.PLATFORM_TYPE_WIDTHS[var28_28] << 7;
                    var30_30 = 0;
                    if (GameWorld.plPlatform == -1) {
                        GameWorld.checkPlatform(var27_27, var28_28, GameWorld.enemyData[var0 + 11] >> 7, GameWorld.enemyData[var0 + 1] >> 7);
                        v14 = var30_30 = GameWorld.plPlatform == var27_27 ? 1 : 0;
                    }
                    if ((var31_31 = GameWorld.enemyData[var0 + 6]) != 0) {
                        v15 = var0 + 5;
                        GameWorld.enemyData[v15] = GameWorld.enemyData[v15] + 224;
                        v16 = var0 + 2;
                        GameWorld.enemyData[v16] = GameWorld.enemyData[v16] + (var31_31 == 1 ? -GameWorld.enemyData[var0 + 4] : GameWorld.enemyData[var0 + 4]);
                        v17 = var0 + 3;
                        GameWorld.enemyData[v17] = GameWorld.enemyData[v17] + GameWorld.enemyData[var0 + 5];
                        var32_32 = GameWorld.enemyData[var0 + 1] + (var29_29 >> 1) - var16_16;
                        if (GameWorld.enemyData[var0 + 3] >= var32_32) {
                            var30_30 = 0;
                            GameWorld.enemyData[var0 + 3] = var32_32;
                            if (var31_31 == 1) {
                                GameWorld.enemyData[var0 + 2] = GameWorld.enemyData[var0 + 11];
                                var28_28 = 12;
                                GameWorld.enemyData[var0 + 7] = 12;
                                var30_30 = GameWorld.plPlatform == var27_27 && GameWorld.plX - GameWorld.enemyData[var0 + 11] > GameWorld.SEESAW_LEFT_TO_X ? 1 : 0;
                            } else {
                                GameWorld.enemyData[var0 + 2] = GameWorld.enemyData[var0 + 11] + var29_29 - var15_15;
                                var28_28 = 14;
                                GameWorld.enemyData[var0 + 7] = 14;
                                v18 = var30_30 = GameWorld.plPlatform == var27_27 && GameWorld.plX - GameWorld.enemyData[var0 + 11] < GameWorld.SEESAW_RIGHT_FROM_X ? 1 : 0;
                            }
                            if (var30_30 != 0) {
                                GameWorld.sonicSetState(9);
                                GameWorld.plVelY = -Math.min(GameWorld.enemyData[var0 + 5] + 224, 3136);
                                GameWorld.plPlatform = -1;
                            }
                            var31_31 = 0;
                            GameWorld.enemyData[var0 + 6] = 0;
                        }
                    }
                    if (GameWorld.plPlatform != var27_27) continue block13;
                    var32_32 = GameWorld.plX - GameWorld.enemyData[var0 + 11];
                    GameWorld.enemyData[var0 + 7] = var32_32 <= GameWorld.SEESAW_LEFT_TO_X ? 12 : (var32_32 >= GameWorld.SEESAW_RIGHT_FROM_X ? 14 : 13);
                    if (var28_28 == GameWorld.enemyData[var0 + 7]) continue block13;
                    var28_28 = GameWorld.enemyData[var0 + 7];
                    if (var31_31 == 0 && (var28_28 == 14 && GameWorld.enemyData[var0 + 2] == GameWorld.enemyData[var0 + 11] || var28_28 == 12 && GameWorld.enemyData[var0 + 2] != GameWorld.enemyData[var0 + 11] || var28_28 == 13)) {
                        GameWorld.enemyData[var0 + 6] = GameWorld.enemyData[var0 + 2] == GameWorld.enemyData[var0 + 11] ? 2 : 1;
                        GameWorld.enemyData[var0 + 5] = var28_28 == 13 ? -2016 : -Math.min(Math.max(2016, GameWorld.plVelY + 224), 3136);
                        GameWorld.enemyData[var0 + 4] = (var29_29 - var15_15) / (-GameWorld.enemyData[var0 + 5] / 224) >> 1;
                        v19 = var0 + 2;
                        GameWorld.enemyData[v19] = GameWorld.enemyData[v19] + GameWorld.enemyData[var0 + 4];
                        v20 = var0 + 3;
                        GameWorld.enemyData[v20] = GameWorld.enemyData[v20] + GameWorld.enemyData[var0 + 5];
                    }
                    if (var30_30 == 0) continue block13;
                    GameWorld.plPlatform = -1;
                    GameWorld.checkPlatform(var27_27, GameWorld.enemyData[var0 + 7], GameWorld.enemyData[var0 + 11] >> 7, GameWorld.enemyData[var0 + 1] >> 7);
                    if (GameWorld.plPlatform != -1) continue block13;
                    if (GameWorld.plState == 6) {
                        GameWorld.sonicSetState(8);
                        continue block13;
                    }
                    GameWorld.sonicSetState(7);
                    continue block13;
                }
                case 9: {
                    switch (GameWorld.enemyData[var0 + 6]) {
                        case 0: {
                            if (GameWorld.plY != GameWorld.enemyData[var0 + 3] + var16_16 || GameWorld.plX <= GameWorld.enemyData[var0 + 2] - 2048 || GameWorld.plX >= GameWorld.enemyData[var0 + 2] + var15_15 + 2048) {
                                Animator.animate(var12_12);
                                var15_15 = var13_13.width << 7;
                                var16_16 = var13_13.height << 7;
                                v21 = var0 + 2;
                                GameWorld.enemyData[v21] = GameWorld.enemyData[v21] + GameWorld.enemyData[var0 + 4];
                                var2_2 = GameWorld.enemyData[var0 + 2];
                                var27_27 = GameWorld.enemyData[var0 + 11];
                                if (var27_27 + (4096 - var15_15) < GameWorld.enemyData[var0 + 2] || var27_27 - 4096 > GameWorld.enemyData[var0 + 2]) {
                                    if (GameWorld.enemyData[var0 + 4] < 0) {
                                        var21_21 = var2_2 >> 11;
                                        GameWorld.enemyData[var0 + 2] = var21_21 + 1 << 11;
                                    } else {
                                        var21_21 = var2_2 + var15_15 - 1 >> 11;
                                        GameWorld.enemyData[var0 + 2] = (var21_21 << 4) - var13_13.width << 7;
                                    }
                                    GameWorld.enemyData[var0 + 6] = 1;
                                    GameWorld.enemyData[var0 + 7] = 10;
                                    break block0;
                                }
                            }
                            ** GOTO lbl3
                        }
                        case 1: {
                            if (GameWorld.enemyData[var0 + 7] == 1) {
                                GameWorld.enemyData[var0 + 4] = -GameWorld.enemyData[var0 + 4];
                            }
                        }
                        case 2: 
                        case 3: {
                            v22 = var0 + 7;
                            GameWorld.enemyData[v22] = GameWorld.enemyData[v22] - 1;
                            if (GameWorld.enemyData[v22] == 0) {
                                GameWorld.enemyData[var0 + 6] = 0;
                                var27_27 = GameWorld.enemyData[var0 + 4] < 0 ? 0 : 1;
                                Animator.reset(var12_12, GameWorld.img_zoneEnemies[var27_27]);
                            } else {
                                ** GOTO lbl325
                            }
                        }
                    }
                }
            }
lbl325:
            // 6 sources

        }
    }

    private static void removeEnemy(int n, boolean bl) {
        if (bl) {
            GameWorld.obData[GameWorld.enemyData[n + 10] + 4] = 2;
            GameWorld.enemyData[n + 0] = 4;
            GameWorld.enemyData[n + 6] = 0;
            GameWorld.enemyData[n + 4] = 0;
            GameWorld.enemyData[n + 5] = -1280;
            int n2 = enemyData[n + 9];
            int n3 = Animator.frame[n2];
            DeviceImage deviceImage = Animator.frameImages[n2][n3];
            int n4 = deviceImage.width << 7;
            int n5 = deviceImage.height << 7;
            int n6 = n + 2;
            enemyData[n6] = enemyData[n6] + ((n4 >> 1) - (n4 >> 2));
            int n7 = n + 3;
            enemyData[n7] = enemyData[n7] + ((n5 >> 1) - (n5 >> 2));
            Animator.reset(n2, img_commonEnemies[1]);
            plScore += COMBO_SCORES[plComboPtr++];
            plScoreUpdated = true;
            if (plComboPtr == COMBO_SCORES.length) {
                --plComboPtr;
            }
        } else {
            GameWorld.enemyData[n + 0] = -1;
            Animator.release(enemyData[n + 9]);
        }
    }

    private static void checkForLava() {
        int n;
        int n2;
        int n3;
        if (!(plState >= 7 || currentZone != 2 || plInvincible || plState >= 7 || plPlatform != -1 || (n3 = GameWorld.getTile(n2 = plX >> 11, n = plY >> 11)) != 38 && n3 != 39)) {
            GameWorld.sonicHit(0);
        }
    }

    private static void updateBouncingRings() {
        if (--bouncingRingsTicks == 0) {
            bouncingRingsCount = 0;
            return;
        }
        int n = ringSize << 7;
        int n2 = lastBouncingRingPtr;
        for (int i = 0; i <= n2; i += 4) {
            boolean bl;
            int n3;
            int n4;
            int n5 = ringsData[i + 0];
            int n6 = ringsData[i + 1];
            if (n6 == 0) continue;
            int n7 = ringsData[i + 2];
            int n8 = ringsData[i + 3] + 112;
            int n9 = n5 + n7;
            int n10 = n6 + n8;
            if (n7 > 0) {
                n4 = n5 + n >> 11;
                n3 = n9 + n >> 11;
            } else {
                n4 = n5 >> 11;
                n3 = n9 >> 11;
            }
            int n11 = n6 + n >> 11;
            int n12 = n10 + n >> 11;
            boolean bl2 = false;
            int n13 = GameWorld.getTileType(GameWorld.getTile(n3, n12));
            if (n13 >= 0 && n13 < 19) {
                if (n12 > n11) {
                    n8 = -((n8 >> 1) + (n8 >> 2));
                    n10 = (n12 << 11) - n;
                    if (n8 < 0 && n8 > -128) {
                        bl2 = true;
                    }
                } else if (n3 > n4 && n12 == n11) {
                    n7 = -n7;
                    n9 = n5;
                } else if (n3 < n4) {
                    n7 = -n7;
                    n9 = n5;
                }
            }
            int n14 = plX + -1152 - n;
            int n15 = plX + 768;
            int n16 = plY + -1920 - n;
            int n17 = plY + -128;
            boolean bl3 = bl = bouncingRingsTicks > 45;
            if (bl2) {
                GameWorld.ringsData[i + 1] = 0;
                --bouncingRingsCount;
                continue;
            }
            if (!bl && n9 > n14 && n9 < n15 && n10 > n16 && n10 < n17) {
                GameWorld.setRings(plRings + 1);
                GameWorld.ringsData[i + 1] = 0;
                --bouncingRingsCount;
                continue;
            }
            GameWorld.ringsData[i + 0] = n9;
            GameWorld.ringsData[i + 1] = n10;
            GameWorld.ringsData[i + 2] = n7;
            GameWorld.ringsData[i + 3] = n8;
        }
    }

    private static void setRings(int n) {
        if (n > plRings) {
            plLives += n / 100 - plRings / 100;
            hud_livesUpdated = true;
        }
        plRings = n;
        hud_ringsUpdated = true;
        fillStatusArea = true;
        if (debug_invincibility) {
            plRings = 1;
        }
    }

    private static void tvBonus(int n) {
        switch (n) {
            case 0: {
                GameWorld.setRings(plRings + 10);
                break;
            }
            case 1: {
                plSparkles = true;
                plSparklesTimer = 350;
                break;
            }
            case 2: {
                plBarrier = true;
                break;
            }
            case 3: {
                ++plLives;
                hud_livesUpdated = true;
                fillStatusArea = true;
            }
        }
    }

    private static int getMagnitude(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return n2 + (5 * n >> 4);
    }

    private static void sonicLook(int n) {
        if (n == 0) {
            if (camOy <= 0 && camOy > -28) {
                camOy -= 3;
            }
        } else if (camOy >= 0 && camOy < 42) {
            camOy += 3;
        }
    }

    private static void camJump() {
        camAy = plY >> 7;
    }

    private static void camLand() {
        if (camAy != 0) {
            int n = (plY >> 7) - 57 - 16;
            camSlackOffsetY = camY - n;
            camAy = 0;
        }
    }

    private static void targetCamera() {
        if (camOy > 0 && !Engine.isPressed(2)) {
            if ((camOy -= 3) < 0) {
                camOy = 0;
            }
        } else if (camOy < 0 && !Engine.isPressed(16) && (camOy += 3) > 0) {
            camOy = 0;
        }
        if (camSlackOffsetY > 0) {
            if ((camSlackOffsetY -= 10) < 0) {
                camSlackOffsetY = 0;
            }
        } else if (camSlackOffsetY < 0 && (camSlackOffsetY += 10) > 0) {
            camSlackOffsetY = 0;
        }
        int n = 0;
        if (camAy != 0) {
            int n2 = plY >> 7;
            n = camAy - n2;
            if (n > 28) {
                n = 28;
            } else if (n < 0) {
                n = 0;
                camAy = 0;
            }
        }
        camX = (plX >> 7) - 64;
        camY = (plY >> 7) - 57 - 16 + camOy + n + camSlackOffsetY;
        if (camX < 0) {
            camX = 0;
        } else if (camX >= camLimitX) {
            camX = camLimitX - 1;
        }
        if (camY < 0) {
            camY = 0;
        } else if (camY >= camLimitY) {
            camY = camLimitY - 1;
        }
        endCamX = camX + 128 - 1;
        endCamY = camY + 115 - 1;
    }

    private static void processDebugKeys() {
    }

    private static void updateGame() {
        long l;
        if (gameState == 5) {
            levelCompleteRingBonus = plRings * 100;
            long l2 = System.currentTimeMillis() - plTimeStartedMillis;
            for (int i = 0; i < TIME_BONUS_TABLE.length; i += 2) {
                int n = TIME_BONUS_TABLE[i] * 1000;
                if (l2 >= (long)n) continue;
                levelCompleteTimeBonus = TIME_BONUS_TABLE[i + 1] * 1000;
                break;
            }
            return;
        }
        if (plInvincible && --plInvincibilityTimer == 0) {
            plInvincible = false;
        }
        if (plSparkles && --plSparklesTimer == 0) {
            plSparkles = false;
        }
        if (System.currentTimeMillis() - plTimeStartedMillis > 600000L && !plTimeOver) {
            plTimeOver = true;
            GameWorld.sonicHit(4);
            hud_timeUpdated = true;
            fillStatusArea = true;
        }
        if ((l = System.currentTimeMillis() / 900L) != lastHudUpdateTimeSecs && !plTimeOver) {
            hud_timeUpdated = true;
            fillStatusArea = true;
            lastHudUpdateTimeSecs = l;
        }
        if (plScoreUpdated) {
            int n = oldPlScore % 50000;
            int n2 = plScore % 50000;
            if (n > n2) {
                ++plLives;
                hud_livesUpdated = true;
                fillStatusArea = true;
            }
            oldPlScore = plScore;
        }
    }

    private static void update() {
        plPrevX = plX;
        plPrevY = plY;
        GameWorld.sonicUpdate();
        GameWorld.updateGame();
        if (plState == 11) {
            return;
        }
        GameWorld.updateObjects();
        GameWorld.updateEnemies();
        GameWorld.checkForLava();
        if (bouncingRingsCount > 0) {
            GameWorld.updateBouncingRings();
        }
        GameWorld.targetCamera();
    }

    public static void tick() {
        switch (gameState) {
            case 0: {
                plLives = 3;
                plScore = 0;
                oldPlScore = 0;
                plSavePoint = 0;
                plSaveTimeMillis = 0L;
            }
            case 1: {
                GameWorld.resetLevel(false);
                gameState = 6;
                break;
            }
            case 6: {
                if (System.currentTimeMillis() - zoneScrTime <= 2000L) break;
                gameState = 2;
                loading = false;
                break;
            }
            case 2: {
                Engine.gameSuspendedTimeMillis = Engine.gameSuspendedTimeMillis1;
                Engine.gameSuspendedTimeMillis1 = System.currentTimeMillis();
                if (Engine.key(128)) {
                    Engine.instance.returnFromGameWorld(true);
                    break;
                }
                GameWorld.processDebugKeys();
                GameWorld.update();
                break;
            }
            case 3: {
                GameWorld.resetLevel(true);
                gameState = 2;
                break;
            }
            case 4: {
                if (System.currentTimeMillis() - gameOverDisplayMillis <= 3000L && !Engine.key(16) && !Engine.key(32)) break;
                if (plTimeOver && plLives > 0) {
                    plTimeOver = false;
                    gameState = 3;
                    break;
                }
                gameState = 0;
                Engine.instance.returnFromGameWorld(false);
                break;
            }
            case 5: {
                if (System.currentTimeMillis() - gameOverDisplayMillis <= 3000L && !Engine.key(16) && !Engine.key(32)) break;
                Device.soundFunction(1);
                plSavePoint = 0;
                plSaveTimeMillis = 0L;
                if (currentZone == 2 && currentAct == 1 || GluGMGDemo.mDemo > 0) {
                    Engine.instance.returnFromGameWorld(false);
                    break;
                }
                plScore += levelCompleteRingBonus + levelCompleteTimeBonus;
                try {
                    zoneScrTime = System.currentTimeMillis();
                    boolean bl = false;
                    whileLoading = true;
                    if (currentAct == 1) {
                        int n = currentZone + 1;
                        GameWorld.unloadResources(1);
                        bl = GameWorld.loadLevel(n, 0, levelLoadState);
                    } else {
                        int n = currentAct + 1;
                        GameWorld.unloadResources(2);
                        bl = GameWorld.loadLevel(currentZone, n, levelLoadState);
                    }
                    whileLoading = false;
                    if (!bl) break;
                    gameState = 1;
                    GameWorld.tick();
                    break;
                }
                catch (Exception exception) {
                    Engine.debugWrite(exception.toString());
                }
            }
        }
    }

    private static int sin(int n) {
        if (n >= 360) {
            n %= 360;
        } else if (n < 0) {
            if (n < -360) {
                n %= 360;
            }
            n += 360;
        }
        return lut[n];
    }

    private static int cos(int n) {
        if ((n += 90) >= 360) {
            n %= 360;
        } else if (n < 0) {
            if (n < -360) {
                n %= 360;
            }
            n += 360;
        }
        return lut[n];
    }

    private static boolean updateMovingPlatform(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11 = obData[n4 + 5] * 7;
        int n12 = platformData[n11 + 0];
        int n13 = PLATFORM_TYPE_BEHAVIOURS[n12];
        boolean bl = false;
        n3 <<= 7;
        if (n13 == 2 || n13 == 6 || n13 == 7 || n13 == 8) {
            n10 = platformData[n11 + 4];
            n9 = platformData[n11 + 6];
        } else {
            n10 = platformData[n11 + 3];
            n9 = platformData[n11 + 5];
        }
        if (plPlatform == n4) {
            if (n13 == 3) {
                n8 = n10 & 0x7F;
                plX = plX & 0xFFFFFF80 | n8;
            } else {
                n8 = n10 & 0x7F;
                plY = plX & 0xFFFFFF80 | n8;
            }
        }
        if (n3 > 0) {
            if (platformData[n11 + 1] == 0) {
                if (n10 > n3 - n7) {
                    if ((n9 -= n5) <= 0) {
                        n9 = 0;
                        GameWorld.platformData[n11 + 1] = 1;
                    }
                } else if (n9 < n6 && (n9 += n5) > n6) {
                    n9 = n6;
                }
            } else if (n10 <= n7) {
                if ((n9 += n5) > 0) {
                    n9 = 0;
                    if (n13 != 6 || plPlatform == n4) {
                        GameWorld.platformData[n11 + 1] = 0;
                    } else if (n13 == 6 && obData[n4 + 1] > 0) {
                        GameWorld.obData[n4 + 4] = 0;
                    }
                }
            } else if (n9 > -n6 && (n9 -= n5) < -n6) {
                n9 = -n6;
            }
            if ((n10 += n9) > n3) {
                n9 = 0;
                n10 = n3;
            }
            if (n10 < 0) {
                n9 = 0;
                n10 = 0;
            }
        } else {
            if (platformData[n11 + 1] == 0) {
                if (n10 < n3 + n7) {
                    if ((n9 += n5) >= 0) {
                        n9 = 0;
                        GameWorld.platformData[n11 + 1] = 1;
                    }
                } else if (n9 > -n6 && (n9 -= n5) < -n6) {
                    n9 = -n6;
                }
            } else if (n10 >= -n7) {
                if ((n9 -= n5) < 0) {
                    n9 = 0;
                    if (n13 != 6 || plPlatform == n4) {
                        GameWorld.platformData[n11 + 1] = 0;
                    } else if (n13 == 6 && obData[n4 + 1] < 0) {
                        GameWorld.obData[n4 + 4] = 0;
                    }
                }
            } else if (n9 < n6 && (n9 += n5) > n6) {
                n9 = n6;
            }
            if ((n10 += n9) < n3) {
                n9 = 0;
                n10 = n3;
            }
            if (n10 > 0) {
                n9 = 0;
                n10 = 0;
            }
        }
        if (n13 == 2 || n13 == 6 || n13 == 7 || n13 == 8) {
            GameWorld.platformData[n11 + 4] = n10;
            GameWorld.platformData[n11 + 6] = n9;
            if (plPlatform == n4) {
                plY = (n2 << 7) + n10 + GameWorld.getPlatformY(n12, plX - (n << 7));
            }
            if (platformData[n11 + 0] == 6 || platformData[n11 + 0] == 17) {
                bl = true;
            }
        } else {
            GameWorld.platformData[n11 + 3] = n10;
            GameWorld.platformData[n11 + 5] = n9;
            if (plPlatform == n4) {
                n8 = plX + n9;
                int n14 = n9 > 0 ? 1 : -1;
                int n15 = GameWorld.checkTileHit(n8, plY, n14, 0, true);
                if (n15 == 0 || n15 == 1) {
                    plPlatform = -1;
                    if (plState == 6) {
                        GameWorld.sonicSetState(8);
                    } else {
                        GameWorld.sonicSetState(7);
                    }
                    plVelY = 0;
                    plVelX = 0;
                    GameWorld.sonicFall();
                    GameWorld.platformData[n11 + 2] = 1;
                    return bl;
                }
                plX = n8;
            }
        }
        GameWorld.platformData[n11 + 2] = 1;
        return bl;
    }

    static {
        int n;
        isLoadingFinished = false;
        gameState = 0;
        COLORS_ZONES = new int[][]{{9438, 27904}, {0x222222, 0x222222}, {2181631, 2181631}};
        MARBLE_ZONE_GROUND_LEVELS = new int[]{25, 24, 24};
        SONIC_START_LOCATION = new int[]{4, 22, 2, 22, 2, 22, 1, 46, 1, 32, 1, 54};
        SONIC_PAUSED_SPEED = 2048;
        SONIC_PHYS_INITIAL_AX = 12;
        SONIC_PHYS_MAX_SPEED = 1536;
        SONIC_PHYS_MAX_DASH_SPEED = 1792;
        SONIC_PHYS_MAX_SPRUNG_SPEED = 1792;
        FLOOR_NORMAL_X = new byte[]{0, 0, -14, -23, 14, 23, -14, 0, 14, 0, 0, -14, 14, 0, -14, -23, 0, 14, 23};
        FLOOR_NORMAL_Y = new byte[]{-32, -32, -28, -23, -28, -23, -28, -32, -28, -32, 0, -28, -28, -32, -28, -23, -32, -28, -23};
        FLOOR_ANGLE = new short[]{0, 0, 344, -1, 16, -1, 350, 350, 10, 10, 0, 338, 22, 0, 338, 354, 0, 0, 0};
        TV_BOUNCE_PX = new int[]{0, 2, 4, 6, 4, 2, 0};
        tvHeight = 0;
        PLATFORM_MAP_ZONES = new int[][]{{0, 1}, {2, 5, 7}, {3, 4, 6, 8}};
        PLATFORM_MAPS = new int[]{44, 47, 50, 59, 62, 63, 64, 51, 61};
        NUM_PLATFORMS = PLATFORM_MAPS.length;
        PLATFORM_TYPE_BEHAVIOURS = new int[]{0, 1, 2, 3, 3, 0, 2, 4, 0, 3, 2, 5, -1, -1, -1, 2, 6, 7, 8, -1, -1, -1, 1};
        PLATFORM_TYPE_MAPS = new int[]{0, 1, 1, 1, 2, -1, -1, -1, -1, 3, 3, 3, -1, -1, -1, 4, 5, 6, 8, 7, -1, -1, 3};
        PLATFORM_TYPE_WIDTHS = new int[]{128, 32, 32, 32, 32, 32, 32, -1, 16, 32, 32, 32, 48, 48, 48, 32, 16, 96, 128, 128, 24, 24, 32};
        for (int i = 0; i < DeviceConstants.FLOOR_MAPS.length; ++i) {
            byte[] byArray = DeviceConstants.FLOOR_MAPS[i];
            for (int j = 0; j < byArray.length; ++j) {
                DeviceConstants.FLOOR_MAPS[i][j] = (byte)(100 * DeviceConstants.FLOOR_MAPS[i][j] / 100);
            }
        }
        SPIKED_PLATFORM_SEGMENT_REPS = new int[]{3, 4, 4, 3};
        SMALL_SPIKED_PLATFORM_SEGMENT_REPS = new int[]{3, 3, 3, 3};
        SEESAW_LEFT_TO_X = (PLATFORM_TYPE_WIDTHS[12] << 1) / 5 << 7;
        SEESAW_RIGHT_FROM_X = (PLATFORM_TYPE_WIDTHS[14] << 7) - SEESAW_LEFT_TO_X;
        OB_BRIDGE_OFFSETS = new byte[]{0, 1, 3, 4};
        OB_BRIDGE_MAX_OFFSET = new byte[]{1, 2, 3, 3, 3, 3, 2, 1};
        bridgeOffsets = new byte[8];
        ringsData = new int[128];
        currentZone = -1;
        currentAct = -1;
        currentActState = -1;
        levelLoadState = -1;
        bgYOffset = 0;
        loopOffsetY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13, 13, 14, 16, 17, 18, 19, 21, 22, 24, 26, 28, 30, 33, 37, 37, 37, 41, 44, 46, 48, 50, 52, 53, 55, 56, 57, 58, 60, 61, 61, 62, 63, 64, 65, 65, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71, 71, 72, 72, 72, 72, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 73, 73, 72, 72, 72, 72, 71, 71, 71, 70, 70, 69, 69, 68, 68, 67, 67, 66, 65, 65, 64, 63, 62, 61, 61, 60, 58, 57, 56, 55, 53, 52, 50, 48, 46, 44, 41, 37, 37, 37, 33, 30, 28, 26, 24, 22, 21, 19, 18, 17, 16, 14, 13, 13, 12, 11, 10, 9, 9, 8, 7, 7, 6, 6, 5, 5, 4, 4, 3, 3, 3, 2, 2, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        loopOffsetX = new byte[]{-95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -7, -6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 44, 44, 44, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 6, 6, 5, 5, 4, 4, 3, 2, 1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -43, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96};
        fakeLoopIdx = 0;
        loopVelocity = 16;
        loopID = new short[][]{{60, 78, 114, 116}, {70, 123, 151, 153}, {199, 273, 282}, {60, 169, 207, 230}, {63, 288}, {29, 265, 323}};
        colx = 0;
        coly = 0;
        debug_pausedSteppingSize_ptr = 2;
        PAUSED_STEPPING_SIZES = new int[]{2048, 128, 1};
        TIME_BONUS_TABLE = new short[]{60, 50, 85, 10, 90, 5, 120, 4, 180, 3, 240, 2, Short.MAX_VALUE, 1};
        COMBO_SCORES = new short[]{100, 200, 500, 1000};
        whileLoading = false;
        lut = new short[360];
        int n2 = 57;
        int n3 = 1024 * n2;
        int n4 = 0;
        for (n = 0; n <= 90; ++n) {
            int n5 = n4 / n2;
            GameWorld.lut[n] = (short)n5;
            n4 += (n3 -= n5) / n2;
        }
        for (n = 1; n <= 90; ++n) {
            GameWorld.lut[n + 90] = lut[90 - n];
        }
        for (n = 1; n < 180; ++n) {
            GameWorld.lut[n + 180] = -lut[n];
        }
        sinData = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2249, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6156, 6293, 6428, 6560, 6691, 6820, 6946, 7071, 7193, 7313, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8191, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9510, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};
    }
}

