/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Constants;
import STH2P1_S40P1.Debug;
import STH2P1_S40P1.Engine;
import STH2P1_S40P1.ResourceMaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound
implements Debug,
Constants,
PlayerListener {
    private static Player sound_current;
    private static Player[] sounds;
    private static VolumeControl _mPlayerVolumeControl;
    public static int curSoundIndex;
    private static int[] AUDIO_FILES;
    private static boolean[] AUDIO_LOOPS;
    private static int[] SOUND_MAPPING;
    private static final int[] _VOLUME_MAP;
    private static DeviceSound instance;
    private static boolean listenerActive;

    public static void init() {
        sounds = new Player[AUDIO_FILES.length];
        for (int i = 0; i < sounds.length; ++i) {
            try {
                DeviceSound.sounds[i] = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResourceAsBytes(AUDIO_FILES[i])), (String)"audio/midi");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        listenerActive = true;
    }

    public static void update() {
        if (!(DeviceSound.isSoundPlaying() || curSoundIndex == -1 || curSoundIndex == 0 || Engine.state == 4 || Engine.state == 3 || Engine.ingamemenu || Engine.hideNotify)) {
            DeviceSound.play(curSoundIndex);
        }
    }

    public static void play(int n) {
        if (n >= SOUND_MAPPING.length) {
            return;
        }
        curSoundIndex = n;
        int n2 = SOUND_MAPPING[n];
        if (n2 == -1) {
            return;
        }
        Engine.lastSound = n;
        if (sound_current != null) {
            sound_current.deallocate();
            sound_current = null;
        }
        try {
            sound_current = sounds[n2];
            sound_current.setLoopCount(AUDIO_LOOPS[n2] ? -1 : 1);
            sound_current.start();
            _mPlayerVolumeControl = (VolumeControl)sound_current.getControl("VolumeControl");
            _mPlayerVolumeControl.setLevel(_VOLUME_MAP[Engine.soundOn]);
            if (Constants.SOUND_LINKAGE[n] != -1) {
                sounds[Constants.SOUND_LINKAGE[n]].prefetch();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Constants.SOUND_LINKAGE[curSoundIndex] != -1) {
            sound_current.addPlayerListener((PlayerListener)instance);
            listenerActive = true;
        }
    }

    public static void volumeChanged() {
        if (Engine.menuCurrent != Engine.menuInGameSettings) {
            DeviceSound.play(curSoundIndex);
        }
    }

    public static void stop() {
        if (sound_current != null) {
            sound_current.deallocate();
            sound_current = null;
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn != 0 && n != -1) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying();
        }
        return true;
    }

    public static boolean isSoundPlaying() {
        return sound_current != null && sound_current.getState() == 400;
    }

    private DeviceSound() {
    }

    public static void removeTrackListener() {
        sound_current.removePlayerListener((PlayerListener)instance);
        listenerActive = false;
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (!listenerActive) {
            return;
        }
        if (string == "endOfMedia" && Constants.SOUND_LINKAGE[curSoundIndex] != -1) {
            DeviceSound.play(Constants.SOUND_LINKAGE[curSoundIndex]);
        }
    }

    static {
        curSoundIndex = -1;
        AUDIO_FILES = new int[]{89, 90, 91, 92, 93, 94};
        AUDIO_LOOPS = new boolean[]{false, false, true, true, false, true};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 3, 4, 5};
        _VOLUME_MAP = new int[]{0, 25, 50, 100};
        instance = new DeviceSound();
    }
}

