/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Constants;
import STH2P1_S40P1.Debug;
import STH2P1_S40P1.ResourceMaster;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage
implements Constants,
Debug {
    private Image image;
    private static final int[] MANIPULATIONS = new int[]{2, 1, 6, 3, 5, 7};
    private int clip_x;
    private int clip_y;
    public short width;
    public short height;
    public byte offset_x;
    public byte offset_y;
    public byte frameWidth;
    public byte frameHeight;
    public int manipulation;
    private static long[] _gCRCTable;

    public DeviceImage(int n, String string) {
        this.createImage(ResourceMaster.getResourceAsBytes(n), string);
    }

    public DeviceImage(int n, int n2, String string) {
        if (n2 == -1) {
            this.createImage(ResourceMaster.getResourceAsBytes(n), string);
        } else {
            this.createPalettedImage(ResourceMaster.getResourceAsBytes(n), ResourceMaster.getResourceAsBytes(n2), string);
        }
    }

    public DeviceImage(int n, String string, int n2) {
        this.createImage(ResourceMaster.getResourceAsBytes(n), string);
        this.manipulation = MANIPULATIONS[n2 - 1];
    }

    public DeviceImage(byte[] byArray, String string) {
        this.createImage(byArray, string);
    }

    private void createImage(byte[] byArray, String string) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createPalettedImage(byte[] byArray, byte[] byArray2, String string) {
        try {
            int n = 0;
            while (byArray[n] != 80 || byArray[n + 1] != 76 || byArray[n + 2] != 84 || byArray[n + 3] != 69) {
                ++n;
            }
            int n2 = this.toInt(byArray, n - 4) / 3;
            int n3 = n + 4;
            System.arraycopy(byArray2, 1, byArray, n3, byArray2[0] * 3);
            long l = this.calculateCRC(byArray, n, n3 += n2 * 3);
            byArray[n3++] = (byte)(l >> 24);
            byArray[n3++] = (byte)(l >> 16);
            byArray[n3++] = (byte)(l >> 8);
            byArray[n3] = (byte)l;
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
            byArray = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4, boolean bl) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.width = deviceImage.width;
        this.height = deviceImage.height;
        this.offset_x = deviceImage.offset_x;
        this.offset_y = deviceImage.offset_y;
        this.clip_x = deviceImage.clip_x;
        this.clip_y = deviceImage.clip_y;
        this.frameWidth = deviceImage.frameWidth;
        this.frameHeight = deviceImage.frameHeight;
        this.manipulation = MANIPULATIONS[n - 1];
        this.image = deviceImage.image;
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2, true);
            }
        }
        return deviceImageArray;
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage(int n, int n2) {
        this.width = (short)n;
        this.height = (short)n2;
        this.image = Image.createImage((int)n, (int)n2);
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    public void drawImagePlainClip(Graphics graphics, int n, int n2) {
        graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n + this.offset_x, n2 + this.offset_y, 20);
    }

    public void drawImageClipStack(Graphics graphics, int n, int n2) {
        graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n + this.offset_x, n2 + this.offset_y, 20);
    }

    public void drawImageAndRestoreClip(Graphics graphics, int n, int n2) {
        graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n + this.offset_x, n2 + this.offset_y, 20);
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n - this.clip_x + this.offset_x, n2 - this.clip_y + this.offset_y, 20);
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.image, n - this.clip_x + this.offset_x, n2 - this.clip_y + this.offset_y, n3);
    }

    public void manipulateOffsets() {
        switch (this.manipulation) {
            case 2: {
                this.offset_x = (byte)(this.frameWidth - (this.width + this.offset_x));
                break;
            }
            case 1: {
                this.offset_y = -this.offset_y;
                break;
            }
            case 6: {
                this.offset_x = this.offset_y = this.offset_x;
                break;
            }
            case 3: {
                this.offset_x = (byte)(this.width - this.offset_x - 1);
                this.offset_y = (byte)(this.height - this.offset_y - 1);
                break;
            }
            case 5: {
                this.offset_y = (byte)(this.height - this.offset_x - 1);
                this.offset_x = (byte)(this.width - this.offset_y - 1);
                break;
            }
            case 7: {
                this.offset_x = (byte)(this.frameWidth - (this.width + this.offset_x));
                this.offset_y = (byte)(this.frameHeight - (this.height + this.offset_y));
            }
        }
    }

    private long calculateCRC(byte[] byArray, int n, int n2) {
        this.createCRCTable();
        long l = 0xFFFFFFFFL;
        for (int i = n; i < n2; ++i) {
            l = l >> 8 ^ _gCRCTable[(int)((l ^ (long)byArray[i]) & 0xFFL)];
        }
        this.destroyCRCTable();
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private void createCRCTable() {
        if (_gCRCTable == null) {
            _gCRCTable = new long[256];
            for (int i = 0; i < 256; ++i) {
                long l = i;
                for (int j = 0; j < 8; ++j) {
                    if ((l & 1L) == 1L) {
                        l = 0xEDB88320L ^ l >> 1;
                        continue;
                    }
                    l >>= 1;
                }
                DeviceImage._gCRCTable[i] = l;
            }
        }
    }

    private void destroyCRCTable() {
        _gCRCTable = null;
    }

    private int toInt(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF;
        n2 += (byArray[n + 2] & 0xFF) << 8;
        n2 += (byArray[n + 1] & 0xFF) << 16;
        return n2 += (byArray[n] & 0xFF) << 24;
    }
}

