/*
 * Decompiled with CFR 0.152.
 */
package engine.midlet.nokia7650;

import engine.midlet.nokia7650.ptnApp;
import engine.midlet.nokia7650.ptnGraphics;
import engine.midlet.nokia7650.ptnImage;

public abstract class ptnTileScreen {
    private ptnImage tile;
    private int tileWidth;
    private int tileHeight;
    private int renderWidth;
    private int renderHeight;
    private int renderWidthNormal;
    private int renderHeightNormal;
    private int screenAddX;
    private int screenAddY;
    private int levelWidthTable;
    private int levelShift;
    private int levelTabSize;
    private int levelWidth;
    private int levelHeight;
    private int levelWidthNormal;
    private int levelHeightNormal;
    private int positionX;
    private int positionY;
    private int positionXLow;
    private int positionYLow;
    private int speedX;
    private int speedY;
    private boolean error;
    private boolean lessX;
    private boolean lessY;
    private boolean lessAny;
    public boolean[] levelUpdate;
    public int[] levelType;
    public int[] levelMinFrame;
    public int[] levelMaxFrame;
    public int[] levelActualFrame;
    private ptnImage renderScreen;
    private ptnApp myApp;
    private ptnGraphics renderGraphics;
    private int renderDrawX;
    private int renderDrawY;

    protected ptnTileScreen() {
    }

    public void init(ptnApp ptnApp2, ptnImage ptnImage2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.myApp = ptnApp2;
        int n11 = n5;
        int n12 = n6;
        this.tile = ptnImage2;
        this.tileWidth = n;
        this.tileHeight = n2;
        this.speedX = n9;
        this.speedY = n10;
        this.error = false;
        this.lessX = false;
        this.lessY = false;
        this.lessAny = false;
        if (n3 >= n5) {
            this.lessX = true;
            n11 = n3;
        }
        if (n4 >= n6) {
            this.lessY = true;
            n12 = n4 + 1;
        }
        if (this.lessX || this.lessY) {
            this.lessAny = true;
        }
        this.renderWidth = n3 + 1;
        this.renderHeight = n4 + 1;
        this.levelWidth = n5;
        this.levelHeight = n6;
        this.renderWidthNormal = this.renderWidth * this.tileWidth;
        this.renderHeightNormal = this.renderHeight * this.tileHeight;
        this.levelWidthNormal = this.levelWidth * this.tileWidth;
        this.levelHeightNormal = this.levelHeight * this.tileHeight;
        this.levelShift = 1;
        while (this.levelShift < 16) {
            this.levelWidthTable = 1 << this.levelShift;
            if (this.levelWidthTable >= n11) break;
            ++this.levelShift;
        }
        this.levelTabSize = (1 << this.levelShift) * n12;
        n11 = this.renderWidthNormal;
        if (this.lessX) {
            n11 = this.levelWidthNormal;
        }
        n12 = this.renderHeightNormal;
        if (this.lessY) {
            n12 = this.levelHeightNormal;
        }
        this.levelUpdate = this.allocBooleanTab();
        this.levelType = this.allocIntTab();
        this.levelMinFrame = this.allocIntTab();
        this.levelMaxFrame = this.allocIntTab();
        this.levelActualFrame = this.allocIntTab();
        this.renderScreen = this.myApp.appCreateImage(n11, n12, "tileScreen");
        this.renderGraphics = this.renderScreen.getPtnGraphics();
        int n13 = 0;
        while (n13 < this.getYOffset(this.levelHeight)) {
            int n14 = 0;
            while (n14 < this.levelWidth) {
                int n15 = n14 + n13;
                this.levelUpdate[n15] = false;
                this.levelType[n15] = 0;
                this.levelMinFrame[n15] = 0;
                this.levelMaxFrame[n15] = 0;
                this.levelActualFrame[n15] = 0;
                ++n14;
            }
            n13 += this.getYOffset(1);
        }
        this.setPosition(n7, n8);
    }

    public boolean isError() {
        return this.error;
    }

    public int[] allocIntTab() {
        int[] nArray = new int[this.levelTabSize];
        if (nArray == null) {
            this.error = true;
        }
        return nArray;
    }

    public byte[] allocByteTab() {
        byte[] byArray = new byte[this.levelTabSize];
        if (byArray == null) {
            this.error = true;
        }
        return byArray;
    }

    public boolean[] allocBooleanTab() {
        boolean[] blArray = new boolean[this.levelTabSize];
        if (blArray == null) {
            this.error = true;
        }
        return blArray;
    }

    public int getOffset(int n, int n2) {
        int n3 = n + (n2 << this.levelShift);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.levelTabSize) {
            n3 = this.levelTabSize - 1;
        }
        return n3;
    }

    public int getYOffset(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.levelHeight) {
            return this.levelHeight << this.levelShift;
        }
        return n << this.levelShift;
    }

    public void setPosition(int n, int n2) {
        int n3;
        int n4 = this.renderWidth;
        int n5 = this.renderHeight;
        this.screenAddX = 0;
        this.screenAddY = 0;
        if (this.lessX) {
            n4 = this.levelWidth + 1;
            n3 = this.renderWidth - this.levelWidth - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            this.screenAddX = this.tileWidth * n3 >> 1;
        }
        if (this.lessY) {
            n5 = this.levelHeight;
            n3 = this.renderHeight - this.levelHeight - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            this.screenAddY = this.tileHeight * n3 >> 1;
        }
        this.positionX = n;
        this.positionY = n2;
        this.positionXLow = 0;
        this.positionYLow = 0;
        this.renderDrawX = 0;
        this.renderDrawY = 0;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = n7 * this.tileWidth;
                int n9 = n6 * this.tileHeight;
                this.renderGraphics.setClip(n8, n9, this.tileWidth, this.tileHeight);
                if (n7 + this.positionX < this.levelWidth && n6 + this.positionY < this.levelHeight) {
                    int n10 = this.getOffset(n7 + this.positionX, n6 + this.positionY);
                    this.renderGraphics.drawImage(this.tile, n8, n9 - this.levelActualFrame[n10]);
                }
                ++n7;
            }
            ++n6;
        }
    }

    public void setSpeedX(int n) {
        this.speedX = n;
    }

    public void setSpeedY(int n) {
        this.speedY = n;
    }

    public int getScreenAddX() {
        return this.screenAddX;
    }

    public int getScreenAddY() {
        return this.screenAddY;
    }

    public int getX() {
        return this.positionX;
    }

    public int getY() {
        return this.positionY;
    }

    public int getPositonX() {
        return this.positionX * this.tileWidth + this.positionXLow;
    }

    public int getPositonY() {
        return this.positionY * this.tileHeight + this.positionYLow;
    }

    public int getSpeedX() {
        return this.speedX;
    }

    public int getSpeedY() {
        return this.speedY;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public int getLevelWidth() {
        return this.levelWidth;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public void moveLeft() {
        if (this.lessX) {
            return;
        }
        int n = this.positionX--;
        this.positionXLow -= this.speedX;
        if (this.positionXLow < 0) {
            this.positionXLow += this.tileWidth;
            if (this.positionX < 0) {
                this.positionX = 0;
                this.positionXLow = 0;
            }
        }
        if (n != this.positionX) {
            this.renderDrawX -= this.tileWidth;
            if (this.renderDrawX < 0) {
                this.renderDrawX = this.renderWidthNormal - this.tileWidth;
            }
            int n2 = this.renderDrawX;
            int n3 = this.renderDrawY;
            int n4 = this.getOffset(this.positionX, this.positionY);
            int n5 = n4 + this.getYOffset(this.renderHeight);
            if (this.lessY) {
                n5 = n4 + this.getYOffset(this.levelHeight);
            }
            while (n4 < n5) {
                this.renderGraphics.setClip(n2, n3, this.tileWidth, this.tileHeight);
                int n6 = n3 - this.levelActualFrame[n4];
                this.renderGraphics.drawImage(this.tile, n2, n6);
                if ((n3 += this.tileHeight) >= this.renderHeightNormal) {
                    n3 = 0;
                }
                n4 += 1 << this.levelShift;
            }
        }
    }

    public void moveRight() {
        if (this.lessX) {
            return;
        }
        int n = this.positionX++;
        this.positionXLow += this.speedX;
        if (this.positionXLow > this.tileWidth) {
            this.positionXLow -= this.tileWidth;
            if (this.positionX > this.levelWidth - this.renderWidth) {
                this.positionX = this.levelWidth - this.renderWidth;
                this.positionXLow = this.tileWidth;
            }
        }
        if (n != this.positionX) {
            int n2 = this.renderDrawX;
            int n3 = this.renderDrawY;
            int n4 = this.positionX + this.renderWidth - 1 + this.getYOffset(this.positionY);
            int n5 = n4 + this.getYOffset(this.renderHeight);
            if (this.lessY) {
                n5 = n4 + this.getYOffset(this.levelHeight);
            }
            while (n4 < n5) {
                this.renderGraphics.setClip(n2, n3, this.tileWidth, this.tileHeight);
                int n6 = n3 - this.levelActualFrame[n4];
                this.renderGraphics.drawImage(this.tile, n2, n6);
                if ((n3 += this.tileHeight) >= this.renderHeightNormal) {
                    n3 = 0;
                }
                n4 += 1 << this.levelShift;
            }
            this.renderDrawX += this.tileWidth;
            if (this.renderDrawX >= this.renderWidthNormal) {
                this.renderDrawX = 0;
            }
        }
    }

    public void moveUp() {
        if (this.lessY) {
            return;
        }
        int n = this.positionY--;
        this.positionYLow -= this.speedY;
        if (this.positionYLow < 0) {
            this.positionYLow += this.tileHeight;
            if (this.positionY < 0) {
                this.positionY = 0;
                this.positionYLow = 0;
            }
        }
        if (n != this.positionY) {
            this.renderDrawY -= this.tileHeight;
            if (this.renderDrawY < 0) {
                this.renderDrawY = this.renderHeightNormal - this.tileHeight;
            }
            int n2 = this.renderDrawX;
            int n3 = this.renderDrawY;
            int n4 = this.getOffset(this.positionX, this.positionY);
            int n5 = n4 + this.renderWidth;
            if (this.lessX) {
                n5 = n4 + this.levelWidth + 1;
            }
            while (n4 < n5) {
                this.renderGraphics.setClip(n2, n3, this.tileWidth, this.tileHeight);
                int n6 = n3 - this.levelActualFrame[n4];
                this.renderGraphics.drawImage(this.tile, n2, n6);
                if ((n2 += this.tileWidth) >= this.renderWidthNormal) {
                    n2 = 0;
                }
                ++n4;
            }
        }
    }

    public void moveDown() {
        if (this.lessY) {
            return;
        }
        int n = this.positionY++;
        this.positionYLow += this.speedY;
        if (this.positionYLow > this.tileHeight) {
            this.positionYLow -= this.tileHeight;
            if (this.positionY > this.levelHeight - this.renderHeight) {
                this.positionY = this.levelHeight - this.renderHeight;
                this.positionYLow = this.tileHeight;
            }
        }
        if (n != this.positionY) {
            int n2 = this.renderDrawX;
            int n3 = this.renderDrawY;
            int n4 = this.positionX + this.getYOffset(this.positionY + this.renderHeight - 1);
            int n5 = n4 + this.renderWidth;
            if (this.lessX) {
                n5 = n4 + this.levelWidth + 1;
            }
            while (n4 < n5) {
                this.renderGraphics.setClip(n2, n3, this.tileWidth, this.tileHeight);
                int n6 = n3 - this.levelActualFrame[n4];
                this.renderGraphics.drawImage(this.tile, n2, n6);
                if ((n2 += this.tileWidth) >= this.renderWidthNormal) {
                    n2 = 0;
                }
                ++n4;
            }
            this.renderDrawY += this.tileHeight;
            if (this.renderDrawY >= this.renderHeightNormal) {
                this.renderDrawY = 0;
            }
        }
    }

    public boolean canMoveLeft() {
        return this.positionXLow > 0 || this.positionX > 0;
    }

    public boolean canMoveRight() {
        return this.positionXLow < this.tileWidth || this.positionX < this.levelWidth - this.renderWidth;
    }

    public boolean canMoveUp() {
        return this.positionYLow > 0 || this.positionY > 0;
    }

    public boolean canMoveDown() {
        return this.positionYLow < this.tileHeight || this.positionY < this.levelHeight - this.renderHeight;
    }

    private void paintLess() {
        int n = this.getOffset(this.positionX, this.positionY);
        int n2 = n + this.getYOffset(this.renderHeight);
        int n3 = this.renderWidth;
        if (this.lessX) {
            n3 = this.levelWidth;
        }
        if (this.lessY) {
            n2 = n + this.getYOffset(this.levelHeight);
        }
        int n4 = n;
        while (n4 < n2) {
            int n5 = n4;
            while (n5 < n3 + n4) {
                if (this.levelUpdate[n5]) {
                    int n6 = n5 - n4;
                    n6 *= this.tileWidth;
                    if ((n6 += this.renderDrawX) >= this.renderWidthNormal) {
                        n6 -= this.renderWidthNormal;
                    }
                    int n7 = n4 - n >> this.levelShift;
                    n7 *= this.tileHeight;
                    if ((n7 += this.renderDrawY) >= this.renderHeightNormal) {
                        n7 -= this.renderHeightNormal;
                    }
                    this.renderGraphics.setClip(n6, n7, this.tileWidth, this.tileHeight);
                    int n8 = this.levelActualFrame[n5];
                    this.renderGraphics.drawImage(this.tile, n6, n7 - n8);
                    if ((n8 += this.tileHeight) > this.levelMaxFrame[n5]) {
                        this.updateTile(n5);
                    } else {
                        this.levelActualFrame[n5] = n8;
                    }
                }
                ++n5;
            }
            n4 += this.getYOffset(1);
        }
    }

    private void paintNormal() {
        int n = this.getOffset(this.positionX, this.positionY);
        int n2 = n + this.getYOffset(this.renderHeight);
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3;
            while (n4 < this.renderWidth + n3) {
                if (this.levelUpdate[n4]) {
                    int n5 = n4 - n3;
                    n5 *= this.tileWidth;
                    if ((n5 += this.renderDrawX) >= this.renderWidthNormal) {
                        n5 -= this.renderWidthNormal;
                    }
                    int n6 = n3 - n >> this.levelShift;
                    n6 *= this.tileHeight;
                    if ((n6 += this.renderDrawY) >= this.renderHeightNormal) {
                        n6 -= this.renderHeightNormal;
                    }
                    this.renderGraphics.setClip(n5, n6, this.tileWidth, this.tileHeight);
                    int n7 = this.levelActualFrame[n4];
                    this.renderGraphics.drawImage(this.tile, n5, n6 - n7);
                    if ((n7 += this.tileHeight) > this.levelMaxFrame[n4]) {
                        this.updateTile(n4);
                    } else {
                        this.levelActualFrame[n4] = n7;
                    }
                }
                ++n4;
            }
            n3 += this.getYOffset(1);
        }
    }

    public void paint(ptnGraphics ptnGraphics2) {
        if (this.lessAny) {
            this.paintLess();
            ptnGraphics2.setClip(this.screenAddX, this.screenAddY, this.levelWidthNormal, this.levelHeightNormal);
            int n = -(this.renderDrawX + this.positionXLow) + this.screenAddX;
            int n2 = this.renderWidthNormal + n;
            int n3 = -(this.renderDrawY + this.positionYLow) + this.screenAddY;
            int n4 = this.renderHeightNormal + n3;
            ptnGraphics2.drawImage(this.renderScreen, n, n3);
            ptnGraphics2.drawImage(this.renderScreen, n2, n3);
            ptnGraphics2.drawImage(this.renderScreen, n, n4);
            ptnGraphics2.drawImage(this.renderScreen, n2, n4);
        } else {
            this.paintNormal();
            ptnGraphics2.setClip(0, 0, this.renderWidthNormal - this.tileWidth, this.renderHeightNormal - this.tileHeight);
            int n = -(this.renderDrawX + this.positionXLow);
            int n5 = this.renderWidthNormal + n;
            int n6 = -(this.renderDrawY + this.positionYLow);
            int n7 = this.renderHeightNormal + n6;
            ptnGraphics2.drawImage(this.renderScreen, n, n6);
            ptnGraphics2.drawImage(this.renderScreen, n5, n6);
            ptnGraphics2.drawImage(this.renderScreen, n, n7);
            ptnGraphics2.drawImage(this.renderScreen, n5, n7);
        }
    }

    public void paint(ptnGraphics ptnGraphics2, int n, int n2) {
        if (this.lessAny) {
            this.paintLess();
            ptnGraphics2.setClip(this.screenAddX + n, this.screenAddY + n2, this.levelWidthNormal, this.levelHeightNormal);
            int n3 = -(this.renderDrawX + this.positionXLow) + this.screenAddX;
            int n4 = this.renderWidthNormal + (n3 += n);
            int n5 = -(this.renderDrawY + this.positionYLow) + this.screenAddY;
            int n6 = this.renderHeightNormal + (n5 += n2);
            ptnGraphics2.drawImage(this.renderScreen, n3, n5);
            ptnGraphics2.drawImage(this.renderScreen, n4, n5);
            ptnGraphics2.drawImage(this.renderScreen, n3, n6);
            ptnGraphics2.drawImage(this.renderScreen, n4, n6);
        } else {
            this.paintNormal();
            ptnGraphics2.setClip(n, n2, this.renderWidthNormal - this.tileWidth, this.renderHeightNormal - this.tileHeight);
            int n7 = -(this.renderDrawX + this.positionXLow);
            int n8 = this.renderWidthNormal + (n7 += n);
            int n9 = -(this.renderDrawY + this.positionYLow);
            int n10 = this.renderHeightNormal + (n9 += n2);
            ptnGraphics2.drawImage(this.renderScreen, n7, n9);
            ptnGraphics2.drawImage(this.renderScreen, n8, n9);
            ptnGraphics2.drawImage(this.renderScreen, n7, n10);
            ptnGraphics2.drawImage(this.renderScreen, n8, n10);
        }
    }

    public abstract void updateTile(int var1);

    public abstract void createTiles();
}

