/*
 * Decompiled with CFR 0.152.
 */
package engine.midlet.nokia7650;

import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundsMedia {
    public boolean isEnabled = true;
    private static Player[] sfx;
    public short volume;
    private int playing;
    public boolean isAllowToPlay;

    public SoundsMedia() {
        sfx = new Player[8];
        this.sfxLoad(0, "/finish.mid");
        this.sfxLoad(1, "/game_over.mid");
        this.sfxLoad(2, "/main_menu.mid");
        this.sfxLoad(3, "/sfx_bonus.mid");
        this.sfxLoad(4, "/sfx_falldown.mid");
        this.sfxLoad(5, "/sfx_menu_click.mid");
        this.sfxLoad(6, "/sfx_menu_select.mid");
        this.sfxLoad(7, "/stage_complete.mid");
        this.volume = 1;
        this.playing = -1;
    }

    private void sfxLoad(int n, String string) {
        block2: {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                SoundsMedia.sfx[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                sfx[n].realize();
            }
            catch (Exception exception) {
                if (sfx[n] == null) break block2;
                sfx[n].close();
                SoundsMedia.sfx[n] = null;
            }
        }
    }

    public void dispose() {
        try {
            if (this.playing != -1) {
                this.sfxStop(this.playing);
            }
            for (int i = 0; i < sfx.length; ++i) {
                sfx[i].close();
            }
            sfx = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVolume(short s) {
        this.volume = s;
        for (int i = 0; i < sfx.length; ++i) {
            Control[] controlArray = sfx[i].getControls();
            for (int j = 0; j < controlArray.length; ++j) {
                if (!(controlArray[j] instanceof VolumeControl)) continue;
                ((VolumeControl)controlArray[j]).setLevel(s * 10);
            }
        }
    }

    public void sfxPlay(int n, int n2) {
        if (!this.isEnabled) {
            return;
        }
        try {
            if (this.playing != -1) {
                this.sfxStop(this.playing);
            }
            sfx[n].setLoopCount(n2);
            sfx[n].start();
            this.playing = n;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void sfxStop(int n) throws MediaException {
        sfx[n].stop();
        sfx[n].setMediaTime(0L);
        this.playing = -1;
    }
}

