/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.sound;

import com.anthemgames.sound.SoundPlayer;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class NokiaSoundPlayer
implements SoundPlayer {
    private Sound[] sound;
    private String[] music = new String[]{"negative1", "positive1", "title_theme1", "win1", "bell_ring", "punch", "count_midi"};

    public void playSound(String filename, String mimetype) {
        this.doPlaySound(filename, false);
    }

    public void playBackgroundSound(String filename, String mimetype) {
        this.doPlaySound(filename, true);
    }

    public void stop() {
        if (this.sound != null) {
            for (int i = 0; i < this.sound.length; ++i) {
                this.sound[i].stop();
            }
        }
    }

    private void doPlaySound(String file, boolean background) {
        if (this.sound == null) {
            this.sound = new Sound[this.music.length];
            for (int i = 0; i < this.sound.length; ++i) {
                this.sound[i] = new Sound(NokiaSoundPlayer.loadData("/" + this.music[i] + ".ott"), 1);
            }
        }
        int soundIndex = -1;
        for (int i = 0; i < this.music.length; ++i) {
            if (file != this.music[i]) continue;
            soundIndex = i;
        }
        if (soundIndex != -1) {
            this.sound[soundIndex].play(background ? 0 : 1);
        }
    }

    public static byte[] loadData(String name) {
        byte[] res = null;
        InputStream in = Thread.currentThread().getClass().getResourceAsStream(name);
        if (in != null) {
            try {
                int i;
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((i = in.read(buf)) > 0) {
                    bout.write(buf, 0, i);
                }
                res = bout.toByteArray();
                bout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }
}

