/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky.ui;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.RockyRuntime;
import com.anthemgames.rocky.ui.ConfigScreen;
import com.anthemgames.ui.TextScreen;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainScreen
extends FullCanvas {
    private static final String[] CREDITS = new String[]{"Rocky Boxing", "v" + Runtime.getMidletVersion(), "Copyright 2006,", "SkyZone", "Entertainment", "www.SkyZone", "Mobile.com", "", "Game Developers:", "Travis Jones", "Christopher", "Rumpf", "Darryl L.", "Pierce", " ", "Game Artists:", "Marco Garcia", "John Ballard", " ", "Game Producer:", "Bob Shireman", "", "Rocky (TM) & (c)", "1976-2006", "Metro-Goldwyn", "-Mayer", "Studios Inc", "All rights", "reserved", ""};
    private static final String[] HELPTEXT = new String[]{"How to play:", "1 - jab", "2 - hook", "3 - uppercut", "4 - move left", "5 - block", "6 - move right", " ", "Combo 1:", "     2, 3", "Combo 2:", "     2, 1, 2", "Combo 3:", "     1, 1, 3", "Combo 4:", "     1, 2, 2, 3", "Combo 5:", "     3, 1, 2, 1, 3", "", "To toggle sound", "while playing:", "     press '#'", "", "To select option", "in the menus:", "press OK/LSK", " ", "OK/LSK - Pause", " ", "HELP: Support@", "SkyZoneMobile.", "com"};
    private static final int PLAY = 0;
    private static final int HIGHSCORES = 1;
    private static final int HELP = 2;
    private static final int OPTIONS = 3;
    private static final int ABOUT = 4;
    private static final int EXIT = 5;
    public static boolean memoryFull = false;
    public static boolean showCredits = true;
    private static final String[] MAINMENU = new String[]{"Play", "High Scores", "Help", "Options", "About", "Exit"};
    private static final int TRAIN = 10;
    private static final int FIGHT_APOLLO = 11;
    private static final int FIGHT_CLUBBER = 12;
    private static final int FIGHT_DRAGO = 13;
    private static final int BACK = 14;
    private static int splashCount = 0;
    private static final String[] PLAYMENU = new String[]{"Train", "Apollo Creed", "Clubber Lang", "Ivan Drago", "Back"};
    private static final int CONFIRMEXIT_CONFIRM = 20;
    private static final int CONFIRMEXIT_BACK = 21;
    private static final String[] CONFIRMEXIT = new String[]{"Confirm Exit", "Back"};
    private static final int OPTIONS_LABEL = 30;
    private static final int OPTIONS_SOUNDON = 31;
    private static final int OPTIONS_SOUNDOFF = 32;
    public static final int MODE_MAINMENU = 0;
    public static final int MODE_PLAYMENU = 1;
    public static final int MODE_CONFIRMEXIT = 2;
    protected Font font = Font.getFont((int)0, (int)1, (int)0);
    protected int selection = 0;
    protected String[] items;
    private int bgcolor;
    private Image bgimage;
    private int mode;
    private boolean ignoreHideNotify = true;
    public static final int OK_BUTTON = -23;
    private Font textfont = Font.getFont((int)0, (int)1, (int)16);
    public boolean setDrawLoading = false;
    private Image offscreen;
    private Graphics primary = null;
    public static String[] splashMessage = new String[]{"SkyZone", "Entertainment"};
    private static boolean runOnce = true;

    public MainScreen(int mode) {
        this.init(mode);
    }

    private void init(int mode) {
        this.bgcolor = 0;
        switch (mode) {
            case 0: {
                this.items = MAINMENU;
                break;
            }
            case 1: {
                this.items = PLAYMENU;
                break;
            }
            case 2: {
                this.items = CONFIRMEXIT;
                this.selection = 0;
            }
        }
        this.mode = mode;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int ypos;
        int xpos;
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.bgimage != null) {
            xpos = (this.getWidth() - this.bgimage.getWidth()) / 2;
            ypos = (this.getHeight() - this.bgimage.getHeight()) / 2;
            graphics.drawImage(this.bgimage, xpos, ypos, 20);
        }
        int smallMenu = 0;
        int height = (this.font.getHeight() - smallMenu) * this.items.length;
        int width = 0;
        for (int index = 0; index < this.items.length; ++index) {
            width = this.font.stringWidth(this.items[index]) > width ? this.font.stringWidth(this.items[index]) : width;
        }
        int xoffset = (this.getWidth() - width) / 2;
        int yoffset = (this.getHeight() - height) / 2;
        graphics.setColor(0);
        graphics.fillRect(xoffset - 2, yoffset - 2, width + 4, height + 4);
        graphics.setColor(0xFF0000);
        graphics.drawRect(xoffset - 2, yoffset - 2, width + 4, height + 4);
        for (int index = 0; index < this.items.length; ++index) {
            graphics.setColor(index == this.selection ? 0xFFFF00 : 0xFFFFFF);
            graphics.drawString(this.items[index], this.getWidth() / 2, yoffset, 17);
            yoffset += this.font.getHeight() - smallMenu;
        }
        if (this.setDrawLoading) {
            this.drawLoading(graphics);
        }
        if (memoryFull) {
            this.drawMemoryCheck(graphics);
        }
        if (showCredits) {
            graphics.setColor(this.bgcolor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Font font = Font.getFont((int)64, (int)0, (int)8);
            Image copyright = Runtime.createTextImage(splashMessage, font, 0, 0xFFFFFF);
            xpos = (this.getWidth() - copyright.getWidth()) / 2;
            ypos = 5 + (this.getHeight() - copyright.getHeight()) / 2;
            graphics.drawImage(copyright, xpos, ypos, 20);
        }
    }

    private void drawMemoryCheck(Graphics graphics) {
    }

    public void keyPressed(int keycode) {
        if (memoryFull) {
            memoryFull = false;
        }
        if (RockyRuntime.ignoreKeys) {
            return;
        }
        if (keycode == -6) {
            keycode = -10;
        }
        switch (this.getGameAction(keycode)) {
            case 1: 
            case 2: {
                if (this.selection <= 0) break;
                --this.selection;
                break;
            }
            case 5: 
            case 6: {
                if (this.selection >= this.items.length - 1) break;
                ++this.selection;
                break;
            }
            case 8: {
                this.onSelection(this.selection);
                break;
            }
            default: {
                if (keycode != -23) break;
                this.onSelection(this.selection);
            }
        }
        this.repaint();
    }

    private void drawLoading(Graphics graphics) {
        int width = this.textfont.stringWidth("cargando");
        int height = this.textfont.getSize();
        int xpos = (this.getWidth() - width) / 2;
        int ypos = (this.getHeight() - height) / 2;
        graphics.setColor(0);
        graphics.fillRect(xpos - 2, ypos - 2, width + 4, height + 4);
        graphics.setColor(0xFF0000);
        graphics.drawRect(xpos - 2, ypos - 2, width + 4, height + 4);
        graphics.setColor(0xFF0000);
        graphics.drawString("Loading", this.getWidth() / 2, ypos + 2, 17);
    }

    public void onSelection(int selection) {
        if (this.mode == 1) {
            selection += 10;
        }
        if (this.mode == 2) {
            selection += 20;
        }
        Object screen = null;
        switch (selection) {
            case 0: {
                this.init(1);
                break;
            }
            case 1: {
                screen = RockyRuntime.GetTextScreen(this.getHighScores(), (Displayable)this, false, false);
                break;
            }
            case 2: {
                screen = RockyRuntime.GetTextScreen(HELPTEXT, (Displayable)this, false, false);
                break;
            }
            case 3: {
                screen = new ConfigScreen();
                break;
            }
            case 4: {
                screen = RockyRuntime.GetTextScreen(CREDITS, (Displayable)this, false);
                break;
            }
            case 5: {
                this.init(2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (this.setDrawLoading) {
                    return;
                }
                this.setDrawLoading = true;
                this.repaint();
                this.serviceRepaints();
                if (selection == 10) {
                    RockyRuntime.ignoreKeys = true;
                    screen = RockyRuntime.GetArenaScreen(0);
                    break;
                }
                RockyRuntime.ignoreKeys = true;
                screen = RockyRuntime.GetArenaScreen(2, selection == 11 ? 0 : (selection == 12 ? 1 : 2));
                break;
            }
            case 14: 
            case 21: {
                this.init(0);
                break;
            }
            case 20: {
                Runtime.exitApp();
            }
        }
        System.gc();
        if (screen != null) {
            if (screen instanceof TextScreen) {
                ((TextScreen)((Object)screen)).setUpIndicator(Runtime.loadImage("up"));
                ((TextScreen)((Object)screen)).setDownIndicator(Runtime.loadImage("down"));
            }
            Runtime.showScreen((Displayable)screen);
        }
    }

    public void showNotify() {
        this.bgimage = null;
        this.bgimage = RockyRuntime.SplashImg;
        if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
            RockyRuntime.playBackgroundSound("title_theme1", "");
        }
    }

    public void hideNotify() {
    }

    private String[] getHighScores() {
        String[] result = new String[12];
        for (int index = 0; index < 4; ++index) {
            String time;
            String string = time = index == 0 ? String.valueOf(Config.getComboPunches()) + " Punches" : "0" + String.valueOf(Config.getTime(index - 1));
            if (index != 0) {
                time = "0:" + time.substring(time.length() - 2) + " Round " + String.valueOf(Config.getRound(index - 1));
            }
            String name = "";
            switch (index) {
                case 0: {
                    name = "Training Combo";
                    break;
                }
                case 1: {
                    name = "Apollo Creed";
                    break;
                }
                case 2: {
                    name = "Clubber Lang";
                    break;
                }
                case 3: {
                    name = "Ivan Drago";
                }
            }
            result[index * 3 + 0] = name + ":";
            result[index * 3 + 1] = "  " + time;
            result[index * 3 + 2] = " ";
        }
        return result;
    }
}

