/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky;

import com.anthemgames.Runtime;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Config {
    public static final int STARTER = 0;
    public static final int BEAT_APOLLO = 1;
    public static final int BEAT_CLUBBER = 2;
    public static final int BEAT_DRAGO = 3;
    private static int combopunches = 0;
    private static int[] rounds = new int[4];
    private static int[] times = new int[4];
    private static int difficulty = -1;
    private static boolean sound = true;
    private static boolean vibrate = false;
    private static int level = 0;
    private static final String STORENAME = "RockyConfig";

    private Config() {
    }

    public static void addScore(int npc, int round, int time) {
        if (round < rounds[npc] || round == rounds[npc] && time < times[npc] || rounds[npc] == 0 && times[npc] == 0) {
            Config.rounds[npc] = round;
            Config.times[npc] = time;
        }
        Config.setLevel(npc + 1);
        Config.save();
    }

    public static int getComboPunches() {
        return combopunches;
    }

    public static void setComboPunches(int combopunches) {
        if (combopunches > Config.combopunches) {
            Config.combopunches = combopunches;
            Config.save();
        }
    }

    public static int getTime(int npc) {
        return times[npc];
    }

    public static int getRound(int npc) {
        return rounds[npc];
    }

    public static void toggleSound(boolean sound) {
        Config.sound = sound;
        Config.save();
    }

    public static boolean playSound() {
        return sound;
    }

    public static void toggleVibrate(boolean vibrate) {
        Config.vibrate = vibrate;
        Config.save();
    }

    public static boolean vibrate() {
        return vibrate;
    }

    public static void setLevel(int level) {
        if (Config.level < level) {
            Config.level = level;
        }
        Config.save();
    }

    public static int getLevel() {
        return level;
    }

    public static String getLevelText() {
        return level == -1 ? "Beginner" : "Level " + String.valueOf(level + 1);
    }

    private static void load() {
        try {
            InputStream istream = Runtime.loadData(STORENAME);
            if (istream != null) {
                DataInputStream input = new DataInputStream(istream);
                combopunches = input.readInt();
                for (int index = 0; index < rounds.length; ++index) {
                    Config.rounds[index] = input.readInt();
                    Config.times[index] = input.readInt();
                }
                sound = input.readBoolean();
                vibrate = input.readBoolean();
                level = input.readInt();
            }
        }
        catch (IOException error) {
            Runtime.handleError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        try {
            output.writeInt(combopunches);
            for (int index = 0; index < rounds.length; ++index) {
                output.writeInt(rounds[index]);
                output.writeInt(times[index]);
            }
            output.writeBoolean(sound);
            output.writeBoolean(vibrate);
            output.writeInt(level);
            Runtime.saveData(STORENAME, baos.toByteArray(), true);
        }
        catch (IOException error) {
            Runtime.handleError(error);
        }
        finally {
            try {
                output.close();
                baos.close();
            }
            catch (IOException error) {
                Runtime.handleError(error);
            }
        }
    }

    static {
        Config.load();
    }
}

