/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.ui;

import com.anthemgames.Runtime;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextScreen
extends FullCanvas {
    private int topline = 0;
    private int maxheight = -1;
    private int bgcolor = 0;
    private int fgcolor = 0xFFFF00;
    private Font font = Font.getDefaultFont();
    private boolean adjusted = false;
    private boolean paragraphs = true;
    private boolean centered = true;
    private Image upindicator = null;
    private Image dnindicator = null;
    public static final int OK_BUTTON = -23;
    private String[] text;
    private Displayable nextscreen;

    public TextScreen(String[] text, Displayable nextscreen) {
        this.text = text;
        this.nextscreen = nextscreen;
    }

    public TextScreen(String[] text, Displayable nextscreen, boolean paragraphs) {
        this(text, nextscreen);
        this.paragraphs = paragraphs;
    }

    public TextScreen(String[] text, Displayable nextscreen, boolean paragraphs, boolean centered) {
        this(text, nextscreen, paragraphs);
        this.centered = false;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setUpIndicator(Image upindicator) {
        this.upindicator = upindicator;
    }

    public void setDownIndicator(Image dnindicator) {
        this.dnindicator = dnindicator;
    }

    public void paint(Graphics graphics) {
        if (this.maxheight == -1) {
            this.maxheight = this.getHeight();
        }
        if (!this.adjusted) {
            this.text = Runtime.breakUpLines(this.font, this.text, this.getWidth(), this.paragraphs);
            this.adjusted = true;
        }
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.topline > 0 && this.upindicator != null) {
            graphics.drawImage(this.upindicator, this.getWidth() - 1, 0, 24);
        }
        if (this.font.getHeight() * (this.text.length - this.topline) > this.maxheight && this.dnindicator != null) {
            graphics.drawImage(this.dnindicator, this.getWidth() - 1, this.getHeight() - 1, 40);
        }
        graphics.setColor(this.fgcolor);
        graphics.setFont(this.font);
        boolean done = false;
        int line = this.topline;
        int ypos = 0;
        while (!done) {
            String thisline = this.text[line++];
            int xpos = this.centered ? (this.getWidth() - this.font.stringWidth(thisline)) / 2 : 1;
            graphics.drawString(thisline, xpos, ypos, 20);
            done = line >= this.text.length || (ypos += this.font.getHeight()) + this.font.getHeight() > this.getHeight();
        }
    }

    public void keyPressed(int keycode) {
        if (keycode == -6 || keycode == -7) {
            keycode = -10;
        }
        switch (this.getGameAction(keycode)) {
            case 1: {
                if (this.topline > 0) {
                    --this.topline;
                }
                this.repaint();
                break;
            }
            case 6: {
                if (this.topline < this.text.length - 1 && this.font.getHeight() * (this.text.length - this.topline) > this.maxheight) {
                    ++this.topline;
                }
                this.repaint();
                break;
            }
            case 8: {
                Runtime.showScreen(this.nextscreen);
                break;
            }
            default: {
                if (keycode != -23) break;
                Runtime.showScreen(this.nextscreen);
            }
        }
    }
}

