/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky.ui;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.RockyRuntime;
import com.anthemgames.rocky.players.Boxer;
import com.anthemgames.rocky.ui.Arena;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ComboTrainer {
    private int[] combo = new int[50];
    private int combo_index = 0;
    private int combo_top = 2;
    public boolean restart = true;
    public boolean painted = false;
    private Image numbers = Runtime.loadImage("numbers");
    private Image go = Runtime.loadImage("go");
    private int mistakes = 0;
    private int successes = 0;
    public boolean finished = true;
    private int number;
    private Arena arena;
    private Boxer boxer;
    public StopThread thread = null;

    public ComboTrainer(Arena arena, Boxer boxer) {
        this.arena = arena;
        this.boxer = boxer;
        Random random = new Random();
        for (int index = 0; index < this.combo.length; ++index) {
            this.combo[index] = Math.abs(random.nextInt() % 3) + 1;
        }
    }

    public void ComboRestart() {
        this.combo = new int[50];
        this.combo_index = 0;
        this.combo_top = 2;
        this.restart = true;
        this.painted = false;
        this.mistakes = 0;
        this.successes = 0;
        this.finished = true;
        Object thread = null;
        Random random = new Random();
        for (int index = 0; index < this.combo.length; ++index) {
            this.combo[index] = Math.abs(random.nextInt() % 3) + 1;
        }
    }

    private ComboTrainer GetComboTrainer() {
        return this;
    }

    public void finishedPunch(int which) {
        this.threwPunch(which);
        if (this.finished) {
            this.restart = true;
            this.painted = false;
        }
    }

    public boolean succeeded() {
        return this.successes >= 10;
    }

    public boolean ready() {
        return this.restart && !this.painted && this.finished;
    }

    public synchronized void start() {
        while (this.thread != null) {
            Thread.currentThread();
            Thread.yield();
        }
        this.thread = new StopThread();
        this.thread.start();
        this.restart = false;
        this.finished = false;
    }

    public void endThread() {
        try {
            if (this.thread != null) {
                this.thread.done = true;
            }
            this.thread = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isPainting() {
        return !this.painted;
    }

    public void paint(Graphics graphics, int width, int height) {
        if (this.number != -1) {
            int x = 0;
            int y = 0;
            switch (this.number) {
                case 1: {
                    x = 0;
                    y = 0;
                    break;
                }
                case 2: {
                    x = 24;
                    y = 24;
                    break;
                }
                case 3: {
                    x = 48;
                    y = 48;
                    break;
                }
                case 4: {
                    this.drawGo(graphics, width, height);
                }
            }
            Runtime.drawClippedImage(graphics, this.numbers, (width - 24) / 2, (height - 24) / 2, 24, 24, (this.number - 1) * 24, 0);
        }
    }

    public void drawGo(Graphics graphics, int width, int height) {
        Runtime.drawClippedImage(graphics, this.go, (width - 24) / 2, (height - 21) / 2, 24, 21, 0, 0);
    }

    public int getComboCount() {
        return this.combo_top;
    }

    public void threwPunch(int which) {
        this.arena.resetComboTrainTime();
        if (this.combo[this.combo_index] == which) {
            ++this.combo_index;
            if (this.combo_index == this.combo_top) {
                ++this.successes;
                try {
                    Config.setComboPunches(this.combo_top);
                }
                catch (Throwable error) {
                    Runtime.checkIfSavable();
                }
                if (this.successes == 10) {
                    this.arena.comboSuccess();
                }
                ++this.combo_top;
                this.combo_index = 0;
                if (this.combo_top == this.combo.length) {
                    this.arena.combosDone(this.mistakes != 0);
                } else {
                    this.arena.comboCompleted();
                }
                this.finished = true;
            }
        } else {
            ++this.mistakes;
            this.combo_index = 0;
            if (this.mistakes == 3) {
                this.arena.combosDone(true);
            } else {
                this.arena.comboFailed();
            }
            this.finished = true;
        }
    }

    class StopThread
    extends Thread {
        boolean done = false;

        StopThread() {
        }

        public void run() {
            ComboTrainer.this.boxer.setComboTrainer(null);
            ComboTrainer.this.arena.setFrozen(true);
            int index = 0;
            boolean pause = false;
            ComboTrainer.this.painted = false;
            while (!this.done) {
                int sleeptime;
                ComboTrainer.this.arena;
                if (Arena.Interupted) continue;
                if (!pause) {
                    pause = true;
                    sleeptime = 500;
                    switch (ComboTrainer.this.combo[index++]) {
                        case 1: {
                            ComboTrainer.this.number = 1;
                            ComboTrainer.this.boxer.punch(0);
                            break;
                        }
                        case 2: {
                            ComboTrainer.this.number = 2;
                            ComboTrainer.this.boxer.punch(1);
                            break;
                        }
                        case 3: {
                            ComboTrainer.this.number = 3;
                            ComboTrainer.this.boxer.punch(2);
                        }
                    }
                } else {
                    sleeptime = 600;
                    ComboTrainer.this.number = -1;
                    pause = false;
                }
                try {
                    Thread.sleep(sleeptime);
                }
                catch (InterruptedException error) {
                    // empty catch block
                }
                this.done = index == ComboTrainer.this.combo_top;
            }
            ComboTrainer.this.number = 4;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ComboTrainer.this.arena;
            if (!Arena.Interupted && RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
                RockyRuntime.playSound("bell_ring", "");
            }
            ComboTrainer.this.restart = false;
            ComboTrainer.this.painted = true;
            ComboTrainer.this.boxer.setComboTrainer(ComboTrainer.this.GetComboTrainer());
            ComboTrainer.this.arena;
            if (!Arena.Interupted) {
                ComboTrainer.this.arena.setFrozen(false);
            }
            ComboTrainer.this.arena;
            if (!Arena.Interupted) {
                ComboTrainer.this.arena.startComboTraining();
            }
            ComboTrainer.this.thread = null;
        }
    }
}

