/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky.players;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.RockyRuntime;
import com.anthemgames.rocky.ui.Arena;
import com.anthemgames.rocky.ui.ComboTrainer;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Boxer {
    private static final int BOXER_MINIMUM_DISTANCE = 18;
    private static final int CELL_WIDTH = 0;
    private static final int DOWN_XPOS = 1;
    private static final int DOWN_WIDTH = 2;
    private static final int HITBOX_X1 = 3;
    private static final int HITBOX_X2 = 4;
    private static final int PUNCHRANGE = 5;
    private static final int HITPOINTS = 6;
    private static final int RECOVERTIME = 7;
    private static final int DAMAGE_BONUS = 8;
    public static final int JAB_PUNCH = 0;
    public static final int HOOK_PUNCH = 1;
    public static final int UPPERCUT_PUNCH = 2;
    private static final int[][] IMAGE_DATA = new int[][]{{32, 60, 60, 12, 24, 0, 50, 15, 1}, {32, 120, 60, 12, 24, 0, 75, 10, 2}, {32, 180, 60, 12, 24, 0, 100, 5, 3}, {32, 0, 60, 8, 24, 32, 0, 0, 0}, {32, 0, 60, 8, 24, 32, 0, 0, 0}, {32, 0, 60, 8, 24, 32, 0, 0, 0}, {29, -1, -1, 4, 28, 0, 999, 0, 0}};
    private Image downimage;
    public static final int APOLLO_CREED = 0;
    public static final int CLUBBER_LANG = 1;
    public static final int IVAN_DRAGO = 2;
    public static final int GYM_ROCKY = 3;
    public static final int SWEATSUIT_ROCKY = 4;
    public static final int RING_ROCKY = 5;
    public static final int MEATBAG = 6;
    private static final String[] BOXER_IMAGES = new String[]{"apollo", "clubber", "drago", "rockypro", "rockytrain", "rockypro", "beef"};
    public static final int JAB = 0;
    public static final int LEFT_HOOK_1 = 1;
    public static final int LEFT_HOOK_2 = 2;
    public static final int RIGHT_HOOK_1 = 3;
    public static final int RIGHT_HOOK_2 = 4;
    public static final int BLOCK = 5;
    public static final int UPPERCUT_1 = 5;
    public static final int UPPERCUT_2 = 6;
    public static final int UPPERCUT_3 = 7;
    public static final int STAND = 8;
    public static final int STEP_1 = 8;
    public static final int STEP_2 = 9;
    public static final int HIT = 9;
    public static final int GOING_DOWN_1 = 10;
    public static final int UNCONSCIOUS = 100;
    private static final int BEEF_IDLE = 0;
    private static final int BEEF_HIT_1 = 1;
    private static final int BEEF_HIT_2 = 2;
    private static final int BEEF_HIT_3 = 3;
    private static final int BEEF_HIT_4 = 4;
    private static final int[][] ANIMATIONS = new int[][]{{5, 5}, {8, 9}, {0, 8}, {1, 2, 1, 8}, {3, 4, 3, 8}, {5, 6, 7, 6, 5, 8}, {9, 8}, {9, 8}, {9, 10}, {1, 2, 3, 2, 1}};
    private static final int JAB_HIT_FRAME = 1;
    private static final int HOOK_HIT_FRAME = 1;
    private static final int UPPERCUT_HIT_FRAME = 2;
    private static final int BLOCKING = 0;
    private static final int WALKING = 1;
    private static final int JABBING = 2;
    private static final int LEFT_HOOKING = 3;
    private static final int RIGHT_HOOKING = 4;
    private static final int UPPERCUT = 5;
    private static final int TAKING_HIT = 6;
    private static final int STUNNED = 7;
    private static final int KNOCKEDOUT = 8;
    private static final int BEATING_MEAT = 9;
    private static final int JAB_DAMAGE = 1;
    private static final int HOOK_DAMAGE = 2;
    private static final int UPPERCUT_DAMAGE = 4;
    public static final long COMBO_TIME_DIFFERENTIAL = 2000L;
    public static final int COMBO_DAMAGE_0 = 13;
    public static final int COMBO_DAMAGE_1 = 10;
    public static final int COMBO_DAMAGE_2 = 8;
    public static final int COMBO_DAMAGE_3 = 6;
    public static final int COMBO_DAMAGE_4 = 6;
    public static final int KEY_JAB = 1;
    public static final int KEY_HOOK = 2;
    public static final int KEY_UPPERCUT = 3;
    public static final int COMBO_0 = 0;
    public static final int COMBO_1 = 1;
    public static final int COMBO_2 = 2;
    public static final int COMBO_3 = 3;
    public static final int COMBO_4 = 4;
    public static final int[][] COMBOS = new int[][]{{3, 1, 2, 1, 3}, {1, 2, 2, 3}, {1, 1, 3}, {2, 1, 2}, {2, 3}};
    private static final int[] COMBO_DAMAGE = new int[]{13, 10, 8, 6, 6};
    private static final int NONE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private int lastpunch = 1;
    private int moving = 0;
    private int punch = 0;
    private boolean blocking = false;
    private int[] imagedata;
    public Boxer opponent;
    protected int which;
    private Image filmstrip;
    private int xpos;
    private int ypos;
    private int hitpoints;
    protected int maxhitpoints;
    private int damage = 0;
    private long lasthit = 0L;
    private int[] hits = new int[5];
    private int combo_hit_count = 0;
    private boolean knocked_out = false;
    private boolean falling = false;
    private boolean can_move = true;
    private long last_hit_time = 0L;
    private long recover_time;
    private long recodmg_modifier = 0L;
    private Arena arena;
    private boolean taking_damage = false;
    public int[] current_frames = null;
    public int current_frame = -1;
    public int hit_frame = -1;
    private long last_hp_update = 0L;
    private int minx = 0;
    private int maxx = 256;
    private ComboTrainer comboTrainer = null;
    private int damage_bonus = 0;
    private int knockouts = 0;
    private boolean countedout = false;
    private long last_moved = 0L;
    private long lastmove = 0L;
    private Random id = new Random();
    private boolean using_caution = false;
    private int[] combo = null;
    private int combo_move = 0;
    private long move_differential;
    private int reflexes;

    public Boxer(int which, Arena arena) {
        this.which = which;
        this.arena = arena;
        this.imagedata = IMAGE_DATA[which];
        this.setupPersonality();
        this.filmstrip = Runtime.loadImage(BOXER_IMAGES[which]);
        if (which == 0 || which == 1 || which == 2 || which == 5) {
            this.downimage = Runtime.loadImage(BOXER_IMAGES[which] + "_down");
        }
        switch (which) {
            case 3: 
            case 4: 
            case 5: {
                switch (Config.getLevel()) {
                    case 0: {
                        this.recover_time = 75L;
                        this.hitpoints = 50;
                        break;
                    }
                    case 1: {
                        this.recover_time = 50L;
                        this.hitpoints = 75;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.recover_time = 25L;
                        this.hitpoints = 100;
                    }
                }
                this.damage_bonus = this.hitpoints / 10 - 5;
                break;
            }
            default: {
                this.hitpoints = this.imagedata[6];
                this.recover_time = this.imagedata[7];
                this.damage_bonus = this.imagedata[8];
            }
        }
        this.maxhitpoints = this.hitpoints;
    }

    public void setComboTrainer(ComboTrainer comboTrainer) {
        this.comboTrainer = comboTrainer;
    }

    public int getWhich() {
        return this.which;
    }

    public void setOpponent(Boxer opponent) {
        this.opponent = opponent;
    }

    public void setMinMaxX(int minx, int maxx) {
        this.minx = minx;
        this.maxx = maxx;
    }

    public int getX() {
        if (this.xpos < this.minx) {
            this.xpos = this.minx;
        }
        if (this.xpos > this.maxx) {
            this.xpos = this.maxx;
        }
        return this.xpos;
    }

    public void setX(int xpos) {
        this.xpos = xpos;
    }

    public int getY() {
        return this.isDown() ? 72 : this.ypos;
    }

    public void setY(int ypos) {
        this.ypos = ypos;
    }

    public int getMaxHitPoints() {
        return this.maxhitpoints;
    }

    public int getHitPoints() {
        return this.hitpoints - this.damage;
    }

    public void addHitPointBonus(int bonus) {
        this.maxhitpoints += bonus;
        this.hitpoints = this.maxhitpoints;
    }

    public void addHitPoints(int amount) {
        this.damage -= (amount *= Math.abs(this.id.nextInt()) % 2 > 0 ? 2 : 1);
        if (this.damage < 0) {
            this.damage = 0;
        }
    }

    public boolean inMiddleOfPunch() {
        return this.which != 6 && this.current_frames != null && (this.punch == 1 || this.punch == 2 || this.punch == 3);
    }

    public void setCountedOut(boolean countedout) {
        this.countedout = countedout;
    }

    public boolean isCountedOut() {
        return this.countedout;
    }

    public boolean isKnockedOut() {
        return this.knocked_out;
    }

    public boolean isDown() {
        return this.knocked_out && this.current_frames == null;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public int getWidth() {
        return this.imagedata[4] - (this.imagedata[3] + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getCurrentFrame(boolean canThink, Graphics graphics, int background_offset) {
        int xoffset;
        int height;
        int width;
        int frameid;
        Image image;
        block24: {
            block23: {
                image = null;
                frameid = this.which == 6 ? 0 : 8;
                width = 0;
                height = 0;
                xoffset = -1;
                if (this.which != 6) break block23;
                if (this.current_frames != null) {
                    frameid = this.current_frames[this.current_frame++];
                    if (this.current_frame == this.current_frames.length) {
                        this.current_frames = null;
                        this.current_frame = -1;
                        this.punch = 0;
                    }
                    break block24;
                } else {
                    frameid = 0;
                }
                break block24;
            }
            if (this.which != 4 && this.which != 3 && this.which != 5 && !this.isKnockedOut() && canThink) {
                this.think();
            }
            if (this.current_frames != null) {
                frameid = this.current_frames[this.current_frame];
                switch (this.which) {
                    case 3: 
                    case 5: {
                        switch (this.moving) {
                            case 1: {
                                if (!this.canRetreat()) break;
                                this.xpos -= 2;
                                break;
                            }
                            case 2: {
                                if (!this.canAdvance()) break;
                                this.xpos += 2;
                                break;
                            }
                        }
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        switch (this.moving) {
                            case 1: {
                                if (!this.canAdvance()) break;
                                this.xpos -= 2;
                                break;
                            }
                            case 2: {
                                if (!this.canRetreat()) break;
                                this.xpos += 2;
                            }
                        }
                        break;
                    }
                }
                if (System.currentTimeMillis() - this.last_moved > 75L) {
                    this.last_moved = System.currentTimeMillis();
                    ++this.current_frame;
                }
                if (this.current_frame == this.current_frames.length) {
                    this.current_frames = null;
                    this.current_frame = -1;
                    this.hit_frame = -1;
                    if (this.comboTrainer != null) {
                        this.comboTrainer.finishedPunch(this.punch);
                    }
                    this.punch = 0;
                }
            } else {
                if (canThink && System.currentTimeMillis() - this.last_hp_update >= 1000L && !this.isDown()) {
                    this.addHitPoints(1);
                    this.last_hp_update = System.currentTimeMillis();
                }
                this.moving = 0;
                this.blocking = false;
                frameid = 8;
            }
        }
        if (image == null) {
            image = this.isDown() ? this.downimage : this.filmstrip;
            xoffset = this.isDown() ? 0 : frameid * this.imagedata[0];
            width = this.isDown() ? this.imagedata[2] : this.imagedata[0];
            height = this.isDown() ? this.downimage.getHeight() : this.filmstrip.getHeight();
        }
        Runtime.drawClippedImage(graphics, image, this.xpos - background_offset, this.getY(), width, height, xoffset, 0);
    }

    public boolean isStunned() {
        return System.currentTimeMillis() - this.last_hit_time <= this.recover_time + this.recodmg_modifier;
    }

    public void throwingPunch(int x) {
        this.react(x);
    }

    public boolean punch(int which) {
        boolean result = false;
        if (this.current_frames == null && !this.isStunned() && !this.isKnockedOut()) {
            result = true;
            int animation = 0;
            switch (which) {
                case 0: {
                    animation = 2;
                    this.hit_frame = 1;
                    this.punch = 1;
                    this.lastpunch = 2;
                    break;
                }
                case 1: {
                    animation = this.lastpunch == 1 ? 4 : 3;
                    this.hit_frame = 1;
                    this.punch = 2;
                    this.lastpunch = this.lastpunch == 1 ? 2 : 1;
                    break;
                }
                case 2: {
                    animation = 5;
                    this.hit_frame = 2;
                    this.punch = 3;
                    this.lastpunch = 1;
                }
            }
            this.current_frames = ANIMATIONS[animation];
            this.current_frame = 0;
        }
        return result;
    }

    public void moveLeft() {
        if (this.current_frames == null && this.which != 4 && !this.isStunned() && !this.isDown()) {
            boolean canmove;
            boolean bl = this.which == 3 || this.which == 5 ? this.canRetreat() : (canmove = this.which == 0 || this.which == 1 || this.which == 2 ? this.canAdvance() : false);
            if (canmove) {
                this.current_frames = ANIMATIONS[1];
                this.current_frame = 0;
                this.moving = 1;
            }
        }
    }

    public void moveRight() {
        if (this.current_frames == null && this.which != 4 && !this.isStunned() && !this.isDown()) {
            boolean canmove;
            boolean bl = this.which == 3 || this.which == 5 ? this.canAdvance() : (canmove = this.which == 0 || this.which == 1 || this.which == 2 ? this.canRetreat() : false);
            if (canmove) {
                this.current_frames = ANIMATIONS[1];
                this.current_frame = 0;
                this.moving = 2;
            }
        }
    }

    public void block() {
        if (this.current_frames == null && this.which != 6 && !this.isStunned() && !this.isKnockedOut()) {
            this.blocking = true;
            this.current_frames = ANIMATIONS[0];
            this.current_frame = 0;
            this.lastpunch = 2;
        }
    }

    public int getPunchX() {
        return this.xpos + this.imagedata[5];
    }

    public void seePunch(int x) {
        this.react(x);
    }

    public void takeHit(int x) {
        if (!(!this.withinRange(x) || this.falling || this.isDown() || this.isKnockedOut() || this.taking_damage || this.opponent.current_frames == null || this.opponent.current_frame != this.opponent.hit_frame)) {
            long timeSinceLastPunch;
            this.current_frames = null;
            this.current_frame = -1;
            this.taking_damage = true;
            this.tookHit();
            this.last_hit_time = System.currentTimeMillis();
            this.current_frames = ANIMATIONS[this.which == 6 ? 9 : 6];
            this.current_frame = 0;
            switch (this.opponent.punch) {
                case 1: {
                    if (this.isBlocking()) break;
                    this.takeDamage(1);
                    break;
                }
                case 2: {
                    if (this.isBlocking()) break;
                    this.takeDamage(2);
                    break;
                }
                case 3: {
                    this.takeDamage(4);
                }
            }
            if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
                RockyRuntime.playSound("punch", "");
            }
            if ((timeSinceLastPunch = System.currentTimeMillis() - this.lasthit) > 2000L) {
                this.hits[0] = this.opponent.punch;
                this.hits[4] = 0;
                this.hits[3] = 0;
                this.hits[2] = 0;
                this.hits[1] = 0;
                this.combo_hit_count = 1;
            }
            this.validateCombo(this.opponent.punch);
            int combo_damage = this.getComboDamage();
            if (combo_damage > 0) {
                this.takeDamage(combo_damage);
            }
            if (this.getHitPoints() <= 0) {
                this.knockOut();
            }
            this.lasthit = System.currentTimeMillis();
            this.taking_damage = false;
        }
    }

    public void knockOut() {
        if (!this.knocked_out) {
            this.damage = this.hitpoints;
            ++this.knockouts;
            this.opponent.stopMoving();
            this.stopMoving();
            this.knocked_out = true;
            this.arena.positionBoxers(false);
            this.falling = true;
            this.current_frames = ANIMATIONS[8];
            this.current_frame = 0;
            this.hit_frame = -1;
        }
    }

    public void getUp() {
        this.falling = false;
        this.knocked_out = false;
        this.damage /= 2;
        this.current_frames = null;
        this.current_frame = -1;
    }

    public int getKnockouts() {
        return this.knockouts;
    }

    public void resetHitPoints() {
        this.falling = false;
        this.knockouts = (this.knockouts + 1) / 2;
        this.recodmg_modifier = 0L;
        if (this.knocked_out) {
            this.maxhitpoints = this.hitpoints * 60 / 100 - this.hitpoints * 5 / 100;
        }
        this.knocked_out = false;
        this.hitpoints = this.maxhitpoints;
        this.damage = 0;
        this.current_frames = null;
        this.current_frame = -1;
    }

    public boolean canPunch() {
        return this.current_frames != null && this.getHitPoints() > 0 && !this.opponent.isDown();
    }

    public boolean canRetreat() {
        boolean result = false;
        switch (this.which) {
            case 3: 
            case 5: {
                result = this.xpos > this.minx;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                result = this.xpos < this.maxx;
            }
        }
        return result;
    }

    public boolean canAdvance() {
        boolean result = false;
        switch (this.which) {
            case 3: 
            case 5: {
                result = this.xpos + 18 < this.opponent.getX();
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                result = this.xpos > this.opponent.xpos + 18;
            }
        }
        return result && !this.isKnockedOut();
    }

    public void stopMoving() {
        this.current_frames = null;
        this.current_frame = -1;
        this.hit_frame = -1;
        this.moving = 0;
    }

    boolean withinRange(int x) {
        int hitx = x - this.xpos;
        return !this.isKnockedOut() && !this.isDown() && hitx >= this.imagedata[3] && hitx <= this.imagedata[4];
    }

    public void takeDamage(int dmg) {
        if (this.which != 6) {
            int olddmg = dmg;
            this.recodmg_modifier += (long)(dmg += this.opponent.damage_bonus > 0 ? Math.abs(this.id.nextInt() % this.opponent.damage_bonus) : 0);
            this.damage += dmg;
            if (this.damage > this.hitpoints) {
                this.damage = this.hitpoints;
            }
        }
    }

    private synchronized void validateCombo(int the_punch) {
        if (this.combo_hit_count >= this.hits.length) {
            this.combo_hit_count = 0;
        }
        this.hits[this.combo_hit_count++] = the_punch;
        boolean hasMatch = true;
        for (int index = 0; index < COMBOS.length; ++index) {
            int[] combo = COMBOS[index];
            hasMatch = true;
            for (int check = 0; check < this.combo_hit_count && check < combo.length; ++check) {
                hasMatch &= this.hits[check] == combo[check];
            }
            if (hasMatch) break;
        }
        if (!hasMatch) {
            this.combo_hit_count = 0;
        }
    }

    private int getComboDamage() {
        int result = 0;
        boolean match = false;
        for (int which = 0; which < COMBOS.length && !match; ++which) {
            int[] combo = COMBOS[which];
            if (this.combo_hit_count != combo.length) continue;
            match = true;
            for (int hit = 0; hit < combo.length; ++hit) {
                match &= combo[hit] == this.hits[hit];
            }
            if (!match) continue;
            this.combo_hit_count = 0;
            this.hits[4] = 0;
            this.hits[3] = 0;
            this.hits[2] = 0;
            this.hits[1] = 0;
            this.hits[0] = 0;
            result = COMBO_DAMAGE[which];
            if (this.opponent.which != 3 && this.opponent.which != 5) break;
            this.arena.threwCombo();
            break;
        }
        return result;
    }

    private void setupPersonality() {
        switch (this.which) {
            case 0: {
                this.move_differential = 17L;
                this.reflexes = 3;
                break;
            }
            case 1: {
                this.move_differential = 10L;
                this.reflexes = 2;
                break;
            }
            case 2: {
                this.move_differential = 5L;
                this.reflexes = 1;
            }
        }
    }

    public synchronized void think() {
        boolean moved = false;
        boolean bl = this.using_caution = this.using_caution && this.getHitPoints() < this.maxhitpoints * 2 / 5;
        if ((this.getHitPoints() <= this.maxhitpoints * 10 / 100 || this.using_caution && this.getHitPoints() <= this.maxhitpoints / 3) && this.withinRange(this.opponent.getPunchX()) && !this.opponent.isKnockedOut()) {
            this.using_caution = true;
            switch (Math.abs(this.id.nextInt() % 10)) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    if (!this.canRetreat() || !this.withinRange(this.opponent.getPunchX()) || Math.abs(this.id.nextInt()) % 10 <= this.reflexes) break;
                    this.moveRight();
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    this.block();
                    break;
                }
                case 8: 
                case 9: {
                    this.punch(0);
                }
            }
            moved = true;
        } else if (!this.using_caution) {
            boolean canthink;
            boolean bl2 = canthink = System.currentTimeMillis() - this.lastmove > this.move_differential;
            if (canthink) {
                if (this.using_caution) {
                    if (Math.abs(this.id.nextInt() % 5) > 3) {
                        this.moveRight();
                    }
                } else if (this.withinRange(this.opponent.getPunchX())) {
                    this.using_caution = false;
                    if (this.combo != null) {
                        switch (this.combo[this.combo_move]) {
                            case 1: {
                                moved = this.punch(0);
                                break;
                            }
                            case 2: {
                                moved = this.punch(1);
                                break;
                            }
                            case 3: {
                                moved = this.punch(2);
                            }
                        }
                        if (++this.combo_move >= this.combo.length) {
                            this.combo = null;
                        }
                    } else if (!this.inMiddleOfPunch() && !this.opponent.isDown()) {
                        int combono = Math.abs(this.id.nextInt() % COMBOS.length);
                        switch (Math.abs(this.id.nextInt() % 8)) {
                            case 0: 
                            case 2: 
                            case 5: 
                            case 7: {
                                this.combo = COMBOS[combono];
                                this.combo_move = 0;
                                break;
                            }
                            case 1: {
                                moved = this.punch(2);
                                break;
                            }
                            case 3: {
                                moved = this.punch(0);
                                break;
                            }
                            case 4: {
                                moved = this.punch(1);
                                break;
                            }
                            case 6: {
                                if (this.opponent.inMiddleOfPunch() && Math.abs(this.id.nextInt() % this.reflexes) > this.reflexes / 2) {
                                    this.block();
                                }
                                moved = true;
                            }
                        }
                    }
                } else if (!this.opponent.isKnockedOut() && this.canAdvance()) {
                    this.moveLeft();
                }
            } else if (Math.abs(this.id.nextInt() % this.reflexes) > this.reflexes / 2) {
                this.block();
            }
        }
        if (moved) {
            this.lastmove = System.currentTimeMillis();
        }
    }

    public void react(int x) {
        if (this.withinRange(x)) {
            this.block();
        }
    }

    public void tookHit() {
        this.combo = null;
    }
}

