/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.ui.Arena;
import com.anthemgames.rocky.ui.MainScreen;
import com.anthemgames.sound.NokiaSoundPlayer;
import com.anthemgames.ui.TextScreen;
import com.sprintpcs.media.Vibrator;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class RockyRuntime
extends Runtime {
    public static String[] CREDITS = new String[]{"Rocky", "(TM) & (c)", "1976-2006", "Metro-Goldwyn-Mayer", "Studios Inc", " ", "Todos los derechos", "reservados.", ""};
    public static Image SplashImg;
    public static boolean ignoreKeys;
    public static int showingLegal;
    public static final boolean AUDIO_ENABLED;
    public static final String AUDIO_EXTENSION = ".qcp";
    public static final String AUDIO_MIMETYPE = "audio/vnd.qcelp";
    public static final boolean SMALL_RUNTIME = false;
    private static MainScreen MyMainScreen;
    private static TextScreen MyTextScreen;
    private static Arena MyArena;
    public static String debugText;

    public static MainScreen getMainScreen() {
        if (MyMainScreen == null) {
            MyMainScreen = new MainScreen(0);
        }
        RockyRuntime.MyMainScreen.setDrawLoading = false;
        return MyMainScreen;
    }

    public static MainScreen getMainScreen(int type) {
        if (MyMainScreen == null) {
            MyMainScreen = new MainScreen(type);
        }
        RockyRuntime.MyMainScreen.setDrawLoading = false;
        return MyMainScreen;
    }

    public static TextScreen GetTextScreen(String[] text, Displayable nextscreen, boolean paragraphs) {
        MyTextScreen = null;
        MyTextScreen = new TextScreen(text, nextscreen, paragraphs);
        return MyTextScreen;
    }

    public static TextScreen GetTextScreen(String[] text, Displayable nextscreen, boolean paragraphs, boolean centered) {
        MyTextScreen = null;
        MyTextScreen = new TextScreen(text, nextscreen, paragraphs, centered);
        return MyTextScreen;
    }

    public static synchronized Arena GetArenaScreen(int venue, int npc) {
        RockyRuntime.FreememForGame();
        MyArena = new Arena(venue, npc);
        return MyArena;
    }

    public static synchronized Arena GetArenaScreen(int venue) {
        RockyRuntime.FreememForGame();
        MyArena = new Arena(venue);
        return MyArena;
    }

    public static void FreememForGame() {
        MyMainScreen = null;
        MyTextScreen = null;
        MyArena = null;
        System.gc();
    }

    public static void showScreen() {
        Arena.Interupted = false;
        Runtime.showScreen((Displayable)RockyRuntime.getMainScreen());
        ignoreKeys = true;
        RockyRuntime.PauseLegal();
        RockyRuntime.showMGM();
        MainScreen.showCredits = false;
        ignoreKeys = false;
    }

    public static void showMGM() {
        MainScreen.splashMessage = new String[]{"MGM Interactive"};
        RockyRuntime.PauseLegal();
    }

    public static void showCredits() {
        MainScreen.splashMessage = CREDITS;
        RockyRuntime.PauseLegal();
    }

    public static void PauseLegal() {
        try {
            Thread.sleep(2000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MyMainScreen.repaint();
    }

    public static void pauseApp() {
        if (Runtime.currentScreen != null && Runtime.currentScreen instanceof Arena) {
            Arena.Interupted = true;
            ((Arena)Runtime.currentScreen).pause();
        }
    }

    public static void playSound(String filename, String mimetype) {
        Runtime.playSound(filename, mimetype);
    }

    public static void playBackgroundSound(String filename, String mimetype) {
        Runtime.playBackgroundSound(filename, mimetype);
    }

    public static void vibrate() {
        if (Config.vibrate()) {
            Vibrator.vibrate((int)100);
        }
    }

    static {
        Runtime.setSoundPlayer(new NokiaSoundPlayer());
        SplashImg = null;
        ignoreKeys = false;
        showingLegal = 0;
        AUDIO_ENABLED = Runtime.soundPlayer != null;
        MyMainScreen = null;
        MyTextScreen = null;
        MyArena = null;
        debugText = "";
    }
}

