/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameFC
extends FullCanvas
implements Runnable {
    private Main main;
    private Thread thread = null;
    private Image offscreen = Image.createImage((int)96, (int)65);
    private boolean upPressed = false;
    private boolean downPressed = false;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    public boolean firePressed = false;
    public Mario mario;
    public Landscape landscape;
    public boolean dead;
    public boolean completed;
    private Gate gate;
    private LevelInfo levelInfo;
    public int level;
    public Vector turtles = new Vector();
    private int bgR;
    private int bgG;
    private int bgB;

    public GameFC(Main main) {
        this.main = main;
        main.cache.put("mario.png", main.loadImage("mario.png"));
        main.cache.put("bricks.png", main.loadImage("bricks.png"));
        main.cache.put("characters1.png", main.loadImage("characters1.png"));
        main.cache.put("characters2.png", main.loadImage("characters2.png"));
        this.loadLevel(1);
    }

    private void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void paint(Graphics graphics) {
        this.start();
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(this.bgR, this.bgG, this.bgB);
        graphics2.fillRect(0, 0, 96, 65);
        this.landscape.paint(graphics2);
        this.paintTurtles(graphics2);
        this.mario.paint(graphics2);
        if (this.gate != null) {
            this.gate.paint(graphics2);
        }
        if (this.levelInfo != null) {
            this.levelInfo.paint(graphics2);
        }
        this.main.paintCenter(graphics, this.offscreen);
    }

    public void run() {
        while (this.main.currentDA == this) {
            try {
                if (!this.dead && this.gate == null) {
                    this.landscape.touch();
                    this.marioTouchTurtles();
                    if (this.rightPressed) {
                        this.mario.move(1);
                    }
                    if (this.leftPressed) {
                        this.mario.move(-1);
                    }
                    if (this.upPressed) {
                        this.mario.jump();
                    }
                    this.mario.idle();
                    this.turtleAction();
                    if (this.completed) {
                        this.gate = new Gate(0, this.main);
                    }
                } else {
                    if (this.dead && this.mario.yF < 650) {
                        this.mario.dead();
                        if (this.mario.deadJump < 4) {
                            ++this.mario.deadJump;
                            this.mario.yF -= 30;
                        } else if (this.mario.yF < 650) {
                            this.mario.yF += 40;
                        }
                    } else if (this.gate == null) {
                        this.gate = new Gate(0, this.main);
                    }
                    if (this.levelInfo != null && this.levelInfo.done) {
                        if (this.levelInfo.state == 1) {
                            this.gate = new Gate(1, this.main);
                        }
                        if (this.levelInfo.state == 0) {
                            this.main.setCurrentDA((Displayable)new MainMenuL(this.main));
                        }
                        this.levelInfo = null;
                    }
                    if (this.gate != null && this.gate.done) {
                        if (this.dead) {
                            this.gate = new Gate(2, this.main);
                            this.levelInfo = new LevelInfo(0, this);
                            continue;
                        }
                        if (this.completed) {
                            this.loadLevel(this.level + 1);
                            continue;
                        }
                        this.gate = null;
                    }
                }
                this.repaint();
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println("Run cycle exception: " + exception.toString());
            }
        }
        this.thread = null;
    }

    public void keyPressed(int n) {
        if (this.main.currentDA != this) {
            return;
        }
        if (n == -6) {
            GameMenuL gameMenuL = new GameMenuL(this.main, this);
            this.main.setCurrentDA((Displayable)gameMenuL);
            return;
        }
        int n2 = this.getGameAction(n);
        if (n2 == 1) {
            this.upPressed = true;
        }
        if (n2 == 6) {
            this.downPressed = true;
        }
        if (n2 == 2) {
            this.leftPressed = true;
        }
        if (n2 == 5) {
            this.rightPressed = true;
        }
        if (n2 == 8) {
            this.firePressed = true;
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 1) {
            this.upPressed = false;
        }
        if (n2 == 6) {
            this.downPressed = false;
        }
        if (n2 == 2) {
            this.leftPressed = false;
        }
        if (n2 == 5) {
            this.rightPressed = false;
        }
        if (n2 == 8) {
            this.firePressed = false;
        }
    }

    public void loadLevel(int n) {
        if (n > 15) {
            n = 1;
        }
        this.level = n;
        if (this.main.demo && n > 1) {
            this.main.setCurrentDA((Displayable)new ActivateFC(this.main));
            return;
        }
        this.turtles.removeAllElements();
        String string = new String(this.main.loadResource("levels/level" + n + ".txt"));
        Vector vector = this.main.getLines(string);
        String string2 = (String)vector.elementAt(0);
        Vector vector2 = this.main.getTokens(string2);
        this.bgR = Integer.parseInt((String)vector2.elementAt(0));
        this.bgG = Integer.parseInt((String)vector2.elementAt(1));
        this.bgB = Integer.parseInt((String)vector2.elementAt(2));
        int n2 = ((String)vector.elementAt(1)).length();
        int n3 = vector.size();
        char[][] cArray = new char[n2][n3 - 1];
        int n4 = 0;
        while (n4 < n3 - 1) {
            String string3 = (String)vector.elementAt(n4 + 1);
            int n5 = 0;
            while (n5 < n2) {
                cArray[n5][n4] = string3.charAt(n5);
                ++n5;
            }
            ++n4;
        }
        this.landscape = new Landscape(this.main, cArray, this);
        this.mario = new Mario(this.main, this);
        this.dead = false;
        this.completed = false;
        this.gate = new Gate(2, this.main);
        this.levelInfo = new LevelInfo(1, this);
        this.main.saveFile("level", ("" + n).getBytes());
    }

    private void paintTurtles(Graphics graphics) {
        int n = this.turtles.size();
        int n2 = 0;
        while (n2 < n) {
            GroundEnemy groundEnemy = (GroundEnemy)this.turtles.elementAt(n2);
            if (!groundEnemy.isActive()) {
                this.turtles.removeElementAt(n2);
                --n2;
                --n;
            } else {
                groundEnemy.paint(graphics);
            }
            ++n2;
        }
    }

    private void turtleAction() {
        int n = this.turtles.size();
        int n2 = 0;
        while (n2 < n) {
            GroundEnemy groundEnemy = (GroundEnemy)this.turtles.elementAt(n2);
            groundEnemy.move();
            ++n2;
        }
    }

    private void marioTouchTurtles() {
        int n = this.turtles.size();
        int n2 = 0;
        while (n2 < n) {
            GroundEnemy groundEnemy = (GroundEnemy)this.turtles.elementAt(n2);
            int n3 = groundEnemy.xF / 10;
            int n4 = groundEnemy.yF / 10;
            int n5 = n3 + groundEnemy.w;
            int n6 = n4 + groundEnemy.h;
            if (this.main.inside(this.mario.xF / 10 + this.mario.w / 2, this.mario.yF / 10 + this.mario.h - this.mario.h / 4, n3, n4, n5, n6)) {
                this.dead = true;
            }
            ++n2;
        }
    }
}

