/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Mario {
    private Image[] skins;
    private Main main;
    private GameFC gameFC;
    public int xF;
    public int yF;
    public int w = 12;
    public int h = 20;
    private int curSkin = 3;
    private int dir = 1;
    private long skinTime = 0L;
    private int jumpF = 0;
    private boolean jf = false;
    public int deadJump = 0;
    public static final int MOVE_LEFT = -1;
    public static final int MOVE_RIGHT = 1;

    public Mario(Main main, GameFC gameFC) {
        this.main = main;
        this.gameFC = gameFC;
        Image frames = (Image)main.cache.get("mario.png");
        this.skins = new Image[8];
        this.skins[3] = main.extractFrame(frames, this.w, this.h, 0);
        this.skins[4] = main.extractFrame(frames, this.w, this.h, 1);
        this.skins[5] = main.extractFrame(frames, this.w, this.h, 2);
        this.skins[2] = main.flipHorizontal(this.skins[3]);
        this.skins[1] = main.flipHorizontal(this.skins[4]);
        this.skins[0] = main.flipHorizontal(this.skins[5]);
        this.skins[6] = main.extractFrame(frames, this.w, this.h, 3);
        this.skins[7] = main.flipHorizontal(this.skins[6]);
        this.xF = 0;
        this.yF = 650 - gameFC.landscape.h * 10 - this.h * 10;
    }

    public void paint(Graphics g) {
        g.drawImage(this.skins[this.curSkin], this.xF / 10, this.yF / 10, 0x10 | 4);
    }

    public void move(int where) {
        this.dir = where;
        int dxF = 0;
        long curTime = System.currentTimeMillis();
        switch (this.dir) {
            case -1: {
                if (this.curSkin > 2) {
                    this.curSkin = 2;
                } else if (curTime > this.skinTime + 200L) {
                    this.skinTime = curTime;
                    --this.curSkin;
                    if (this.curSkin < 0) {
                        this.curSkin = 2;
                    }
                }
                dxF = -30;
                if (this.xF + dxF >= 0) break;
                dxF = 0;
                break;
            }
            case 1: {
                if (this.curSkin < 3) {
                    this.curSkin = 3;
                } else if (curTime > this.skinTime + 200L) {
                    this.skinTime = curTime;
                    ++this.curSkin;
                    if (this.curSkin > 5) {
                        this.curSkin = 3;
                    }
                }
                dxF = 30;
            }
        }
        Landscape landscape = this.gameFC.landscape;
        int[] pos1 = this.gameFC.landscape.getPosition((this.xF + dxF) / 10 + this.w / 2, this.yF / 10 + this.h / 4);
        int mi1 = pos1[0];
        int mj1 = pos1[1];
        int[] pos2 = this.gameFC.landscape.getPosition((this.xF + dxF) / 10 + this.w / 2, this.yF / 10 + this.h - this.h / 4);
        int mi2 = pos2[0];
        int mj2 = pos2[1];
        if (!landscape.isEmpty(mi1, mj1) || !landscape.isEmpty(mi2, mj2)) {
            dxF = 0;
        }
        this.xF += dxF;
    }

    public void jump() {
        if (!this.jf) {
            this.jumpF = 230;
        }
    }

    public void idle() {
        int mi;
        int[] pos;
        long curTime = System.currentTimeMillis();
        if (curTime > this.skinTime + 200L) {
            switch (this.dir) {
                case -1: {
                    this.curSkin = 2;
                    break;
                }
                case 1: {
                    this.curSkin = 3;
                }
            }
        }
        if (this.jf) {
            switch (this.dir) {
                case -1: {
                    this.curSkin = 1;
                    break;
                }
                case 1: {
                    this.curSkin = 4;
                }
            }
        }
        Landscape landscape = this.gameFC.landscape;
        if (this.jumpF > 0) {
            int mj;
            pos = this.gameFC.landscape.getPosition(this.xF / 10 + this.w / 2, this.yF / 10 - 3);
            mi = pos[0];
            if (landscape.isEmpty(mi, mj = pos[1])) {
                this.yF -= 30;
                this.jumpF -= 30;
            } else {
                this.jumpF = 0;
            }
            this.jf = true;
        } else {
            int mj;
            pos = this.gameFC.landscape.getPosition(this.xF / 10 + this.w / 2, this.yF / 10 + this.h);
            mi = pos[0];
            if (landscape.isEmpty(mi, mj = pos[1])) {
                this.yF += 30;
                this.jf = true;
            } else {
                this.yF = landscape.yF + (mj * landscape.h - this.h) * 10;
                this.jf = false;
            }
        }
        int sxF = 0;
        int syF = 0;
        if (this.xF > 480) {
            sxF = this.xF - 480;
        }
        if (this.yF + this.h * 10 < 0) {
            syF = -650;
        }
        if (this.yF + this.h * 10 > 650) {
            syF = 650;
        }
        landscape.scroll(-sxF, -syF);
    }

    public void dead() {
        long curTime = System.currentTimeMillis();
        if (this.curSkin < 6) {
            this.curSkin = 6;
        }
        if (curTime > this.skinTime + 100L) {
            ++this.curSkin;
            if (this.curSkin > 7) {
                this.curSkin = 6;
            }
        }
    }
}

