/*
 * Decompiled with CFR 0.152.
 */
class RopeStart
extends GimmickObject {
    public static final int DEGREE = crlFP32.actTanDegree(1, 2);
    public int velocity;
    public int degree;
    public boolean controlling;

    protected RopeStart(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (GimmickObject.hookImage == null) {
            try {
                GimmickObject.hookImage = MFImage.createImage("/gimmick/hook.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.used = false;
        this.controlling = false;
        this.degree = this.iLeft == 0 ? 180 - DEGREE : DEGREE;
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, GimmickObject.hookImage, 0, 0, 16, 24, 0, this.posX, this.posY, 17);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (!this.used) {
            this.velocity = Math.abs(playerObject.getVelX());
            this.used = true;
            this.controlling = true;
            playerObject.setOutOfControl(this);
            playerObject.railing = true;
            playerObject.collisionState = 1;
            playerObject.faceDirection = true;
        }
    }

    public void logic() {
        if (GameObject.player.outOfControl && GameObject.player.outOfControlObject == this) {
            this.velocity += GameObject.GRAVITY * MyAPI.dSin(this.degree) / 100;
            if (this.velocity > 0) {
                this.velocity -= 30;
                if (this.velocity < 0) {
                    this.velocity = 0;
                }
            }
            if (this.velocity < 0) {
                this.velocity += 30;
                if (this.velocity > 0) {
                    this.velocity = 0;
                }
            }
            this.posX += this.velocity * MyAPI.dCos(this.degree) / 100;
            this.posY += this.velocity * MyAPI.dSin(this.degree) / 100;
            this.refreshCollisionRect(this.posX, this.posY);
            if (GameObject.player.outOfControl) {
                int n = GameObject.player.getFootPositionX();
                int n2 = GameObject.player.getFootPositionY();
                GameObject.player.doPullMotion(this.posX, this.posY + 1408);
                GameObject.player.setVelX(this.velocity * MyAPI.dCos(this.degree) / 100);
                GameObject.player.setVelY(this.velocity * MyAPI.dSin(this.degree) / 100);
                GameObject.player.checkWithObject(n, n2, GameObject.player.getFootPositionX(), GameObject.player.getFootPositionY());
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n, n2, 1024, 2560);
    }

    public void turn() {
        this.degree = 180 - this.degree;
        this.velocity = -this.velocity;
        int n = Math.abs(this.velocity);
        if (n > 1800) {
            this.velocity = this.velocity < 0 ? -1800 : 1800;
        }
    }
}

