/*
 * Decompiled with CFR 0.152.
 */
class Monkey
extends EnemyObject {
    public int velocity = 320;
    public int limitTopY;
    public int limitBottomY;
    public static Animation monkeyAnimation;
    public int state;
    public int alert_state;
    public int ALERT_WIDTH = 256;
    public int ALERT_HEIGHT = 160;
    public int BOMB_MAX_SPEED_X = 384;
    public int attack_cnt = 0;
    public int enemyid;
    public int posXr;
    public int posXl;

    public static void releaseAllResource() {
        monkeyAnimation = null;
    }

    protected Monkey(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posY -= 1024;
        this.posXl = this.posX;
        this.posXr = this.posX - this.velocity * 2;
        this.limitTopY = this.posY;
        this.limitBottomY = this.posY + this.mHeight;
        if (monkeyAnimation == null) {
            monkeyAnimation = new Animation("/animation/monkey");
        }
        this.drawer = monkeyAnimation.getDrawer(0, true, 0);
        this.enemyid = n;
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, this.ALERT_WIDTH, this.ALERT_HEIGHT);
        int n = this.posX;
        int n2 = this.posY;
        this.posX = this.posX < GameObject.player.getCheckPositionX() ? this.posXr : this.posXl;
        n = this.posX;
        switch (this.state) {
            case 0: {
                if (this.alert_state == 0 || this.alert_state == 1) {
                    if (this.posX < GameObject.player.getCheckPositionX()) {
                        this.drawer.setTrans(2);
                    } else {
                        this.drawer.setTrans(0);
                    }
                }
                if (this.velocity > 0) {
                    this.posY += this.velocity;
                    if (this.posY >= this.limitBottomY) {
                        this.posY = this.limitBottomY;
                        this.velocity = -this.velocity;
                    }
                } else {
                    this.posY += this.velocity;
                    if (this.posY <= this.limitTopY) {
                        this.posY = this.limitTopY;
                        this.velocity = -this.velocity;
                    }
                }
                if (this.posY == this.limitTopY && this.alert_state == 0) {
                    ++this.attack_cnt;
                    if (this.attack_cnt == 2) {
                        this.state = 1;
                        this.attack_cnt = 0;
                    }
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                this.drawer.setActionId(1);
                this.drawer.setLoop(false);
                if (this.posX < GameObject.player.getCheckPositionX()) {
                    this.drawer.setTrans(2);
                } else {
                    this.drawer.setTrans(0);
                }
                if (this.drawer.checkEnd()) {
                    int n3 = -(this.posX - GameObject.player.getCheckPositionX()) / 12;
                    if (Math.abs(n3) > this.BOMB_MAX_SPEED_X) {
                        n3 = n3 > 0 ? this.BOMB_MAX_SPEED_X : -this.BOMB_MAX_SPEED_X;
                    }
                    BulletObject.addBullet(this.enemyid, this.posX, this.posY, n3, 0);
                    this.state = 0;
                    this.drawer.setActionId(0);
                    this.drawer.setLoop(true);
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 768, n2, 1536, 1280);
    }
}

