/*
 * Decompiled with CFR 0.152.
 */
public class Line {
    public int A;
    public int B;
    public int C;
    public static final int[] DIVISOR = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23};

    public Line(int n, int n2, int n3, int n4) {
        this.setProperty(n, n2, n3, n4);
    }

    public Line() {
    }

    public void setProperty(int n, int n2, int n3, int n4) {
        this.A = n4 - n2;
        this.B = n - n3;
        this.C = this.A * n + this.B * n2;
        this.dealDivisor();
    }

    public int getY(int n) {
        if (this.isVertical()) {
            return 0;
        }
        return (this.C - this.A * n) / this.B;
    }

    public boolean isHorizontal() {
        return this.A == 0;
    }

    public boolean isVertical() {
        return this.B == 0;
    }

    public void dealDivisor() {
        if (this.A == 0 && this.B == 0) {
            return;
        }
        for (int i = 0; i < DIVISOR.length; ++i) {
            int n = DIVISOR[i];
            while (this.A % n == 0 && this.B % n == 0 && this.C % n == 0) {
                this.A /= n;
                this.B /= n;
                this.C /= n;
            }
        }
    }

    public int cos(int n) {
        int n2 = 0;
        try {
            n2 = Math.abs((this.B * n << 3) / crlFP32.sqrt(this.A * this.A + this.B * this.B));
        }
        catch (Exception exception) {
            exception.toString();
        }
        return n2;
    }

    public int sin(int n) {
        int n2 = 0;
        try {
            n2 = Math.abs((this.A * n << 3) / crlFP32.sqrt(this.A * this.A + this.B * this.B));
        }
        catch (Exception exception) {
            exception.toString();
        }
        return n2;
    }

    public boolean directRatio() {
        return this.B * this.A < 0;
    }

    public Direction getOneDirection() {
        if (this.isHorizontal()) {
            return new Direction(-1, 0);
        }
        if (this.isVertical()) {
            return new Direction(0, -1);
        }
        if (this.directRatio()) {
            return new Direction(1, 1);
        }
        if (!this.directRatio()) {
            return new Direction(-1, 1);
        }
        return new Direction(0, 0);
    }
}

