/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;

public abstract class GameObject
implements SonicDef {
    protected int posX;
    protected int posY;
    protected int mWidth;
    protected int mHeight;
    protected int currentLayer;
    protected boolean firstTouch = true;
    public static PlayerObject player;
    public static GameObject boss;
    public static AnimationDrawer ringDrawer;
    public static Vector[][] allGameObject;
    public static Vector mainObjectLogicVec;
    public static Vector playerCheckVec;
    public CollisionRect collisionRect = new CollisionRect();
    public CollisionRect preCollisionRect = new CollisionRect();
    public static Vector[] paintVec;
    public static int objVecWidth;
    public static int objVecHeight;
    public Coordinate moveDistance = new Coordinate();
    protected static int GRAVITY;
    public static Animation destroyEffectAnimation;
    public static long systemClock;
    protected static Animation rockBreakAnimation;
    protected static SoundSystem soundInstance;
    public static int stageModeState;
    public static boolean bossFighting;
    public static boolean IsGamePause;
    public static Coordinate camera;
    public static int loadStep;
    public static int loadNum;
    public static int currentLoadIndex;
    public static DataInputStream ds;
    public static int closeStep;
    public static int currentX;
    public static int currentY;
    public static int preCenterX;
    public static int preCenterY;
    public static CollisionRect screenRect;
    public static CollisionRect rectH;
    public static CollisionRect rectV;
    public static CollisionBlock groundblock;
    public static CollisionRect resetRect;
    public boolean needInit;

    public static void initObject(int n, int n2, boolean bl) {
        GameObject.closeObject(bl);
        player = new PlayerObject();
        boss = null;
        allGameObject = null;
        objVecWidth = (n + 256 - 1) / 256;
        objVecHeight = (n2 + 256 - 1) / 256;
        allGameObject = new Vector[objVecWidth][objVecHeight];
        for (int i = 0; i < objVecWidth; ++i) {
            for (int j = 0; j < objVecHeight; ++j) {
                GameObject.allGameObject[i][j] = new Vector();
            }
        }
        if (destroyEffectAnimation == null) {
            destroyEffectAnimation = new Animation("/animation/destroy_effect");
        }
        if (rockBreakAnimation == null) {
            rockBreakAnimation = new Animation("/animation/iwa_patch");
        }
        preCenterX = -1;
        preCenterY = -1;
        IsGamePause = false;
        if (soundInstance == null) {
            soundInstance = SoundSystem.getInstance();
        }
        RingObject.ringInit();
        GimmickObject.gimmickInit();
        EnemyObject.enemyinit();
        bossFighting = false;
    }

    public static void ObjectClear() {
        GimmickObject.gimmickInit();
        boss = null;
    }

    public static void logicObjects() {
        if (!IsGamePause) {
            int n;
            systemClock = systemClock < Long.MAX_VALUE ? ++systemClock : 0L;
            for (n = 0; n < 4; ++n) {
                paintVec[n].removeAllElements();
            }
            GimmickObject.gimmickStaticLogic();
            EnemyObject.enemyStaticLogic();
            RingObject.ringLogic();
            player.logic();
            if (!GameObject.player.outOfControl) {
                MapManager.cameraLogic();
            }
            GameObject.checkObjWhileMoving(player);
            n = 0;
            int n2 = 0;
            GameObject.getGameObjectVecArray(player, mainObjectLogicVec);
            while (n2 < mainObjectLogicVec.size()) {
                Vector vector = (Vector)mainObjectLogicVec.elementAt(n2);
                if (n < vector.size()) {
                    GameObject gameObject = (GameObject)vector.elementAt(n);
                    if (!player.isControlObject(gameObject)) {
                        gameObject.logic();
                        if (gameObject.objectChkDestroy()) {
                            gameObject.close();
                            vector.removeElementAt(n);
                            --n;
                        } else if (gameObject.checkInit()) {
                            vector.removeElementAt(n);
                            --n;
                        }
                    }
                    if (GameObject.checkPaintNecessary(gameObject)) {
                        paintVec[gameObject.getPaintLayer()].addElement(gameObject);
                    }
                    ++n;
                    continue;
                }
                n = 0;
                ++n2;
            }
            if (boss != null) {
                boss.logic();
                if (!boss.isFarAwayCamera()) {
                    paintVec[boss.getPaintLayer()].addElement(boss);
                }
            }
            BulletObject.bulletLogicAll();
            SmallAnimal.animalLogic();
            if (GameObject.player.outOfControl) {
                MapManager.cameraLogic();
            }
        }
    }

    public static void setNoInput() {
        if (player != null) {
            player.setNoKey();
        }
    }

    public static void drawPlayer(MFGraphics mFGraphics) {
        camera = MapManager.getCamera();
        player.draw(mFGraphics);
    }

    public static void drawObjectBeforeSonic(MFGraphics mFGraphics) {
        int n;
        camera = MapManager.getCamera();
        for (n = 0; n < paintVec[3].size(); ++n) {
            ((GameObject)paintVec[3].elementAt(n)).draw(mFGraphics);
        }
        for (n = 0; n < paintVec[0].size(); ++n) {
            ((GameObject)paintVec[0].elementAt(n)).draw(mFGraphics);
        }
    }

    public static void drawObjectAfterEveryThing(MFGraphics mFGraphics) {
        camera = MapManager.getCamera();
        for (int i = 0; i < paintVec[2].size(); ++i) {
            ((GameObject)paintVec[2].elementAt(i)).draw(mFGraphics);
        }
        RingObject.ringDraw(mFGraphics);
    }

    public static void drawObjects(MFGraphics mFGraphics) {
        ringDrawer.moveOn();
        camera = MapManager.getCamera();
        for (int i = 0; i < paintVec[1].size(); ++i) {
            ((GameObject)paintVec[1].elementAt(i)).draw(mFGraphics);
        }
        SmallAnimal.animalDraw(mFGraphics);
    }

    public static boolean loadObjectStep(String string, int n) {
        boolean bl = true;
        switch (loadStep) {
            case 0: {
                try {
                    InputStream inputStream = MFDevice.getResourceAsStream(string);
                    ds = new DataInputStream(inputStream);
                    loadNum = ds.readShort();
                    currentLoadIndex = 0;
                }
                catch (Exception exception) {
                    ds = null;
                }
                break;
            }
            case 1: {
                try {
                    if (ds == null) break;
                    block17: for (int i = 0; i < 20 && currentLoadIndex < loadNum; ++i, ++currentLoadIndex) {
                        switch (n) {
                            case 0: {
                                GameObject.loadGimmickByStream(ds);
                                continue block17;
                            }
                            case 1: {
                                GameObject.loadRingByStream(ds);
                                continue block17;
                            }
                            case 2: {
                                GameObject.loadEnemyByStream(ds);
                                continue block17;
                            }
                            case 3: {
                                GameObject.loadItemByStream(ds);
                            }
                        }
                    }
                    if (currentLoadIndex >= loadNum) break;
                    bl = false;
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    if (ds != null) {
                        ds.close();
                    }
                    loadStep = 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        }
        if (bl) {
            ++loadStep;
        }
        return false;
    }

    public static void loadGimmickByStream(DataInputStream dataInputStream) {
        try {
            GameObject gameObject;
            int n = dataInputStream.readShort();
            int n2 = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            int n3 = dataInputStream.readByte();
            int n4 = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            if (n < 0) {
                n += 256;
            }
            if (n2 < 0) {
                n2 += 256;
            }
            if (n3 < 0) {
                n3 += 256;
            }
            if (n4 < 0) {
                n4 += 256;
            }
            if ((gameObject = GimmickObject.getNewInstance(by, n, n2, by2, by3, n3, n4)) != null) {
                GameObject.addGameObject(gameObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadRingByStream(DataInputStream dataInputStream) {
        try {
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            RingObject ringObject = RingObject.getNewInstance(s, s2);
            GameObject.addGameObject(ringObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadEnemyByStream(DataInputStream dataInputStream) {
        try {
            EnemyObject enemyObject;
            int n = dataInputStream.readShort();
            int n2 = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            int n3 = dataInputStream.readByte();
            int n4 = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            if (n < 0) {
                n += 256;
            }
            if (n2 < 0) {
                n2 += 256;
            }
            if (n3 < 0) {
                n3 += 256;
            }
            if (n4 < 0) {
                n4 += 256;
            }
            if ((enemyObject = EnemyObject.getNewInstance(by, n, n2, by2, by3, n3, n4)) != null && enemyObject != boss) {
                GameObject.addGameObject(enemyObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadItemByStream(DataInputStream dataInputStream) {
        try {
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            ItemObject itemObject = ItemObject.getNewInstance(by, s, s2);
            GameObject.addGameObject(itemObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addGameObject(GameObject gameObject, int n, int n2) {
        allGameObject[(n >> 6) / 256][(n2 >> 6) / 256].addElement(gameObject);
        gameObject.refreshCollisionRect(gameObject.posX, gameObject.posY);
    }

    public static void addGameObject(GameObject gameObject) {
        if (gameObject == null) {
            return;
        }
        int n = (gameObject.posX >> 6) / 256;
        if (n >= objVecWidth) {
            n = objVecWidth - 1;
        }
        allGameObject[n][(gameObject.posY >> 6) / 256].addElement(gameObject);
        gameObject.refreshCollisionRect(gameObject.posX, gameObject.posY);
    }

    public static void collisionChkWithAllGameObject(PlayerObject playerObject) {
        Object object;
        boolean bl = false;
        if (playerObject.attackRectVec.size() > 0) {
            bl = true;
        }
        int n = 0;
        int n2 = 0;
        GameObject.getGameObjectVecArray(player, mainObjectLogicVec);
        while (n2 < mainObjectLogicVec.size()) {
            Vector vector = (Vector)mainObjectLogicVec.elementAt(n2);
            if (n < vector.size()) {
                RingObject ringObject;
                CollisionRect collisionRect;
                object = (GameObject)vector.elementAt(n);
                if (bl) {
                    for (int i = 0; i < playerObject.attackRectVec.size(); ++i) {
                        collisionRect = (CollisionRect)playerObject.attackRectVec.elementAt(i);
                        if (!collisionRect.collisionChk(((GameObject)object).getCollisionRect())) continue;
                        ((GameObject)object).doWhileCollision(playerObject, 4);
                    }
                }
                if (playerObject.isAttracting() && object instanceof RingObject && (collisionRect = playerObject.attractRect).collisionChk((ringObject = (RingObject)object).getCollisionRect())) {
                    ringObject.beAttract();
                }
                if (((GameObject)object).collisionChkWithObject(playerObject)) {
                    ((GameObject)object).doWhileCollisionWrap(playerObject);
                    ((GameObject)object).firstTouch = false;
                } else {
                    ((GameObject)object).doWhileNoCollision();
                    ((GameObject)object).firstTouch = true;
                }
                ++n;
                continue;
            }
            n = 0;
            ++n2;
        }
        if (boss != null) {
            RingObject ringObject;
            if (bl) {
                for (int i = 0; i < playerObject.attackRectVec.size(); ++i) {
                    object = (CollisionRect)playerObject.attackRectVec.elementAt(i);
                    if (!((CollisionRect)object).collisionChk(boss.getCollisionRect())) continue;
                    boss.doWhileCollision(playerObject, 4);
                }
            }
            if (playerObject.isAttracting() && boss instanceof RingObject && ((CollisionRect)(object = playerObject.attractRect)).collisionChk((ringObject = (RingObject)boss).getCollisionRect())) {
                ringObject.beAttract();
            }
            if (boss.collisionChkWithObject(playerObject)) {
                boss.doWhileCollisionWrap(playerObject);
                GameObject.boss.firstTouch = false;
            } else {
                boss.doWhileNoCollision();
                GameObject.boss.firstTouch = true;
            }
        }
        BulletObject.checkWithAllBullet(playerObject);
    }

    public static void closeObject() {
        int n;
        if (player != null) {
            player.close();
        }
        if (allGameObject != null) {
            for (n = 0; n < objVecWidth; ++n) {
                for (int i = 0; i < objVecHeight; ++i) {
                    for (int j = 0; j < allGameObject[n][i].size(); ++j) {
                        ((GameObject)allGameObject[n][i].elementAt(j)).close();
                    }
                    allGameObject[n][i].removeAllElements();
                }
            }
            allGameObject = null;
        }
        for (n = 0; n < 4; ++n) {
            paintVec[n].removeAllElements();
        }
        SmallAnimal.animalClose();
        BulletObject.bulletClose();
        System.gc();
    }

    public static void closeObject(boolean bl) {
        GameObject.closeObject();
        if (!bl) {
            EnemyObject.releaseAllEnemyResource();
            GimmickObject.releaseGimmickResource();
        }
        System.gc();
    }

    public static boolean closeObjectStep(boolean bl) {
        boolean bl2 = true;
        block0 : switch (closeStep) {
            case 0: {
                if (player != null) {
                    player.close();
                }
                currentX = 0;
                currentY = 0;
                break;
            }
            case 1: {
                if (allGameObject == null) break;
                bl2 = false;
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < allGameObject[currentX][currentY].size(); ++j) {
                        ((GameObject)allGameObject[currentX][currentY].elementAt(j)).close();
                    }
                    allGameObject[currentX][currentY].removeAllElements();
                    if (++currentY < objVecHeight) continue;
                    currentY = 0;
                    if (++currentX < objVecWidth) continue;
                    bl2 = true;
                    allGameObject = null;
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 4; ++i) {
                    paintVec[i].removeAllElements();
                }
                break;
            }
            case 3: {
                SmallAnimal.animalClose();
                BulletObject.bulletClose();
                break;
            }
            case 4: {
                if (bl) break;
                EnemyObject.releaseAllEnemyResource();
                GimmickObject.releaseGimmickResource();
                break;
            }
            case 5: {
                System.gc();
                break;
            }
            case 6: {
                closeStep = 0;
                return true;
            }
        }
        if (bl2) {
            ++closeStep;
        }
        return false;
    }

    public static void quitGameState() {
        GameObject.closeObject(false);
        ItemObject.closeItem();
        SmallAnimal.releaseAllResource();
        PlayerObject.doWhileQuitGame();
        System.gc();
    }

    public static void setPlayerPosition(int n, int n2) {
        if (player != null) {
            GameObject.player.footPointX = n << 6;
            GameObject.player.footPointY = n2 << 6;
        }
    }

    public static void checkObjWhileMoving(GameObject gameObject) {
        int n = (MapManager.getCamera().x + (MapManager.CAMERA_WIDTH >> 1)) / 256;
        int n2 = (MapManager.getCamera().y + (MapManager.CAMERA_HEIGHT >> 1)) / 256;
        if (preCenterX == -1 && preCenterY == -1) {
            for (int i = n - 1; i <= n + 1; ++i) {
                if (i < 0 || i >= objVecWidth) continue;
                for (int j = n2 - 1; j <= n2 + 1; ++j) {
                    if (j < 0 || j >= objVecHeight) continue;
                    for (int k = 0; k < allGameObject[i][j].size(); ++k) {
                        GameObject gameObject2 = (GameObject)allGameObject[i][j].elementAt(k);
                        gameObject2.doInitWhileInCamera();
                    }
                }
            }
            preCenterX = n;
            preCenterY = n2;
        } else if (preCenterX != n || preCenterY != n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = n - preCenterX;
            int n9 = n2 - preCenterY;
            if (n8 != 0) {
                n7 = n + (n8 > 0 ? -2 : 2);
                if (n7 >= 0 && n7 < objVecWidth) {
                    for (n6 = -2; n6 <= 2; ++n6) {
                        if (n2 + n6 < 0 || n2 + n6 >= objVecHeight) continue;
                        for (n5 = 0; n5 < allGameObject[n7][n2 + n6].size(); ++n5) {
                            GameObject gameObject3 = (GameObject)allGameObject[n7][n2 + n6].elementAt(n5);
                            int n10 = (gameObject3.getCheckPositionX() >> 6) / 256;
                            n4 = (gameObject3.getCheckPositionY() >> 6) / 256;
                            if (n10 < 0 || n10 >= objVecWidth || n4 < 0 || n4 >= objVecHeight || n10 == n7 && n4 == n2 + n6) continue;
                            allGameObject[n7][n2 + n6].removeElementAt(n5);
                            --n5;
                            allGameObject[n10][n4].addElement(gameObject3);
                        }
                    }
                }
                if ((n6 = n + (n8 > 0 ? 1 : -1)) >= 0 && n6 < objVecWidth) {
                    for (n5 = n2 - 1; n5 <= n2 + 1; ++n5) {
                        if (n5 < 0 || n5 >= objVecHeight) continue;
                        for (int i = 0; i < allGameObject[n6][n5].size(); ++i) {
                            GameObject gameObject4 = (GameObject)allGameObject[n6][n5].elementAt(i);
                            n4 = (gameObject4.getCheckPositionX() >> 6) / 256;
                            n3 = (gameObject4.getCheckPositionY() >> 6) / 256;
                            if (n4 < 0 || n4 >= objVecWidth || n3 < 0 || n3 >= objVecHeight || n4 == n6 && n3 == n5) continue;
                            allGameObject[n6][n5].removeElementAt(i);
                            --i;
                            allGameObject[n4][n3].addElement(gameObject4);
                        }
                    }
                }
            }
            if (n9 != 0) {
                n7 = n2 + (n9 > 0 ? -2 : 2);
                if (n7 >= 0 && n7 < objVecHeight) {
                    for (n6 = -2; n6 <= 2; ++n6) {
                        if (n + n6 < 0 || n + n6 >= objVecWidth) continue;
                        for (n5 = 0; n5 < allGameObject[n + n6][n7].size(); ++n5) {
                            GameObject gameObject5 = (GameObject)allGameObject[n + n6][n7].elementAt(n5);
                            int n11 = (gameObject5.getCheckPositionX() >> 6) / 256;
                            n4 = (gameObject5.getCheckPositionY() >> 6) / 256;
                            if (n11 < 0 || n11 >= objVecWidth || n4 < 0 || n4 >= objVecHeight || n11 == n + n6 && n4 == n7) continue;
                            allGameObject[n + n6][n7].removeElementAt(n5);
                            --n5;
                            allGameObject[n11][n4].addElement(gameObject5);
                        }
                    }
                }
                if ((n6 = n2 + (n9 > 0 ? 1 : -1)) >= 0 && n6 < objVecHeight) {
                    for (n5 = n - 1; n5 <= n + 1; ++n5) {
                        if (n5 < 0 || n5 >= objVecWidth) continue;
                        for (int i = 0; i < allGameObject[n5][n6].size(); ++i) {
                            GameObject gameObject6 = (GameObject)allGameObject[n5][n6].elementAt(i);
                            n4 = (gameObject6.getCheckPositionX() >> 6) / 256;
                            n3 = (gameObject6.getCheckPositionY() >> 6) / 256;
                            if (n4 < 0 || n4 >= objVecWidth || n3 < 0 || n3 >= objVecHeight || n4 == n5 && n3 == n6) continue;
                            allGameObject[n5][n6].removeElementAt(i);
                            --i;
                            allGameObject[n4][n3].addElement(gameObject6);
                        }
                    }
                }
            }
            preCenterX = n;
            preCenterY = n2;
        }
    }

    public static void getGameObjectVecArray(GameObject gameObject, Vector vector) {
        vector.removeAllElements();
        int n = (MapManager.getCamera().x + (MapManager.CAMERA_WIDTH >> 1)) / 256;
        int n2 = (MapManager.getCamera().y + (MapManager.CAMERA_HEIGHT >> 1)) / 256;
        if (n < 0 || n >= objVecWidth || n2 < 0 || n2 >= objVecHeight) {
            return;
        }
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = n + 1;
        int n6 = n2 + 1;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 >= objVecWidth) {
            n5 = objVecWidth - 1;
        }
        if (n6 >= objVecHeight) {
            n6 = objVecHeight - 1;
        }
        if (allGameObject == null) {
            return;
        }
        for (int i = n3; i <= n5; ++i) {
            for (int j = n4; j <= n6; ++j) {
                vector.addElement(allGameObject[i][j]);
            }
        }
    }

    public static boolean checkPaintNecessary(GameObject gameObject) {
        return gameObject.isInCamera();
    }

    public boolean collisionChkWithObject(PlayerObject playerObject) {
        CollisionRect collisionRect = playerObject.getCollisionRect();
        CollisionRect collisionRect2 = this.getCollisionRect();
        rectH.setRect(collisionRect.x0, collisionRect.y0 + 192, collisionRect.getWidth(), collisionRect.getHeight() - 384);
        rectV.setRect(collisionRect.x0 + 192, collisionRect.y0, collisionRect.getWidth() - 384, collisionRect.getHeight());
        return collisionRect2.collisionChk(rectH) || collisionRect2.collisionChk(rectV);
    }

    public boolean onObjectChk(PlayerObject playerObject) {
        CollisionRect collisionRect = playerObject.getCollisionRect();
        CollisionRect collisionRect2 = this.getCollisionRect();
        rectH.setRect(collisionRect.x0, collisionRect.y0 + 192, collisionRect.getWidth(), collisionRect.getHeight() - 384);
        rectV.setRect(collisionRect.x0 + 192, collisionRect.y0, collisionRect.getWidth() - 384, collisionRect.getHeight());
        return collisionRect2.collisionChk(rectV);
    }

    public CollisionRect getCollisionRect() {
        return this.collisionRect;
    }

    public int getCheckPositionX() {
        return this.posX;
    }

    public int getCheckPositionY() {
        return this.posY;
    }

    public Coordinate getMoveDistance() {
        return this.moveDistance;
    }

    public void doWhileCollisionWrap(PlayerObject playerObject) {
        int n = 4;
        int n2 = playerObject.getMoveDistance().x;
        int n3 = playerObject.getMoveDistance().y;
        CollisionRect collisionRect = playerObject.getCollisionRect();
        CollisionRect collisionRect2 = playerObject.preCollisionRect;
        n2 = collisionRect.x0 - collisionRect2.x0;
        n3 = collisionRect.y0 - collisionRect2.y0;
        boolean bl = Math.abs(n2) >= Math.abs(n3);
        int n4 = 192;
        rectH.setRect(collisionRect.x0, collisionRect.y0 + n4, collisionRect.getWidth(), collisionRect.getHeight() - n4 * 2);
        rectV.setRect(collisionRect.x0 + n4, collisionRect.y0, collisionRect.getWidth() - n4 * 2, collisionRect.getHeight());
        if (bl && rectH.collisionChk(this.getCollisionRect())) {
            if (collisionRect.x1 - collisionRect2.x1 > 0 && collisionRect2.isLeftOf(this.collisionRect, n4) || !rectV.collisionChk(this.getCollisionRect()) && collisionRect.x0 < this.collisionRect.x0 && playerObject.getVelX() >= -192) {
                n = 3;
            } else if (collisionRect.x0 - collisionRect2.x0 < 0 && collisionRect2.isRightOf(this.collisionRect, n4) || !rectV.collisionChk(this.getCollisionRect()) && collisionRect.x1 > this.collisionRect.x1 && playerObject.getVelX() <= 192) {
                n = 2;
            }
        }
        if (n == 4 && rectV.collisionChk(this.getCollisionRect())) {
            if (collisionRect.y1 - collisionRect2.y1 > 0 && collisionRect2.isUpOf(this.collisionRect, n4 + 5)) {
                n = 1;
            } else if (collisionRect.y0 - collisionRect2.y0 < 0 && collisionRect2.isDownOf(this.collisionRect, n4)) {
                n = 0;
            }
        }
        if (n == 4 && rectH.collisionChk(this.getCollisionRect())) {
            if (collisionRect.x1 - collisionRect2.x1 > 0 && collisionRect2.isLeftOf(this.collisionRect, n4) || !rectV.collisionChk(this.getCollisionRect()) && collisionRect.x0 < this.collisionRect.x0 && playerObject.getVelX() >= -192) {
                n = 3;
            } else if (collisionRect.x0 - collisionRect2.x0 < 0 && collisionRect2.isRightOf(this.collisionRect, n4) || !rectV.collisionChk(this.getCollisionRect()) && collisionRect.x1 > this.collisionRect.x1 && playerObject.getVelX() <= 192) {
                n = 2;
            }
        }
        if (player.inRailState()) {
            this.doWhileRail(playerObject, n);
        } else {
            this.doWhileCollision(playerObject, n);
        }
    }

    public void doWhileCollisionWrapWithPlayer() {
        if (player == null || GameObject.player.isDead) {
            return;
        }
        int n = 4;
        int n2 = this.collisionRect.x0 - this.preCollisionRect.x0;
        int n3 = this.collisionRect.y0 - this.preCollisionRect.y0;
        boolean bl = Math.abs(n2) >= Math.abs(n3);
        int n4 = 192;
        player.refreshCollisionRectWrap();
        rectH.setRect(GameObject.player.collisionRect.x0, GameObject.player.collisionRect.y0 + n4, GameObject.player.collisionRect.getWidth(), GameObject.player.collisionRect.getHeight() - n4 * 2);
        rectV.setRect(GameObject.player.collisionRect.x0 + n4, GameObject.player.collisionRect.y0, GameObject.player.collisionRect.getWidth() - n4 * 2, GameObject.player.collisionRect.getHeight());
        if (bl && rectH.collisionChk(this.getCollisionRect())) {
            if (this.collisionRect.x1 > this.preCollisionRect.x1 && this.preCollisionRect.isLeftOf(GameObject.player.collisionRect, n4)) {
                n = 2;
            } else if (this.collisionRect.x0 < this.preCollisionRect.x0 && this.preCollisionRect.isRightOf(GameObject.player.collisionRect, n4)) {
                n = 3;
            }
        }
        if (n == 4 && rectV.collisionChk(this.getCollisionRect())) {
            if (this.collisionRect.y1 > this.preCollisionRect.y1 && this.preCollisionRect.isUpOf(GameObject.player.collisionRect, n4)) {
                n = 0;
            } else if (this.collisionRect.y0 < this.preCollisionRect.y0 && this.preCollisionRect.isDownOf(GameObject.player.collisionRect, n4)) {
                n = 1;
            }
        }
        if (n == 4 && rectH.collisionChk(this.getCollisionRect())) {
            if (this.collisionRect.x1 > this.preCollisionRect.x1 && this.preCollisionRect.isLeftOf(GameObject.player.collisionRect, n4)) {
                n = 2;
            } else if (this.collisionRect.x0 < this.preCollisionRect.x0 && this.preCollisionRect.isRightOf(GameObject.player.collisionRect, n4)) {
                n = 3;
            }
        }
        if (!player.isFootOnObject(this)) {
            if (this.collisionChkWithObject(player)) {
                if (GameObject.player.railing) {
                    this.doWhileRail(player, n);
                } else {
                    this.doWhileCollision(player, n);
                }
            }
        } else {
            player.moveOnObject(GameObject.player.footPointX + n2, this.collisionRect.y0);
        }
        this.preCollisionRect.setTwoPosition(this.collisionRect.x0, this.collisionRect.y0, this.collisionRect.x1, this.collisionRect.y1);
    }

    public int getGroundY(int n, int n2) {
        int n3;
        int n4;
        int n5 = n / 512;
        int n6 = n2 / 512;
        if (n6 < 0 || n6 >= MapManager.getMapHeight() * 12) {
            return n2;
        }
        if (n5 < 0 || n5 >= MapManager.getMapWidth() * 12) {
            return n2;
        }
        CollisionMap.getCollisionInfoWithBlock(n5, n6, 1, groundblock);
        int n7 = groundblock.getCollisionY(n);
        CollisionMap.getCollisionInfoWithBlock(n5, n6, 0, groundblock);
        int n8 = groundblock.getCollisionY(n);
        int n9 = 1;
        if (n7 == -1 && n8 != -1) {
            n9 = 0;
            n7 = n8;
        }
        if (n7 != -1 && n8 == -1) {
            n9 = 1;
        }
        while (n7 == 0 && n6 >= 0) {
            CollisionMap.getCollisionInfoWithBlock(n5, --n6, n9, groundblock);
            CollisionMap.getCollisionInfoWithBlock(n5, n6, 1, groundblock);
            n4 = groundblock.getCollisionY(n);
            CollisionMap.getCollisionInfoWithBlock(n5, n6, 0, groundblock);
            n3 = groundblock.getCollisionY(n);
            if (n4 == -1 && n3 != -1) {
                n9 = 0;
            }
            if (n4 != -1 && n3 == -1) {
                n9 = 1;
            }
            CollisionMap.getCollisionInfoWithBlock(n5, n6, n9, groundblock);
            n7 = groundblock.getCollisionY(n);
        }
        while (n7 == -1 && n6 < MapManager.getMapHeight() * 12) {
            CollisionMap.getCollisionInfoWithBlock(n5, ++n6, n9, groundblock);
            CollisionMap.getCollisionInfoWithBlock(n5, n6, 1, groundblock);
            n4 = groundblock.getCollisionY(n);
            CollisionMap.getCollisionInfoWithBlock(n5, n6, 0, groundblock);
            n3 = groundblock.getCollisionY(n);
            if (n4 == -1 && n3 != -1) {
                n9 = 0;
            }
            if (n4 != -1 && n3 == -1) {
                n9 = 1;
            }
            CollisionMap.getCollisionInfoWithBlock(n5, n6, n9, groundblock);
            n7 = groundblock.getCollisionY(n);
        }
        n2 = this.getBlockUpSide(n5, n6) + (n7 << 6);
        return n2;
    }

    public void drawInMap(MFGraphics mFGraphics, AnimationDrawer animationDrawer, int n, int n2) {
        animationDrawer.draw(mFGraphics, (n >> 6) - GameObject.camera.x, (n2 >> 6) - GameObject.camera.y);
    }

    public void drawInMap(MFGraphics mFGraphics, AnimationDrawer animationDrawer) {
        this.drawInMap(mFGraphics, animationDrawer, this.posX, this.posY);
    }

    public void drawInMap(MFGraphics mFGraphics, MFImage mFImage, int n, int n2, int n3) {
        MyAPI.drawImage(mFGraphics, mFImage, (n >> 6) - GameObject.camera.x, (n2 >> 6) - GameObject.camera.y, n3);
    }

    public void drawInMap(MFGraphics mFGraphics, MFImage mFImage, int n) {
        this.drawInMap(mFGraphics, mFImage, this.posX, this.posY, n);
    }

    public void drawInMap(MFGraphics mFGraphics, MFImage mFImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        MyAPI.drawRegion(mFGraphics, mFImage, n, n2, n3, n4, n5, (n6 >> 6) - GameObject.camera.x, (n7 >> 6) - GameObject.camera.y, n8);
    }

    public void drawInMap(MFGraphics mFGraphics, MFImage mFImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawInMap(mFGraphics, mFImage, n, n2, n3, n4, n5, this.posX, this.posY, n6);
    }

    public int getBlockLeftSide(int n, int n2) {
        return n + 0 << 3 << 6;
    }

    public int getBlockRightSide(int n, int n2) {
        return (n + 1 << 3) - 1 << 6;
    }

    public int getBlockUpSide(int n, int n2) {
        return n2 + 0 << 3 << 6;
    }

    public int getBlockDownSide(int n, int n2) {
        return (n2 + 1 << 3) - 1 << 6;
    }

    public void checkWithPlayer(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            this.refreshCollisionRect(n3, n4);
            this.doWhileCollisionWrapWithPlayer();
            return;
        }
        boolean bl = Math.abs(n5) >= Math.abs(n6);
        int n7 = bl ? Math.abs(n5) : Math.abs(n6);
        int n8 = n;
        int n9 = n2;
        int n10 = 0;
        while (n10 <= n7 && n10 < n7) {
            if ((n10 += 512) >= n7) {
                n10 = n7;
            }
            int n11 = n + n5 * n10 / n7;
            int n12 = n2 + n6 * n10 / n7;
            this.refreshCollisionRect(n11, n12);
            this.doWhileCollisionWrapWithPlayer();
            n8 = n11;
            n9 = n12;
        }
    }

    public boolean isInCamera() {
        return this.isInCamera(40);
    }

    public boolean isFarAwayCamera() {
        return !this.isInCamera(256);
    }

    public boolean isInCamera(int n) {
        Coordinate coordinate = MapManager.getCamera();
        screenRect.setRect(coordinate.x + MapManager.CAMERA_OFFSET_X << 6, coordinate.y + MapManager.CAMERA_OFFSET_Y << 6, MapManager.CAMERA_WIDTH << 6, MapManager.CAMERA_HEIGHT << 6);
        GameObject.screenRect.x0 -= n << 6;
        GameObject.screenRect.x1 += n << 6;
        GameObject.screenRect.y0 -= n << 6;
        GameObject.screenRect.y1 += n << 6;
        return this.collisionRect.collisionChk(screenRect);
    }

    public void doWhileNoCollision() {
    }

    public boolean objectChkDestroy() {
        return false;
    }

    public void doInitWhileInCamera() {
    }

    public boolean canBeInit() {
        return true;
    }

    public int getPaintLayer() {
        return 1;
    }

    public boolean releaseWhileBeHurt() {
        return false;
    }

    public void refreshCollisionRectWrap() {
        this.refreshCollisionRect(this.posX, this.posY);
        this.preCollisionRect.setTwoPosition(this.collisionRect.x0, this.collisionRect.y0, this.collisionRect.x1, this.collisionRect.y1);
    }

    public void transportTo(int n, int n2) {
        this.posX = n;
        this.posY = n2;
        this.refreshCollisionRect(this.posX, this.posY);
        this.preCollisionRect.setTwoPosition(this.collisionRect.x0, this.collisionRect.y0, this.collisionRect.x1, this.collisionRect.y1);
    }

    public abstract void logic();

    public abstract void draw(MFGraphics var1);

    public abstract void doWhileCollision(PlayerObject var1, int var2);

    public abstract void refreshCollisionRect(int var1, int var2);

    public abstract void close();

    public boolean checkInit() {
        resetRect.setRect((MapManager.getCamera().x + (MapManager.CAMERA_WIDTH >> 1) << 6) - 14720, (MapManager.getCamera().y + (MapManager.CAMERA_HEIGHT >> 1) << 6) - 14720, 29440, 29440);
        if (this.needInit) {
            if (!resetRect.collisionChk(this.collisionRect) && this.canBeInit()) {
                this.doInitWhileInCamera();
                this.refreshCollisionRect(this.posX, this.posY);
                GameObject.addGameObject(this);
                this.needInit = false;
                return true;
            }
        } else if (resetRect.collisionChk(this.collisionRect)) {
            this.needInit = true;
        }
        return false;
    }

    public void doWhileRail(PlayerObject playerObject, int n) {
    }

    public void checkWithMap(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = n5;
        int n8 = n6;
        boolean bl = n6 < 0;
        boolean bl2 = n5 < 0;
        int n9 = (Math.abs(n7) + 512 - 1) / 512;
        int n10 = (Math.abs(n8) + 512 - 1) / 512;
        boolean bl3 = n9 > n10;
        int n11 = n;
        int n12 = n2;
        if (n8 > 0) {
            for (int i = 0; i <= (bl3 ? n9 : n10); ++i) {
                int n13;
                int n14;
                if (bl3) {
                    n14 = n11 + (n7 >= 0 ? 1 : -1) * 512 * i;
                    n13 = (n12 * n9 + n8 * i) / n9;
                    if (n7 > 0) {
                        if (n14 > n11 + n7) {
                            n14 = n11 + n7;
                            n13 = n12 + n8;
                        }
                    } else if (n7 < 0) {
                        if (n14 < n11 + n7) {
                            n14 = n11 + n7;
                            n13 = n12 + n8;
                        }
                    } else {
                        n14 = n11;
                    }
                } else {
                    n13 = n12 + (n8 >= 0 ? 1 : -1) * 512 * i;
                    n14 = (n11 * n10 + n7 * i) / n10;
                    if (n13 > n12 + n8) {
                        n14 = n11 + n7;
                        n13 = n12 + n8;
                    }
                }
                int n15 = this.getDownCheckPointY(n14, n13);
                int n16 = n15 - n13;
                int n17 = this.downSideCollisionChk(n14, n15);
                if (n17 < 0) continue;
                this.posY = n17 - n16;
                this.posX = n14;
                break;
            }
        }
    }

    public int getDownCheckPointY(int n, int n2) {
        this.refreshCollisionRect(n, n2);
        return this.collisionRect.y1;
    }

    public int downSideCollisionChk(int n, int n2) {
        int n3 = 1;
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), n3, groundblock);
        int n4 = groundblock.getCollisionY(n >> 6);
        if (n4 < 0) {
            n3 = 0;
            CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), n3, groundblock);
            n4 = groundblock.getCollisionY(n >> 6);
        }
        int n5 = 0;
        if (n4 >= 0 && !groundblock.getReverseY(n >> 6, groundblock.getDegreeNearby(n5))) {
            int n6 = this.getBlockUpSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n4 << 6);
            int n7 = this.getQuaParam(n2, 512);
            if (n2 >= n6) {
                while (n4 >= 0) {
                    n6 = this.getBlockUpSide(this.getQuaParam(n, 512), n7) + (n4 << 6);
                    CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), --n7, n3, groundblock);
                    n4 = groundblock.getCollisionY(n >> 6);
                }
                CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n6, 512), n3, groundblock);
                int n8 = Math.abs(n5 - groundblock.getDegreeNearby(n5));
                if (n8 > 180) {
                    n8 = 360 - n8;
                }
                return n6;
            }
        }
        return -1;
    }

    public int getQuaParam(int n, int n2) {
        if (n > 0) {
            return n / n2;
        }
        return (n - (n2 - 1)) / n2;
    }

    public void drawCollisionRect(MFGraphics mFGraphics) {
        if (SonicDebug.showCollisionRect) {
            mFGraphics.setColor(0xFF0000);
            mFGraphics.drawRect((this.collisionRect.x0 >> 6) - GameObject.camera.x, (this.collisionRect.y0 >> 6) - GameObject.camera.y, this.collisionRect.getWidth() >> 6, this.collisionRect.getHeight() >> 6);
            mFGraphics.drawRect((this.collisionRect.x0 >> 6) - GameObject.camera.x + 1, (this.collisionRect.y0 >> 6) - GameObject.camera.y + 1, (this.collisionRect.getWidth() >> 6) - 2, (this.collisionRect.getHeight() >> 6) - 2);
        }
    }

    static {
        mainObjectLogicVec = new Vector();
        playerCheckVec = new Vector();
        paintVec = new Vector[4];
        for (int i = 0; i < 4; ++i) {
            GameObject.paintVec[i] = new Vector();
        }
        GRAVITY = 172;
        destroyEffectAnimation = null;
        soundInstance = null;
        bossFighting = false;
        loadStep = 0;
        ds = null;
        closeStep = 0;
        preCenterX = -1;
        preCenterY = -1;
        screenRect = new CollisionRect();
        rectH = new CollisionRect();
        rectV = new CollisionRect();
        groundblock = new CollisionBlock();
        resetRect = new CollisionRect();
    }
}

