/*
 * Decompiled with CFR 0.152.
 */
class Furiko
extends GimmickObject {
    public int centerX;
    public int centerY;
    public static int degree = 2240;
    public static int lineVelocity = 0;
    public boolean touching = false;
    public int thisDegree;
    public int leaveCount = 0;

    protected Furiko(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (Arm.baseImage == null) {
            try {
                Arm.baseImage = MFImage.createImage("/gimmick/part_1_2.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (GimmickObject.hookImage == null) {
            try {
                GimmickObject.hookImage = MFImage.createImage("/gimmick/hook.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.centerX = this.posX;
        this.centerY = this.posY;
    }

    public static void staticLogic() {
        lineVelocity += (GameObject.GRAVITY - 60) * MyAPI.dSin((degree >> 6) - 90) / 100;
        degree -= ((lineVelocity << 6) / 4480 << 6) * 180 / 201;
    }

    public void logic() {
        if (this.leaveCount > 0) {
            --this.leaveCount;
        }
        this.thisDegree = degree >> 6;
        if (this.iLeft != 0) {
            this.thisDegree = 180 - this.thisDegree;
        }
        this.posX = this.centerX + 4480 * MyAPI.dCos(this.thisDegree) / 100;
        this.posY = this.centerY + 4480 * MyAPI.dSin(this.thisDegree) / 100;
        this.refreshCollisionRect(this.posX, this.posY);
        if (this.touching) {
            GameObject.player.doPullMotion(this.posX, this.posY + 960 + 640);
            if (Key.press(Key.gUp | 0x1000000)) {
                GameObject.player.outOfControl = false;
                this.touching = false;
                GameObject.player.doJump();
                this.leaveCount = 10;
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        for (int i = 0; i < 4; ++i) {
            int n = this.centerX + (i + 1) * 960 * MyAPI.dCos(this.thisDegree) / 100;
            int n2 = this.centerY + (i + 1) * 960 * MyAPI.dSin(this.thisDegree) / 100;
            this.drawInMap(mFGraphics, Arm.baseImage, 8, 0, 8, 8, 0, n, n2, 3);
        }
        this.drawInMap(mFGraphics, GimmickObject.hookImage, 0, 0, 16, 24, 0, 17);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 512, n2 + 960, 1024, 640);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (!this.touching && this.firstTouch && this.leaveCount == 0) {
            this.touching = true;
            playerObject.setOutOfControl(this);
        }
    }

    public void close() {
    }

    public static void releaseAllResource() {
    }
}

