/*
 * Decompiled with CFR 0.152.
 */
class Spring
extends GimmickObject {
    public static Animation springAnimation = null;
    public AnimationDrawer drawer;
    public static final int[][] COLLISION_PARAM = new int[][]{{-15, -15, 30, 15}, {-15, 0, 30, 15}, {-16, -28, 16, 28}, {0, -28, 16, 28}, {-22, -30, 26, 26}, {-4, -30, 26, 26}, {-22, -21, 26, 13}, {-4, -21, 26, 13}};
    public static final int[] SPRING_POWER = new int[]{1968 + (GameObject.GRAVITY >> 1), 2351 + (GameObject.GRAVITY >> 1), 2744 + (GameObject.GRAVITY >> 1), 3234};
    public int springPower;
    public int centerPointX;

    public Spring(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (springAnimation == null) {
            springAnimation = new Animation("/animation/se_bane_kiro");
        }
        if (this.iLeft < 0) {
            this.iLeft = 0;
        } else if (this.iLeft > 3) {
            this.iLeft = 3;
        }
        this.springPower = SPRING_POWER[this.iLeft];
        this.drawer = springAnimation.getDrawer((this.objId - 8) * 2, false, 0);
        if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
            this.drawer.setActionId(this.objId * 2);
        }
        this.centerPointX = this.collisionRect.x0 + this.collisionRect.x1 >> 1;
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer, this.posX, this.posY);
        if (this.drawer.checkEnd()) {
            if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
                this.drawer.setActionId(this.objId * 2);
            } else {
                this.drawer.setActionId((this.objId - 8) * 2);
            }
        }
        this.drawCollisionRect(mFGraphics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doWhileCollision(PlayerObject playerObject, int n) {
        block35: {
            if (this.used) {
                return;
            }
            playerObject.beStop(this.collisionRect.x0, n, this);
            if (playerObject != GameObject.player) return;
            switch (n) {
                case 3: {
                    switch (this.objId) {
                        case 12: 
                        case 14: {
                            if (GameObject.player.getCheckPositionX() >= this.centerPointX) return;
                            GameObject.player.beSpring(this.springPower, 1);
                            GameObject.player.beSpring(this.springPower * 7 / 10, n);
                            this.drawer.setActionId((this.objId - 8) * 2 + 1);
                            GameObject.player.setFootPositionY(this.collisionRect.y0);
                            return;
                        }
                        case 10: {
                            GameObject.player.faceDirection = false;
                            GameObject.player.beSpring(this.springPower, n);
                            this.drawer.setActionId((this.objId - 8) * 2 + 1);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.objId) {
                        case 13: 
                        case 15: {
                            if (GameObject.player.getCheckPositionX() <= this.centerPointX) return;
                            GameObject.player.beSpring(this.springPower, 1);
                            GameObject.player.beSpring(this.springPower * 7 / 10, n);
                            this.drawer.setActionId((this.objId - 8) * 2 + 1);
                            GameObject.player.setFootPositionY(this.collisionRect.y0);
                            return;
                        }
                        case 11: {
                            GameObject.player.faceDirection = true;
                            GameObject.player.beSpring(this.springPower, n);
                            this.drawer.setActionId((this.objId - 8) * 2 + 1);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 0: {
                    switch (this.objId) {
                        case 9: {
                            GameObject.player.beSpring(this.springPower, n);
                            if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
                                this.drawer.setActionId(this.objId * 2 + 1);
                                return;
                            }
                            this.drawer.setActionId((this.objId - 8) * 2 + 1);
                        }
                    }
                    return;
                }
                case 1: {
                    switch (this.objId) {
                        case 8: {
                            GameObject.player.beSpring(this.springPower, n);
                            if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
                                this.drawer.setActionId(this.objId * 2 + 1);
                            } else {
                                this.drawer.setActionId((this.objId - 8) * 2 + 1);
                            }
                            if (this.iLeft != 1) return;
                            GameObject.player.setAnimationId(14);
                            break block35;
                        }
                        case 13: 
                        case 15: {
                            if (GameObject.player.getCheckPositionX() <= this.centerPointX) return;
                            GameObject.player.beSpring(this.springPower * 7 / 10, 2);
                            GameObject.player.beSpring(this.springPower, n);
                            if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
                                this.drawer.setActionId(this.objId * 2 + 1);
                            } else {
                                this.drawer.setActionId((this.objId - 8) * 2 + 1);
                            }
                            if (this.iLeft == 1) {
                                GameObject.player.setAnimationId(14);
                            }
                            GameObject.player.setFootPositionY(this.collisionRect.y0);
                            break block35;
                        }
                        case 12: 
                        case 14: {
                            if (GameObject.player.getCheckPositionX() >= this.centerPointX) return;
                            GameObject.player.beSpring(this.springPower * 7 / 10, 3);
                            GameObject.player.beSpring(this.springPower, n);
                            if ((this.objId == 8 || this.objId == 9) && this.iLeft == 2) {
                                this.drawer.setActionId(this.objId * 2 + 1);
                            } else {
                                this.drawer.setActionId((this.objId - 8) * 2 + 1);
                            }
                            if (this.iLeft == 1) {
                                GameObject.player.setAnimationId(14);
                            }
                            GameObject.player.setFootPositionY(this.collisionRect.y0);
                        }
                    }
                }
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n + (COLLISION_PARAM[this.objId - 8][0] << 6), n2 + (COLLISION_PARAM[this.objId - 8][1] << 6), COLLISION_PARAM[this.objId - 8][2] << 6, COLLISION_PARAM[this.objId - 8][3] << 6);
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        springAnimation = null;
    }
}

