/*
 * Decompiled with CFR 0.152.
 */
class RollIsland
extends GimmickObject {
    public static Animation animation = null;
    public AnimationDrawer drawer;
    public static final int[][] DIRECTION = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    public int velocity;
    public int moveDistance;
    public int posOriginalX;
    public int posOriginalY;
    public boolean controlling;
    public byte noCollisionCount;

    protected RollIsland(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posX += 256;
        this.posY += 256;
        if (animation == null) {
            animation = new Animation("/animation/roll_island");
        }
        this.drawer = animation.getDrawer(0, true, 0);
        this.moveDistance = n6 * 42 * 4 + n5 * 4;
        if (this.iLeft % 2 == 1) {
            this.moveDistance >>= 1;
        }
        this.posOriginalX = this.posX;
        this.posOriginalY = this.posY;
        this.controlling = false;
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 896, n2 - 896, 1792, 1792);
    }

    public void logic() {
        if (this.noCollisionCount > 0) {
            this.noCollisionCount = (byte)(this.noCollisionCount - 1);
        }
        if (GameObject.player.outOfControl && GameObject.player.outOfControlObject == this) {
            if (Key.repeat(Key.gRight)) {
                this.velocity += 40;
                if (this.velocity > 1040) {
                    this.velocity = 1040;
                }
                GameObject.player.faceDirection = true;
            } else if (Key.repeat(Key.gLeft)) {
                this.velocity -= 40;
                if (this.velocity < -1040) {
                    this.velocity = -1040;
                }
                GameObject.player.faceDirection = false;
            } else if (this.posX != this.posOriginalX || this.posY != this.posOriginalY) {
                this.velocity -= 40;
            }
            this.rollLogic();
            int n = GameObject.player.getFootPositionX();
            int n2 = GameObject.player.getFootPositionY();
            GameObject.player.setFootPositionX(this.posX);
            GameObject.player.setFootPositionY(this.collisionRect.y0);
            GameObject.player.checkWithObject(n, n2, GameObject.player.getFootPositionX(), GameObject.player.getFootPositionY());
            if (GameObject.player.outOfControl && GameObject.player.outOfControlObject == this) {
                if (Math.abs(this.velocity) == 0) {
                    GameObject.player.setAnimationId(0);
                } else if (Math.abs(this.velocity) < 160) {
                    GameObject.player.setAnimationId(1);
                } else if (Math.abs(this.velocity) < 1020) {
                    GameObject.player.setAnimationId(2);
                } else {
                    GameObject.player.setAnimationId(3);
                }
                if (Key.press(Key.gUp | 0x1000000)) {
                    GameObject.player.outOfControl = false;
                    this.controlling = false;
                    GameObject.player.doJump();
                    if (this.velocity > 0) {
                        GameObject.player.setVelX(200);
                    } else if (this.velocity < 0) {
                        GameObject.player.setVelX(-200);
                    } else {
                        GameObject.player.setVelX(0);
                    }
                }
            }
        } else {
            this.velocity -= 40;
            this.rollLogic();
        }
    }

    public boolean releaseWhileBeHurt() {
        this.noCollisionCount = 0;
        return true;
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.noCollisionCount > 0) {
            return;
        }
        playerObject.beStop(0, n, this);
        if (n == 1) {
            playerObject.setOutOfControl(this);
            this.controlling = true;
        }
    }

    public void rollLogic() {
        this.posX += DIRECTION[this.iLeft][0] * this.velocity;
        this.posY += DIRECTION[this.iLeft][1] * this.velocity;
        if (this.velocity > 0) {
            if (DIRECTION[this.iLeft][0] > 0) {
                if (this.posX > this.posOriginalX + this.moveDistance) {
                    this.posX = this.posOriginalX + this.moveDistance;
                }
            } else if (DIRECTION[this.iLeft][0] < 0 && this.posX < this.posOriginalX - this.moveDistance) {
                this.posX = this.posOriginalX - this.moveDistance;
            }
            if (DIRECTION[this.iLeft][1] > 0) {
                if (this.posY > this.posOriginalY + this.moveDistance) {
                    this.posY = this.posOriginalY + this.moveDistance;
                }
            } else if (DIRECTION[this.iLeft][1] < 0 && this.posY < this.posOriginalY - this.moveDistance) {
                this.posY = this.posOriginalY - this.moveDistance;
            }
            this.drawer.setActionId(1);
        } else {
            if (DIRECTION[this.iLeft][0] > 0) {
                if (this.posX < this.posOriginalX) {
                    this.posX = this.posOriginalX;
                }
            } else if (DIRECTION[this.iLeft][0] < 0 && this.posX > this.posOriginalX) {
                this.posX = this.posOriginalX;
            }
            if (DIRECTION[this.iLeft][1] > 0) {
                if (this.posY < this.posOriginalY) {
                    this.posY = this.posOriginalY;
                }
            } else if (DIRECTION[this.iLeft][1] < 0 && this.posY > this.posOriginalY) {
                this.posY = this.posOriginalY;
            }
            this.drawer.setActionId(1);
        }
        this.drawer.setActionId(1);
        if (this.posX == this.posOriginalX && this.posY == this.posOriginalY) {
            this.velocity = 0;
        }
        if (this.velocity == 0) {
            this.drawer.setActionId(0);
        }
        this.refreshCollisionRect(this.posX, this.posY);
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        animation = null;
    }
}

