/*
 * Decompiled with CFR 0.152.
 */
class PipeIn
extends GimmickObject {
    public static Animation pipeAnimation;
    public AnimationDrawer drawer;
    public int direction;
    public static final int[] TRANS;

    protected PipeIn(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (pipeAnimation == null) {
            pipeAnimation = new Animation("/animation/pipe_in");
        }
        if (this.iTop > this.iLeft) {
            this.direction = this.iTop > 0 ? 1 : 0;
            this.posX += 256;
        } else {
            this.direction = this.iLeft > 0 ? 3 : 2;
            this.posY -= 256;
        }
        this.drawer = pipeAnimation.getDrawer(0, true, TRANS[this.direction]);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        switch (this.direction) {
            case 0: {
                this.collisionRect.setRect(n - 1152, n2, 2304, 2560);
                break;
            }
            case 1: {
                this.collisionRect.setRect(n - 1152, n2 - 2560, 2304, 2560);
                break;
            }
            case 2: {
                this.collisionRect.setRect(n, n2 - 1152, 2560, 2304);
                break;
            }
            case 3: {
                this.collisionRect.setRect(n - 2560, n2 - 1152, 2560, 2304);
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (GameObject.player.piping) {
            return;
        }
        switch (n) {
            case 0: {
                if (this.direction != 1) break;
                return;
            }
            case 1: {
                if (this.direction != 0) break;
                return;
            }
            case 2: {
                if (this.direction != 3) break;
                return;
            }
            case 3: {
                if (this.direction != 2) break;
                return;
            }
        }
        if (this.direction == n) {
            GameObject.player.pipeIn(this.posX, this.posY, this.iLeft, this.iTop);
            GameObject.player.changeVisible(false);
            SoundSystem.getInstance().playSe(2);
        } else {
            playerObject.beStop(0, n, this);
        }
    }

    public void close() {
        this.drawer = null;
    }

    public int getPaintLayer() {
        return 2;
    }

    public static void releaseAllResource() {
        pipeAnimation = null;
    }

    static {
        TRANS = new int[]{0, 3, 6, 5};
    }
}

