/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;

public class MapManager
implements SonicDef {
    public static Coordinate camera = new Coordinate();
    public static PlayerObject focusObj;
    public static int cameraActionX;
    public static int cameraActionY;
    public static final int CAMERA_WIDTH;
    public static final int CAMERA_HEIGHT;
    public static final int CAMERA_OFFSET_X;
    public static final int CAMERA_OFFSET_Y;
    public static boolean cameraLocked;
    public static int mapWidth;
    public static int mapHeight;
    public static int IMAGE_TILE_WIDTH;
    public static int proposeLeftCameraLimit;
    public static int proposeRightCameraLimit;
    public static int actualLeftCameraLimit;
    public static int actualRightCameraLimit;
    public static int proposeDownCameraLimit;
    public static int actualDownCameraLimit;
    public static int proposeUpCameraLimit;
    public static int actualUpCameraLimit;
    public static Coordinate reCamera;
    public static MFImage image;
    public static short[][][] mapModel;
    public static short[][] mapFront;
    public static short[][] mapBack;
    public static InputStream is;
    public static DataInputStream ds;
    public static int loadStep;
    public static final int[][] WIND_POSITION;
    public static final int LOOP_COUNT;
    public static MFImage windImage;
    public static AnimationDrawer windDrawer;
    public static int shakeCount;

    public static void cameraLogic() {
        if (focusObj == null || cameraLocked) {
            return;
        }
        if (MapManager.getPixelWidth() < CAMERA_WIDTH) {
            MapManager.camera.x = (CAMERA_WIDTH - MapManager.getPixelWidth()) / 2;
        } else {
            MapManager.cameraActionX();
            if (actualLeftCameraLimit > proposeLeftCameraLimit) {
                if ((actualLeftCameraLimit -= 5) < proposeLeftCameraLimit) {
                    actualLeftCameraLimit = proposeLeftCameraLimit;
                }
            } else if (actualLeftCameraLimit < proposeLeftCameraLimit && (actualLeftCameraLimit += 5) > proposeLeftCameraLimit) {
                actualLeftCameraLimit = proposeLeftCameraLimit;
            }
            if (actualRightCameraLimit < proposeRightCameraLimit) {
                if ((actualRightCameraLimit += 5) > proposeRightCameraLimit) {
                    actualRightCameraLimit = proposeRightCameraLimit;
                }
            } else if (actualRightCameraLimit > proposeRightCameraLimit && (actualRightCameraLimit -= 5) < proposeRightCameraLimit) {
                actualRightCameraLimit = proposeRightCameraLimit;
            }
            if (MapManager.camera.x < actualLeftCameraLimit - CAMERA_OFFSET_X) {
                MapManager.camera.x = actualLeftCameraLimit - CAMERA_OFFSET_X;
                cameraActionX = 0;
            }
            if (actualRightCameraLimit != MapManager.getPixelWidth() && MapManager.camera.x > actualRightCameraLimit - CAMERA_WIDTH - CAMERA_OFFSET_X) {
                MapManager.camera.x = actualRightCameraLimit - CAMERA_WIDTH - CAMERA_OFFSET_X;
                cameraActionX = 0;
            }
            if (actualRightCameraLimit != MapManager.getPixelWidth() && Math.abs(actualRightCameraLimit - actualLeftCameraLimit) < CAMERA_WIDTH) {
                MapManager.camera.x = actualRightCameraLimit + actualLeftCameraLimit - CAMERA_WIDTH >> 1;
                cameraActionX = 0;
            }
        }
        if (MapManager.getPixelHeight() < CAMERA_HEIGHT) {
            MapManager.camera.y = (CAMERA_HEIGHT - MapManager.getPixelHeight()) / 2;
        } else {
            MapManager.cameraActionY();
            if (actualDownCameraLimit > proposeDownCameraLimit) {
                if ((actualDownCameraLimit -= 5) < proposeDownCameraLimit) {
                    actualDownCameraLimit = proposeDownCameraLimit;
                }
            } else if (actualDownCameraLimit < proposeDownCameraLimit && (actualDownCameraLimit += 5) > proposeDownCameraLimit) {
                actualDownCameraLimit = proposeDownCameraLimit;
            }
            if (actualUpCameraLimit < proposeUpCameraLimit) {
                if ((actualUpCameraLimit += 5) > proposeUpCameraLimit) {
                    actualUpCameraLimit = proposeUpCameraLimit;
                }
            } else if (actualUpCameraLimit > proposeUpCameraLimit && (actualUpCameraLimit -= 5) < proposeUpCameraLimit) {
                actualUpCameraLimit = proposeUpCameraLimit;
            }
            if (MapManager.camera.y < actualUpCameraLimit - CAMERA_OFFSET_Y) {
                MapManager.camera.y = actualUpCameraLimit - CAMERA_OFFSET_Y;
                cameraActionY = 0;
            } else if (MapManager.camera.y > actualDownCameraLimit - CAMERA_HEIGHT - CAMERA_OFFSET_Y) {
                MapManager.camera.y = actualDownCameraLimit - CAMERA_HEIGHT - CAMERA_OFFSET_Y;
                cameraActionY = 0;
            }
        }
        if (shakeCount > 0) {
            int n = --shakeCount * 6 / 14;
            MapManager.camera.y = MapManager.camera.y + (shakeCount % 2 == 0 ? n : -n);
            if (MapManager.camera.x < 0) {
                MapManager.camera.x = 0;
            }
            if (MapManager.camera.x + CAMERA_WIDTH > MapManager.getPixelWidth()) {
                MapManager.camera.x = MapManager.getPixelWidth() - CAMERA_WIDTH;
            }
            if (MapManager.camera.y < 0) {
                MapManager.camera.y = 0;
            }
            if (MapManager.camera.y + CAMERA_HEIGHT > MapManager.getPixelHeight()) {
                MapManager.camera.y = MapManager.getPixelHeight() - CAMERA_HEIGHT;
            }
        }
    }

    public static void cameraActionX() {
        int n = focusObj.getFocusX() - (CAMERA_WIDTH >> 1) - CAMERA_OFFSET_X;
        switch (cameraActionX) {
            case 0: {
                MapManager.camera.x = MyAPI.calNextPosition(MapManager.camera.x, n, 3, 6, 4);
                break;
            }
            case 1: {
                int n2 = n < 0 ? 0 : n;
                int n3 = (n2 - MapManager.camera.x) * 100 / 5;
                MapManager.camera.x = MapManager.camera.x + (n3 / 100 + (n3 == 0 ? 0 : (n3 > 0 ? 5 : -5)));
                if (n3 * (n2 * 100 - MapManager.camera.x * 100) > 0) break;
                cameraActionX = 0;
                break;
            }
            case 2: {
                MapManager.camera.x = n;
                cameraActionX = 0;
            }
        }
    }

    public static void cameraActionY() {
        int n = focusObj.getFocusY() - (CAMERA_HEIGHT >> 1) - CAMERA_OFFSET_Y;
        switch (cameraActionY) {
            case 0: {
                MapManager.camera.y = MyAPI.calNextPosition(MapManager.camera.y, n, 3, 6, 4);
                break;
            }
            case 1: {
                int n2 = focusObj.getFocusY() - (CAMERA_HEIGHT >> 1) < 0 ? 0 : focusObj.getFocusY() - (CAMERA_HEIGHT >> 1);
                int n3 = (n2 - MapManager.camera.y) * 100 / 5;
                MapManager.camera.y = MapManager.camera.y + (n3 / 100 + (n3 == 0 ? 0 : (n3 > 0 ? 5 : -5)));
                if (n3 * (n2 * 100 - MapManager.camera.y * 100) > 0) break;
                cameraActionY = 0;
                break;
            }
            case 2: {
                MapManager.camera.y = n;
                cameraActionY = 0;
            }
        }
    }

    public static void setCameraLeftLimit(int n) {
        proposeLeftCameraLimit = n;
        actualLeftCameraLimit = proposeLeftCameraLimit <= MapManager.camera.x ? proposeLeftCameraLimit : MapManager.camera.x;
    }

    public static void setCameraRightLimit(int n) {
        proposeRightCameraLimit = n;
        actualRightCameraLimit = proposeRightCameraLimit >= MapManager.camera.x + CAMERA_WIDTH ? proposeRightCameraLimit : MapManager.camera.x + CAMERA_WIDTH;
    }

    public static void setCameraDownLimit(int n) {
        proposeDownCameraLimit = n;
        actualDownCameraLimit = MapManager.camera.y + CAMERA_HEIGHT > proposeDownCameraLimit ? MapManager.camera.y + CAMERA_HEIGHT : proposeDownCameraLimit;
    }

    public static void setCameraUpLimit(int n) {
        proposeUpCameraLimit = n;
        actualUpCameraLimit = MapManager.camera.y < proposeUpCameraLimit ? MapManager.camera.y : proposeUpCameraLimit;
    }

    public static boolean isCameraStop() {
        if (focusObj == null || cameraLocked) {
            return true;
        }
        return cameraActionX == 0 && cameraActionY == 0;
    }

    public static Coordinate getCamera() {
        return camera;
    }

    public static void setFocusObj(PlayerObject playerObject) {
        if (focusObj != playerObject) {
            cameraActionX = 1;
            cameraActionY = 1;
        }
        focusObj = playerObject;
        MapManager.lockCamera(false);
    }

    public static void focusQuickLocation() {
        cameraActionX = 0;
        cameraActionY = 0;
        if (focusObj != null) {
            MapManager.camera.x = focusObj.getFocusX() - (CAMERA_WIDTH >> 1);
            MapManager.camera.y = focusObj.getFocusY() - (CAMERA_HEIGHT >> 1);
        }
        MapManager.cameraLogic();
    }

    public static void setCameraMoving() {
        cameraActionX = 1;
        cameraActionY = 1;
        MapManager.cameraLogic();
    }

    public static void lockCamera(boolean bl) {
        cameraLocked = bl;
    }

    public static boolean loadMapStep(int n, String string) {
        boolean bl = true;
        switch (loadStep) {
            case 0: {
                try {
                    image = MFImage.createImage("/map/stage" + string + ".png");
                    IMAGE_TILE_WIDTH = MyAPI.zoomIn(image.getHeight() / 16);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                is = MFDevice.getResourceAsStream("/map/" + string + ".pm");
                ds = new DataInputStream(is);
                break;
            }
            case 2: {
                try {
                    mapWidth = ds.readByte();
                    mapHeight = ds.readByte();
                    if (mapWidth < 0) {
                        mapWidth += 256;
                    }
                    if (mapHeight < 0) {
                        mapHeight += 256;
                    }
                    mapFront = new short[mapWidth][mapHeight];
                    mapBack = new short[mapWidth][mapHeight];
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                try {
                    int n2 = ds.readShort();
                    ds.readShort();
                    mapModel = new short[n2][6][6];
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < 6; ++j) {
                            for (int k = 0; k < 6; ++k) {
                                MapManager.mapModel[i][j][k] = ds.readShort();
                            }
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case 4: {
                try {
                    for (int i = 0; i < mapWidth; ++i) {
                        for (int j = 0; j < mapHeight; ++j) {
                            MapManager.mapFront[i][j] = ds.readShort();
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case 5: {
                try {
                    for (int i = 0; i < mapWidth; ++i) {
                        for (int j = 0; j < mapHeight; ++j) {
                            MapManager.mapBack[i][j] = ds.readShort();
                        }
                    }
                    if (ds == null) break;
                    ds.close();
                }
                catch (Exception exception) {}
                break;
            }
            case 6: {
                proposeLeftCameraLimit = 0;
                actualLeftCameraLimit = 0;
                proposeUpCameraLimit = 0;
                actualUpCameraLimit = 0;
                proposeRightCameraLimit = MapManager.getPixelWidth();
                actualRightCameraLimit = MapManager.getPixelWidth();
                proposeDownCameraLimit = MapManager.getPixelHeight();
                actualDownCameraLimit = MapManager.getPixelHeight();
                loadStep = 0;
                return true;
            }
        }
        if (bl) {
            ++loadStep;
        }
        return false;
    }

    public static void closeMap() {
        image = null;
        mapModel = null;
        mapFront = null;
        mapBack = null;
        windImage = null;
        windDrawer = null;
        GraphicPatch.releaseAllResource();
    }

    public static void drawBack(MFGraphics mFGraphics) {
        BackGroundManager.drawBackGround(mFGraphics);
        MapManager.drawMap(mFGraphics, mapBack);
    }

    public static void drawFront(MFGraphics mFGraphics) {
        MapManager.drawMap(mFGraphics, mapFront);
    }

    public static void drawMapFrame(MFGraphics mFGraphics) {
        if (CAMERA_OFFSET_X > 0 || CAMERA_OFFSET_Y > 0) {
            if (CAMERA_OFFSET_Y > 0) {
                mFGraphics.setColor(255);
                MyAPI.fillRect(mFGraphics, 0, 0, Def.SCREEN_WIDTH, CAMERA_OFFSET_Y);
                MyAPI.fillRect(mFGraphics, 0, Def.SCREEN_HEIGHT - CAMERA_OFFSET_Y, Def.SCREEN_WIDTH, CAMERA_OFFSET_Y);
            }
            if (CAMERA_OFFSET_X > 0) {
                mFGraphics.setColor(255);
                MyAPI.fillRect(mFGraphics, 0, 0 + CAMERA_OFFSET_Y, CAMERA_OFFSET_X, Def.SCREEN_HEIGHT - (CAMERA_OFFSET_Y << 1));
                MyAPI.fillRect(mFGraphics, Def.SCREEN_WIDTH - CAMERA_OFFSET_X, 0 + CAMERA_OFFSET_Y, CAMERA_OFFSET_X, Def.SCREEN_HEIGHT - (CAMERA_OFFSET_Y << 1));
            }
        }
    }

    public static void drawMap(MFGraphics mFGraphics, short[][] sArray) {
        int n = (MapManager.camera.x + CAMERA_OFFSET_X) / 16;
        int n2 = (MapManager.camera.y + CAMERA_OFFSET_Y) / 16;
        int n3 = (MapManager.camera.x + CAMERA_WIDTH + 16 - 1 + CAMERA_OFFSET_X) / 16;
        int n4 = (MapManager.camera.y + CAMERA_HEIGHT + 16 - 1 + CAMERA_OFFSET_Y) / 16;
        int n5 = -1;
        for (int i = n; i < n3; ++i) {
            int n6;
            int n7;
            int n8 = i / 6;
            if (n8 != n5) {
                n7 = 1;
                for (n6 = n2 / 6; n6 < (n4 + 6 - 1) / 6; ++n6) {
                    if (MapManager.getModelIdByIndex(sArray, n8, n6) == 0) continue;
                    n7 = 0;
                    break;
                }
                n5 = i / 6;
                if (n7 != 0) {
                    i = (n8 + 1) * 6 - 1;
                    continue;
                }
            }
            for (n7 = n2; n7 < n4; ++n7) {
                int n9;
                n6 = MapManager.getModelId(sArray, i, n7);
                if (n6 == 0) {
                    n9 = n7 / 6;
                    n7 = (n9 + 1) * 6 - 1;
                    continue;
                }
                n9 = MapManager.getTileId(sArray, i, n7);
                boolean bl = (n9 & 0x8000) != 0;
                boolean bl2 = (n9 & 0x4000) != 0;
                int n10 = 0;
                if (bl2) {
                    n10 |= 2;
                }
                if (bl) {
                    n10 |= 1;
                }
                MapManager.drawTile(mFGraphics, n9 & 0x3FFF, i, n7, n10);
            }
        }
    }

    public static int getTileId(short[][] sArray, int n, int n2) {
        int n3 = n % 6;
        int n4 = n2 % 6;
        short[][] sArray2 = mapModel[MapManager.getModelId(sArray, n, n2)];
        return sArray2[n3][n4];
    }

    public static int getModelId(short[][] sArray, int n, int n2) {
        int n3 = n / 6;
        int n4 = n2 / 6;
        return MapManager.getModelIdByIndex(sArray, n3, n4);
    }

    public static int getModelIdByIndex(short[][] sArray, int n, int n2) {
        if (n >= mapWidth) {
            n = mapWidth - 4 + (n - mapWidth) % 4;
        }
        return sArray[n][n2];
    }

    public static void drawTile(MFGraphics mFGraphics, int n, int n2, int n3, int n4) {
        if (image == null) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n5 = n % IMAGE_TILE_WIDTH;
        int n6 = n / IMAGE_TILE_WIDTH;
        MyAPI.drawImage(mFGraphics, image, n5 * 16, n6 * 16, 16, 16, n4, n2 * 16 - MapManager.camera.x, n3 * 16 - MapManager.camera.y, 20);
    }

    public static int getPixelWidth() {
        return mapWidth * 16 * 6;
    }

    public static int getPixelHeight() {
        return mapHeight * 16 * 6;
    }

    public static int getMapWidth() {
        return mapWidth;
    }

    public static int getMapHeight() {
        return mapHeight;
    }

    public static void setShake(int n) {
        if (n > 0) {
            shakeCount = n;
        }
    }

    static {
        cameraActionX = 2;
        cameraActionY = 2;
        CAMERA_WIDTH = Def.SCREEN_WIDTH;
        CAMERA_HEIGHT = Def.SCREEN_HEIGHT - 0;
        CAMERA_OFFSET_X = Def.SCREEN_WIDTH - CAMERA_WIDTH >> 1;
        CAMERA_OFFSET_Y = Def.SCREEN_HEIGHT - CAMERA_HEIGHT >> 1;
        IMAGE_TILE_WIDTH = 16;
        reCamera = new Coordinate();
        loadStep = 0;
        WIND_POSITION = new int[][]{{0, 24, 0}, {60, 80, 1}, {100, 0, 1}, {120, 44, 0}, {216, 58, 1}, {296, 12, 0}, {352, 72, 0}, {386, 36, 1}};
        LOOP_COUNT = (Def.SCREEN_WIDTH + 960 - 1) / 480;
    }
}

