/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public final class MFDevice {
    public static MFGraphics graphics;
    public static boolean deviceRotated;
    public static boolean interruptPauseFlag;
    public static long lastSystemTime;
    public static long lastSystemTimeTT;
    public static long lastSystemTimeFPS;
    public static long currentSystemTime;
    public static boolean exitFlag;
    public static MFGameState currentState;
    public static MFGameState nextState;
    public static Vector componentVector;
    public static MFTouchKey interruptConfirm;
    public static boolean responseInterrupt;
    protected static Runnable mainRunnable;
    protected static Canvas mainCanvas;
    public static String webPageUrl;
    public static final byte[] NULL_RECORD;
    public static Hashtable records;
    public static RecordStore recordStore;

    public static final void sysFlushGraphics() {
        ((MyCanvas)mainCanvas).repaint();
        ((MyCanvas)mainCanvas).serviceRepaints();
    }

    public static final void sysPointerPressed(int n, int n2) {
        for (int i = 0; i < componentVector.size(); ++i) {
            MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
            mFComponent.pointerPressed(0, n, n2);
        }
    }

    public static final void sysPointerReleased(int n, int n2) {
        for (int i = 0; i < componentVector.size(); ++i) {
            MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
            mFComponent.pointerReleased(0, n, n2);
        }
    }

    public static final void sysPointerDragged(int n, int n2) {
        for (int i = 0; i < componentVector.size(); ++i) {
            MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
            mFComponent.pointerDragged(0, n, n2);
        }
    }

    public static final void openUrl(String string, boolean bl) {
        if (bl) {
            webPageUrl = string;
            MFDevice.notifyExit();
        }
    }

    public static final void notifyStart() {
        MFDevice.changeState(GloftSOAD.getInstance().getEntryGameState());
        deviceRotated = false;
        Thread thread = new Thread(mainRunnable);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void notifyPause() {
        Runnable runnable = mainRunnable;
        synchronized (runnable) {
            if (responseInterrupt && !interruptPauseFlag) {
                MFGamePad.resetKeys();
                MFSound.deviceInterrupt();
                if (currentState != null) {
                    currentState.onPause();
                }
                interruptPauseFlag = true;
                for (int i = 0; i < componentVector.size(); ++i) {
                    MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
                    mFComponent.reset();
                }
                interruptConfirm = new MFTouchKey(0, 190, 100, 50, 2112);
                MFDevice.addComponent(interruptConfirm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void notifyResume() {
        Runnable runnable = mainRunnable;
        synchronized (runnable) {
            if (responseInterrupt && interruptPauseFlag) {
                MFGamePad.resetKeys();
                MFSound.deviceResume();
                if (currentState != null) {
                    currentState.onResume();
                }
                interruptPauseFlag = false;
                for (int i = 0; i < componentVector.size(); ++i) {
                    MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
                    mFComponent.reset();
                }
                MFDevice.removeComponent(interruptConfirm);
            }
        }
    }

    public static final void notifyExit() {
        exitFlag = true;
    }

    public static void changeState(MFGameState mFGameState) {
        nextState = mFGameState;
    }

    public static final void addComponent(MFComponent mFComponent) {
        if (componentVector != null && !componentVector.contains(mFComponent)) {
            mFComponent.reset();
            componentVector.addElement(mFComponent);
        }
    }

    public static final void removeComponent(MFComponent mFComponent) {
        if (componentVector != null) {
            componentVector.removeElement(mFComponent);
        }
    }

    public static final InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        try {
            inputStream = Runtime.getRuntime().getClass().getResourceAsStream(string);
        }
        catch (Exception exception) {
            System.out.println("Error on loading: " + string);
        }
        return inputStream;
    }

    public static final byte[] loadRecord(String string) {
        byte[] byArray = (byte[])records.get(string);
        return byArray;
    }

    public static final void saveRecord(String string, byte[] byArray) {
        records.put(string, byArray);
        MFDevice.updateRecords();
    }

    public static final void initRecords() {
        if (records == null) {
            records = new Hashtable();
            FilterInputStream filterInputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                recordStore = RecordStore.openRecordStore((String)"rms", (boolean)true);
                if (recordStore.getNumRecords() <= 0) {
                    recordStore.addRecord(NULL_RECORD, 0, NULL_RECORD.length);
                }
                byte[] byArray = recordStore.getRecord(1);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                int n = ((DataInputStream)filterInputStream).readInt();
                for (int i = 0; i < n; ++i) {
                    String string = ((DataInputStream)filterInputStream).readUTF();
                    int n2 = 0;
                    int n3 = ((DataInputStream)filterInputStream).readInt();
                    byte[] byArray2 = new byte[n3];
                    while ((n2 = ((DataInputStream)filterInputStream).read(byArray2, n2, n3 - n2)) < n3) {
                    }
                    records.put(string, byArray2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void updateRecords() {
        FilterOutputStream filterOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"rms", (boolean)true);
            byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(records.size());
            Enumeration enumeration = records.keys();
            for (int i = 0; i < records.size(); ++i) {
                String string = (String)enumeration.nextElement();
                byte[] byArray = (byte[])records.get(string);
                ((DataOutputStream)filterOutputStream).writeUTF(string);
                ((DataOutputStream)filterOutputStream).writeInt(byArray.length);
                ((OutputStream)filterOutputStream).write(byArray);
            }
            ((DataOutputStream)filterOutputStream).flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.setRecord(1, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        mainRunnable = new Runnable(){

            public final void run() {
                mainCanvas = new MyCanvas();
                mainCanvas.repaint();
                mainCanvas.serviceRepaints();
                mainCanvas.setFullScreenMode(true);
                Display.getDisplay((MIDlet)GloftSOAD.getInstance()).setCurrent((Displayable)mainCanvas);
                deviceRotated = false;
                interruptPauseFlag = false;
                responseInterrupt = true;
                exitFlag = false;
                lastSystemTime = System.currentTimeMillis();
                MFDevice.initRecords();
                MFGraphics.init();
                MFSound.init();
                MFGamePad.resetKeys();
                componentVector = new Vector();
                while (!exitFlag) {
                    this.tick();
                    if (System.currentTimeMillis() - lastSystemTime > 3000L) {
                        MFDevice.notifyPause();
                        MFDevice.notifyResume();
                    }
                    lastSystemTime = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        currentSystemTime = System.currentTimeMillis();
                    } while (currentState != null && currentSystemTime - lastSystemTimeFPS > 0L && currentSystemTime - lastSystemTimeFPS < (long)currentState.getFrameTime());
                    lastSystemTimeFPS = System.currentTimeMillis();
                    lastSystemTimeTT = System.currentTimeMillis();
                }
                currentState.onExit();
                if (webPageUrl != null) {
                    MFDevice.openUrl(webPageUrl, false);
                }
                GloftSOAD.getInstance().notifyDestroyed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tick() {
                if (graphics != null) {
                    graphics.reset();
                }
                Runnable runnable = mainRunnable;
                synchronized (runnable) {
                    MFGamePad.keyTick();
                    for (int i = 0; i < componentVector.size(); ++i) {
                        MFComponent mFComponent = (MFComponent)componentVector.elementAt(i);
                        mFComponent.tick();
                    }
                }
                MFSound.tick();
                if (nextState != null) {
                    if (currentState != null) {
                        currentState.onExit();
                    }
                    currentState = nextState;
                    currentState.onEnter();
                    nextState = null;
                }
                if (!interruptPauseFlag) {
                    currentState.onTick();
                    if (!exitFlag && graphics != null) {
                        currentState.onRender(graphics);
                    }
                }
                MFDevice.sysFlushGraphics();
            }
        };
        NULL_RECORD = new byte[]{0, 0, 0, 0};
    }

    static class MyCanvas
    extends Canvas {
        MyCanvas() {
        }

        protected void paint(Graphics graphics) {
            if (MFDevice.graphics == null) {
                MFDevice.graphics = MFGraphics.createMFGraphics(graphics, 320, 240);
            } else if (MFDevice.graphics.g != graphics) {
                MFDevice.graphics.g = graphics;
            }
        }

        public final void hideNotify() {
            MFDevice.notifyPause();
        }

        public final void showNotify() {
            MFDevice.notifyResume();
        }

        public final void keyPressed(int n) {
        }

        public final void keyReleased(int n) {
        }

        public final void pointerPressed(int n, int n2) {
            int n3 = n2;
            int n4 = 240 - n;
            MFDevice.sysPointerPressed(n3, n4);
            IGP.updatePointerPressed(n, n2);
        }

        public final void pointerReleased(int n, int n2) {
            int n3 = n2;
            int n4 = 240 - n;
            MFDevice.sysPointerReleased(n3, n4);
            IGP.updatePointerReleased(n, n2);
        }

        public final void pointerDragged(int n, int n2) {
            int n3 = n2;
            int n4 = 240 - n;
            MFDevice.sysPointerDragged(n3, n4);
            IGP.updatePointerDragged(n, n2);
        }
    }
}

