/*
 * Decompiled with CFR 0.152.
 */
class LadyBug
extends EnemyObject {
    public int dg = 10;
    public int plus_cnt = 0;
    public int plus = 1;
    public int circleCenterX = this.posX + (this.mWidth >> 1);
    public int circleCenterY = this.posY;
    public static Animation ladybugAnimation;
    public int state;
    public int alert_state;
    public int wait_cnt = 0;
    public int wait_cnt_max = 16;
    public int attack_cnt = 0;
    public int attack_cnt_max = 4;
    public int emenyid;
    public int fire_start_speed = 300;

    public static void releaseAllResource() {
        ladybugAnimation = null;
    }

    protected LadyBug(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (ladybugAnimation == null) {
            ladybugAnimation = new Animation("/animation/ladybug");
        }
        this.drawer = ladybugAnimation.getDrawer(0, false, 0);
        this.emenyid = n;
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, 72, 64);
        int n = this.posX;
        int n2 = this.posY;
        switch (this.state) {
            case 0: {
                if (this.alert_state == 0) {
                    this.state = 2;
                    this.drawer.setActionId(2);
                    this.drawer.setLoop(true);
                    this.attack_cnt = 0;
                } else if (this.wait_cnt < this.wait_cnt_max) {
                    ++this.wait_cnt;
                } else {
                    this.state = 1;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                this.drawer.setActionId(1);
                this.drawer.setLoop(true);
                if (this.plus > 0) {
                    this.plus_cnt += this.plus;
                    if (this.plus_cnt >= 180 / this.dg) {
                        this.plus_cnt = 180 / this.dg;
                        this.plus = -this.plus;
                        this.state = 0;
                        this.drawer.setActionId(0);
                        this.drawer.setLoop(true);
                        this.wait_cnt = 0;
                    }
                } else {
                    this.plus_cnt += this.plus;
                    if (this.plus_cnt <= 0) {
                        this.plus_cnt = 0;
                        this.plus = -this.plus;
                        this.state = 0;
                        this.drawer.setActionId(0);
                        this.drawer.setLoop(true);
                        this.wait_cnt = 0;
                    }
                }
                this.posX = this.circleCenterX - (this.mWidth >> 1) * MyAPI.dCos(this.dg * this.plus_cnt) / 100;
                this.posY = this.circleCenterY + (this.mWidth >> 1) * MyAPI.dSin(this.dg * this.plus_cnt) / 100;
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 2: {
                if (this.attack_cnt < this.attack_cnt_max) {
                    ++this.attack_cnt;
                } else {
                    BulletObject.addBullet(this.emenyid, this.posX - 832, this.posY, -this.fire_start_speed, -this.fire_start_speed);
                    BulletObject.addBullet(this.emenyid, this.posX + 832, this.posY, this.fire_start_speed, -this.fire_start_speed);
                    this.state = 1;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 832, n2, 1664, 1024);
    }
}

