/*
 * Decompiled with CFR 0.152.
 */
public class ItemObject
extends GameObject {
    public int objId;
    public static MFImage itemBoxImage;
    public static MFImage itemContentImage;
    public static int gridWidth;
    public boolean used;
    public int moveCount;

    public static ItemObject getNewInstance(int n, int n2, int n3) {
        n2 <<= 6;
        n3 <<= 6;
        if (n == 0 && GameObject.stageModeState == 1) {
            return null;
        }
        ItemObject itemObject = new ItemObject(n, n2, n3);
        itemObject.refreshCollisionRect(itemObject.posX, itemObject.posY);
        return itemObject;
    }

    public static void closeItem() {
        itemBoxImage = null;
        itemContentImage = null;
    }

    public ItemObject(int n, int n2, int n3) {
        this.objId = n;
        this.mWidth = 1536;
        this.mHeight = 2048;
        this.posX = n2;
        this.posY = n3 + 320;
        if (itemBoxImage == null) {
            try {
                itemBoxImage = MFImage.createImage("/item/item_box.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (itemContentImage == null) {
            try {
                itemContentImage = MFImage.createImage("/item/item_content.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            gridWidth = MyAPI.zoomIn(itemContentImage.getHeight(), true) >> 3;
        }
        this.used = false;
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.used) {
            return;
        }
        if (n != 4) {
            switch (n) {
                case 2: 
                case 3: {
                    if (playerObject != GameObject.player || !playerObject.isAttackingItem(this.firstTouch)) break;
                    playerObject.doAttackPose(this, n);
                    this.used = true;
                    this.moveCount = 20;
                    GameObject.player.getPreItem(this.objId);
                    SoundSystem.getInstance().playSe(2);
                    if (this.objId != 0) break;
                    SoundSystem.getInstance().playBgmSequence(10, StageManager.getBgmId());
                    break;
                }
                case 1: {
                    if (playerObject != GameObject.player || !playerObject.isAttackingItem() || !this.firstTouch) break;
                    playerObject.doAttackPose(this, n);
                    this.used = true;
                    this.moveCount = 20;
                    GameObject.player.getPreItem(this.objId);
                    SoundSystem.getInstance().playSe(2);
                    if (this.objId != 0) break;
                    SoundSystem.getInstance().playBgmSequence(10, StageManager.getBgmId());
                }
            }
            if (!this.used) {
                playerObject.beStop(0, n, this);
            }
        }
        if (this.used) {
            Effect.showEffect(GameObject.destroyEffectAnimation, 0, this.posX >> 6, this.posY - (this.mHeight >> 1) >> 6, 0);
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (!this.used || this.moveCount >= 0) {
            this.drawInMap(mFGraphics, itemContentImage, this.objId * gridWidth, 0, gridWidth, gridWidth, 0, this.posX, this.posY - 1024, 3);
        }
        if (!this.used) {
            this.drawInMap(mFGraphics, itemBoxImage, 33);
        }
    }

    public void logic() {
        if (this.used) {
            if (this.moveCount > 0) {
                --this.moveCount;
                this.posY -= 200;
            }
            if (this.moveCount == 0) {
                this.moveCount = -1;
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - (this.mWidth >> 1), n2 - this.mHeight, this.mWidth, this.mHeight);
    }

    public void close() {
    }
}

